/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.handler.impl;

import com.rsa.authmgr.admin.agentmgt.converter.Converter;
import com.rsa.authmgr.admin.agentmgt.data.AgentDTO;
import com.rsa.authmgr.admin.migration.utility.MigrationLoggingHelper;
import com.rsa.authmgr.admin.radius.data.DeviceModelDTO;
import com.rsa.authmgr.admin.radius.data.RadiusClientAgentGUIDsDTO;
import com.rsa.authmgr.admin.radius.data.RadiusClientDTO;
import com.rsa.authmgr.admin.radius.data.converter.RadiusConverters;
import com.rsa.authmgr.admin.radius.data.converter.RadiusProfileConverter;
import com.rsa.authmgr.admin.radius.data.validator.RadiusValidators;
import com.rsa.authmgr.internal.admin.agentmgt.AgentAdministration;
import com.rsa.authmgr.internal.admin.agentmgt.AgentCreatedEvent;
import com.rsa.authmgr.internal.admin.agentmgt.AgentCreatedEventListener;
import com.rsa.authmgr.internal.admin.agentmgt.AgentLocator;
import com.rsa.authmgr.internal.admin.agentmgt.dal.Agent;
import com.rsa.authmgr.internal.admin.common.dal.DataObject;
import com.rsa.authmgr.internal.admin.radius.RadiusClientAdministration;
import com.rsa.authmgr.internal.admin.radius.dal.AMRadiusClientAccess;
import com.rsa.authmgr.internal.admin.radius.dal.AgentRadiusClientAccess;
import com.rsa.authmgr.internal.admin.radius.dal.AgentRadiusClientAssocHBM;
import com.rsa.authmgr.internal.admin.radius.dal.RadiusClientHBM;
import com.rsa.authmgr.internal.admin.radius.dal.RadiusServerAccess;
import com.rsa.authmgr.internal.admin.radius.dal.RadiusServerHBM;
import com.rsa.authmgr.internal.admin.radius.impl.exception.TransactionException;
import com.rsa.authmgr.internal.admin.radius.impl.util.RadiusAuthzCheck;
import com.rsa.authmgr.internal.admin.radius.impl.util.RadiusLicenseCheck;
import com.rsa.authmgr.internal.common.AMAdminActionKey;
import com.rsa.authmgr.internal.common.AMDomainObjectType;
import com.rsa.authmgr.internal.common.topology.TopologyHelper;
import com.rsa.authmgr.internal.radius.jaxb.device.DeviceModels;
import com.rsa.authmgr.internal.radius.jaxb.radiusclient.RadiusClient;
import com.rsa.authmgr.internal.radius.jaxb.radiusclient.RadiusClients;
import com.rsa.authmgr.internal.radius.sbr.xui.RSARadiusDataStream;
import com.rsa.authmgr.internal.radius.sbr.xui.XUIConnectionManager;
import com.rsa.authmgr.internal.radius.util.JAXBUtil;
import com.rsa.authmgr.internal.radius.util.SessionUtil;
import com.rsa.authmgr.internal.radius.util.XUIUrlBuilder;
import com.rsa.authmgr.internal.util.trusted.TrustedExecutor;
import com.rsa.authmgr.radius.common.RadiusDomainObjectType;
import com.rsa.authmgr.radius.exception.RadiusSystemException;
import com.rsa.command.exception.InvalidArgumentException;
import com.rsa.common.ConcurrentUpdateException;
import com.rsa.common.DataNotFoundException;
import com.rsa.common.DuplicateDataException;
import com.rsa.common.GUID;
import com.rsa.common.InsufficientPrivilegeException;
import com.rsa.common.LocalizableException;
import com.rsa.common.ObjectInUseException;
import com.rsa.common.SystemException;
import com.rsa.common.search.Filter;
import com.rsa.ims.components.spring.IMSApplicationListener;
import com.rsa.ims.components.spring.IMSEvent;
import com.rsa.ims.components.spring.IMSEventRegister;
import com.rsa.ims.logging.Level;
import com.rsa.ims.logging.auditsys.AdminActionKey;
import com.rsa.ims.logging.auditsys.AuditLog;
import com.rsa.ims.logging.auditsys.AuditLogFactory;
import com.rsa.ims.logging.auditsys.DomainObjectDetails;
import com.rsa.ims.logging.auditsys.simple.SimpleDomainObjectDetails;
import com.rsa.ims.logging.trace.TraceLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class AMRadiusClientAdministrationImpl
implements RadiusClientAdministration,
AgentCreatedEventListener {
    private static final TraceLog trace = TraceLog.getTraceLogger(AMRadiusClientAdministrationImpl.class);
    protected static AuditLog audit = AuditLogFactory.getLog(AMRadiusClientAdministrationImpl.class);
    private static final String DOMAIN_OBJECT = "RADIUS clients";
    private JAXBContext m_jaxbContext;
    private JAXBContext m_jaxbContextDevice;
    private RadiusAuthzCheck authz;
    private AMRadiusClientAccess amRadiuClientAcces;
    private AgentAdministration agentAdmin = null;
    private AgentLocator agentLocator = null;
    private PlatformTransactionManager platformTransactionManager = null;
    private XUIConnectionManager xuiConnMgr;
    private AgentRadiusClientAccess agentRadiusAssocAccess;
    private TopologyHelper topologyHelper = null;
    private RadiusServerAccess serverAccess = null;
    private List<RadiusClientHBM> missingClientsInSBR = null;
    private List<RadiusClientDTO> missingClientsInAM = null;

    public void init() {
        this.initJAXBCtx();
    }

    private void initJAXBCtx() {
        try {
            this.m_jaxbContext = JAXBContext.newInstance((String)"com.rsa.authmgr.internal.radius.jaxb.radiusclient");
            this.m_jaxbContextDevice = JAXBContext.newInstance((String)"com.rsa.authmgr.internal.radius.jaxb.device");
        }
        catch (JAXBException exp) {
            if (trace.isEnabled(Level.ERROR)) {
                trace.log(Level.ERROR, (Object)" [JAXB_ISSUE] Unable to initialize JAXB context(s)for RADIUS clients", (Throwable)exp);
            }
            throw new SystemException("Unable to initialize JAXB context", (Throwable)exp);
        }
    }

    public PlatformTransactionManager getPlatformTransactionManager() {
        return this.platformTransactionManager;
    }

    public void setPlatformTransactionManager(PlatformTransactionManager tm) {
        this.platformTransactionManager = tm;
    }

    public RadiusAuthzCheck getAuthz() {
        return this.authz;
    }

    public void setAuthz(RadiusAuthzCheck authz) {
        this.authz = authz;
    }

    public AMRadiusClientAccess getAmRadiuClientAcces() {
        return this.amRadiuClientAcces;
    }

    public void setAmRadiuClientAcces(AMRadiusClientAccess amRadiuClientAcces) {
        this.amRadiuClientAcces = amRadiuClientAcces;
    }

    public XUIConnectionManager getXuiConnMgr() {
        return this.xuiConnMgr;
    }

    public void setXuiConnMgr(XUIConnectionManager xuiConnMgr) {
        this.xuiConnMgr = xuiConnMgr;
    }

    public AgentAdministration getAgentAdmin() {
        return this.agentAdmin;
    }

    public void setAgentAdmin(AgentAdministration agentAdmin) {
        this.agentAdmin = (AgentAdministration)TrustedExecutor.trustedCall((Object)agentAdmin);
    }

    public AgentLocator getAgentLocator() {
        return this.agentLocator;
    }

    public void setAgentLocator(AgentLocator agentLocator) {
        this.agentLocator = (AgentLocator)TrustedExecutor.trustedCall((Object)agentLocator);
    }

    public AgentRadiusClientAccess getAgentRadiusAssocAccess() {
        return this.agentRadiusAssocAccess;
    }

    public void setAgentRadiusAssocAccess(AgentRadiusClientAccess agentRadiusAssocAccess) {
        this.agentRadiusAssocAccess = agentRadiusAssocAccess;
    }

    public RadiusServerAccess getServerAccess() {
        return this.serverAccess;
    }

    public void setServerAccess(RadiusServerAccess serverAccess) {
        this.serverAccess = serverAccess;
    }

    private DomainObjectDetails fetchSimpleDomainObjectDetails(RadiusClientDTO p_client) throws com.rsa.common.InvalidArgumentException {
        try {
            return new SimpleDomainObjectDetails(RadiusDomainObjectType.RADIUS_CLIENTS, p_client.getName(), GUID.parse((String)p_client.getId()), GUID.parse2((String)p_client.getSecurityDomain()));
        }
        catch (GUID.UnknownGUIDTypeException unknownGUIDTypeException) {
            throw new com.rsa.common.InvalidArgumentException("Invalid GUIDs", "UNKNOW_GUID_TYPE_EXP");
        }
    }

    public RadiusClientAgentGUIDsDTO createRadiusClient(RadiusClientDTO p_client) throws InsufficientPrivilegeException, com.rsa.common.InvalidArgumentException, DuplicateDataException {
        trace.log(Level.VERBOSE, (Object)"createRadiusClient() - Enters");
        RadiusLicenseCheck.checkRadiusLicense((String)"Create Radius Client");
        RadiusValidators.validateRadiusClientDTO((RadiusClientDTO)p_client, (RadiusValidators.Actions)RadiusValidators.Actions.CREATE);
        if (!p_client.getName().equals("<ANY>")) {
            GUID sdGuid;
            try {
                sdGuid = GUID.parse2((String)p_client.getSecurityDomain());
            }
            catch (GUID.UnknownGUIDTypeException unknownGUIDTypeException) {
                throw new SystemException("Invalid security domain GUID " + p_client.getSecurityDomain());
            }
            Collection results = this.serverAccess.search(Filter.empty(), sdGuid);
            for (RadiusServerHBM server : results) {
                if (!server.getHost().getPrimaryIpAddress().equals(p_client.getIpaddress())) continue;
                throw new com.rsa.common.InvalidArgumentException("A RADIUS client cannot be on the same host as a RADIUS server", "CLIENT_ON_SAME_HOST_AS_SERVER");
            }
        }
        GUID securityDomainGUID = this.getSecurityDomainGUID(p_client);
        this.authZCheck(AMAdminActionKey.AM_RADIUS_CREATE_CLIENT, securityDomainGUID, this.fetchSimpleDomainObjectDetails(p_client));
        RadiusClientAgentGUIDsDTO dto = null;
        try {
            dto = this.createRadiusClient(p_client, false, securityDomainGUID);
            trace.log(Level.VERBOSE, (Object)("createRadiusClient() - success: " + this.fetchSimpleDomainObjectDetails(p_client)));
            audit.logAdminEvent(AMAdminActionKey.AM_RADIUS_CREATE_CLIENT, this.fetchSimpleDomainObjectDetails(p_client), new String[0]);
        }
        catch (ConcurrentUpdateException conExp) {
            if (trace.isEnabled(Level.ERROR)) {
                trace.log(Level.ERROR, (Object)" [RADIUS_DAL_ISSUE] Unexcepted issue in creating RADIUS client", (Throwable)conExp);
            }
            throw new SystemException("Unexcepted issue in creating RADIUS client");
        }
        catch (DataNotFoundException dnfExp) {
            if (trace.isEnabled(Level.ERROR)) {
                trace.log(Level.ERROR, (Object)" [RADIUS_DAL_ISSUE] Unexcepted issue in creating RADIUS client", (Throwable)dnfExp);
            }
            throw new SystemException("Unexcepted issue in creating RADIUS client");
        }
        trace.log(Level.VERBOSE, (Object)"createRadiusClient() - Exit");
        return dto;
    }

    private GUID getSecurityDomainGUID(RadiusClientDTO p_client) throws com.rsa.common.InvalidArgumentException {
        try {
            return GUID.parse2((String)p_client.getSecurityDomain());
        }
        catch (GUID.UnknownGUIDTypeException unknownGUIDTypeException) {
            throw new com.rsa.common.InvalidArgumentException("Invalid Security Domain GUID", "UNKNOW_GUID_TYPE_EXP");
        }
    }

    private RadiusClientAgentGUIDsDTO createRadiusClient(final RadiusClientDTO p_client, final boolean p_update, final GUID securityDomain) throws InsufficientPrivilegeException, DuplicateDataException, ConcurrentUpdateException, DataNotFoundException {
        GUID amclientGuid = null;
        TransactionTemplate creatTransaction = new TransactionTemplate(this.getPlatformTransactionManager());
        creatTransaction.setPropagationBehavior(3);
        try {
            amclientGuid = (GUID)creatTransaction.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    boolean amStatus = false;
                    boolean sbrStatus = false;
                    GUID guid = AMRadiusClientAdministrationImpl.this.createOrUpdateAMRadiusClientInTransaction(p_client, p_update);
                    boolean bl = amStatus = guid != null;
                    if (!amStatus) {
                        if (trace.isEnabled(Level.ERROR)) {
                            trace.log(Level.ERROR, (Object)" [RADIUS_DAL_ISSUE] Unknow issue - unable to create/update RADIUS client in AM database\n");
                        }
                        throw new SystemException("Unknow issue - unable to create/update RADIUS client - " + p_client.toString());
                    }
                    if (trace.isEnabled(Level.VERBOSE)) {
                        trace.log(Level.VERBOSE, (Object)"Succesfully created/updated RADIUS client in AM database");
                    }
                    sbrStatus = AMRadiusClientAdministrationImpl.this.createRadiusClientToSBRInTranscation(p_client, securityDomain);
                    if (amStatus && sbrStatus) {
                        trace.log(Level.VERBOSE, (Object)"Succesfully created/updated RADIUS client");
                    }
                    return guid;
                }
            });
        }
        catch (TransactionException transExp) {
            if (transExp.getCause() instanceof ConcurrentUpdateException) {
                if (trace.isEnabled(Level.ERROR)) {
                    trace.log(Level.ERROR, (Object)(" [RADIUS_DAL_ISSUE] Administrators are concurrently updating the same RADIUS client object\nRadiusClient :  " + p_client.toString()));
                }
                throw (ConcurrentUpdateException)transExp.getCause();
            }
            if (transExp.getCause() instanceof DuplicateDataException) {
                if (trace.isEnabled(Level.ERROR)) {
                    trace.log(Level.ERROR, (Object)(" [RADIUS_DAL_ISSUE] Administrators are trying to create/update a duplicate RADIUS client object\nRadiusClient :  " + p_client.toString()));
                }
                throw (DuplicateDataException)transExp.getCause();
            }
            if (transExp.getCause() instanceof DataNotFoundException) {
                if (trace.isEnabled(Level.ERROR)) {
                    trace.log(Level.ERROR, (Object)(" [RADIUS_DAL_ISSUE] Could not find RADIUS client for update " + p_client.toString()));
                }
                throw (DataNotFoundException)transExp.getCause();
            }
            throw new SystemException("Unexpected issue in creating/updatingRADIUS client", (Throwable)transExp);
        }
        RadiusClientAgentGUIDsDTO guidDTO = new RadiusClientAgentGUIDsDTO();
        guidDTO.setRadiusClientGuid(amclientGuid.getTypedGuid());
        guidDTO.setAssociatedAgentGuid(this.autoLinkRadiusClientAndAgent(p_client, p_update, amclientGuid));
        return guidDTO;
    }

    public String autoLinkRadiusClientAndAgent(RadiusClientDTO client, boolean isUpdate, GUID amclientGuid) throws InsufficientPrivilegeException, DataNotFoundException {
        if (isUpdate) {
            return this.updateAgentAssociation(client, amclientGuid);
        }
        Agent agent = this.lookupAgentByIp(client);
        if (agent == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)client.getName()) || !client.getName().equalsIgnoreCase(agent.getHost().getName())) {
            return null;
        }
        try {
            this.linkAgentToRadiusClient(amclientGuid, agent);
        }
        catch (Exception anyExp) {
            trace.log(Level.ERROR, (Object)"Unexpected issue in automatically linking an agent with RADIUS client", (Throwable)anyExp);
            return null;
        }
        return agent.getId().getTypedGuid();
    }

    private GUID createOrUpdateAMRadiusClientInTransaction(RadiusClientDTO p_client, boolean p_update) {
        GUID guid = null;
        try {
            RadiusClientHBM tmp = RadiusConverters.createAMRadiusClient((RadiusClientDTO)p_client);
            if (p_update) {
                tmp.setNotes("UPDATING RADIUS client");
                this.amRadiuClientAcces.updateRadiusClient(tmp);
                guid = tmp.getId();
            } else {
                tmp.setNotes("CREATING RADIUS client");
                guid = this.amRadiuClientAcces.saveRadiusClient(tmp);
            }
        }
        catch (ConcurrentUpdateException conExp) {
            throw new TransactionException((Throwable)conExp);
        }
        catch (DuplicateDataException dupExp) {
            throw new TransactionException((Throwable)dupExp);
        }
        catch (DataNotFoundException dnfExp) {
            throw new TransactionException((Throwable)dnfExp);
        }
        return guid;
    }

    private boolean createRadiusClientToSBRInTranscation(RadiusClientDTO p_client, GUID securityDomain) {
        RadiusClient l_client = RadiusConverters.creatRadiusClientFromDTO((RadiusClientDTO)p_client);
        RadiusClients l_clients = new RadiusClients();
        List l_lists = l_clients.getRadiusClient();
        l_lists.add(l_client);
        boolean sbrStatus = false;
        try {
            sbrStatus = this.xuiConnMgr.getAccess().create(XUIUrlBuilder.buildCreateRadiusClientURL((String)l_client.getId()), this.convertToXml(l_clients));
        }
        catch (RadiusSystemException anyExp) {
            trace.log(Level.ERROR, (Object)" [XUI_ISSUE] Unable to create/update RADIUS client");
            throw anyExp;
        }
        return sbrStatus;
    }

    private Agent lookupAgentByIp(RadiusClientDTO p_client) throws InsufficientPrivilegeException {
        try {
            return this.agentLocator.lookupByIP(p_client.getIpaddress());
        }
        catch (InsufficientPrivilegeException inSuffExp) {
            throw inSuffExp;
        }
        catch (DataNotFoundException dataNotFoundException) {
            return null;
        }
    }

    private GUID lookupAssociatedAgentGuid(GUID p_clientGuid) {
        AgentRadiusClientAssocHBM assoc = null;
        try {
            assoc = this.agentRadiusAssocAccess.getAssociatedAgent(p_clientGuid);
        }
        catch (DataNotFoundException dataNotFoundException) {}
        return assoc != null ? assoc.getAgentGuid() : null;
    }

    public String updateAgentAssociation(RadiusClientDTO client, GUID amRadiusClient) throws InsufficientPrivilegeException, DataNotFoundException {
        if (StringUtils.isEmpty((String)client.getAgentGuid())) {
            return null;
        }
        Agent agent = this.agentLocator.lookup(this.lookupAssociatedAgentGuid(amRadiusClient));
        agent.getHost().setPrimaryIpAddress(client.getIpaddress());
        try {
            this.agentAdmin.update(agent);
        }
        catch (Exception anyExp) {
            throw new SystemException("Unable to update the associated agent", (Throwable)anyExp);
        }
        return client.getAgentGuid();
    }

    public boolean deleteAssociatedAgent(GUID p_clientGuid) {
        Agent agent = null;
        try {
            agent = this.agentLocator.lookup(this.lookupAssociatedAgentGuid(p_clientGuid));
        }
        catch (Exception anyExp) {
            throw new SystemException("Unable to find the associated Agent for this RADIUS client", (Throwable)anyExp);
        }
        try {
            this.agentAdmin.delete(agent.getId());
        }
        catch (ObjectInUseException objectInUseException) {
            trace.log(Level.VERBOSE, (Object)" [RADIUS_DAL_ISSUE] Unable to delete associated RADIUS client's agent since it is in use");
        }
        catch (Exception anyExp) {
            throw new SystemException("Unable to delete associated Agent", (Throwable)anyExp);
        }
        return true;
    }

    public boolean linkAgentToRadiusClient(GUID clientId, Agent agent) throws com.rsa.common.InvalidArgumentException, InsufficientPrivilegeException, DuplicateDataException, DataNotFoundException, ConcurrentUpdateException, ObjectInUseException {
        agent.setClientType(4);
        GUID agentId = agent.getId();
        if (agentId == null) {
            this.authz.authzCheck("CREATE", AMAdminActionKey.AUTHMGR_AGENT_CREATE, "AGENT", agent.getSecurityDomainId(), (DomainObjectDetails)new SimpleDomainObjectDetails(AMDomainObjectType.AM_AGENT, null, null, agent.getSecurityDomainId()));
            agentId = this.agentAdmin.add(agent);
        } else {
            this.agentAdmin.update(agent);
        }
        try {
            AgentRadiusClientAssocHBM assoc = this.agentRadiusAssocAccess.getAssociatedRadiusClient(agentId);
            assoc.setAgentGuid(agentId);
            assoc.setRadiusClientGuid(clientId);
            this.agentRadiusAssocAccess.update((DataObject)assoc);
        }
        catch (DataNotFoundException dataNotFoundException) {
            AgentRadiusClientAssocHBM assoc = new AgentRadiusClientAssocHBM();
            assoc.setAgentGuid(agentId);
            assoc.setRadiusClientGuid(clientId);
            this.agentRadiusAssocAccess.add((DataObject)assoc);
        }
        return true;
    }

    public boolean linkAgentToRadiusClient(GUID p_client, AgentDTO p_agentDTO) throws com.rsa.common.InvalidArgumentException, InsufficientPrivilegeException, DuplicateDataException, DataNotFoundException, ConcurrentUpdateException, ObjectInUseException {
        Agent bizAgentObj;
        RadiusLicenseCheck.checkRadiusLicense((String)"Link Radius Client And Agent");
        RadiusValidators.validateGUIDObjects((GUID[])new GUID[]{p_client});
        if (p_agentDTO == null) {
            throw new com.rsa.common.InvalidArgumentException("Agent cannot be null", "AGENTMGT_AGENT_INVALID_ARGUMENT");
        }
        try {
            bizAgentObj = Converter.convertToDalObject((AgentDTO)p_agentDTO, null);
        }
        catch (InvalidArgumentException e) {
            throw new com.rsa.common.InvalidArgumentException((LocalizableException)e);
        }
        catch (GUID.UnknownGUIDTypeException unknownGUIDTypeException) {
            throw new com.rsa.common.InvalidArgumentException("Unknown GUID Type exception", "UNKNOW_GUID_TYPE_EXP");
        }
        return this.linkAgentToRadiusClient(p_client, bizAgentObj);
    }

    public List<RadiusClientDTO> getRadiusClients(GUID p_sd) throws InsufficientPrivilegeException, com.rsa.common.InvalidArgumentException {
        return this.getRadiusClients(p_sd, Filter.empty(), 0);
    }

    public List<RadiusClientDTO> getRadiusClients(GUID p_sd, Filter filter) throws InsufficientPrivilegeException, com.rsa.common.InvalidArgumentException {
        return this.getRadiusClients(p_sd, filter, 0);
    }

    public List<RadiusClientDTO> getRadiusClients(GUID p_sd, Filter filter, int limit) throws InsufficientPrivilegeException, com.rsa.common.InvalidArgumentException {
        RadiusLicenseCheck.checkRadiusLicense((String)"View Radius Client");
        RadiusValidators.validateGUIDObjects((GUID[])new GUID[]{p_sd});
        this.authZCheck(AMAdminActionKey.AM_RADIUS_VIEW_CLIENT, p_sd, (DomainObjectDetails)new SimpleDomainObjectDetails(RadiusDomainObjectType.RADIUS_CLIENTS, null, null, p_sd));
        return this.getRadiusClientList(p_sd, filter, limit);
    }

    public List<RadiusClientDTO> getRadiusClients(GUID p_sd, Filter filter, int limit, int after) throws InsufficientPrivilegeException, com.rsa.common.InvalidArgumentException {
        RadiusLicenseCheck.checkRadiusLicense((String)"View Radius Client");
        RadiusValidators.validateGUIDObjects((GUID[])new GUID[]{p_sd});
        this.authZCheck(AMAdminActionKey.AM_RADIUS_VIEW_CLIENT, p_sd, (DomainObjectDetails)new SimpleDomainObjectDetails(RadiusDomainObjectType.RADIUS_CLIENTS, null, null, p_sd));
        return this.getRadiusClientList(p_sd, filter, limit, after);
    }

    public List<RadiusClientDTO> synchronizeRadiusClients(GUID p_sd, boolean deleteDangling) throws InsufficientPrivilegeException, com.rsa.common.InvalidArgumentException, DuplicateDataException, DataNotFoundException, ConcurrentUpdateException {
        if (!this.authz.getAuthz().isSystemOrSuperAdmin()) {
            throw new InsufficientPrivilegeException("Unauthorized RADIUS synchronization attempted.", "RADIUS_INSUFFICIENT_PRIVILEGE");
        }
        RadiusLicenseCheck.checkRadiusLicense((String)"View Radius Client");
        RadiusValidators.validateGUIDObjects((GUID[])new GUID[]{p_sd});
        String l_respXML = null;
        try {
            l_respXML = this.xuiConnMgr.getAccess().read("/radiusClients/");
        }
        catch (RadiusSystemException anyExp) {
            if (trace.isEnabled(Level.ERROR)) {
                trace.log(Level.ERROR, (Object)" [XUI_ISSUE] Unable to List RADIUS client", (Throwable)anyExp);
            }
            throw anyExp;
        }
        if (StringUtils.isBlank((String)l_respXML)) {
            return Collections.emptyList();
        }
        return this.convertFromJAXBPojoToClientDTO(this.convertFromXML(l_respXML), p_sd, deleteDangling);
    }

    public void synchronizeIPv6RadiusClients(GUID p_sd) throws InsufficientPrivilegeException, com.rsa.common.InvalidArgumentException, DuplicateDataException, DataNotFoundException, ConcurrentUpdateException {
        if (!this.authz.getAuthz().isSystemOrSuperAdmin()) {
            throw new InsufficientPrivilegeException("Unauthorized RADIUS synchronization attempted.", "RADIUS_INSUFFICIENT_PRIVILEGE");
        }
        RadiusLicenseCheck.checkRadiusLicense((String)"View Radius Client");
        RadiusValidators.validateGUIDObjects((GUID[])new GUID[]{p_sd});
        String l_respXML = this.getSBRClientsXML();
        if (StringUtils.isBlank((String)l_respXML)) {
            return;
        }
        int i = this.syncIPv6(this.convertFromXML(l_respXML), p_sd);
        if (trace.isEnabled(Level.INFO)) {
            trace.log(Level.INFO, (Object)(" [RADIUS_DEBUG] Synchronized " + i + " RADIUS client IPv6 addresses."));
        }
    }

    private String getSBRClientsXML() {
        RSARadiusDataStream radiusDataStream = null;
        BufferedReader bufReader = null;
        String l_respXML = null;
        try {
            try {
                radiusDataStream = this.xuiConnMgr.getAccess().getDataAsStream("/radiusClients/");
                bufReader = new BufferedReader(new InputStreamReader(radiusDataStream.getInputStream(), "UTF-8"));
                char[] buffer = new char[4096];
                int len = 0;
                StringBuilder sb = new StringBuilder();
                while ((len = bufReader.read(buffer)) != -1) {
                    sb.append(buffer, 0, len);
                }
                l_respXML = sb.toString();
            }
            catch (RadiusSystemException anyExp) {
                if (trace.isEnabled(Level.ERROR)) {
                    trace.log(Level.ERROR, (Object)" [XUI_ISSUE] Unable to List RADIUS client", (Throwable)anyExp);
                }
                throw anyExp;
            }
            catch (Exception exc) {
                if (trace.isEnabled(Level.ERROR)) {
                    trace.log(Level.ERROR, (Object)"Unable to List RADIUS clients", (Throwable)exc);
                }
                throw new SystemException("Unable to List RADIUS clients", (Throwable)exc);
            }
        }
        catch (Throwable throwable) {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (Exception exception) {}
            }
            if (radiusDataStream != null) {
                radiusDataStream.releaseConnection();
            }
            throw throwable;
        }
        if (bufReader != null) {
            try {
                bufReader.close();
            }
            catch (Exception exception) {}
        }
        if (radiusDataStream != null) {
            radiusDataStream.releaseConnection();
        }
        return l_respXML;
    }

    private int syncIPv6(RadiusClients p_clients, GUID p_topLevelSD) throws DuplicateDataException, DataNotFoundException, ConcurrentUpdateException {
        int i = 0;
        List xuiRadiusClientList = RadiusConverters.getRadiusClients((RadiusClients)p_clients);
        List amRadiusClientList = (List)this.amRadiuClientAcces.getRadiusClients(p_topLevelSD, null, 0);
        HashMap<String, RadiusClientHBM> radClntsMap = new HashMap<String, RadiusClientHBM>(amRadiusClientList.size());
        for (RadiusClientHBM radClnt : amRadiusClientList) {
            radClntsMap.put(radClnt.getName(), radClnt);
        }
        String ipV6AddressSBR = null;
        String ipV6AddressAM = null;
        for (RadiusClientDTO dto : xuiRadiusClientList) {
            ipV6AddressSBR = StringUtils.trimToEmpty((String)dto.getIpV6address());
            RadiusClientHBM amRadiusClient = (RadiusClientHBM)radClntsMap.get(dto.getName());
            if (amRadiusClient == null || ipV6AddressSBR.equalsIgnoreCase(ipV6AddressAM = StringUtils.trimToEmpty((String)amRadiusClient.getIpV6Address()))) continue;
            amRadiusClient.setIpV6Address(ipV6AddressSBR);
            this.amRadiuClientAcces.updateRadiusClient(amRadiusClient);
            ++i;
        }
        return i;
    }

    private List<RadiusClientDTO> getRadiusClientList(GUID p_topLevelSD, Filter filter, int limit) {
        List amRadiusClientList = (List)this.amRadiuClientAcces.getRadiusClients(p_topLevelSD, filter, limit);
        List<RadiusClientDTO> finalList = this.getRadiusClientDTOs(amRadiusClientList);
        return finalList;
    }

    private List<RadiusClientDTO> getRadiusClientList(GUID p_topLevelSD, Filter filter, int limit, int after) {
        List amRadiusClientList = (List)this.amRadiuClientAcces.getRadiusClients(p_topLevelSD, filter, limit, after);
        List<RadiusClientDTO> finalList = this.getRadiusClientDTOs(amRadiusClientList);
        return finalList;
    }

    private List<RadiusClientDTO> getRadiusClientDTOs(List<RadiusClientHBM> amRadiusClientList) {
        List amRadiusClientAgentAssocList = this.agentRadiusAssocAccess.getAllRadiusClientAgentAssoc();
        HashMap<GUID, AgentRadiusClientAssocHBM> radClntsAgentAssocMap = new HashMap<GUID, AgentRadiusClientAssocHBM>(amRadiusClientAgentAssocList.size());
        for (AgentRadiusClientAssocHBM assoc : amRadiusClientAgentAssocList) {
            radClntsAgentAssocMap.put(assoc.getRadiusClientGuid(), assoc);
        }
        ArrayList<RadiusClientDTO> finalList = new ArrayList<RadiusClientDTO>(amRadiusClientList.size());
        for (RadiusClientHBM amRadiusClient : amRadiusClientList) {
            RadiusClientDTO dto = new RadiusClientDTO();
            dto.setId(amRadiusClient.getId().getTypedGuid());
            dto.setName(amRadiusClient.getName());
            dto.setIpaddress(amRadiusClient.getIpAddress());
            dto.setIpV6address(amRadiusClient.getIpV6Address());
            dto.setDescription(amRadiusClient.getDescription());
            dto.setModel(amRadiusClient.getMakeAndModel());
            dto.setSecurityDomain(amRadiusClient.getSecurityDomainId().getTypedGuid());
            dto.setRowVer(amRadiusClient.getRowVersion());
            dto.setLastUpdatedOn(amRadiusClient.getLastUpdatedOn());
            dto.setLastUpdatedBy(amRadiusClient.getLastUpdatedBy());
            dto.setAgentGuid(radClntsAgentAssocMap.get(amRadiusClient.getId()) == null ? null : ((AgentRadiusClientAssocHBM)radClntsAgentAssocMap.get(amRadiusClient.getId())).getRadiusClientGuid().getTypedGuid());
            finalList.add(dto);
        }
        return finalList;
    }

    private List<RadiusClientDTO> convertFromJAXBPojoToClientDTO(RadiusClients p_clients, GUID p_topLevelSD, boolean deleteDangling) throws DuplicateDataException, DataNotFoundException, ConcurrentUpdateException {
        List xuiRadiusClientList = RadiusConverters.getRadiusClients((RadiusClients)p_clients);
        List amRadiusClientList = (List)this.amRadiuClientAcces.getRadiusClients(p_topLevelSD, null, 0);
        List amRadiusClientAgentAssocList = this.agentRadiusAssocAccess.getAllRadiusClientAgentAssoc();
        HashMap<GUID, AgentRadiusClientAssocHBM> radClntsAgentAssocMap = new HashMap<GUID, AgentRadiusClientAssocHBM>(amRadiusClientAgentAssocList.size());
        for (AgentRadiusClientAssocHBM assoc : amRadiusClientAgentAssocList) {
            radClntsAgentAssocMap.put(assoc.getRadiusClientGuid(), assoc);
        }
        HashMap<String, RadiusClientHBM> radClntsMap = new HashMap<String, RadiusClientHBM>(amRadiusClientList.size());
        for (RadiusClientHBM radClnt : amRadiusClientList) {
            radClntsMap.put(radClnt.getName(), radClnt);
        }
        Iterator iter = xuiRadiusClientList.iterator();
        while (iter.hasNext()) {
            RadiusClientDTO dto = (RadiusClientDTO)iter.next();
            RadiusClientHBM amRadiusClient = (RadiusClientHBM)radClntsMap.get(dto.getName());
            if (amRadiusClient == null) continue;
            dto.setId(amRadiusClient.getId().getTypedGuid());
            dto.setSecurityDomain(amRadiusClient.getSecurityDomainId().getTypedGuid());
            dto.setRowVer(amRadiusClient.getRowVersion());
            dto.setLastUpdatedOn(amRadiusClient.getLastUpdatedOn());
            dto.setLastUpdatedBy(amRadiusClient.getLastUpdatedBy());
            dto.setAgentGuid(radClntsAgentAssocMap.get(amRadiusClient.getId()) == null ? null : ((AgentRadiusClientAssocHBM)radClntsAgentAssocMap.get(amRadiusClient.getId())).getRadiusClientGuid().getTypedGuid());
            amRadiusClientList.remove(amRadiusClient);
            iter.remove();
        }
        ArrayList<RadiusClientDTO> updatedList = new ArrayList<RadiusClientDTO>();
        if (this.needToResolveOutOfSynch(xuiRadiusClientList, amRadiusClientList)) {
            this.missingClientsInSBR = amRadiusClientList;
            this.missingClientsInAM = xuiRadiusClientList;
            return this.resolveOutOfSynch(xuiRadiusClientList, amRadiusClientList, updatedList, p_topLevelSD, deleteDangling);
        }
        return updatedList;
    }

    public List<RadiusClientHBM> getMissingClientsinSBR() {
        return this.missingClientsInSBR;
    }

    public List<RadiusClientDTO> getMissingClientsinAM() {
        return this.missingClientsInAM;
    }

    private String lookupAssocAgentGUID(HashMap<GUID, AgentRadiusClientAssocHBM> radClntsAgentAssocMap, GUID guid) {
        if (radClntsAgentAssocMap.get(guid) != null) {
            AgentRadiusClientAssocHBM assoc = radClntsAgentAssocMap.get(guid);
            return assoc.getAgentGuid().getTypedGuid();
        }
        return null;
    }

    private boolean needToResolveOutOfSynch(List<RadiusClientDTO> xuiRadiusClientList, List<RadiusClientHBM> amRadiusClientList) {
        return xuiRadiusClientList.size() > 0 || amRadiusClientList.size() > 0;
    }

    private List<RadiusClientDTO> resolveOutOfSynch(List<RadiusClientDTO> xuiRadiusClientList, List<RadiusClientHBM> amRadiusClientList, List<RadiusClientDTO> updatedList, GUID topLevelSD, boolean deleteDangling) throws DuplicateDataException, DataNotFoundException, ConcurrentUpdateException {
        trace.log(Level.ERROR, (Object)"RADIUS Client are out of synch");
        if (xuiRadiusClientList.size() > 0 && this.topologyHelper.isPrimaryInstance()) {
            this.resolveSBRDBOutofSynch(xuiRadiusClientList, updatedList, topLevelSD);
        }
        if (amRadiusClientList.size() > 0) {
            this.resolveAMDBOutOfSynch(amRadiusClientList, updatedList, deleteDangling);
        }
        return updatedList;
    }

    private void resolveAMDBOutOfSynch(List<RadiusClientHBM> amRadiusClientList, List<RadiusClientDTO> updatedList, boolean deleteDangling) throws ConcurrentUpdateException {
        trace.log(Level.ERROR, (Object)"AM has dangling RADIUS clients that do not exist in SBR server");
        trace.log(Level.ERROR, (Object)("List of RADIUS clients that exist in AM but not in SBR server" + amRadiusClientList.size()));
        trace.log(Level.ERROR, (Object)amRadiusClientList.toString());
        for (RadiusClientHBM tmp : amRadiusClientList) {
            if (deleteDangling) {
                this.amRadiuClientAcces.deleteRadiusClient(tmp.getId());
                this.logInfo("Deleted the dangling RADIUS client in AM database: " + tmp.getName());
                try {
                    audit.logAdminEvent(AMAdminActionKey.AM_RADIUS_DELETE_CLIENT, (DomainObjectDetails)new SimpleDomainObjectDetails(RadiusDomainObjectType.RADIUS_CLIENTS, tmp.getName(), GUID.parse((String)tmp.getId().getTypedGuid()), GUID.parse((String)tmp.getSecurityDomainId().getTypedGuid())), new String[0]);
                }
                catch (GUID.UnknownGUIDTypeException unknownGUIDTypeException) {
                    trace.log(Level.ERROR, (Object)("Invalid GUID found when deleting client " + tmp.getName() + " from database."));
                }
                continue;
            }
            RadiusClientDTO dto = new RadiusClientDTO();
            dto.setId(tmp.getId().getTypedGuid());
            dto.setName(tmp.getName());
            dto.setDescription(tmp.getDescription());
            dto.setModel(tmp.getMakeAndModel());
            dto.setSecurityDomain(tmp.getSecurityDomainId().getTypedGuid());
            dto.setRowVer(tmp.getRowVersion());
            dto.setLastUpdatedOn(tmp.getLastUpdatedOn());
            dto.setLastUpdatedBy(tmp.getLastUpdatedBy());
            dto.setIpaddress(tmp.getIpAddress());
            dto.setIpV6address(tmp.getIpV6Address());
            dto.setDangling(true);
            updatedList.add(dto);
        }
    }

    private void resolveSBRDBOutofSynch(List<RadiusClientDTO> xuiRadiusClientList, List<RadiusClientDTO> finalList, GUID topLevelSD) throws DuplicateDataException, DataNotFoundException {
        trace.log(Level.ERROR, (Object)"SBR has some RADIUS clients out of synch with AM ");
        trace.log(Level.ERROR, (Object)("List of RADIUS clients that exist in SBR but not in AM" + xuiRadiusClientList.size()));
        trace.log(Level.ERROR, (Object)xuiRadiusClientList.toString());
        GUID guid = null;
        RadiusClientHBM lookupObj = null;
        for (RadiusClientDTO xuiObj : xuiRadiusClientList) {
            try {
                RadiusClientHBM amObj = new RadiusClientHBM();
                amObj.setName(xuiObj.getName());
                amObj.setDescription(xuiObj.getDescription());
                amObj.setMakeAndModel(xuiObj.getModel());
                amObj.setSecurityDomainId(topLevelSD);
                if (StringUtils.isBlank((String)xuiObj.getIpaddress())) {
                    amObj.setIpAddress(null);
                } else {
                    amObj.setIpAddress(xuiObj.getIpaddress());
                }
                if (StringUtils.isBlank((String)xuiObj.getIpV6address())) {
                    amObj.setIpV6Address(null);
                } else {
                    amObj.setIpV6Address(xuiObj.getIpV6address());
                }
                amObj.setLastUpdatedBy(SessionUtil.getPrincipalInSession());
                amObj.setLastUpdatedOn(new Date());
                guid = this.amRadiuClientAcces.saveRadiusClient(amObj);
                this.logInfo("Added the RADIUS client from SBR database to AM database: " + xuiObj.getName());
                lookupObj = this.amRadiuClientAcces.load(guid);
            }
            catch (Exception e) {
                this.logError("Failed to add the RADIUS client from SBR database to AM database: " + xuiObj.getName() + " " + e.getMessage());
                this.deleteSBRRadiusClientInTransaction(topLevelSD, xuiObj.getName());
                this.logInfo("Deleted RADIUS client from SBR database " + xuiObj.getName());
            }
            if (lookupObj != null) {
                xuiObj.setId(lookupObj.getId().getTypedGuid());
                xuiObj.setRowVer(lookupObj.getRowVersion());
                xuiObj.setSecurityDomain(lookupObj.getSecurityDomainId().getTypedGuid());
                try {
                    audit.logAdminEvent(AMAdminActionKey.AM_RADIUS_CREATE_CLIENT, this.fetchSimpleDomainObjectDetails(xuiObj), new String[0]);
                }
                catch (com.rsa.common.InvalidArgumentException invalidArgumentException) {
                    trace.log(Level.ERROR, (Object)("Failed to write to audit log when adding client " + xuiObj.getName() + " to database."));
                }
                finalList.add(xuiObj);
                continue;
            }
            trace.log(Level.ERROR, (Object)"Failed to lookup an AM RADIUS client object which was just created before lookup");
        }
    }

    private RadiusClientDTO convertSingleJAXBPojoToClientDTO(RadiusClients p_xuiRadiusClients, RadiusClientHBM p_amRadiusClient) {
        List xuiRadiusClientList = RadiusConverters.getRadiusClients((RadiusClients)p_xuiRadiusClients);
        RadiusClientDTO dto = null;
        if (xuiRadiusClientList != null && !xuiRadiusClientList.isEmpty()) {
            dto = (RadiusClientDTO)xuiRadiusClientList.get(0);
        } else {
            dto = new RadiusClientDTO();
            dto.setName(p_amRadiusClient.getName());
            dto.setDescription(p_amRadiusClient.getDescription());
            dto.setModel(p_amRadiusClient.getMakeAndModel());
            dto.setDangling(true);
            dto.setIpaddress("1.2.3.4");
            dto.setIpV6address("::ffff:1.2.3.4");
            dto.setSharedSecret("abcd");
        }
        dto.setId(p_amRadiusClient.getId().getTypedGuid());
        dto.setSecurityDomain(p_amRadiusClient.getSecurityDomainId().getTypedGuid());
        dto.setRowVer(p_amRadiusClient.getRowVersion());
        dto.setLastUpdatedOn(p_amRadiusClient.getLastUpdatedOn());
        dto.setLastUpdatedBy(p_amRadiusClient.getLastUpdatedBy());
        dto.setAgentGuid(this.getAssociatedAgentGUID(dto, p_amRadiusClient.getId()));
        return dto;
    }

    private String getAssociatedAgentGUID(RadiusClientDTO p_dto, GUID amRadiusClient) {
        AgentRadiusClientAssocHBM assoc = null;
        try {
            assoc = this.agentRadiusAssocAccess.getAssociatedAgent(amRadiusClient);
        }
        catch (Exception exception) {
            return null;
        }
        return assoc.getAgentGuid().getTypedGuid();
    }

    public RadiusClients convertFromXML(String p_xml) {
        return (RadiusClients)JAXBUtil.convertFromXMLToObject((String)p_xml, (String)DOMAIN_OBJECT, (JAXBContext)this.m_jaxbContext);
    }

    private DeviceModels convertFromDeviceModelXML(String p_xml) {
        return (DeviceModels)JAXBUtil.convertFromXMLToObject((String)p_xml, (String)"Device Models", (JAXBContext)this.m_jaxbContextDevice);
    }

    public boolean deleteRadiusClient(final GUID p_client, final GUID p_sd) throws InsufficientPrivilegeException, com.rsa.common.InvalidArgumentException, ConcurrentUpdateException, DataNotFoundException {
        RadiusLicenseCheck.checkRadiusLicense((String)"Delete Radius Client");
        RadiusValidators.validateGUIDObjects((GUID[])new GUID[]{p_sd});
        final RadiusClientHBM l_client = this.amRadiuClientAcces.load(p_client);
        this.authZCheck(AMAdminActionKey.AM_RADIUS_DELETE_CLIENT, p_sd, l_client.getSimpleDomainObjectDetails());
        TransactionTemplate deleteTransaction = new TransactionTemplate(this.getPlatformTransactionManager());
        deleteTransaction.setPropagationBehavior(3);
        Boolean status = null;
        try {
            status = (Boolean)deleteTransaction.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    String l_clientName = l_client.getName();
                    boolean amStatus = AMRadiusClientAdministrationImpl.this.deleteAMRadiusClientInTransaction(p_client);
                    boolean sbrStatus = AMRadiusClientAdministrationImpl.this.deleteSBRRadiusClientInTransaction(p_sd, l_clientName);
                    return amStatus && sbrStatus;
                }
            });
            audit.logAdminEvent(AMAdminActionKey.AM_RADIUS_DELETE_CLIENT, l_client.getSimpleDomainObjectDetails(), new String[0]);
        }
        catch (TransactionException transExp) {
            if (transExp.getCause() instanceof ConcurrentUpdateException) {
                if (trace.isEnabled(Level.ERROR)) {
                    trace.log(Level.ERROR, (Object)(" [RADIUS_DAL_ISSUE] Administrators are concurrently deleting the same RADIUS client object\nRadiusClient :  " + p_client.toString()));
                }
                throw (ConcurrentUpdateException)transExp.getCause();
            }
            throw new SystemException("Unexpected issue in deleting aRadius client object", (Throwable)transExp);
        }
        return status;
    }

    public RadiusClientAgentGUIDsDTO updateRadiusClient(RadiusClientDTO p_client) throws InsufficientPrivilegeException, com.rsa.common.InvalidArgumentException, ConcurrentUpdateException, DuplicateDataException, DataNotFoundException {
        trace.log(Level.VERBOSE, (Object)"updateRadiusClient() - Enters");
        RadiusLicenseCheck.checkRadiusLicense((String)"Update Radius Client");
        RadiusValidators.validateRadiusClientDTO((RadiusClientDTO)p_client, (RadiusValidators.Actions)RadiusValidators.Actions.UPDATE);
        if (!p_client.getName().equals("<ANY>")) {
            GUID sdGuid;
            try {
                sdGuid = GUID.parse2((String)p_client.getSecurityDomain());
            }
            catch (GUID.UnknownGUIDTypeException unknownGUIDTypeException) {
                throw new SystemException("Invalid security domain GUID " + p_client.getSecurityDomain());
            }
            Collection results = this.serverAccess.search(Filter.empty(), sdGuid);
            for (RadiusServerHBM server : results) {
                if (!server.getHost().getPrimaryIpAddress().equals(p_client.getIpaddress())) continue;
                throw new com.rsa.common.InvalidArgumentException("A RADIUS client to be updated cannot be on the same host as a RADIUS server", "UPDATED_CLIENT_ON_SAME_HOST_AS_SERVER");
            }
        }
        GUID securityDomainGUID = this.getSecurityDomainGUID(p_client);
        this.authZCheck(AMAdminActionKey.AM_RADIUS_UPDATE_CLIENT, securityDomainGUID, this.fetchSimpleDomainObjectDetails(p_client));
        RadiusClientAgentGUIDsDTO dto = this.createRadiusClient(p_client, true, securityDomainGUID);
        audit.logAdminEvent(AMAdminActionKey.AM_RADIUS_UPDATE_CLIENT, this.fetchSimpleDomainObjectDetails(p_client), new String[0]);
        trace.log(Level.VERBOSE, (Object)("updateRadiusClient() - success: " + this.fetchSimpleDomainObjectDetails(p_client)));
        return dto;
    }

    private String convertToXml(RadiusClients p_client) {
        return JAXBUtil.convertFromObjectToXML((Object)p_client, (String)DOMAIN_OBJECT, (JAXBContext)this.m_jaxbContext);
    }

    public RadiusClientDTO lookupRadiusClient(GUID p_client, GUID p_sd) throws InsufficientPrivilegeException, DataNotFoundException {
        RadiusLicenseCheck.checkRadiusLicense((String)"View Radius Client");
        if (p_client == null || p_sd == null) {
            throw new IllegalArgumentException("Valid RADIUS client guid and top-level security domain GUID are expected.");
        }
        this.authZCheck(AMAdminActionKey.AM_RADIUS_VIEW_CLIENT, p_sd, (DomainObjectDetails)new SimpleDomainObjectDetails(RadiusDomainObjectType.RADIUS_CLIENTS, null, null, p_sd));
        RadiusClientHBM amObj = this.amRadiuClientAcces.load(p_client);
        if (amObj == null) {
            throw new SystemException("Unexpected issue - Unable to get a Radius client from AM datstore\n.");
        }
        String getUrl = XUIUrlBuilder.buildLookupRadiusClientURL((String)amObj.getName());
        String respXML = null;
        try {
            respXML = this.xuiConnMgr.getAccess().read(getUrl);
        }
        catch (RadiusSystemException anyExp) {
            if (trace.isEnabled(Level.ERROR)) {
                trace.log(Level.ERROR, (Object)(" [XUI_ISSUE] Unable to lookup Radius client" + amObj.getName()));
            }
            throw anyExp;
        }
        if (StringUtils.isBlank((String)respXML)) {
            return null;
        }
        respXML = this.formatXML(respXML);
        return this.convertSingleJAXBPojoToClientDTO(this.convertFromXML(respXML), amObj);
    }

    private String formatXML(String p_origXML) {
        String xmlPI = "<?xml version = \"1.0\"?>";
        String tempXml = p_origXML.trim();
        if (tempXml.startsWith(xmlPI)) {
            tempXml = tempXml.substring(xmlPI.length(), tempXml.length());
        }
        StringBuilder buffer = new StringBuilder(p_origXML.length() + 50);
        buffer.append(xmlPI);
        buffer.append("<radiusClients>");
        buffer.append(tempXml);
        buffer.append("</radiusClients>");
        return buffer.toString();
    }

    private void authZCheck(AdminActionKey p_actionKey, GUID p_sd, DomainObjectDetails p_domainObj) throws InsufficientPrivilegeException {
        String action = null;
        if (p_actionKey.equals((Object)AMAdminActionKey.AM_RADIUS_CREATE_CLIENT)) {
            action = "CREATE";
        } else if (p_actionKey.equals((Object)AMAdminActionKey.AM_RADIUS_UPDATE_CLIENT)) {
            action = "UPDATE";
        } else if (p_actionKey.equals((Object)AMAdminActionKey.AM_RADIUS_VIEW_CLIENT)) {
            action = "READ";
        } else if (p_actionKey.equals((Object)AMAdminActionKey.AM_RADIUS_DELETE_CLIENT)) {
            action = "DELETE";
        } else {
            throw new InsufficientPrivilegeException("Unknown operation");
        }
        this.authz.authzCheck(action, p_actionKey, "RADIUS_CLIENT", p_sd, p_domainObj);
    }

    public List<DeviceModelDTO> getAllDeviceModels(GUID p_sd) {
        RadiusLicenseCheck.checkRadiusLicense((String)"Create Radius Client");
        String getUrl = "/deviceModels/";
        String l_respXML = null;
        try {
            l_respXML = this.xuiConnMgr.getAccess().read(getUrl);
        }
        catch (RadiusSystemException anyExp) {
            if (trace.isEnabled(Level.ERROR)) {
                trace.log(Level.ERROR, (Object)" [XUI_ISSUE] Unable to get RADIUS client's make/model");
            }
            throw anyExp;
        }
        if (StringUtils.isBlank((String)l_respXML)) {
            return Collections.emptyList();
        }
        return RadiusProfileConverter.getDeviceModels((DeviceModels)this.convertFromDeviceModelXML(l_respXML));
    }

    private boolean deleteAMRadiusClientInTransaction(GUID p_client) {
        boolean amStatus = false;
        try {
            if (this.lookupAssociatedAgentGuid(p_client) != null) {
                amStatus = this.deleteAssociatedAgent(p_client);
            }
            amStatus = this.amRadiuClientAcces.deleteRadiusClient(p_client);
        }
        catch (ConcurrentUpdateException concExp) {
            throw new TransactionException((Throwable)concExp);
        }
        if (!amStatus) {
            throw new SystemException("Unknow reason - failed to delete RADIUS  client");
        }
        return amStatus;
    }

    private boolean deleteSBRRadiusClientInTransaction(GUID p_sd, String l_clientName) {
        boolean sbrStatus = false;
        try {
            sbrStatus = this.xuiConnMgr.getAccess().delete(XUIUrlBuilder.buildDeleteRadiusClientURL((String)l_clientName));
        }
        catch (RadiusSystemException anyExp) {
            if (trace.isEnabled(Level.ERROR)) {
                trace.log(Level.ERROR, (Object)" [XUI_ISSUE] Unable to delete Radius client", (Throwable)anyExp);
            }
            throw anyExp;
        }
        return sbrStatus;
    }

    public void onApplicationEvent(IMSEvent event) {
        if (event instanceof AgentCreatedEvent) {
            AgentCreatedEvent agentEvent = (AgentCreatedEvent)event;
            try {
                Agent agent = this.agentLocator.lookup(agentEvent.getAgentId());
                Collection clients = this.amRadiuClientAcces.search(Filter.equal((String)"ipAddress", (String)agent.getHost().getPrimaryIpAddress()), 1);
                if (clients.size() == 1) {
                    RadiusClientHBM client = (RadiusClientHBM)clients.iterator().next();
                    this.linkAgentToRadiusClient(client.getId(), agent);
                }
            }
            catch (Exception e) {
                throw new SystemException("Failed to associate agent with radius client", (Throwable)e);
            }
        }
    }

    public TopologyHelper getTopologyHelper() {
        return this.topologyHelper;
    }

    public void setTopologyHelper(TopologyHelper topologyHelper) {
        this.topologyHelper = (TopologyHelper)TrustedExecutor.trustedCall((Object)topologyHelper);
    }

    public void setEventRegister(IMSEventRegister eventRegister) {
        eventRegister.registerForEvent((IMSApplicationListener)this, AgentCreatedEvent.class, null);
    }

    public String trustedLookupRadiusClientsMakeAndModel(GUID guid, String clientIP) throws DataNotFoundException, com.rsa.common.InvalidArgumentException {
        return new String();
    }

    private void logInfo(String msg) {
        MigrationLoggingHelper.getmigrationLogger().log(java.util.logging.Level.INFO, msg);
    }

    private void logError(String msg) {
        MigrationLoggingHelper.getmigrationLogger().log(java.util.logging.Level.SEVERE, msg);
    }
}

