/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.handler.impl;

import com.rsa.authmgr.admin.migration.handler.AMRadiusClientMigration;
import com.rsa.authmgr.admin.migration.utility.MigrationLoggingHelper;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.data.RadiusClientDTO;
import com.rsa.authmgr.admin.radius.data.converter.RadiusConverters;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.internal.admin.radius.RadiusClientAdministration;
import com.rsa.authmgr.internal.radius.jaxb.radiusclient.RadiusClients;
import com.rsa.common.search.Filter;
import com.rsa.security.SecurityContext;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;

public class AMRadiusClientMigrationImpl
implements AMRadiusClientMigration {
    RadiusMigrationUtility migUtility = new RadiusMigrationUtility();
    List<String> failedRadiusClientList = new ArrayList<String>();
    private static final String RADIUS_CLIENTS = "RADIUS clients";

    @Override
    public void importRadiusClientData() throws Exception {
        this.logInfo("***Starting Migration of Radius clients***");
        Path path = Paths.get(String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.SBR_MIG_DIR, new String[0]);
        File realmRadSrvExpLoc = new File(path.toAbsolutePath().toString());
        RadiusClients clientData = (RadiusClients)this.migUtility.convertXMLToString(new File(realmRadSrvExpLoc, "radiusClients.xml"), RADIUS_CLIENTS, null);
        this.logInfo("Total Number of clients found and considered for migration:: " + clientData.getRadiusClient().size());
        RadiusMigrationUtility.getMigrateResultDTO().setTotalNumberOfClients(clientData.getRadiusClient().size());
        if (clientData == null || clientData.getRadiusClient().size() <= 0) {
            this.logInfo("There are no SBR RADIUS clients available for migration.");
            return;
        }
        List xuiRadiusClientList = RadiusConverters.getRadiusClients((RadiusClients)clientData);
        try {
            try {
                this.updateRadiusClients(xuiRadiusClientList);
                this.logInfo("Successfully completed the migration of RADIUS clients");
                this.setLoggerProperties();
            }
            catch (Exception e) {
                this.logError("Failed to migrate RADIUS clients due to the following error:: " + e.getLocalizedMessage(), e);
                this.setLoggerProperties();
                throw e;
            }
        }
        finally {
            this.setLoggerProperties();
        }
        RadiusMigrationUtility.getMigrateResultDTO().setClientsFailedToMigrate(this.failedRadiusClientList);
        RadiusMigrationUtility.getMigrateResultDTO().setTotalNumberOfClientsFailed(this.failedRadiusClientList.size());
        int totalClientsSuccess = clientData.getRadiusClient().size() - this.failedRadiusClientList.size();
        RadiusMigrationUtility.getMigrateResultDTO().setTotalNumberOfClientsSuceess(totalClientsSuccess);
    }

    private void updateRadiusClients(List<RadiusClientDTO> xuiRadiusClientList) throws Exception {
        if (xuiRadiusClientList == null || xuiRadiusClientList.isEmpty()) {
            this.logWarn("Unable to continue migration of RADIUS clients as SBR client list not available.");
            return;
        }
        this.logInfo("Updating the RADIUS clients to the database, total number of clients exported: " + xuiRadiusClientList.size());
        ArrayList radiusClientList = new ArrayList();
        radiusClientList.addAll(this.getRadiusClient().getRadiusClients(this.migUtility.getTopLevelSD(), Filter.empty(), 0));
        this.logInfo("Retrived the RADIUS client list from the database. Total number of clients retrieved: " + radiusClientList.size());
        if (radiusClientList == null || radiusClientList.isEmpty()) {
            this.logWarn("Unable to retrive clients from the database, clients are available on the SBR Radius Server");
            throw new Exception("Failed to retrieve the clients from AM database, clients are available in SBR RADIUS Server");
        }
        HashMap<String, RadiusClientDTO> radClntsMap = new HashMap<String, RadiusClientDTO>(radiusClientList.size());
        for (RadiusClientDTO radClnt : radiusClientList) {
            radClntsMap.put(radClnt.getName(), radClnt);
        }
        int logProgressCounter = 1;
        int recordCounter = 1;
        Iterator<RadiusClientDTO> iter = xuiRadiusClientList.iterator();
        while (iter.hasNext()) {
            String clientName = null;
            try {
                if (RadiusMigrationUtility.getLogProgressSize() % logProgressCounter == 100) {
                    this.logProgressInfo("Completed migration of " + recordCounter + " client records. Migration of clients records in progress");
                    logProgressCounter = 1;
                }
                RadiusClientDTO dto = iter.next();
                clientName = dto.getName();
                final RadiusClientDTO amRadiusClient = (RadiusClientDTO)radClntsMap.get(dto.getName());
                if (amRadiusClient != null) {
                    amRadiusClient.setSharedSecret(dto.getEncryptSharedSecret());
                    amRadiusClient.setKeepAlive(dto.getKeepAlive());
                    if (amRadiusClient.getName().equals("<ANY>")) {
                        amRadiusClient.setIpaddress("");
                        amRadiusClient.setIpV6address("");
                    }
                    if (amRadiusClient.getIpV6address() != null && !amRadiusClient.getIpV6address().isEmpty()) {
                        amRadiusClient.setIpaddressType("1");
                        amRadiusClient.setIpaddress(this.generateIPv4());
                    }
                    SecurityContext.doAsSystem((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            AMRadiusClientMigrationImpl.this.getRadiusClient().updateRadiusClient(amRadiusClient);
                            return null;
                        }
                    });
                }
                ++recordCounter;
                ++logProgressCounter;
                this.logInfo("Successfully updated the RADIUS client with name: " + amRadiusClient.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                ++recordCounter;
                ++logProgressCounter;
                this.logError("Failed to migrate RADIUS client with name: " + clientName, e);
                this.failedRadiusClientList.add(clientName);
            }
        }
    }

    private String generateIPv4() {
        Random r = new Random();
        return "255." + (r.nextInt(254) + 1) + "." + (r.nextInt(254) + 1) + "." + (r.nextInt(254) + 1);
    }

    private RadiusClientAdministration getRadiusClient() {
        return this.migUtility.getRadClientAdmin();
    }

    private void logInfo(String msg) {
        MigrationLoggingHelper.getmigrationLogger().setUseParentHandlers(false);
        MigrationLoggingHelper.getmigrationLogger().log(Level.INFO, msg);
    }

    private void logProgressInfo(String msg) {
        MigrationLoggingHelper.getmigrationLogger().setUseParentHandlers(true);
        MigrationLoggingHelper.getmigrationLogger().log(Level.INFO, msg);
    }

    private void logWarn(String msg) {
        MigrationLoggingHelper.getmigrationLogger().setUseParentHandlers(true);
        MigrationLoggingHelper.getmigrationLogger().log(Level.WARNING, msg);
    }

    private void logError(String msg, Throwable thrown) {
        MigrationLoggingHelper.getmigrationLogger().setUseParentHandlers(true);
        MigrationLoggingHelper.getmigrationLogger().log(Level.SEVERE, msg, thrown);
    }

    private void setLoggerProperties() {
        MigrationLoggingHelper.getmigrationLogger().setUseParentHandlers(true);
    }
}

