/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.handler.impl;

import com.rsa.authmgr.admin.migration.handler.AMRadiusMigrateDictionary;
import com.rsa.authmgr.admin.migration.mgmt.DictionaryConfigManager;
import com.rsa.authmgr.admin.migration.utility.MigrationLoggingHelper;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class AMRadiusMigrateDictionaryImpl
implements AMRadiusMigrateDictionary {
    static final String DICTIONARY_FILE_FILTER = "dictionary.";
    static final String VENDOR_INI_BACKUPFILE = "vendor.ini.bk";
    static final String DICTIONARY_BACKUPFILE = "bk.dictionary.bk";
    static final String INCLUDE_TOKEN = "$INCLUDE ";
    static final String INCLUDE_DICTIONARY = "$INCLUDE  dictionary.";
    static final String DEFAULT_STD_VENDOR_NAME = "- Standard Radius -";
    List<String> FRMasterDictList = new ArrayList<String>();
    public static final String VENDOR_INI_FILENAME = "vendor.ini";
    private static List<String> FREERADIUS_REQUIRED_DICT = new ArrayList<String>();

    static {
        FREERADIUS_REQUIRED_DICT.add("$INCLUDE dictionary.compat");
        FREERADIUS_REQUIRED_DICT.add("$INCLUDE dictionary.usr.illegal");
        FREERADIUS_REQUIRED_DICT.add("$INCLUDE dictionary.ascend.illegal");
        FREERADIUS_REQUIRED_DICT.add("$INCLUDE dictionary.freeradius.internal");
        FREERADIUS_REQUIRED_DICT.add("$INCLUDE dictionary.freeradius");
        FREERADIUS_REQUIRED_DICT.add("$INCLUDE dictionary.motorola.illegal");
    }

    @Override
    public void createFreeRadiusMergedConfigution() throws Exception {
        DictionaryConfigManager configMgr = new DictionaryConfigManager();
        this.backupAllConfigurationFiles(configMgr);
        this.logInfo("*** Starting the migrate the converted SBR dictionary files to free radius");
        try {
            configMgr.deleteDictionaryConfigFiles(String.valueOf(AMRadiusMigrationConstants.FREERADIUS_DICTIONARY_DIR) + "dictionary.freeradius.internal");
            this.logInfo("Successfully deleted the freeradius.internal configuration file");
        }
        catch (IOException e) {
            this.logError("Failed to delete configuration file" + e.getLocalizedMessage(), e);
            e.printStackTrace();
        }
        try {
            configMgr.copyMigratedDictionaryFilesToInstalledLocation();
            this.logInfo("Successfully copied the migrated dictionary file to Free Radius install location");
        }
        catch (IOException e) {
            this.logError("Failed to copy the migrated dictionary configuration files" + e.getMessage(), e);
            e.printStackTrace();
            throw e;
        }
        ArrayList<String> FRMasterDictList = new ArrayList();
        Map<Object, Object> vendorIniMap = new HashMap();
        try {
            FRMasterDictList = configMgr.getInstalledNonConflictingDictionaryFiles();
            this.logInfo("Retrived the non-conflicting dictionary files, removed the conflicting entries using the vendor ID");
            vendorIniMap = configMgr.parseDictionaryFilesForVendorName(FRMasterDictList);
            this.logInfo("Retrived the vendor names from the dictionary file to create the vendor.ini configuration file");
        }
        catch (Exception e) {
            this.logError("Failed to to retrive dictionary configuration information from the installed envriroment " + e.getMessage(), e);
            e.printStackTrace();
            throw e;
        }
        ArrayList<String> vendorIniEntries = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : vendorIniMap.entrySet()) {
            List tempDictFileName = (List)entry.getValue();
            String fileNames = null;
            for (String file : tempDictFileName) {
                fileNames = fileNames == null ? file.split(DICTIONARY_FILE_FILTER)[1] : String.valueOf(fileNames) + "," + file.split(DICTIONARY_FILE_FILTER)[1];
            }
            if (fileNames != null && !fileNames.isEmpty() && entry.getKey().toString() != null && !entry.getKey().toString().isEmpty()) {
                vendorIniEntries.add(configMgr.getVendorIniVendorProductNameFileEntryString(entry.getKey().toString()));
                vendorIniEntries.add(configMgr.getVendorIniDictionaryNameFileEntryString(fileNames));
            }
            fileNames = null;
        }
        try {
            vendorIniEntries.addAll(Files.readAllLines(Paths.get(configMgr.getMigratedVendorIniFilePath(), new String[0])));
            FRMasterDictList.addAll(configMgr.getMigratedMasterDictionaryFileContent());
            this.logInfo("Successfully merged the migrated dictionary configuration with the installed enviroment");
        }
        catch (IOException e) {
            this.logError("Failed read the migrated vendor.ini and master dictionary file for merging" + e.getMessage(), e);
            e.printStackTrace();
            throw e;
        }
        try {
            configMgr.deleteDictionaryConfigFiles(configMgr.getInstalledVendorIniFilePath());
            configMgr.deleteDictionaryConfigFiles(configMgr.getInstalledMasterDictFilePath());
            this.logInfo("Successfully deleted the dictionary configuration files in the installed enviroment");
        }
        catch (IOException e) {
            this.logError("Failed to delete configuration file" + e.getLocalizedMessage(), e);
            e.printStackTrace();
            throw e;
        }
        try {
            ArrayList<String> includFileConent = new ArrayList<String>();
            includFileConent.addAll(FREERADIUS_REQUIRED_DICT);
            for (String dictionary : FRMasterDictList) {
                if (!dictionary.startsWith(INCLUDE_TOKEN)) {
                    includFileConent.add(INCLUDE_TOKEN + dictionary);
                    continue;
                }
                includFileConent.add(dictionary);
            }
            this.writeEntriesToFile(configMgr.getInstalledMasterDictFilePath(), includFileConent);
            this.writeEntriesToFile(configMgr.getInstalledVendorIniFilePath(), vendorIniEntries);
            this.logInfo("Successfully created the merged dictionary file configuration in the installed enviroment");
        }
        catch (IOException e) {
            this.logError("Failed create the dictionary config file in the installed enviroment" + e.getMessage(), e);
            e.printStackTrace();
            throw e;
        }
    }

    private void backupAllConfigurationFiles(DictionaryConfigManager configMgr) {
        try {
            configMgr.backupDictionaryConfigFiles(String.valueOf(AMRadiusMigrationConstants.FREERADIUS_DICTIONARY_DIR) + "dictionary.freeradius.internal", String.valueOf(AMRadiusMigrationConstants.FREERADIUS_DICTIONARY_DIR) + "bk.dictionary.freeradius.internal.bk");
        }
        catch (IOException e) {
            this.logError("Failed to backup freeradius internal dictionary file" + e.getMessage(), e);
            e.printStackTrace();
        }
        try {
            configMgr.backupDictionaryConfigFiles(configMgr.getInstalledVendorIniFilePath(), String.valueOf(AMRadiusMigrationConstants.FREERADIUS_DICTIONARY_DIR) + VENDOR_INI_BACKUPFILE);
        }
        catch (IOException e) {
            this.logError("Failed to backup vendor.ini configuration file" + e.getMessage(), e);
            e.printStackTrace();
        }
        try {
            configMgr.backupDictionaryConfigFiles(configMgr.getInstalledMasterDictFilePath(), String.valueOf(AMRadiusMigrationConstants.FREERADIUS_DICTIONARY_DIR) + DICTIONARY_BACKUPFILE);
        }
        catch (IOException e) {
            this.logError("Failed to backup master dictionary configuration file" + e.getMessage(), e);
            e.printStackTrace();
        }
    }

    private void writeEntriesToFile(String filePath, List<String> entryList) throws IOException {
        for (String entry : entryList) {
            Files.write(Paths.get(filePath, new String[0]), (String.valueOf(entry) + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
    }

    private void logInfo(String msg) {
        MigrationLoggingHelper.getmigrationLogger().log(Level.INFO, msg);
    }

    private void logWarn(String msg) {
        MigrationLoggingHelper.getmigrationLogger().log(Level.WARNING, msg);
    }

    private void logError(String msg, Throwable thrown) {
        MigrationLoggingHelper.getmigrationLogger().log(Level.SEVERE, msg, thrown);
    }
}

