/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.handler.impl;

import com.rsa.authmgr.admin.migration.handler.AMRadiusPreMigrateDictionary;
import com.rsa.authmgr.admin.migration.mgmt.DictionaryConfigManager;
import com.rsa.authmgr.admin.migration.mgmt.DictionaryObjectConverter;
import com.rsa.authmgr.admin.migration.mgmt.FreeRadiusConflictHandler;
import com.rsa.authmgr.admin.migration.mgmt.GetAllStandardRadiusValues;
import com.rsa.authmgr.admin.migration.utility.AttributeParser;
import com.rsa.authmgr.admin.migration.utility.MigrationLoggingHelper;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.migration.validator.AMRadiusDictionaryValidator;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.radius.migration.data.DictionaryAttributeDTO;
import com.rsa.authmgr.admin.radius.migration.data.DictionaryAttributeNameValueDTO;
import com.rsa.authmgr.admin.radius.migration.data.DictionaryDTO;
import com.rsa.common.DataNotFoundException;
import com.rsa.ims.security.keymanager.sys.ServerAccessInfo;
import com.rsa.tools.common.ConnectionManager4CLI;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class AMRadiusPreMigrateDictionaryImpl
implements AMRadiusPreMigrateDictionary {
    private static final String SQL_CLIENT_MODEL_QUERY_SELECT = "SELECT DISTINCT client_name, make_and_model FROM rsa_rep.am_radius_clients";
    private static final String MAKE_AND_MODEL = "MAKE_AND_MODEL";
    private static final String CLIENT_NAME = "CLIENT_NAME";
    private static final String DCT_TOKEN = ".dct";
    private static final String DCI_TOKEN = ".dci";
    private static final String EMPTY_NONE = "NONE";
    private static final String REPLACE_SPECIAL_CHAR = "[^A-Za-z0-9]+";
    private static final String HYPEN = "-";
    private static final String DICTIONARY_DOT_TOKEN = "dictionary.";
    private List<String> dictFilesToBeMigrated = new ArrayList<String>();
    private List<String> dictFilesNotMigrated = new ArrayList<String>();
    private List<String> vendorModelNotMigrated = new ArrayList<String>();
    private List<String> vendorsToBeMigrated = new ArrayList<String>();
    private List<String> dictFilesMigratedWithErrors = new ArrayList<String>();
    private List<String> changedAttributeValueNameList = new ArrayList<String>();
    private List<String> changedAttributeNameList = new ArrayList<String>();
    DictionaryConfigManager configMgr = new DictionaryConfigManager();
    private static List<String> FREERADIUS_STD_DICT_LIST_VENDOR_INI = new ArrayList<String>();
    private int totalNumOfVendorsMigratedSuccess = 0;
    private int totalNumOfVendorsMigratedFailed = 0;
    private int totolDictionaryFilesInSystem = 0;
    private int totalNumOfDictionaryFilesToBeMigrated = 0;
    private int totalNumOfDictionaryMigratedSuccess = 0;
    private int totalNumOfDictionaryMigratedFailed = 0;

    static {
        FREERADIUS_STD_DICT_LIST_VENDOR_INI.add("freeradius.internal");
        FREERADIUS_STD_DICT_LIST_VENDOR_INI.add("freeradius");
    }

    @Override
    public Map<String, String> getAllVendorsForMigration() throws DataNotFoundException {
        HashMap<String, String> clientAndModel = new HashMap<String, String>();
        PreparedStatement statement = null;
        try {
            try {
                statement = this.getDBConneciton().prepareStatement(SQL_CLIENT_MODEL_QUERY_SELECT);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String modelName = resultSet.getString(MAKE_AND_MODEL);
                    clientAndModel.put(resultSet.getString(CLIENT_NAME), resultSet.getString(MAKE_AND_MODEL));
                    this.vendorsToBeMigrated.add(modelName);
                }
            }
            catch (Exception e) {
                this.logError("Unable to retrieve make and model due to database error: " + e.getMessage(), e);
                throw new DataNotFoundException(e.getMessage(), e.getCause().toString());
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    this.logWarn(e.getMessage());
                    statement = null;
                }
            }
        }
        return clientAndModel;
    }

    @Override
    public void copySBRDictFilesToMigrationDir() throws Exception {
        File directory = new File(AMRadiusMigrationConstants.RADIUS_HOME_DIR);
        File[] filesArray = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(AMRadiusPreMigrateDictionaryImpl.DCT_TOKEN);
            }
        });
        if (filesArray == null || filesArray.length == 0) {
            this.logWarn("Unable to copy SBR dictionary files for backup. Dictionary files were not found in " + AMRadiusMigrationConstants.RADIUS_HOME_DIR);
        }
        Arrays.asList(filesArray).forEach(file -> {
            try {
                Files.copy(file.toPath(), Paths.get(String.valueOf(this.getSBRDictionaryMigrationDirectory()) + file.getName(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception exception) {
                if (file != null) {
                    this.logWarn("Failed to back up SBR RADIUS dictionary file: " + file.toString());
                }
                this.logWarn("Failed back up SBR RADIUS dictionary file");
            }
        });
        try {
            Files.copy(Paths.get(this.getInstalledVendorIniFilePath(), new String[0]), Paths.get(String.valueOf(this.getSBRDictionaryMigrationDirectory()) + "vendor.ini", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            this.logWarn("Failed to back up SBR vendor.ini file from the directory location" + AMRadiusMigrationConstants.RADIUS_HOME_DIR);
        }
    }

    @Override
    public Map<String, List<String>> createVendorIniMap() throws Exception {
        boolean vendorFileExists = RadiusMigrationUtility.checkFileExists(this.getInstalledVendorIniFilePath());
        if (!vendorFileExists) {
            this.setFailedDictConvResults();
            throw new FileNotFoundException("Unable to find the vendor.ini file in the path" + this.getInstalledVendorIniFilePath());
        }
        Map<String, List<String>> dictNameVendorNameMap = this.configMgr.getVendorDictionaryMap(this.getInstalledVendorIniFilePath(), false);
        if (dictNameVendorNameMap.isEmpty()) {
            this.logInfo("No vendors found in the vendor.ini file, the RADIUS dictionary files cannot be migrated");
            this.setFailedDictConvResults();
            throw new IOException("Unable to read the vendor.ini file in the path" + this.getInstalledVendorIniFilePath());
        }
        return dictNameVendorNameMap;
    }

    @Override
    public void convertSbrRadiusDictionaryToFreeRadiusFormat(Map<String, String> clientAndModel, Map<String, List<String>> dictNameVendorNameMap) throws Exception {
        if (clientAndModel == null || clientAndModel.isEmpty()) {
            this.setFailedDictConvResults();
            this.logInfo("Vendor make and model is empty, will not proceed with dictionary file migration");
            return;
        }
        try {
            HashMap<String, String> standardRadiusModel = new HashMap<String, String>();
            standardRadiusModel.put("- Standard Radius -", "- Standard Radius -");
            List<List<DictionaryDTO>> sbrStandardRadiusDictinaryList = this.convertToFreeRadiusDictionaryFormat(standardRadiusModel, dictNameVendorNameMap, null);
            Map<String, List<String>> onlyUsedDictionary = this.getOnlyUsedDictFile(clientAndModel, dictNameVendorNameMap);
            GetAllStandardRadiusValues stdValues = new GetAllStandardRadiusValues();
            List<String> stdRadiusValuesList = stdValues.getAllStandardRadiusValuesFromAllDictionaryFiles(sbrStandardRadiusDictinaryList, this.getAllSBRDictionaryFilePath(), onlyUsedDictionary);
            ArrayList<DictionaryDTO> sbrdict = new ArrayList<DictionaryDTO>();
            if (!sbrStandardRadiusDictinaryList.isEmpty()) {
                for (DictionaryDTO dto : sbrStandardRadiusDictinaryList.get(0)) {
                    if (dto.getMacroName().equalsIgnoreCase(EMPTY_NONE)) {
                        List<String> tempList = dto.getValuesList();
                        tempList.addAll(stdRadiusValuesList);
                        dto.setValuesList(tempList);
                    }
                    sbrdict.add(dto);
                }
            }
            HashMap<String, String> withoutStdRadiusMakeModel = new HashMap<String, String>();
            if (!clientAndModel.isEmpty()) {
                for (Map.Entry<String, String> singlemodel : clientAndModel.entrySet()) {
                    if (!singlemodel.getValue().equalsIgnoreCase("- Standard Radius -")) {
                        withoutStdRadiusMakeModel.put(singlemodel.getKey(), singlemodel.getValue());
                        continue;
                    }
                    this.logInfo("Removing the standard radius vendor from the derived make and model list" + singlemodel);
                }
            }
            List<List<DictionaryDTO>> frDictinaryList = this.convertToFreeRadiusDictionaryFormat(withoutStdRadiusMakeModel, dictNameVendorNameMap, sbrStandardRadiusDictinaryList);
            sbrStandardRadiusDictinaryList.addAll(frDictinaryList);
            this.createAndWriteFreeRadiusDictionaryFiles(sbrStandardRadiusDictinaryList);
        }
        catch (Exception e) {
            this.setPreMigrationDictResults(clientAndModel.size(), dictNameVendorNameMap.size());
            throw e;
        }
        this.setPreMigrationDictResults(clientAndModel.size(), dictNameVendorNameMap.size());
    }

    private List<List<DictionaryDTO>> convertToFreeRadiusDictionaryFormat(Map<String, String> makeAndModel, Map<String, List<String>> dictNameVendorNameMap, List<List<DictionaryDTO>> sbrStandardRadiusDictinaryList) throws IOException {
        DictionaryObjectConverter objConvertor = new DictionaryObjectConverter();
        AMRadiusDictionaryValidator validator = new AMRadiusDictionaryValidator();
        List<List<DictionaryDTO>> sbrDictionaryForEachVendorList = objConvertor.getDictionaryConvertedObjects(this.getOnlyUsedDictFile(makeAndModel, dictNameVendorNameMap));
        ArrayList<DictionaryDTO> frDictionaryList = new ArrayList<DictionaryDTO>();
        ArrayList<List<DictionaryDTO>> frParentList = new ArrayList<List<DictionaryDTO>>();
        CaseInsensitiveMap duplicateNameCheckList = new CaseInsensitiveMap();
        CaseInsensitiveMap duplicateAttrNameValueCheckList = new CaseInsensitiveMap();
        HashMap<String, String> dictionaryFilesMigrateWithErrors = new HashMap<String, String>();
        HashMap<String, String> attributeNamesCommented = new HashMap<String, String>();
        if (sbrStandardRadiusDictinaryList != null) {
            FreeRadiusConflictHandler conflictHandler = new FreeRadiusConflictHandler();
            try {
                conflictHandler.getStandardRadiusNonConflictingAttributes(sbrStandardRadiusDictinaryList, (Map<String, List<DictionaryAttributeDTO>>)duplicateNameCheckList, (Map<String, List<DictionaryAttributeNameValueDTO>>)duplicateAttrNameValueCheckList, true);
            }
            catch (IOException e) {
                this.logError("Failed to get the standard RADIUS attribute map to check for duplicate attributes:: " + e.getMessage(), e);
                e.printStackTrace();
            }
        }
        for (List<DictionaryDTO> sbrDictionaryList : sbrDictionaryForEachVendorList) {
            frDictionaryList = new ArrayList();
            boolean isDictionaryFileAlreadyConverted = false;
            for (DictionaryDTO sbrDictionary : sbrDictionaryList) {
                this.logInfo("***Starting the processing of dictionary file: " + sbrDictionary.getDictionaryFileName());
                if (frParentList != null) {
                    block8: for (List list : frParentList) {
                        for (DictionaryDTO dto : list) {
                            if (!dto.getDictionaryFileName().equalsIgnoreCase(sbrDictionary.getDictionaryFileName())) continue;
                            this.logInfo("Dictionary file already converted: " + sbrDictionary.getDictionaryFileName());
                            if (!sbrDictionary.getDictionaryFileName().equalsIgnoreCase("radius.dct")) {
                                frDictionaryList.add(dto);
                            }
                            isDictionaryFileAlreadyConverted = true;
                            continue block8;
                        }
                    }
                }
                if (sbrStandardRadiusDictinaryList != null && !isDictionaryFileAlreadyConverted) {
                    block10: for (List list : sbrStandardRadiusDictinaryList) {
                        for (DictionaryDTO dto : list) {
                            if (!dto.getDictionaryFileName().equalsIgnoreCase(sbrDictionary.getDictionaryFileName())) continue;
                            this.logInfo("Dictionary file already converted during standard radius dictionary conversion: " + sbrDictionary.getDictionaryFileName());
                            if (!sbrDictionary.getDictionaryFileName().equalsIgnoreCase("radius.dct")) {
                                frDictionaryList.add(dto);
                            }
                            isDictionaryFileAlreadyConverted = true;
                            continue block10;
                        }
                    }
                }
                if (isDictionaryFileAlreadyConverted) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> frValueList = new ArrayList<String>();
                ArrayList<String> attributeIDNotPresent = new ArrayList<String>();
                DictionaryDTO frDictionaryDTO = sbrDictionary;
                try {
                    if (sbrDictionary.isValid()) {
                        ArrayList<String> sbrFileEntries = new ArrayList<String>();
                        if (sbrDictionary.getAttributesList() != null) {
                            this.logInfo("Total number of attributes: " + sbrDictionary.getAttributesList().size() + " for dictionary filename: " + sbrDictionary.getDictionaryFileName());
                            sbrFileEntries.addAll(sbrDictionary.getAttributesList());
                        }
                        if (sbrDictionary.getValuesList() != null) {
                            this.logInfo("Total number of values: " + sbrDictionary.getValuesList().size() + " for dictionary filename: " + sbrDictionary.getDictionaryFileName());
                            sbrFileEntries.addAll(sbrDictionary.getValuesList());
                        }
                        int failureCount = 0;
                        for (String fileEntryLine : sbrFileEntries) {
                            try {
                                this.logInfo("SBR line entry: " + fileEntryLine);
                                if (fileEntryLine.startsWith("ATTRIBUTE")) {
                                    DictionaryAttributeDTO orgAttributeDTO = this.createDictionaryAttributeDTO(fileEntryLine, sbrDictionary);
                                    String orgAttribName = orgAttributeDTO.getAttrName();
                                    DictionaryAttributeDTO attributeDTO = validator.validate(orgAttributeDTO, (Map<String, List<DictionaryAttributeDTO>>)duplicateNameCheckList);
                                    if (!attributeDTO.isAttributeIDFormatSupported()) {
                                        ++failureCount;
                                        attributeDTO.setCommented(true);
                                        this.logError("Attribute identifier definitions with 4-octet types are not supported formats in Freeradius. Failed to migrate attribute: " + attributeDTO.getAttrName(), null);
                                    }
                                    if (attributeDTO.isCommented()) {
                                        attributeNamesCommented.put(attributeDTO.getAttrName(), attributeDTO.getAttrName());
                                    }
                                    if (!orgAttribName.equalsIgnoreCase(attributeDTO.getAttrName())) {
                                        this.changedAttributeNameList.add(String.valueOf(orgAttribName) + ":" + attributeDTO.getAttrID() + ":" + attributeDTO.getAttrName());
                                    }
                                    if (sbrStandardRadiusDictinaryList == null && attributeDTO.getAttrName().equalsIgnoreCase("State")) {
                                        arrayList.add("ATTRIBUTE\tState\t24\toctets");
                                        this.logWarn("Changing SBR attribute named state from string to octets");
                                        continue;
                                    }
                                    if (sbrStandardRadiusDictinaryList == null && attributeDTO.getAttrName().equalsIgnoreCase("EAP-Message")) {
                                        arrayList.add("ATTRIBUTE\tEAP-Message\t79\toctets\tconcat");
                                        this.logWarn("Changing SBR attribute named EAP-Message from octets to octets concat");
                                        continue;
                                    }
                                    if (attributeDTO.getAttrID() != null) {
                                        arrayList.add(this.getAttributeContent(attributeDTO.getAttrName(), attributeDTO.getAttrDataType(), attributeDTO.getAttrID(), attributeDTO.getHasTag(), attributeDTO.getEncryptType(), attributeDTO.isCommented()));
                                        continue;
                                    }
                                    attributeIDNotPresent.add(this.getAttributeContent(attributeDTO.getAttrName(), attributeDTO.getAttrDataType(), null, attributeDTO.getHasTag(), attributeDTO.getEncryptType(), attributeDTO.isCommented()));
                                    continue;
                                }
                                if (!fileEntryLine.startsWith("VALUE")) continue;
                                String[] fileEntryAsArray = fileEntryLine.split("\\s+");
                                String attributeName = validator.replaceUnsupportedCharactersInName(fileEntryAsArray[1]);
                                List attribDTO = (List)duplicateNameCheckList.get(attributeName);
                                String attributeID = null;
                                if (attribDTO != null) {
                                    attributeID = ((DictionaryAttributeDTO)attribDTO.get(0)).getAttrID();
                                }
                                DictionaryAttributeNameValueDTO attribNameValueDTO = this.createDictionaryAttributeNameValueDTO(fileEntryAsArray, sbrDictionary, attributeName, attributeID);
                                String orgAttribValueName = attribNameValueDTO.getAttrValueName();
                                if (fileEntryAsArray != null && attributeNamesCommented.get(attributeName) != null) {
                                    StringBuffer sb = new StringBuffer();
                                    sb.append("#");
                                    sb.append("VALUE").append("\t");
                                    sb.append(attributeName).append("\t");
                                    sb.append(fileEntryAsArray[2]).append("\t");
                                    sb.append(fileEntryAsArray[3].trim());
                                    this.logWarn("Commenting the attribute value name: " + fileEntryAsArray[2] + " as the attribute name has been commented: " + attributeName);
                                    frValueList.add(sb.toString());
                                    continue;
                                }
                                String mergeAttrNameAndValueName = String.valueOf(attribNameValueDTO.getAttrName()) + HYPEN + attribNameValueDTO.getAttrValueName();
                                if (duplicateAttrNameValueCheckList.get(mergeAttrNameAndValueName) != null) continue;
                                DictionaryAttributeNameValueDTO updatedAttribNameValueDTO = validator.validate(attribNameValueDTO, (Map<String, List<DictionaryAttributeNameValueDTO>>)duplicateAttrNameValueCheckList);
                                StringBuffer sb = new StringBuffer();
                                sb.append("VALUE").append("\t");
                                sb.append(updatedAttribNameValueDTO.getAttrName()).append("\t");
                                sb.append(updatedAttribNameValueDTO.getAttrValueName()).append("\t");
                                sb.append(updatedAttribNameValueDTO.getAttrValueID());
                                this.logInfo("FR Converted Entry: " + sb.toString());
                                frValueList.add(sb.toString());
                                if (orgAttribValueName.equalsIgnoreCase(updatedAttribNameValueDTO.getAttrValueName())) continue;
                                this.changedAttributeValueNameList.add(String.valueOf(attribNameValueDTO.getAttrName()) + ":" + orgAttribValueName + ":" + attribNameValueDTO.getAttrValueID() + ":" + updatedAttribNameValueDTO.getAttrValueName());
                            }
                            catch (Exception e) {
                                ++failureCount;
                                this.logError("The dictionary file " + sbrDictionary.getDictionaryFileName() + " is migrated with errors. " + e.getMessage(), e);
                                e.printStackTrace();
                            }
                        }
                        if (failureCount > 0) {
                            this.dictFilesMigratedWithErrors.add(sbrDictionary.getDictionaryFileName());
                            this.dictFilesNotMigrated.add(sbrDictionary.getDictionaryFileName());
                            this.vendorModelNotMigrated.add(sbrDictionary.getVendorName());
                        }
                        frDictionaryDTO.setAttributesList(this.getMissingAttributesID(attributeIDNotPresent, arrayList));
                        frDictionaryDTO.setValuesList(frValueList);
                        frDictionaryList.add(frDictionaryDTO);
                        this.logInfo("*****End of processing of dictionary file: " + sbrDictionary.getDictionaryFileName());
                        continue;
                    }
                    this.dictFilesNotMigrated.add(sbrDictionary.getDictionaryFileName());
                    this.vendorModelNotMigrated.add(sbrDictionary.getVendorName());
                    this.logError("The dictionary file " + sbrDictionary.getDictionaryFileName() + " is not valid and will not be migrated for the vendor: " + sbrDictionary.getVendorName(), null);
                }
                catch (Exception e) {
                    this.dictFilesNotMigrated.add(sbrDictionary.getDictionaryFileName());
                    this.vendorModelNotMigrated.add(sbrDictionary.getVendorName());
                    this.logError("Failed to process the dictionary file entry due to exception " + sbrDictionary.getDictionaryFileName(), e);
                    e.printStackTrace();
                }
            }
            dictionaryFilesMigrateWithErrors.forEach((k, v) -> {
                this.dictFilesMigratedWithErrors.add((String)k);
                this.vendorModelNotMigrated.add((String)v);
            });
            frParentList.add(frDictionaryList);
        }
        return frParentList;
    }

    private DictionaryAttributeDTO createDictionaryAttributeDTO(String fileEntryLine, DictionaryDTO sbrDictionary) {
        DictionaryAttributeDTO dAttrDTO = new DictionaryAttributeDTO();
        String[] attributeIDSyntax = AttributeParser.getAttributeDataTypeAndID(fileEntryLine, sbrDictionary);
        dAttrDTO.setAttrName(AttributeParser.getAttributeName(fileEntryLine));
        dAttrDTO.setAttrID(attributeIDSyntax[0]);
        dAttrDTO.setSbrDataType(attributeIDSyntax[1]);
        dAttrDTO.setVendorID(sbrDictionary.getVendorID());
        dAttrDTO.setAttrDataType(RadiusMigrationUtility.getFreeradiusDataType(attributeIDSyntax[1]));
        dAttrDTO.setHasTag(AttributeParser.getTagAttributeOption(fileEntryLine, dAttrDTO.getAttrDataType()));
        dAttrDTO.setEncryptType(AttributeParser.getEncryptAttributeOption(fileEntryLine, dAttrDTO.getAttrDataType()));
        return dAttrDTO;
    }

    private DictionaryAttributeNameValueDTO createDictionaryAttributeNameValueDTO(String[] fileEntryAsArray, DictionaryDTO sbrDictionary, String attributeName, String attribID) {
        DictionaryAttributeNameValueDTO dAttrDTO = new DictionaryAttributeNameValueDTO();
        dAttrDTO.setAttrName(attributeName);
        dAttrDTO.setAttrValueName(fileEntryAsArray[2]);
        dAttrDTO.setAttrValueID(fileEntryAsArray[3]);
        dAttrDTO.setVendorID(sbrDictionary.getVendorID());
        dAttrDTO.setAttrID(attribID);
        return dAttrDTO;
    }

    private void createAndWriteFreeRadiusDictionaryFiles(List<List<DictionaryDTO>> frDictinaryParentList) throws IOException {
        ArrayList<String> frFileEntries = new ArrayList<String>();
        ArrayList<String> masterDictFileList = new ArrayList<String>();
        ArrayList<String> vendorIniFileContent = new ArrayList<String>();
        HashMap<String, String> usedDictionaryFile = new HashMap<String, String>();
        for (List<DictionaryDTO> frDictionayList : frDictinaryParentList) {
            ArrayList<String> dictionaryFileNameList = new ArrayList<String>();
            String vendorNameIni = null;
            int index = 0;
            for (DictionaryDTO dto : frDictionayList) {
                try {
                    this.logInfo("Starting to create the migrated dictionary file : " + dto.getDictionaryFileName());
                    frFileEntries = new ArrayList();
                    vendorNameIni = dto.getVendorName();
                    StringBuffer vendorHeader = new StringBuffer();
                    StringBuffer vendorBenginVendor = new StringBuffer();
                    StringBuffer endVendor = new StringBuffer();
                    String vendorHeaderName = null;
                    if (dto.getMacroName() != null && !dto.getMacroName().equalsIgnoreCase(EMPTY_NONE)) {
                        vendorHeaderName = String.valueOf(dto.getMacroName()) + HYPEN + dto.getDictionaryFileName().split(DCT_TOKEN)[0];
                    } else if (!dto.getDictionaryFileName().equalsIgnoreCase("radius.dct")) {
                        vendorHeaderName = String.valueOf(dto.getVendorName().replaceAll(REPLACE_SPECIAL_CHAR, HYPEN)) + HYPEN + dto.getDictionaryFileName().split(DCT_TOKEN)[0];
                    }
                    if (vendorHeaderName == null && dto.getDictionaryFileName().equalsIgnoreCase("radius.dct")) {
                        frFileEntries.addAll(dto.getAttributesList());
                        frFileEntries.addAll(dto.getValuesList());
                    } else {
                        vendorHeader.append("\n").append("VENDOR").append("\t").append(vendorHeaderName).append("\t").append(dto.getVendorID());
                        if (dto.getFormat() != null && !dto.getFormat().equalsIgnoreCase("1,1")) {
                            vendorHeader.append("\t").append("format=").append(dto.getFormat());
                        }
                        vendorHeader.append("\n");
                        vendorBenginVendor.append("BEGIN-VENDOR").append("\t").append(vendorHeaderName).append("\n");
                        endVendor.append("\n").append("END-VENDOR").append("\t").append(vendorHeaderName);
                        frFileEntries.add(vendorHeader.toString());
                        frFileEntries.add(vendorBenginVendor.toString());
                        frFileEntries.addAll(dto.getAttributesList());
                        frFileEntries.addAll(dto.getValuesList());
                        frFileEntries.add(endVendor.toString());
                    }
                    Path FRadiusDictFilePath = this.getFRDictFilePath(dto.getDictionaryFileName().split(DCT_TOKEN)[0], String.valueOf(index));
                    if (dto.getDictionaryFileName() != null) {
                        this.logInfo("The SBR dictionary file : " + dto.getDictionaryFileName() + "has been converted to " + FRadiusDictFilePath.getFileName().toString());
                        dictionaryFileNameList.add(FRadiusDictFilePath.getFileName().toString().split(DICTIONARY_DOT_TOKEN)[1]);
                        ++index;
                    }
                    if (usedDictionaryFile.get(FRadiusDictFilePath.toString()) == null) {
                        this.writeEntriesToFile(FRadiusDictFilePath.toString(), frFileEntries);
                        this.dictFilesToBeMigrated.add(dto.getDictionaryFileName());
                        if (dto.isValid()) {
                            masterDictFileList.add("$INCLUDE " + FRadiusDictFilePath.getFileName().toString());
                            usedDictionaryFile.put(FRadiusDictFilePath.toString(), FRadiusDictFilePath.toString());
                            continue;
                        }
                        masterDictFileList.add("#$INCLUDE " + FRadiusDictFilePath.getFileName().toString());
                        usedDictionaryFile.put(FRadiusDictFilePath.toString(), FRadiusDictFilePath.toString());
                        this.logError("The converted dictionary file: " + dto.getDictionaryFileName() + " is not valid,will not be included to FreeRADIUS master dictionary file.", null);
                        continue;
                    }
                    this.logInfo("The SBR dictionary file is already created will be using the same file with name: " + FRadiusDictFilePath.toString());
                }
                catch (Exception e) {
                    this.logError("Failed to write the converted SBR dictionary file : " + dto.getDictionaryFileName() + " with vendor name: " + dto.getVendorName(), e);
                    this.dictFilesNotMigrated.add(dto.getDictionaryFileName());
                    this.vendorModelNotMigrated.add(dto.getVendorName());
                    e.printStackTrace();
                }
            }
            if (vendorNameIni == null || dictionaryFileNameList == null || dictionaryFileNameList.isEmpty()) continue;
            vendorIniFileContent.add("\nvendor-product\t=\t" + vendorNameIni);
            vendorIniFileContent.add("dictionary\t=\t" + String.join((CharSequence)",", dictionaryFileNameList));
        }
        try {
            this.writeEntriesToFile(String.valueOf(this.getFRDictMigrationDirectory()) + "dictionary", masterDictFileList);
            this.writeEntriesToFile(String.valueOf(this.getFRMigrationDirectory()) + "vendor.ini", vendorIniFileContent);
        }
        catch (Exception e) {
            this.logError("Failed to create migrated dictionary configuration files: " + e.getMessage(), e);
            e.printStackTrace();
            throw e;
        }
    }

    private Path getFRDictFilePath(String fileName, String postfix) {
        return Paths.get(String.valueOf(this.getFRDictMigrationDirectory()) + "dictionary" + "." + fileName + RadiusMigrationUtility.getPostFixFileName() + "_" + postfix, new String[0]);
    }

    private void writeEntriesToFile(String filePath, List<String> fileEntries) throws IOException {
        for (String entry : fileEntries) {
            Files.write(Paths.get(filePath, new String[0]), (String.valueOf(entry) + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
    }

    private String getAttributeContent(String attributeName, String frDatatype, String attributeID, String tagOption, String encryptOption, boolean isComment) {
        StringBuffer buffer = new StringBuffer();
        if (attributeID != null) {
            buffer.append("ATTRIBUTE").append("\t").append(attributeName).append("\t").append(attributeID).append("\t").append(frDatatype).append("\t");
        } else {
            buffer.append("ATTRIBUTE").append("\t").append(attributeName).append("\t").append(EMPTY_NONE).append("\t").append(frDatatype).append("\t");
        }
        if (tagOption != null && encryptOption != null && !tagOption.isEmpty() && !encryptOption.isEmpty()) {
            buffer.append(tagOption).append(",").append(encryptOption);
        } else if (tagOption != null && !tagOption.isEmpty()) {
            buffer.append(tagOption);
        } else if (encryptOption != null && !encryptOption.isEmpty()) {
            buffer.append(encryptOption);
        }
        if (isComment) {
            StringBuffer comment = new StringBuffer();
            comment.append("#").append(buffer);
            buffer = comment;
        }
        this.logInfo("FR Converted Entry: " + buffer.toString());
        return buffer.toString();
    }

    private boolean checkForVendorAttributeIDConflict(Map<String, String> vendorIDAttrIDAttrNameMap, String attributeName, String attributeID, String vendorID, Map<String, String> attributeNamesCommented) {
        String combineAttrIDVendorID = String.valueOf(vendorID) + "," + attributeID;
        if (vendorIDAttrIDAttrNameMap.get(combineAttrIDVendorID) != null) {
            String duplicateAttrName = vendorIDAttrIDAttrNameMap.get(combineAttrIDVendorID);
            if (duplicateAttrName != null && !duplicateAttrName.isEmpty()) {
                this.logWarn("Conflicting attribute identifier for vendor ID found. Commenting the attribute name: " + attributeName);
                this.changedAttributeNameList.add(String.valueOf(attributeName) + ":" + duplicateAttrName);
                attributeNamesCommented.put(attributeName, attributeName);
                return true;
            }
        } else {
            vendorIDAttrIDAttrNameMap.put(combineAttrIDVendorID, attributeName);
        }
        return false;
    }

    private Map<String, List<String>> getOnlyUsedDictFile(Map<String, String> clientsAndModel, Map<String, List<String>> dictNameVendorNameMap) {
        HashMap<String, List<String>> sbrUsedVendorListDictFilePathMap = new HashMap<String, List<String>>();
        Map<String, String> exactDictionaryFilePath = null;
        this.logInfo("Get the path of all dictionary files in SBR directory, this is to map the vendor name to dictionary file path");
        try {
            exactDictionaryFilePath = this.getAllSBRDictionaryFilePath();
            this.totolDictionaryFilesInSystem = exactDictionaryFilePath.size();
        }
        catch (Exception e) {
            this.logWarn("Failed to get the SBR dictionary path entries due to error " + e.getMessage());
        }
        for (Map.Entry<String, String> clientAndModel : clientsAndModel.entrySet()) {
            ArrayList<String> dictName = new ArrayList<String>();
            ArrayList names = new ArrayList();
            dictNameVendorNameMap.forEach((k, v) -> {
                if (((String)clientAndModel.getValue()).length() >= 31) {
                    if (k.toString().trim().startsWith((String)clientAndModel.getValue())) {
                        names.addAll(v);
                    }
                } else if (k.toString().trim().equalsIgnoreCase((String)clientAndModel.getValue())) {
                    names.addAll(v);
                }
            });
            if (names != null && !names.isEmpty()) {
                for (String s : names) {
                    if (s.endsWith(DCT_TOKEN)) {
                        s = s.split(DCT_TOKEN)[0];
                    }
                    if (s.endsWith(DCI_TOKEN)) {
                        s = s.split(DCI_TOKEN)[0];
                    }
                    if (exactDictionaryFilePath.get(s.toLowerCase()) != null) {
                        dictName.add(Paths.get(exactDictionaryFilePath.get(s.toLowerCase()), new String[0]).getFileName().toString().split("\\.")[0]);
                        continue;
                    }
                    dictName.add(s.toLowerCase());
                }
                if (!dictName.isEmpty()) {
                    List<String> includedDictFilePath = this.getIncludedDictionaryFiles(dictName, clientAndModel);
                    if (includedDictFilePath != null && !includedDictFilePath.isEmpty()) {
                        dictName.addAll(includedDictFilePath);
                    }
                    ArrayList<String> dictionaryFilePath = new ArrayList<String>();
                    for (String name : dictName) {
                        String path = null;
                        path = exactDictionaryFilePath.get(name.toLowerCase()) != null ? exactDictionaryFilePath.get(name.toLowerCase()) : this.getInstalledDictionaryFilePath(name);
                        dictionaryFilePath.add(path);
                    }
                    sbrUsedVendorListDictFilePathMap.put(clientAndModel.getValue(), dictionaryFilePath);
                    continue;
                }
                if (clientAndModel.getKey().equals("- Standard Radius -")) {
                    this.logError("The vendor model named \"" + clientAndModel.getValue() + "\" does not have a valid dictionary file and will not be considered for migration. Also verify associated dictionary file for this vendor model", null);
                } else {
                    this.logError("The vendor model named \"" + clientAndModel.getValue() + "\" of radius client \"" + clientAndModel.getKey() + "\" does not have a valid dictionary file and will not be considered for migration. Also verify associated dictionary file for this vendor model", null);
                }
                this.vendorModelNotMigrated.add(clientAndModel.getValue());
                continue;
            }
            if (clientAndModel.getKey().equals("- Standard Radius -")) {
                this.logError("The vendor model named \"" + clientAndModel.getValue() + "\" does not exists in the vendor.ini file and will not be considered for migration.", null);
            } else {
                this.logError("The vendor model named \"" + clientAndModel.getValue() + "\" of radius client \"" + clientAndModel.getKey() + "\" does not exists in the vendor.ini file and will not be considered for migration.", null);
            }
            try {
                if (!RadiusMigrationUtility.isPrimary()) continue;
                this.vendorModelNotMigrated.add(clientAndModel.getValue());
            }
            catch (Exception exception) {
                this.logWarn("Failed to retrieve the instance type. Continuing migration.");
            }
        }
        return sbrUsedVendorListDictFilePathMap;
    }

    private Map<String, String> getAllSBRDictionaryFilePath() throws IOException {
        HashMap<String, String> filePaths = new HashMap<String, String>();
        DictionaryConfigManager mgr = new DictionaryConfigManager();
        List<Path> actualPath = mgr.getAllFilesInDirectory(AMRadiusMigrationConstants.RADIUS_HOME_DIR, DCT_TOKEN);
        for (Path p : actualPath) {
            filePaths.put(p.getFileName().toString().toLowerCase().split("\\.")[0], p.toString());
        }
        return filePaths;
    }

    private List<String> getIncludedDictionaryFiles(List<String> dictFileList, Map.Entry<String, String> clientAndModel) {
        ArrayList<String> dictFileEntries = new ArrayList<String>();
        for (String dictFileName : dictFileList) {
            this.logInfo("Processing the dictionary file include entries for file " + dictFileName);
            String dictionaryFilePath = this.getInstalledDictionaryFilePath(dictFileName);
            boolean isFileExists = RadiusMigrationUtility.checkFileExists(dictionaryFilePath);
            if (isFileExists) {
                try {
                    Files.readAllLines(Paths.get(dictionaryFilePath, new String[0]), StandardCharsets.ISO_8859_1).stream().filter(entry -> entry.startsWith("@") && entry.endsWith(DCT_TOKEN) && !entry.contains("radius.dct")).forEach(filename -> {
                        boolean bl = dictFileEntries.add(filename.split("\\.")[0].toLowerCase().substring(1));
                    });
                }
                catch (IOException e) {
                    this.logError("Unable to read or process the dictionary file with name: " + dictFileName.toString() + " due to error " + e.getMessage(), e);
                    this.dictFilesNotMigrated.add(Paths.get(dictionaryFilePath, new String[0]).getFileName().toString());
                    e.printStackTrace();
                }
                continue;
            }
            if (clientAndModel.getKey().equals("- Standard Radius -")) {
                this.logError("The vendor model named \"" + clientAndModel.getValue() + "\" does not have a valid dictionary file \"" + Paths.get(dictionaryFilePath, new String[0]).getFileName().toString() + "\" in path /opt/rsa/am/radius and will not be considered for migration.", null);
            } else {
                this.logError("The vendor model named \"" + clientAndModel.getValue() + "\" of radius client \"" + clientAndModel.getKey() + "\" does not have a valid dictionary file \"" + Paths.get(dictionaryFilePath, new String[0]).getFileName().toString() + "\" in path /opt/rsa/am/radius and will not be considered for migration.", null);
            }
            this.dictFilesNotMigrated.add(Paths.get(dictionaryFilePath, new String[0]).getFileName().toString());
        }
        return dictFileEntries;
    }

    private List<String> getMissingAttributesID(List<String> attributeIDNotPresent, List<String> FRFileEntries) {
        if (attributeIDNotPresent != null && !attributeIDNotPresent.isEmpty()) {
            String lastLine = FRFileEntries.stream().filter(x -> x.startsWith("ATTRIBUTE")).reduce((first, second) -> second).orElse(null);
            int attributeID = 0;
            if (lastLine == null) {
                attributeID = FRFileEntries.size() + 1;
            } else {
                try {
                    attributeID = Integer.valueOf(lastLine.split("\\s+")[2]);
                }
                catch (Exception exception) {}
            }
            List<String> autoGeneratedAttributeID = this.addMissingAttributeID(attributeIDNotPresent, attributeID);
            if (autoGeneratedAttributeID != null && !autoGeneratedAttributeID.isEmpty()) {
                FRFileEntries.addAll(autoGeneratedAttributeID);
            }
        }
        return FRFileEntries;
    }

    private List<String> addMissingAttributeID(List<String> attribIDNotPresent, int id) {
        ArrayList<String> entries = new ArrayList<String>();
        if (attribIDNotPresent != null && !attribIDNotPresent.isEmpty()) {
            for (String line : attribIDNotPresent) {
                String attribLine = null;
                if (!line.contains(EMPTY_NONE)) continue;
                attribLine = id == 0 ? "#" + line : line.replace(EMPTY_NONE, String.valueOf(id));
                entries.add(attribLine);
            }
        }
        return entries;
    }

    private void setFailedDictConvResults() {
        RadiusMigrationUtility.getPremigrateResultDTO().setDictionaryConv(false);
        RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfDictionaryFilesToBeMigrated(0);
        RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfVendorsToBeMigrated(0);
    }

    private void setPreMigrationDictResults(int totalVendorToBeMigrated, int totalVendorsInSystem) {
        RadiusMigrationUtility.getPremigrateResultDTO().setDictFilesToBeMigrated(this.removeDuplicates(this.dictFilesToBeMigrated));
        this.totalNumOfDictionaryFilesToBeMigrated = this.removeDuplicates(this.dictFilesToBeMigrated).size();
        RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfDictionaryFilesToBeMigrated(this.totalNumOfDictionaryFilesToBeMigrated);
        RadiusMigrationUtility.getPremigrateResultDTO().setDictFilesMigratedWithErrors(this.removeDuplicates(this.dictFilesMigratedWithErrors));
        RadiusMigrationUtility.getPremigrateResultDTO().setDictFilesNotMigrated(this.removeDuplicates(this.dictFilesNotMigrated));
        this.totalNumOfDictionaryMigratedFailed = this.removeDuplicates(this.dictFilesNotMigrated).size();
        RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfDictionaryMigratedFailed(this.totalNumOfDictionaryMigratedFailed);
        RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfVendorsToBeMigrated(totalVendorToBeMigrated);
        RadiusMigrationUtility.getPremigrateResultDTO().setVendorMakeModelNotMigrated(this.removeDuplicates(this.vendorModelNotMigrated));
        this.totalNumOfVendorsMigratedFailed = this.removeDuplicates(this.vendorModelNotMigrated).size();
        RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfVendorsMigratedFailed(this.totalNumOfVendorsMigratedFailed);
        RadiusMigrationUtility.getPremigrateResultDTO().setVendorsToBeMigrated(this.removeDuplicates(this.vendorsToBeMigrated));
        RadiusMigrationUtility.getPremigrateResultDTO().setAttributeValueNameChangedList(this.changedAttributeValueNameList);
        RadiusMigrationUtility.getPremigrateResultDTO().setAttributeNameChangedList(this.changedAttributeNameList);
        RadiusMigrationUtility.getPremigrateResultDTO().setTotalVendorsPresentInSystem(totalVendorsInSystem);
        RadiusMigrationUtility.getPremigrateResultDTO().setTotalDictionaryFilesPresentInSystem(this.totolDictionaryFilesInSystem);
        this.totalNumOfVendorsMigratedSuccess = totalVendorToBeMigrated - this.removeDuplicates(this.vendorModelNotMigrated).size();
        RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfVendorsMigratedSuccess(this.totalNumOfVendorsMigratedSuccess);
        if (this.dictFilesToBeMigrated.size() > 0 || this.dictFilesMigratedWithErrors.size() > 0) {
            RadiusMigrationUtility.getPremigrateResultDTO().setDictionaryConv(true);
            this.totalNumOfDictionaryMigratedSuccess = this.removeDuplicates(this.dictFilesToBeMigrated).size() - this.removeDuplicates(this.dictFilesNotMigrated).size();
            RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfDictionaryMigratedSuccess(this.totalNumOfDictionaryMigratedSuccess);
        }
    }

    private ArrayList<String> removeDuplicates(List<String> listWithDuplicates) {
        return new ArrayList<String>(new HashSet<String>(listWithDuplicates));
    }

    private Connection getDBConneciton() throws Exception {
        ServerAccessInfo sai = new ServerAccessInfo();
        ConnectionManager4CLI connManager = new ConnectionManager4CLI(sai);
        DataSource ds = connManager.getDataSource();
        Connection connection = ds.getConnection();
        return connection;
    }

    private String getFRDictMigrationDirectory() {
        return String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.FREERADIUS_DICT_MIG_DIR.toLowerCase();
    }

    private String getInstalledDictionaryFilePath(String fileName) {
        if (!fileName.endsWith(DCT_TOKEN) || !fileName.endsWith(DCI_TOKEN)) {
            return String.valueOf(AMRadiusMigrationConstants.RADIUS_HOME_DIR) + fileName + DCT_TOKEN;
        }
        return String.valueOf(AMRadiusMigrationConstants.RADIUS_HOME_DIR) + fileName;
    }

    private String getFRMigrationDirectory() {
        return String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.FREERADIUS_MIGRATION_DIR.toLowerCase() + File.separator;
    }

    private String getSBRDictionaryMigrationDirectory() {
        return String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.SBR_DICT_MIG_DIR + File.separator;
    }

    private String getInstalledVendorIniFilePath() {
        return String.valueOf(AMRadiusMigrationConstants.RADIUS_HOME_DIR) + "vendor.ini";
    }

    private static String splitByStop(String line, int index) {
        return line.trim().split("\\.")[index].trim();
    }

    private void logInfo(String msg) {
        MigrationLoggingHelper.getmigrationLogger().log(Level.INFO, msg);
    }

    private void logWarn(String msg) {
        MigrationLoggingHelper.getmigrationLogger().log(Level.WARNING, msg);
    }

    private void logError(String msg, Throwable thrown) {
        MigrationLoggingHelper.getmigrationLogger().log(Level.SEVERE, msg, thrown);
    }
}

