/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.handler.impl;

import com.rsa.authmgr.admin.migration.handler.AMRadiusProfileMigration;
import com.rsa.authmgr.admin.migration.utility.MigrationLoggingHelper;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.data.NamedAttributeDTO;
import com.rsa.authmgr.admin.radius.data.RadiusAttributeDTO;
import com.rsa.authmgr.admin.radius.data.RadiusProfileAttrDTO;
import com.rsa.authmgr.admin.radius.data.RadiusProfileDTO;
import com.rsa.authmgr.admin.radius.data.converter.RadiusCheckListConverter;
import com.rsa.authmgr.admin.radius.data.converter.RadiusProfileConverter;
import com.rsa.authmgr.admin.radius.data.converter.RadiusReturnListConverter;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.internal.admin.radius.RadiusProfileAdministration;
import com.rsa.authmgr.internal.radius.jaxb.checklists.CheckList;
import com.rsa.authmgr.internal.radius.jaxb.profiles.AuthenticationProfiles;
import com.rsa.authmgr.internal.radius.jaxb.returnlists.ReturnList;
import com.rsa.common.search.Filter;
import com.rsa.security.SecurityContext;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class AMRadiusProfileMigrationImpl
implements AMRadiusProfileMigration {
    RadiusMigrationUtility migUtility = new RadiusMigrationUtility();
    List<String> profileMigrationFailure = new ArrayList<String>();
    Map<String, String> attributeValueNameChanged = new HashMap<String, String>();
    List<String> usedAttributesNameChanged = new ArrayList<String>();
    private static final String RADIUS_PROFILES = "RADIUS profiles";
    private static final String BEGIN_HEX_TOKEN = "0x";
    private Map<String, List<NamedAttributeDTO>> checkListNamedAtrrubuteMap;
    private Map<String, List<NamedAttributeDTO>> returnListNamedAtrrubuteMap;

    @Override
    public void importRadiusProfileData() throws Exception {
        this.logInfo("***Starting Migration of Radius profile***");
        try {
            Path path = Paths.get(String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.SBR_MIG_DIR, new String[0]);
            File realmRadSrvExpLoc = new File(path.toAbsolutePath().toString());
            this.attributeValueNameChanged = this.getAttributeValueNameChangedMap();
            AuthenticationProfiles profileData = (AuthenticationProfiles)this.migUtility.convertXMLToStringofProfules(new File(realmRadSrvExpLoc, "radiusProfiles.xml"), RADIUS_PROFILES, null);
            String absPAth = new File(realmRadSrvExpLoc, "radiusCheckList.xml").getAbsolutePath();
            String xml = Files.lines(Paths.get(absPAth, new String[0])).collect(Collectors.joining("\n"));
            CheckList checklist = this.migUtility.convertToCheckList(this.formatXML(xml));
            List radiusAttributeDTOCheckList = RadiusCheckListConverter.convertToCheckListRadiusAttrDTOs((CheckList)checklist);
            this.checkListNamed(radiusAttributeDTOCheckList);
            absPAth = new File(realmRadSrvExpLoc, "radiusReturnList.xml").getAbsolutePath();
            xml = Files.lines(Paths.get(absPAth, new String[0])).collect(Collectors.joining("\n"));
            ReturnList returnlist = this.migUtility.convertToreturnList(this.formatXML(xml));
            List radiusAttributeDTOReturnList = RadiusReturnListConverter.convertToReturnListRadiusAttrDTOs((ReturnList)returnlist);
            this.returnListNamed(radiusAttributeDTOReturnList);
            this.logInfo("Total number of profiles considered for migration: " + profileData.getAuthenticationProfile().size());
            RadiusMigrationUtility.getMigrateResultDTO().setTotalNumberOfProfiles(profileData.getAuthenticationProfile().size());
            if (profileData == null || profileData.getAuthenticationProfile().size() <= 0) {
                this.logInfo("There were no profiles available for migration.");
                return;
            }
            List xuiRadiusProfileList = RadiusProfileConverter.getRadiusProfilesDTO((AuthenticationProfiles)profileData);
            try {
                try {
                    this.updateRadiusProfiles(xuiRadiusProfileList);
                    this.logInfo("Successfully completed Migration of RADIUS profile");
                    this.setLoggerProperties();
                }
                catch (Exception e) {
                    this.logError("Failed to migrate RADIUS profile due to error: " + e.getLocalizedMessage(), e);
                    e.printStackTrace();
                    this.setLoggerProperties();
                    throw e;
                }
            }
            finally {
                this.setLoggerProperties();
            }
            RadiusMigrationUtility.getMigrateResultDTO().setProfilesFailedToMigrate(this.profileMigrationFailure);
            RadiusMigrationUtility.getMigrateResultDTO().setTotalNumberOfProfilesFailed(this.profileMigrationFailure.size());
            int totalProfilesSuccess = profileData.getAuthenticationProfile().size() - this.profileMigrationFailure.size();
            RadiusMigrationUtility.getMigrateResultDTO().setTotalNumberOfProfilesSuccess(totalProfilesSuccess);
            RadiusMigrationUtility.getMigrateResultDTO().setUsedAttributeNameChanged(this.usedAttributesNameChanged);
        }
        catch (Exception e) {
            this.logError("Failed to migrate RADIUS profile due to error: " + e.getLocalizedMessage(), e);
            e.printStackTrace();
        }
    }

    private void updateRadiusProfiles(List<RadiusProfileDTO> xuiRadiusProfileList) throws Exception {
        if (xuiRadiusProfileList == null || xuiRadiusProfileList.isEmpty()) {
            this.logError("Unable to retrieve the list of SBR profiles.  SBR profiles are unavailable for migration as the list is empty", null);
            return;
        }
        ArrayList radiusProfileList = new ArrayList();
        radiusProfileList.addAll(this.getRadiusProfile().getRadiusProfiles(this.migUtility.getTopLevelSD(), Filter.empty(), 0));
        this.logInfo("Retrived the RADIUS profiles list from the database. Total number of profiles retrieved: " + radiusProfileList.size());
        if (radiusProfileList == null || radiusProfileList.isEmpty()) {
            this.logWarn("Unable to retrive profiles from AM database, profiles are available in SBR RADIUS server.");
            throw new Exception("Failed to retrieve the profiles from AM database, profiles are available in SBR RADIUS server.");
        }
        HashMap<String, RadiusProfileDTO> radProfileMap = new HashMap<String, RadiusProfileDTO>(radiusProfileList.size());
        for (RadiusProfileDTO radProfile : radiusProfileList) {
            radProfileMap.put(radProfile.getName(), radProfile);
        }
        int logProgressCounter = 1;
        int recordCounter = 1;
        Iterator<RadiusProfileDTO> iter = xuiRadiusProfileList.iterator();
        while (iter.hasNext()) {
            String profileName = null;
            try {
                if (RadiusMigrationUtility.getLogProgressSize() % logProgressCounter == 100) {
                    this.logProgressInfo("Completed migration of " + recordCounter + " profile records. Migration of profile records in progress.");
                    logProgressCounter = 1;
                }
                RadiusProfileDTO dto = iter.next();
                profileName = dto.getName();
                final RadiusProfileDTO amRadiusprofile = (RadiusProfileDTO)radProfileMap.get(dto.getName());
                if (amRadiusprofile != null) {
                    amRadiusprofile.setCheckLists(this.getModifiedCheckList(dto.getCheckLists(), dto.getName()));
                    amRadiusprofile.setReturnLists(this.getModifiedReturnList(dto.getReturnLists(), dto.getName()));
                    SecurityContext.doAsSystem((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            AMRadiusProfileMigrationImpl.this.getRadiusProfile().updateRadiusProfile(amRadiusprofile);
                            return null;
                        }
                    });
                }
                ++recordCounter;
                ++logProgressCounter;
                this.logInfo("Successfully updated the RADIUS profile with name: " + amRadiusprofile.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                ++recordCounter;
                ++logProgressCounter;
                this.logError("Failed to migrate RADIUS profile with name: " + profileName, e);
                this.profileMigrationFailure.add(profileName);
            }
        }
    }

    private List<RadiusProfileAttrDTO> getModifiedCheckList(List<RadiusProfileAttrDTO> orginalList, String profileName) {
        Iterator<RadiusProfileAttrDTO> iterator = orginalList.iterator();
        while (iterator.hasNext()) {
            String hexValue;
            RadiusProfileAttrDTO radiusProfileAttrDTO = iterator.next();
            this.logInfo("SBR checklist Attribute details name:" + radiusProfileAttrDTO.getName() + " Type: " + radiusProfileAttrDTO.getType() + " value: " + radiusProfileAttrDTO.getValue() + " Order:::" + radiusProfileAttrDTO.getOrder());
            if (radiusProfileAttrDTO == null) continue;
            radiusProfileAttrDTO.setMultivalued(true);
            if (radiusProfileAttrDTO.getOrder() == null || radiusProfileAttrDTO.getOrder().intValue() == 0) {
                radiusProfileAttrDTO.setOrder(BigInteger.ONE);
            }
            if (radiusProfileAttrDTO.getType().equalsIgnoreCase("hexadecimal") && !(hexValue = radiusProfileAttrDTO.getValue()).startsWith(BEGIN_HEX_TOKEN)) {
                radiusProfileAttrDTO.setValue(BEGIN_HEX_TOKEN + hexValue);
            }
            radiusProfileAttrDTO.setType(RadiusMigrationUtility.getFreeradiusDataType(radiusProfileAttrDTO.getType()));
            this.logInfo("FR Converted checklist attribute name:::" + radiusProfileAttrDTO.getName() + " Type::: " + radiusProfileAttrDTO.getType() + " Value:::" + radiusProfileAttrDTO.getValue() + " Order:::" + radiusProfileAttrDTO.getOrder());
            String nameAttributeValue = this.getCheckListNamedAttrValueBasedName(radiusProfileAttrDTO.getName(), radiusProfileAttrDTO.getValue());
            if (nameAttributeValue != null) {
                String attributeNameChangeCheck = String.valueOf(radiusProfileAttrDTO.getName()) + ":" + nameAttributeValue;
                if (this.attributeValueNameChanged != null && this.attributeValueNameChanged.get(attributeNameChangeCheck) != null) {
                    String[] changedNameAttributeValue = this.attributeValueNameChanged.get(attributeNameChangeCheck).split("\\,");
                    this.logInfo("The profile returnlist attribute value name has been changed from: " + nameAttributeValue + " to: " + changedNameAttributeValue[1]);
                    if (radiusProfileAttrDTO.getValue().equalsIgnoreCase(changedNameAttributeValue[0])) {
                        nameAttributeValue = changedNameAttributeValue[1];
                    }
                }
                if (nameAttributeValue != null) {
                    radiusProfileAttrDTO.setType("string");
                }
                radiusProfileAttrDTO.setValue(nameAttributeValue);
            }
            if (radiusProfileAttrDTO.getValue() != null && radiusProfileAttrDTO.getValue().length() != 0) continue;
            this.logWarn("For the profile name::" + profileName + ",attribute name " + radiusProfileAttrDTO.getName() + " value is empty.So skipping this checklist attribute.");
            iterator.remove();
        }
        return orginalList;
    }

    private List<RadiusProfileAttrDTO> getModifiedReturnList(List<RadiusProfileAttrDTO> orginalList, String profileName) {
        HashMap<String, Integer> profileAttrOrder = new HashMap<String, Integer>();
        Iterator<RadiusProfileAttrDTO> iterator = orginalList.iterator();
        while (iterator.hasNext()) {
            String hexValue;
            RadiusProfileAttrDTO radiusProfileAttrDTO = iterator.next();
            this.logInfo("SBR returnlist Attribute details name: " + radiusProfileAttrDTO.getName() + "Type: " + radiusProfileAttrDTO.getType() + "Value: " + radiusProfileAttrDTO.getValue() + " Order:::" + radiusProfileAttrDTO.getOrder());
            if (radiusProfileAttrDTO == null) continue;
            radiusProfileAttrDTO.setMultivalued(true);
            if (radiusProfileAttrDTO.getOrder() == null || radiusProfileAttrDTO.getOrder().intValue() == 0) {
                if (profileAttrOrder.get(radiusProfileAttrDTO.getName()) == null) {
                    profileAttrOrder.put(radiusProfileAttrDTO.getName(), BigInteger.ONE.intValue());
                    radiusProfileAttrDTO.setOrder(BigInteger.ONE);
                } else {
                    int orderCounter = (Integer)profileAttrOrder.get(radiusProfileAttrDTO.getName()) + 1;
                    profileAttrOrder.put(radiusProfileAttrDTO.getName(), orderCounter);
                    radiusProfileAttrDTO.setOrder(BigInteger.valueOf(orderCounter));
                }
            }
            if (radiusProfileAttrDTO.getType().equalsIgnoreCase("hexadecimal") && !(hexValue = radiusProfileAttrDTO.getValue()).startsWith(BEGIN_HEX_TOKEN)) {
                radiusProfileAttrDTO.setValue(BEGIN_HEX_TOKEN + hexValue);
            }
            radiusProfileAttrDTO.setType(RadiusMigrationUtility.getFreeradiusDataType(radiusProfileAttrDTO.getType()));
            this.logInfo("FR Converted returnlist attribute name : " + radiusProfileAttrDTO.getName() + " Type: " + radiusProfileAttrDTO.getType() + " Value: " + radiusProfileAttrDTO.getValue() + " Order:::" + radiusProfileAttrDTO.getOrder());
            String nameAttributeValue = this.getReturnListNamedAttrValueBasedName(radiusProfileAttrDTO.getName(), radiusProfileAttrDTO.getValue());
            String attributeNameChangeCheck = String.valueOf(radiusProfileAttrDTO.getName()) + ":" + nameAttributeValue;
            if (this.attributeValueNameChanged != null && this.attributeValueNameChanged.get(attributeNameChangeCheck) != null) {
                String[] changedNameAttributeValue = this.attributeValueNameChanged.get(attributeNameChangeCheck).split("\\,");
                this.logInfo("The profile returnlist attribute value name has been changed from: " + nameAttributeValue + " to: " + changedNameAttributeValue[1]);
                if (radiusProfileAttrDTO.getValue().equalsIgnoreCase(changedNameAttributeValue[0])) {
                    nameAttributeValue = changedNameAttributeValue[1];
                }
            }
            if (nameAttributeValue != null) {
                radiusProfileAttrDTO.setType("string");
                radiusProfileAttrDTO.setValue(nameAttributeValue);
            }
            if (radiusProfileAttrDTO.getValue() != null && radiusProfileAttrDTO.getValue().length() != 0 || radiusProfileAttrDTO.isEcho()) continue;
            this.logWarn("For the profile name::" + profileName + ",attribute name " + radiusProfileAttrDTO.getName() + " value is empty.So skipping this returnList attribute.");
            iterator.remove();
        }
        return orginalList;
    }

    private RadiusProfileAdministration getRadiusProfile() {
        return this.migUtility.getRadProfileAdmin();
    }

    private void returnListNamed(List<RadiusAttributeDTO> radiusAttributeDTOReturnList) {
        this.returnListNamedAtrrubuteMap = new HashMap<String, List<NamedAttributeDTO>>(radiusAttributeDTOReturnList.size());
        for (RadiusAttributeDTO radiusAttributeDTO : radiusAttributeDTOReturnList) {
            if (!radiusAttributeDTO.isNamedAttribute()) continue;
            this.returnListNamedAtrrubuteMap.put(radiusAttributeDTO.getId(), radiusAttributeDTO.getNamedAttributes());
        }
    }

    private void checkListNamed(List<RadiusAttributeDTO> radiusAttributeDTOCheckList) {
        this.checkListNamedAtrrubuteMap = new HashMap<String, List<NamedAttributeDTO>>(radiusAttributeDTOCheckList.size());
        for (RadiusAttributeDTO radiusAttributeDTO : radiusAttributeDTOCheckList) {
            if (!radiusAttributeDTO.isNamedAttribute()) continue;
            this.checkListNamedAtrrubuteMap.put(radiusAttributeDTO.getId(), radiusAttributeDTO.getNamedAttributes());
        }
    }

    private String getCheckListNamedAttrValueBasedName(String namedAttributeName, String value) {
        String namedAttrName = null;
        if (this.checkListNamedAtrrubuteMap == null && this.checkListNamedAtrrubuteMap.size() == 0) {
            return namedAttrName;
        }
        List<NamedAttributeDTO> namelist = this.checkListNamedAtrrubuteMap.get(namedAttributeName);
        if (namelist == null) {
            return namedAttrName;
        }
        for (NamedAttributeDTO attr : namelist) {
            if (!attr.getValue().equals(value)) continue;
            namedAttrName = attr.getName();
            break;
        }
        return namedAttrName;
    }

    private String getReturnListNamedAttrValueBasedName(String namedAttributeName, String value) {
        String namedAttrName = null;
        if (this.returnListNamedAtrrubuteMap == null && this.returnListNamedAtrrubuteMap.size() == 0) {
            return namedAttrName;
        }
        List<NamedAttributeDTO> namelist = this.returnListNamedAtrrubuteMap.get(namedAttributeName);
        if (namelist == null) {
            return namedAttrName;
        }
        for (NamedAttributeDTO attr : namelist) {
            if (!attr.getValue().equals(value)) continue;
            namedAttrName = attr.getName();
            break;
        }
        return namedAttrName;
    }

    private String formatXML(String p_orig) {
        String oldStartPattern = "<namedAttribute";
        String newStartpattern = "<namedAttributeE";
        String oldEndPattern = "</namedAttribute>";
        String newEndPattern = "</namedAttributeE>";
        p_orig = p_orig.replaceAll(oldStartPattern, newStartpattern);
        p_orig = p_orig.replaceAll(oldEndPattern, newEndPattern);
        return p_orig;
    }

    private Map<String, String> getAttributeValueNameChangedMap() throws IOException {
        HashMap<String, String> attributeValuenameChangedMap = new HashMap<String, String>();
        for (String line : RadiusMigrationUtility.getPremigrateResultDTO().getAttributeValueNameChangedList()) {
            String[] lineArray = line.split(":");
            if (lineArray == null || lineArray.length < 4) continue;
            attributeValuenameChangedMap.put(String.valueOf(lineArray[0]) + ":" + lineArray[1], String.valueOf(lineArray[2]) + "," + lineArray[3]);
        }
        return attributeValuenameChangedMap;
    }

    private Map<String, String> getAttributeNameChangedMap() throws IOException {
        HashMap<String, String> nameChangedMap = new HashMap<String, String>();
        if (RadiusMigrationUtility.getPremigrateResultDTO().getAttributeNameChangedList() != null && !RadiusMigrationUtility.getPremigrateResultDTO().getAttributeNameChangedList().isEmpty()) {
            for (String line : RadiusMigrationUtility.getPremigrateResultDTO().getAttributeNameChangedList()) {
                String[] lineArray;
                if (line == null || line.isEmpty() || (lineArray = line.split(":")) == null || lineArray.length < 1) continue;
                nameChangedMap.put(lineArray[0], lineArray[1]);
            }
        }
        return nameChangedMap;
    }

    private void logInfo(String msg) {
        MigrationLoggingHelper.getmigrationLogger().setUseParentHandlers(false);
        MigrationLoggingHelper.getmigrationLogger().log(Level.INFO, msg);
    }

    private void logProgressInfo(String msg) {
        MigrationLoggingHelper.getmigrationLogger().setUseParentHandlers(true);
        MigrationLoggingHelper.getmigrationLogger().log(Level.INFO, msg);
    }

    private void logWarn(String msg) {
        MigrationLoggingHelper.getmigrationLogger().setUseParentHandlers(true);
        MigrationLoggingHelper.getmigrationLogger().log(Level.WARNING, msg);
    }

    private void logError(String msg, Throwable thrown) {
        MigrationLoggingHelper.getmigrationLogger().setUseParentHandlers(true);
        MigrationLoggingHelper.getmigrationLogger().log(Level.SEVERE, msg, thrown);
    }

    private void setLoggerProperties() {
        MigrationLoggingHelper.getmigrationLogger().setUseParentHandlers(true);
    }
}

