/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.mgmt;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DictionaryConfigManager {
    static final String DICTIONARY_FILE_FILTER = "dictionary.";
    public static final String VENDOR_INI_FILENAME = "vendor.ini";
    static final String VENDOR_INI_BACKUPFILE = "vendor.ini.bk";
    static final String DICTIONARY_BACKUPFILE = "bk.dictionary.bk";
    static final String INCLUDE_TOKEN = "$INCLUDE ";
    static final String INCLUDE_DICTIONARY = "$INCLUDE dictionary.";
    private static final String EXCLUDED_FILE_LIST = "iana,dictionary.freeradius.internal,dictionary.usr.illegal,dictionary.ascend.illegal,dictionary.rfc";

    public List<String> getInstalledNonConflictingDictionaryFiles() throws Exception {
        ArrayList<String> mergedDictionaryEntries = new ArrayList<String>();
        Map<String, List<String>> installedVendorIDMap = this.parseDictionaryFilesForVendorID(this.getInstalledMasterDictionaryFileContent());
        Map<String, List<String>> migratedVendorIDMap = this.parseDictionaryFilesForVendorID(this.getMigratedMasterDictionaryFileContent());
        for (Map.Entry<String, List<String>> entry : migratedVendorIDMap.entrySet()) {
            if (installedVendorIDMap.get(entry.getKey()) == null) continue;
            installedVendorIDMap.remove(entry.getKey());
        }
        installedVendorIDMap.forEach((k, v) -> {
            for (String entry : v) {
                mergedDictionaryEntries.add(entry);
            }
        });
        return mergedDictionaryEntries;
    }

    public Map<String, List<String>> getVendorDictionaryMap(String filePath, boolean createOnError) throws Exception {
        try {
            return this.readVendorFile(filePath);
        }
        catch (IOException e) {
            if (createOnError) {
                return this.createNewVendorIniMap();
            }
            throw e;
        }
    }

    public void backupDictionaryConfigFiles(String srcFilePath, String destFilePath) throws IOException {
        if (!RadiusMigrationUtility.checkFileExists(srcFilePath)) {
            throw new FileNotFoundException("Unable to find the source file to perform backup" + srcFilePath);
        }
        Files.copy(Paths.get(srcFilePath, new String[0]), Paths.get(destFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public void deleteDictionaryConfigFiles(String filePath) throws IOException {
        if (!RadiusMigrationUtility.checkFileExists(filePath)) {
            throw new FileNotFoundException("Unable to find the source file to perform backup" + filePath);
        }
        Files.delete(Paths.get(filePath, new String[0]));
    }

    private Map<String, List<String>> createNewVendorIniMap() throws Exception {
        return this.parseDictionaryFilesForVendorName(this.getInstalledMasterDictionaryFileContent());
    }

    public Map<String, List<String>> parseDictionaryFilesForVendorName(List<String> dictionaryFileList) throws Exception {
        HashMap<String, List<String>> vendorList = new HashMap<String, List<String>>();
        for (String fileName : dictionaryFileList) {
            Path dictionaryFileName = Paths.get(this.getInstalledDictionaryFilePath(fileName), new String[0]);
            try {
                String vendorName;
                if (DictionaryConfigManager.isExcluded(dictionaryFileName.getFileName().toString()).booleanValue() || (vendorName = Files.readAllLines(dictionaryFileName).stream().filter(fileEntry -> fileEntry.startsWith("VENDOR")).findFirst().orElse("").split("\\s+")[1].trim()) == null || fileName == null) continue;
                vendorList.put(vendorName, Arrays.asList(fileName));
            }
            catch (Exception e) {
                throw new Exception("Failed to parse the dictionary files to retrive the vendor Names" + e.getMessage());
            }
        }
        return vendorList;
    }

    private Map<String, List<String>> parseDictionaryFilesForVendorID(List<String> dictionaryFileList) throws Exception {
        HashMap<String, List<String>> vendorIDMap = new HashMap<String, List<String>>();
        for (String fileName : dictionaryFileList) {
            Path dictionaryFileName = Paths.get(this.getInstalledDictionaryFilePath(fileName.split("\\s+")[1].trim()), new String[0]);
            try {
                String vendorID;
                if (DictionaryConfigManager.isExcluded(dictionaryFileName.getFileName().toString()).booleanValue() || (vendorID = (String)Files.readAllLines(dictionaryFileName).stream().filter(fileEntry -> fileEntry.startsWith("VENDOR")).findFirst().orElse(null)) == null) continue;
                if (vendorIDMap.get(vendorID) == null) {
                    vendorIDMap.put(this.splitLineBySpace(vendorID, 2), Arrays.asList(this.splitLineBySpace(fileName, 1)));
                    continue;
                }
                List temp = (List)vendorIDMap.get(vendorID);
                temp.add(this.splitLineBySpace(fileName, 1));
                vendorIDMap.put(this.splitLineBySpace(vendorID, 2), temp);
            }
            catch (Exception e) {
                throw new Exception("Failed to parse the dictionary files to retrive the vendor ID" + e.getMessage());
            }
        }
        return vendorIDMap;
    }

    private List<String> getInstalledMasterDictionaryFileContent() throws IOException {
        return this.readMasterDictionaryFile(this.getInstalledMasterDictFilePath());
    }

    public List<String> getMigratedMasterDictionaryFileContent() throws IOException {
        return this.readMasterDictionaryFile(this.getMigratedMasterDictionaryFilePath());
    }

    private List<String> readMasterDictionaryFile(String fileName) throws IOException {
        return Files.readAllLines(Paths.get(fileName, new String[0])).stream().filter(str -> str.startsWith(INCLUDE_DICTIONARY)).collect(Collectors.toList());
    }

    public static Boolean isExcluded(String dictionaryFileName) {
        String[] dictionaryFilesToExcluded = EXCLUDED_FILE_LIST.split(",");
        Boolean isExcluded = false;
        int i = 0;
        while (i < dictionaryFilesToExcluded.length) {
            isExcluded = isExcluded != false || dictionaryFileName.startsWith(dictionaryFilesToExcluded[i]);
            ++i;
        }
        return isExcluded;
    }

    private Map<String, List<String>> readVendorFile(String filePath) throws IOException {
        HashMap<String, List<String>> vendorDictMap;
        block6: {
            vendorDictMap = new HashMap<String, List<String>>();
            File file = new File(filePath);
            if (RadiusMigrationUtility.checkFileExists(file.getAbsolutePath().toString())) {
                Scanner scanner = new Scanner(file);
                while (scanner != null && scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (!line.startsWith("vendor-product")) continue;
                    String vendorName = this.splitLineByEquals(line, 1);
                    String[] dictionaryNames = null;
                    line = scanner.nextLine();
                    if (line.startsWith("dictionary")) {
                        dictionaryNames = this.splitLineByEquals(line, 1).split("\\,");
                    }
                    if (vendorName != null && !vendorName.isEmpty() && dictionaryNames != null && dictionaryNames.length > 0) {
                        vendorDictMap.put(vendorName, Arrays.asList(dictionaryNames));
                        continue;
                    }
                    throw new IOException("Invalid Vendor.ini File not format, does not contain vendor names : " + filePath);
                }
                scanner.close();
                break block6;
            }
            throw new FileNotFoundException("Vendor.ini File not found in the path: " + filePath);
        }
        return vendorDictMap;
    }

    public void copyMigratedDictionaryFilesToInstalledLocation() throws IOException {
        List<Path> dictFilePaths = null;
        try {
            dictFilePaths = this.getAllFilesInDirectory(this.getMigratedDictionaryDirectory(), DICTIONARY_FILE_FILTER);
            for (Path path : dictFilePaths) {
                System.out.println("copy the files to installed path" + path.toString());
                Files.copy(path, Paths.get(String.valueOf(AMRadiusMigrationConstants.FREERADIUS_DICTIONARY_DIR) + path.getFileName(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to copy the migrated configuration files : " + e.getLocalizedMessage());
        }
    }

    public List<Path> getAllFilesInDirectory(String directoryPath, String filter) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Stream<Path> paths = Files.walk(Paths.get(directoryPath, new String[0]), 1, new FileVisitOption[0]);){
                return paths.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(filter) || path.getFileName().toString().endsWith(filter)).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("Unable find the files in the path" + directoryPath);
            throw e;
        }
    }

    public String getVendorIniVendorProductNameFileEntryString(String vendorName) {
        return "vendor-product\t=\t" + vendorName;
    }

    public String getVendorIniDictionaryNameFileEntryString(String fileNames) {
        return "dictionary\t=\t" + fileNames + "\n";
    }

    private String getInstalledDictionaryFilePath(String fileName) {
        return String.valueOf(AMRadiusMigrationConstants.FREERADIUS_DICTIONARY_DIR) + fileName;
    }

    private String splitLineByEquals(String line, int index) {
        return line.split("=")[index].trim();
    }

    private String splitLineBySpace(String line, int index) {
        return line.split("\\s+")[index].trim();
    }

    public String getInstalledMasterDictFilePath() {
        return String.valueOf(AMRadiusMigrationConstants.FREERADIUS_DICTIONARY_DIR) + "dictionary";
    }

    public String getInstalledVendorIniFilePath() {
        return String.valueOf(AMRadiusMigrationConstants.FREERADIUS_DICTIONARY_DIR) + VENDOR_INI_FILENAME;
    }

    public String getMigratedVendorIniFilePath() {
        return String.valueOf(this.getFRMigrationDirectory()) + VENDOR_INI_FILENAME;
    }

    public String getMigratedMasterDictionaryFilePath() {
        return String.valueOf(this.getMigratedDictionaryDirectory()) + "dictionary";
    }

    private String getMigratedDictionaryDirectory() {
        return String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.FREERADIUS_DICT_MIG_DIR.toLowerCase();
    }

    private String getFRMigrationDirectory() {
        return String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.FREERADIUS_MIGRATION_DIR.toLowerCase();
    }
}

