/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.mgmt;

import com.rsa.authmgr.admin.radius.migration.data.DictionaryDTO;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DictionaryObjectConverter {
    private static final String EMPTY_NONE = "NONE";
    private static final String DICT_ATTR_VID_TOKEN = "vid";
    private static int vendorIdGenerator = 30000;
    private static Map<String, String> FR_VENDOR_ID = new HashMap<String, String>();

    static {
        FR_VENDOR_ID.put("shiva.dct", "166");
        FR_VENDOR_ID.put("ascend.dct", "529");
        FR_VENDOR_ID.put("bianca.dct", "272");
        FR_VENDOR_ID.put("netblazr.dct", "117");
    }

    public List<List<DictionaryDTO>> getDictionaryConvertedObjects(Map<String, List<String>> VendorNameDictPathMap) {
        ArrayList<List<DictionaryDTO>> dictionaryList = new ArrayList<List<DictionaryDTO>>();
        VendorNameDictPathMap.forEach((keyName, valueList) -> {
            ArrayList<DictionaryDTO> dictionaryForEachVendorList = new ArrayList<DictionaryDTO>();
            for (String value : valueList) {
                try {
                    List<String> fileEntries = Files.readAllLines(Paths.get(value, new String[0]), StandardCharsets.ISO_8859_1);
                    dictionaryForEachVendorList.addAll(this.getOrderedFileEntries(fileEntries, Paths.get(value, new String[0]).getFileName().toString(), (String)keyName));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dictionaryList.add(dictionaryForEachVendorList);
        });
        return dictionaryList;
    }

    private List<DictionaryDTO> getOrderedFileEntries(List<String> sbrFileEntries, String fileName, String vendorName) {
        ArrayList<DictionaryDTO> dictionaryList = new ArrayList<DictionaryDTO>();
        ArrayList macroList = new ArrayList();
        DictionaryDTO dto = new DictionaryDTO();
        if (sbrFileEntries == null || sbrFileEntries.isEmpty()) {
            dto = new DictionaryDTO();
            dto.setValid(false);
            dto.setMigrated(false);
            dto.setDictionaryFileName(fileName);
            dto.setVendorName(vendorName);
            dictionaryList.add(dto);
        } else {
            macroList.addAll(sbrFileEntries.stream().filter(str -> str.startsWith("MACRO")).collect(Collectors.toList()));
            if (!macroList.isEmpty()) {
                for (String macorline : macroList) {
                    dto = new DictionaryDTO();
                    dto = this.convertToDTO(macorline);
                    dto.setMigrated(false);
                    dto.setDictionaryFileName(fileName);
                    dto.setVendorName(vendorName);
                    dto.setValid(this.setValidDictionaryFile(dto));
                    if (macroList.size() == 1 && dto.getFormat().equalsIgnoreCase("1,1")) {
                        dto.setAttributesList(this.getAttributeFileEntryList(sbrFileEntries, null));
                        dto.setValuesList(this.getValueFileEntryList(sbrFileEntries, dto, null));
                    } else if (macroList.size() == 1 && !dto.getFormat().equalsIgnoreCase("1,1")) {
                        dto.setAttributesList(this.getAttributeFileEntryList(sbrFileEntries, dto.getMacroName()));
                        dto.setValuesList(this.getValueFileEntryList(sbrFileEntries, dto, dto.getMacroName()));
                    } else {
                        dto.setAttributesList(this.getAttributeFileEntryList(sbrFileEntries, dto.getMacroName()));
                        dto.setValuesList(this.getValueFileEntryList(sbrFileEntries, dto, dto.getMacroName()));
                    }
                    dictionaryList.add(dto);
                }
                if (macroList.size() > 1 || macroList.size() == 1 && !dto.getFormat().equalsIgnoreCase("1,1")) {
                    dto = new DictionaryDTO();
                    if (vendorName.equalsIgnoreCase("- Standard Radius -")) {
                        dto.setVendorName(vendorName);
                        dto.setDictionaryFileName(fileName);
                        dto.setVendorID(this.vendorIDGenerator(fileName));
                    } else {
                        dto = this.convertToDTO((String)macroList.get(0));
                        dto.setVendorName(vendorName);
                        dto.setDictionaryFileName(fileName);
                        dto.setMacroName(null);
                    }
                    dto = this.processFileEntriesWithoutPrefixMacro(sbrFileEntries, dto);
                    if (dto.getAttributesList() != null && dto.getAttributesList().size() > 0 || dto.getValuesList() != null && dto.getValuesList().size() > 0) {
                        dictionaryList.add(dto);
                    }
                }
            } else {
                String fileEntryLine = sbrFileEntries.stream().filter(str -> str.startsWith("ATTRIBUTE") && str.contains(DICT_ATTR_VID_TOKEN)).findFirst().orElse(EMPTY_NONE);
                if (fileEntryLine != null && !fileEntryLine.isEmpty() && !fileEntryLine.contains(EMPTY_NONE)) {
                    dto = new DictionaryDTO();
                    dto = this.convertToDTO(fileEntryLine);
                    dto.setDictionaryFileName(fileName);
                    dto.setVendorName(vendorName);
                    if (dto.getVendorID() == null || dto.getVendorID().isEmpty()) {
                        dto.setVendorID(this.vendorIDGenerator(fileName));
                    }
                    dto.setAttributesList(this.getAttributeFileEntryList(sbrFileEntries, null));
                    dto.setValuesList(this.getValueFileEntryList(sbrFileEntries, dto, null));
                    dictionaryList.add(dto);
                } else {
                    dto = new DictionaryDTO();
                    dto.setDictionaryFileName(fileName);
                    dto.setVendorName(vendorName);
                    dto.setFormat("1,1");
                    if (dto.getVendorID() == null || dto.getVendorID().isEmpty()) {
                        dto.setVendorID(this.vendorIDGenerator(fileName));
                    }
                    dto.setAttributesList(this.getAttributeFileEntryList(sbrFileEntries, null));
                    dto.setValuesList(this.getValueFileEntryList(sbrFileEntries, dto, null));
                    dictionaryList.add(dto);
                }
            }
        }
        return dictionaryList;
    }

    private DictionaryDTO processFileEntriesWithoutPrefixMacro(List<String> sbrFileEntries, DictionaryDTO dto) {
        dto.setAttributesList(sbrFileEntries.stream().filter(str -> str.trim().startsWith("ATTRIBUTE") && !str.contains("(")).map(String::trim).collect(Collectors.toList()));
        if (dto.getAttributesList() != null && !dto.getAttributesList().isEmpty()) {
            dto.setValid(true);
            dto.setFormat("1,1");
            ArrayList<String> valueList = new ArrayList<String>();
            for (String attributeEntry : dto.getAttributesList()) {
                valueList.addAll(sbrFileEntries.stream().filter(str -> str.trim().startsWith("VALUE") && attributeEntry.trim().split("\\s+")[1].equalsIgnoreCase(str.trim().split("\\s+")[1])).map(String::trim).collect(Collectors.toList()));
            }
            dto.setValuesList(valueList);
        }
        return dto;
    }

    private String vendorIDGenerator(String fileName) {
        StringBuffer vendorID = new StringBuffer();
        if (FR_VENDOR_ID.get(fileName.toLowerCase()) != null) {
            vendorID.append(FR_VENDOR_ID.get(fileName.toLowerCase()));
        } else {
            vendorID.append(String.valueOf(vendorIdGenerator));
            ++vendorIdGenerator;
        }
        return vendorID.toString();
    }

    private List<String> getValueFileEntryList(List<String> sbrFileEntries, DictionaryDTO dto, String macroName) {
        ArrayList<String> values = new ArrayList<String>();
        if (macroName == null) {
            return sbrFileEntries.stream().filter(str -> str.trim().startsWith("VALUE")).map(String::trim).collect(Collectors.toList());
        }
        for (String attributeEntry : dto.getAttributesList()) {
            values.addAll(sbrFileEntries.stream().filter(str -> str.trim().startsWith("VALUE") && attributeEntry.trim().split("\\s+")[1].equalsIgnoreCase(str.trim().split("\\s+")[1])).map(String::trim).collect(Collectors.toList()));
        }
        return values;
    }

    private List<String> getAttributeFileEntryList(List<String> sbrFileEntries, String macroName) {
        if (macroName == null) {
            return sbrFileEntries.stream().filter(str -> str.trim().startsWith("ATTRIBUTE")).map(String::trim).collect(Collectors.toList());
        }
        return sbrFileEntries.stream().filter(str -> str.trim().startsWith("ATTRIBUTE") && str.trim().contains(macroName) && macroName.equalsIgnoreCase(str.trim().split("\\(")[0].trim().split("\\s+")[2].trim().toLowerCase())).map(String::trim).collect(Collectors.toList());
    }

    private boolean setValidDictionaryFile(DictionaryDTO dto) {
        boolean formatMatcherRight = false;
        boolean formatMatcherLeft = false;
        boolean isValidate = true;
        String[] firstDigit = new String[]{"1", "2", "4"};
        String[] secondDigit = new String[]{"0", "1", "2"};
        int i = 0;
        while (i <= firstDigit.length) {
            if (!formatMatcherRight && dto.getFormat().toString().split(",")[0].equalsIgnoreCase(firstDigit[i])) {
                formatMatcherRight = true;
            }
            if (!formatMatcherLeft && !dto.getFormat().toString().split(",")[1].equalsIgnoreCase(secondDigit[i])) {
                formatMatcherLeft = true;
            }
            ++i;
        }
        if (!formatMatcherRight || !formatMatcherLeft) {
            isValidate = false;
        }
        if (dto.getSyntaxPos() == 0 && dto.getDataSyntax() == null) {
            isValidate = false;
        }
        if (dto.getTypePos() == 0 && dto.getTypeSyntax() == null) {
            isValidate = false;
        }
        return isValidate;
    }

    private DictionaryDTO convertToDTO(String macroLine) {
        DictionaryDTO dto = new DictionaryDTO();
        if (macroLine.startsWith("MACRO")) {
            String str;
            int n;
            int n2;
            String[] stringArray;
            int index;
            String lenPrefixStr;
            String lineSplitBySquareBrace = macroLine.split("\\[")[1].trim().toLowerCase();
            String macroName = macroLine.split("\\(")[0].trim().split("\\s+")[1].trim();
            dto.setMacroName(macroName);
            if (lineSplitBySquareBrace.contains(DICT_ATTR_VID_TOKEN)) {
                StringBuffer macroID = new StringBuffer(lineSplitBySquareBrace.split(DICT_ATTR_VID_TOKEN)[1].trim().split("=")[1].trim().split("\\s+")[0].trim());
                dto.setVendorID(macroID.toString());
            }
            StringBuffer formatType = new StringBuffer();
            if (lineSplitBySquareBrace.contains("type") && lineSplitBySquareBrace.contains("len")) {
                formatType.append(lineSplitBySquareBrace.split("type")[1].trim().split("=")[0].trim()).append(",");
                lenPrefixStr = lineSplitBySquareBrace.split("len")[1].trim().split("=")[0].trim();
                formatType.append(String.valueOf(lenPrefixStr));
            } else if (lineSplitBySquareBrace.contains("type") && !lineSplitBySquareBrace.contains("len")) {
                formatType.append(lineSplitBySquareBrace.split("type")[1].trim().split("=")[0].trim()).append(",").append(0);
            } else if (!lineSplitBySquareBrace.contains("type") && lineSplitBySquareBrace.contains("len")) {
                formatType.append(0).append(",");
                lenPrefixStr = lineSplitBySquareBrace.split("len")[1].trim().split("=")[0].trim();
                formatType.append(String.valueOf(lenPrefixStr));
            } else {
                formatType.append(1).append(",").append(1);
            }
            dto.setFormat(formatType.toString());
            StringBuffer data = new StringBuffer();
            if (lineSplitBySquareBrace.contains("data")) {
                data.append(lineSplitBySquareBrace.split("data")[1].trim().split("=")[1].trim().split("]")[0].trim());
            }
            StringBuffer type = new StringBuffer();
            if (lineSplitBySquareBrace.contains("type")) {
                type.append(lineSplitBySquareBrace.split("=%")[1].trim().split("\\s+")[0].trim());
            }
            String[] macroPosSpecifier = macroLine.split("\\(")[1].trim().split("\\)")[0].trim().split("\\,");
            int attrIDPos = 0;
            int syntaxPos = 0;
            if (data.toString().startsWith("%") && data.toString().endsWith("%")) {
                String dataSpecifier = data.toString().substring(1, data.length() - 1);
                index = 1;
                stringArray = macroPosSpecifier;
                n2 = macroPosSpecifier.length;
                n = 0;
                while (n < n2) {
                    str = stringArray[n];
                    if (str.equalsIgnoreCase(dataSpecifier)) {
                        syntaxPos = index;
                        dto.setSyntaxPos(syntaxPos);
                        dto.setDataSyntax(null);
                    }
                    ++index;
                    ++n;
                }
            } else {
                dto.setDataSyntax(data.toString());
            }
            if (type.toString().endsWith("%")) {
                String typeSpecifier = type.toString().substring(0, type.length() - 1);
                index = 1;
                stringArray = macroPosSpecifier;
                n2 = macroPosSpecifier.length;
                n = 0;
                while (n < n2) {
                    str = stringArray[n];
                    if (str.equalsIgnoreCase(typeSpecifier)) {
                        attrIDPos = index;
                        dto.setTypePos(attrIDPos);
                        dto.setTypeSyntax(null);
                    }
                    ++index;
                    ++n;
                }
            } else {
                dto.setTypeSyntax(type.toString());
            }
        } else if (macroLine.startsWith("ATTRIBUTE") && macroLine.contains("[")) {
            String lineSplitBySquareBrace = macroLine.split("\\[")[1].trim().toLowerCase();
            if (macroLine.contains(DICT_ATTR_VID_TOKEN)) {
                String vendorID = macroLine.split(DICT_ATTR_VID_TOKEN)[1].trim().split("=")[1].trim().split("\\s+")[0].trim();
                dto.setVendorID(vendorID);
            }
            StringBuffer formatType = new StringBuffer();
            if (lineSplitBySquareBrace.contains("type") && lineSplitBySquareBrace.contains("len")) {
                formatType.append(lineSplitBySquareBrace.split("type")[1].trim().split("=")[0].trim()).append(",").append(lineSplitBySquareBrace.split("len")[1].trim().split("=")[0].trim());
            } else {
                formatType.append("1").append(",").append("1");
            }
            dto.setFormat(formatType.toString());
        }
        return dto;
    }
}

