/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.mgmt;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.radius.migration.data.DictionaryAttributeDTO;
import com.rsa.authmgr.admin.radius.migration.data.DictionaryAttributeNameValueDTO;
import com.rsa.authmgr.admin.radius.migration.data.DictionaryDTO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class FreeRadiusConflictHandler {
    private static final String FREE_RADIUS_INTERNAL_FILE_NAME = "dictionary.freeradius.internal";
    private static List<String> FR_STD_REQUIRED_ATTR = new ArrayList<String>();

    static {
        FR_STD_REQUIRED_ATTR = new ArrayList<String>();
        FR_STD_REQUIRED_ATTR.add("ATTRIBUTE\tFramed-Filter-Id 11\tstring");
        FR_STD_REQUIRED_ATTR.add("ATTRIBUTE\tOperator-Name 126 string");
        FR_STD_REQUIRED_ATTR.add("ATTRIBUTE Error-Cause 101 integer");
        FR_STD_REQUIRED_ATTR.add("VALUE Error-Cause Residual-Context-Removed 201");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tInvalid-EAP-Packet 202");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tUnsupported-Attribute 401");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tMissing-Attribute 402");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tNAS-Identification-Mismatch 403");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tInvalid-Request\t404");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tUnsupported-Service\t405");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tUnsupported-Extension 406");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tAdministratively-Prohibited 501");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tProxy-Request-Not-Routable 502");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tSession-Context-Not-Found 503");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tSession-Context-Not-Removable 504");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tProxy-Processing-Error\t505");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tResources-Unavailable\t506");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tRequest-Initiated\t507");
        FR_STD_REQUIRED_ATTR.add("ATTRIBUTE\tChargeable-User-Identity\t89\toctets");
        FR_STD_REQUIRED_ATTR.add("VALUE\tError-Cause\tSession-Context-Not-Found 503");
        FR_STD_REQUIRED_ATTR.add("ATTRIBUTE\tVendor-Specific\t26\tvsa");
        FR_STD_REQUIRED_ATTR.add("VALUE\tFramed-Compression\tVan-Jacobson-TCP-IP\t111");
        FR_STD_REQUIRED_ATTR.add("VALUE\tService-Type Framed-User 222");
    }

    public void getStandardRadiusNonConflictingAttributes(List<List<DictionaryDTO>> sbrStandardRadiusDictinaryList, Map<String, List<DictionaryAttributeDTO>> dictionaryAttrNameCheckList, Map<String, List<DictionaryAttributeNameValueDTO>> dictionaryAttrNameValueCheckList, boolean isCreateFRInternalFile) throws IOException {
        String str;
        ArrayList<String> sbrStandardRadiusFileEntries = new ArrayList<String>();
        for (List<DictionaryDTO> singleEntry : sbrStandardRadiusDictinaryList) {
            for (DictionaryDTO dto : singleEntry) {
                sbrStandardRadiusFileEntries.addAll(dto.getAttributesList());
                sbrStandardRadiusFileEntries.addAll(dto.getValuesList());
            }
        }
        InputStream ins = this.getClass().getClassLoader().getResourceAsStream("resources/dictionary.freeradius.internal");
        BufferedReader r = new BufferedReader(new InputStreamReader(ins));
        ArrayList<String> freeRadiusInternalFileEntries = new ArrayList<String>();
        while ((str = r.readLine()) != null) {
            if (!str.startsWith("ATTRIBUTE") && !str.startsWith("VALUE")) continue;
            freeRadiusInternalFileEntries.add(str);
        }
        this.updateAttributeMap(sbrStandardRadiusFileEntries, dictionaryAttrNameCheckList, dictionaryAttrNameValueCheckList);
        this.createFreeRadiusFileAndNonConflictingAttributeMap(dictionaryAttrNameCheckList, dictionaryAttrNameValueCheckList, freeRadiusInternalFileEntries);
    }

    private void createFreeRadiusFileAndNonConflictingAttributeMap(Map<String, List<DictionaryAttributeDTO>> dictionaryAttrNameCheckList, Map<String, List<DictionaryAttributeNameValueDTO>> dictionaryAttrNameValueCheckList, List<String> freeRadiusInternalFileEntries) throws IOException {
        CaseInsensitiveMap standardRadiusAttrNameMap = new CaseInsensitiveMap();
        CaseInsensitiveMap standardRadiusAttrNameValueMap = new CaseInsensitiveMap();
        ArrayList<String> removedAttributeNames = new ArrayList<String>();
        freeRadiusInternalFileEntries.addAll(FR_STD_REQUIRED_ATTR);
        this.updateAttributeMap(freeRadiusInternalFileEntries, (Map<String, List<DictionaryAttributeDTO>>)standardRadiusAttrNameMap, (Map<String, List<DictionaryAttributeNameValueDTO>>)standardRadiusAttrNameValueMap);
        dictionaryAttrNameCheckList.forEach((arg_0, arg_1) -> FreeRadiusConflictHandler.lambda$0((Map)standardRadiusAttrNameMap, removedAttributeNames, arg_0, arg_1));
        dictionaryAttrNameValueCheckList.forEach((arg_0, arg_1) -> FreeRadiusConflictHandler.lambda$1((Map)standardRadiusAttrNameValueMap, removedAttributeNames, arg_0, arg_1));
        dictionaryAttrNameCheckList.putAll((Map<String, List<DictionaryAttributeDTO>>)standardRadiusAttrNameMap);
        dictionaryAttrNameValueCheckList.putAll((Map<String, List<DictionaryAttributeNameValueDTO>>)standardRadiusAttrNameValueMap);
        this.createInternalFreeRadiusFile(freeRadiusInternalFileEntries, (Map<String, List<DictionaryAttributeDTO>>)standardRadiusAttrNameMap, (Map<String, List<DictionaryAttributeNameValueDTO>>)standardRadiusAttrNameValueMap, removedAttributeNames);
    }

    private void createInternalFreeRadiusFile(List<String> freeRadiusInternalFileEntries, Map<String, List<DictionaryAttributeDTO>> standardRadiusAttrNameMap, Map<String, List<DictionaryAttributeNameValueDTO>> standardRadiusAttrNameValueMap, List<String> removedAttributeNames) throws IOException {
        ArrayList<String> fileContent = new ArrayList<String>();
        for (String fileEntry : freeRadiusInternalFileEntries) {
            String[] fileEntryAsArray = fileEntry.split("\\s+");
            if (fileEntry.startsWith("ATTRIBUTE")) {
                if (standardRadiusAttrNameMap.get(fileEntryAsArray[1]) == null) continue;
                fileContent.add(fileEntry);
                continue;
            }
            if (!fileEntry.startsWith("VALUE")) continue;
            String attributenameCombined = String.valueOf(fileEntryAsArray[1]) + "-" + fileEntryAsArray[2];
            boolean isRemoved = false;
            if (standardRadiusAttrNameValueMap.get(attributenameCombined) != null) {
                for (String removeAttr : removedAttributeNames) {
                    if (!fileEntryAsArray[1].equalsIgnoreCase(removeAttr)) continue;
                    isRemoved = true;
                    break;
                }
            }
            if (isRemoved) continue;
            fileContent.add(fileEntry);
        }
        this.writeEntriesToFile(fileContent);
    }

    private void writeEntriesToFile(List<String> fileEntries) throws IOException {
        for (String entry : fileEntries) {
            Files.write(Paths.get(String.valueOf(this.getFRDictMigrationDirectory()) + FREE_RADIUS_INTERNAL_FILE_NAME, new String[0]), (String.valueOf(entry) + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
    }

    private void updateAttributeMap(List<String> fileEntries, Map<String, List<DictionaryAttributeDTO>> dictionaryAttrNameCheckList, Map<String, List<DictionaryAttributeNameValueDTO>> dictionaryAttrNameValueCheckList) {
        for (String fileEntry : fileEntries) {
            String attributeName;
            String[] fileEntryAsArray = fileEntry.split("\\s+");
            if (fileEntry.startsWith("ATTRIBUTE")) {
                DictionaryAttributeDTO attributeDTO = new DictionaryAttributeDTO();
                attributeDTO.setAttrName(fileEntryAsArray[1]);
                attributeDTO.setAttrID(fileEntryAsArray[2]);
                attributeDTO.setAttrDataType(fileEntryAsArray[3]);
                if (dictionaryAttrNameCheckList.get(fileEntryAsArray[1]) != null) continue;
                dictionaryAttrNameCheckList.put(fileEntryAsArray[1], new ArrayList<DictionaryAttributeDTO>(Arrays.asList(attributeDTO)));
                continue;
            }
            if (!fileEntry.startsWith("VALUE")) continue;
            DictionaryAttributeNameValueDTO dAttrDTO = new DictionaryAttributeNameValueDTO();
            dAttrDTO.setAttrName(fileEntryAsArray[1]);
            dAttrDTO.setAttrValueName(fileEntryAsArray[2]);
            dAttrDTO.setAttrValueID(fileEntryAsArray[3]);
            List<DictionaryAttributeDTO> attributeDTOList = dictionaryAttrNameCheckList.get(fileEntryAsArray[1]);
            if (attributeDTOList != null && attributeDTOList.size() > 0) {
                dAttrDTO.setAttrID(attributeDTOList.get(0).getAttrID());
            }
            if (dictionaryAttrNameValueCheckList.get(attributeName = String.valueOf(fileEntryAsArray[1]) + "-" + fileEntryAsArray[2]) != null) continue;
            dictionaryAttrNameValueCheckList.put(attributeName, new ArrayList<DictionaryAttributeNameValueDTO>(Arrays.asList(dAttrDTO)));
        }
    }

    private String getFRDictMigrationDirectory() {
        return String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.FREERADIUS_DICT_MIG_DIR.toLowerCase();
    }

    private static /* synthetic */ void lambda$0(Map map, List list, String k, List v) {
        if (map.get(k) != null) {
            List attribDTO = (List)map.remove(k);
            list.add(((DictionaryAttributeDTO)attribDTO.get(0)).getAttrName());
        }
    }

    private static /* synthetic */ void lambda$1(Map map, List list, String k, List v) {
        if (map.get(k) != null) {
            List attribDTO = (List)map.remove(k);
            list.add(((DictionaryAttributeNameValueDTO)attribDTO.get(0)).getAttrName());
        }
    }
}

