/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.mgmt;

import com.rsa.authmgr.admin.radius.migration.data.DictionaryDTO;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GetAllStandardRadiusValues {
    public List<String> getAllStandardRadiusValuesFromAllDictionaryFiles(List<List<DictionaryDTO>> sbrStandardRadiusDictinaryList, Map<String, String> dictionaryFilePath, Map<String, List<String>> dictNameVendorNameMap) throws IOException {
        ArrayList<String> allStandardRadiusValueEntries = new ArrayList<String>();
        ArrayList<String> sbrStandardRadiusFileEntries = new ArrayList<String>();
        HashMap<String, String> duplicateAttributeValueNameMap = new HashMap<String, String>();
        for (List<DictionaryDTO> singleEntry : sbrStandardRadiusDictinaryList) {
            for (DictionaryDTO dto : singleEntry) {
                if (dto.getMacroName().equalsIgnoreCase("NONE")) {
                    sbrStandardRadiusFileEntries.addAll(dto.getAttributesList());
                }
                sbrStandardRadiusFileEntries.addAll(dto.getValuesList());
            }
        }
        dictionaryFilePath.remove("radius");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String entry : sbrStandardRadiusFileEntries) {
            String[] fileEntryAsArray = entry.split("\\s+");
            attributeMap.put(fileEntryAsArray[1], fileEntryAsArray[1]);
            if (entry.startsWith("ATTRIBUTE")) {
                duplicateAttributeValueNameMap.put(fileEntryAsArray[1], fileEntryAsArray[1]);
                continue;
            }
            if (!entry.startsWith("VALUE")) continue;
            duplicateAttributeValueNameMap.put(String.valueOf(fileEntryAsArray[1]) + "-" + fileEntryAsArray[2], String.valueOf(fileEntryAsArray[2]) + "," + fileEntryAsArray[3]);
        }
        dictionaryFilePath.forEach((k, v) -> {
            List<Object> fileEntries = new ArrayList();
            try {
                fileEntries = Files.readAllLines(Paths.get(v, new String[0]), StandardCharsets.ISO_8859_1).stream().filter(str -> str.trim().startsWith("VALUE")).map(String::trim).collect(Collectors.toList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fileEntries.size() > 0) {
                allStandardRadiusValueEntries.add("# Updating standard attribute entries from file" + Paths.get(v, new String[0]).getFileName().toString());
            }
            for (String entry : fileEntries) {
                String[] fileEntryAsArray = entry.trim().split("\\s+");
                if (attributeMap.get(fileEntryAsArray[1]) == null) continue;
                if (duplicateAttributeValueNameMap.get(String.valueOf(fileEntryAsArray[1]) + "-" + fileEntryAsArray[2]) == null) {
                    allStandardRadiusValueEntries.add(String.valueOf(fileEntryAsArray[0]) + "\t" + fileEntryAsArray[1] + "\t" + fileEntryAsArray[2] + "\t" + fileEntryAsArray[3]);
                    duplicateAttributeValueNameMap.put(String.valueOf(fileEntryAsArray[1]) + "-" + fileEntryAsArray[2], String.valueOf(fileEntryAsArray[2]) + "," + fileEntryAsArray[3]);
                    continue;
                }
                allStandardRadiusValueEntries.add("#" + fileEntryAsArray[0] + "\t" + fileEntryAsArray[1] + "\t" + fileEntryAsArray[2] + "\t" + fileEntryAsArray[3]);
            }
        });
        return allStandardRadiusValueEntries;
    }
}

