/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.utility;

import com.rsa.authmgr.admin.radius.migration.data.DictionaryDTO;
import java.util.ArrayList;

public class AttributeParser {
    private static final String OPENINING_BRACE_TOKEN = "(";
    private static final String OPENINING_SQUARE_BRACKET_TOKEN = "[";
    private static final String FORMAT_TYPE = "type";
    private static final String DICT_ATTR_VID_TOKEN = "vid";
    private static final String DICT_ATTR_DATA_TOKEN = "data";
    private static final String DICT_ATTR_TAG_TOKEN = "tag";

    public static String getAttributeName(String fileEntryLine) {
        return AttributeParser.splitBySpace(fileEntryLine, 1);
    }

    public static String[] getAttributeDataTypeAndID(String fileEntryLine, DictionaryDTO sbrDictionary) {
        return AttributeParser.processAttrLine(fileEntryLine, sbrDictionary);
    }

    private static String[] processAttrLine(String fileEntryLine, DictionaryDTO dto) {
        String dataType = null;
        String attributeID = null;
        if (fileEntryLine.contains(OPENINING_BRACE_TOKEN)) {
            String[] syntax = AttributeParser.splitByClosingBrace(AttributeParser.splitByOpenBrace(fileEntryLine, 1), 0).split("\\,");
            if (dto.getDataSyntax() != null && !dto.getDataSyntax().isEmpty()) {
                dataType = dto.getDataSyntax();
            } else if (dto.getSyntaxPos() != 0) {
                dataType = syntax[dto.getSyntaxPos() - 1].trim();
            }
            if (dto.getTypePos() != 0) {
                attributeID = syntax[dto.getTypePos() - 1].trim();
            }
        } else if (fileEntryLine.contains(OPENINING_SQUARE_BRACKET_TOKEN)) {
            String[] splitByOpeningSquareBraceString = fileEntryLine.trim().split("\\[");
            if (fileEntryLine.contains(DICT_ATTR_DATA_TOKEN)) {
                dataType = AttributeParser.splitByData(splitByOpeningSquareBraceString[1]);
            }
            if (fileEntryLine.contains(DICT_ATTR_VID_TOKEN) && fileEntryLine.contains(FORMAT_TYPE)) {
                attributeID = AttributeParser.splitBySpace(AttributeParser.splitByEquals(splitByOpeningSquareBraceString[1].trim(), 2), 0);
            } else if (fileEntryLine.contains(DICT_ATTR_TAG_TOKEN)) {
                attributeID = AttributeParser.splitBySpace(fileEntryLine, 2);
            } else if (fileEntryLine.contains(DICT_ATTR_VID_TOKEN) && !fileEntryLine.contains(DICT_ATTR_TAG_TOKEN) && !fileEntryLine.contains(FORMAT_TYPE)) {
                attributeID = null;
            }
        } else {
            String[] fileEntryAsArray = fileEntryLine.split("\\s+");
            if (fileEntryAsArray.length >= 4) {
                attributeID = fileEntryAsArray[2];
                dataType = fileEntryAsArray[3];
            }
        }
        return new String[]{attributeID, dataType};
    }

    public static String getTagAttributeOption(String fileEntry, String frDataType) {
        if (fileEntry.contains("#")) {
            fileEntry = fileEntry.split("#")[0];
        }
        StringBuffer buf = new StringBuffer();
        if (AttributeParser.checkIsTagOptionsRequired(fileEntry)) {
            if (!frDataType.equalsIgnoreCase("octets") && !frDataType.equalsIgnoreCase("ipaddr")) {
                buf.append("has_tag");
            }
        } else {
            return null;
        }
        return buf.toString();
    }

    private static boolean checkIsTagOptionsRequired(String fileEntry) {
        boolean isTabRequired = false;
        String[] fileEntryAsArray = fileEntry.trim().split("\\s+");
        if (fileEntry.contains("tag=") || fileEntryAsArray[fileEntryAsArray.length - 1].endsWith("t")) {
            isTabRequired = true;
            return true;
        }
        return isTabRequired;
    }

    public static String getEncryptAttributeOption(String fileEntry, String dataTypeFR) {
        if (fileEntry.contains("#")) {
            fileEntry = fileEntry.split("#")[0];
        }
        StringBuffer buf = new StringBuffer();
        if (AttributeParser.checkIsEncryptOptionsRequired(fileEntry)) {
            if (fileEntry.contains("User-Password")) {
                buf.append("encrypt=1");
            } else if (fileEntry.contains("MS-MPPE-Send-Key") || fileEntry.contains("MS-MPPE-Recv-Key")) {
                buf.append("encrypt=2");
            } else if (fileEntry.endsWith("salt-encrypt")) {
                buf.append("encrypt=2");
            } else {
                buf.append("encrypt=1");
            }
        }
        return buf.toString();
    }

    private static boolean checkIsEncryptOptionsRequired(String fileEntry) {
        boolean isEncryptRequired = false;
        String[] fileEntryAsArray = fileEntry.trim().split("\\s+");
        if (fileEntryAsArray[fileEntryAsArray.length - 1].endsWith("encrypt")) {
            isEncryptRequired = true;
            return true;
        }
        if (fileEntryAsArray[1].equalsIgnoreCase("User-Password") || fileEntryAsArray[1].equalsIgnoreCase("MS-MPPE-Send-Key") || fileEntryAsArray[1].equalsIgnoreCase("MS-MPPE-Recv-Key")) {
            isEncryptRequired = true;
            return true;
        }
        return isEncryptRequired;
    }

    private static String splitByData(String line) {
        return line.trim().split(DICT_ATTR_DATA_TOKEN)[1].trim().split("=")[1].trim().split("\\]")[0].trim();
    }

    private static String splitByEquals(String line, int index) {
        return line.trim().split("=")[index].trim();
    }

    private static String splitByOpenSquareBrace(String line, int index) {
        return line.trim().split("\\[")[index].trim();
    }

    private static String splitByOpenBrace(String line, int index) {
        return line.trim().split("\\(")[index].trim();
    }

    private static String splitBySpace(String line, int index) {
        return line.trim().split("\\s+")[index].trim();
    }

    private static String splitByClosingBrace(String line, int index) {
        return line.trim().split("\\)")[index].trim();
    }

    public static void main(String[] args) {
        try {
            ArrayList<String> fileEntries = new ArrayList<String>();
            DictionaryDTO dto = new DictionaryDTO();
            dto.setSyntaxPos(2);
            dto.setTypePos(1);
            fileEntries.add("ATTRIBUTE Tunnel-Private-Group-ID        81  [tag=0 data=string]  rt");
            fileEntries.add("ATTRIBUTE LeeMah-Vendor-Specific    26  [vid=1303 data=string] R");
            fileEntries.add("ATTRIBUTE  User-Name                     1     string            c");
            fileEntries.add("ATTRIBUTE Account-Info 26 [vid=9 type1=250 len1=+2 data=string] RO");
            for (String line : fileEntries) {
                String[] array = AttributeParser.processAttrLine(line, dto);
                System.out.println(String.valueOf(array[0]) + ":" + array[1]);
            }
            System.out.println("completed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

