/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.utility;

import com.rsa.common.SystemException;
import com.rsa.ims.connectionpool.manager.impl.ConnectionManagerImpl;
import com.rsa.ims.logging.Level;
import com.rsa.ims.logging.trace.TraceLog;
import com.rsa.ims.security.keymanager.sys.ServerAccessInfo;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ConnectionManager4CLIPooled
extends ConnectionManagerImpl
implements FactoryBean {
    private static final TraceLog TRACE_LOG = TraceLog.getTraceLogger(ConnectionManager4CLIPooled.class);
    private static final Level traceLevel = Level.INFO;
    private PlatformTransactionManager transactionManager;
    private TransactionTemplate transactionTemplate;
    private JdbcTemplate jdbcTemplate;
    private boolean singleConnection = false;

    public ConnectionManager4CLIPooled(ServerAccessInfo accessInfo, String userType) throws Exception {
        String user = this.getUsername(accessInfo, userType);
        String password = this.getPassword(accessInfo, userType);
        this.createInstance(accessInfo.getStringValue("com.rsa.db.type"), accessInfo.getStringValue("com.rsa.db.hostname"), accessInfo.getStringValue("com.rsa.db.port"), accessInfo.getStringValue("com.rsa.db.instance"), user, password, null);
    }

    private void createInstance(String dbType, String host, String port, String instance, String userId, String password, Properties properties) {
        String dbDriver = null;
        String dbUrl = null;
        String newUserId = userId;
        if (dbType.equalsIgnoreCase("MSSQL")) {
            dbDriver = "com.jnetdirect.jsql.JSQLDriver";
            dbUrl = "jdbc:jtds:sqlserver://" + host + ":" + port + "/" + instance;
        } else if (dbType.equalsIgnoreCase("ORACLE")) {
            dbDriver = "oracle.jdbc.OracleDriver";
            dbUrl = "jdbc:oracle:thin:@" + host + ":" + port + ":" + instance;
            if (newUserId.equalsIgnoreCase("SYS")) {
                newUserId = "SYS AS SYSDBA";
            }
        } else if (dbType.equalsIgnoreCase("SYBASE")) {
            dbDriver = "com.sybase.jdbc3.jdbc.SybDataSource";
            dbUrl = "jdbc:sybase:Tds:" + host + ":" + port + "/" + instance;
        } else if (dbType.equalsIgnoreCase("POSTGRES")) {
            dbDriver = "org.postgresql.Driver";
            dbUrl = "jdbc:postgresql://" + host + ":" + port + "/" + instance;
        } else if (dbType.equalsIgnoreCase("HSQLDB")) {
            dbDriver = "org.hsqldb.jdbcDriver";
            dbUrl = host != null ? "jdbc:hsqldb:hsql://" + host + ":" + port + "/" + instance : "jdbc:hsqldb:mem:memdbid";
        } else {
            throw new SystemException("Invalid database type " + dbType);
        }
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(dbDriver);
        ds.setUrl(dbUrl);
        ds.setUsername(newUserId);
        ds.setPassword(password);
        ds.setMinIdle(20);
        ds.setMaxIdle(100);
        this.jdbcTemplate = new JdbcTemplate((DataSource)ds);
        this.transactionManager = new DataSourceTransactionManager((DataSource)ds);
        this.transactionTemplate = new TransactionTemplate(this.transactionManager);
        this.addDatasource("rsapool", (DataSource)new TransactionAwareDataSourceProxy((DataSource)ds));
        if (TRACE_LOG.isEnabled(traceLevel)) {
            TRACE_LOG.log(traceLevel, (Object)("Connecting to [" + dbUrl + "] as user [" + newUserId + "]"));
        }
    }

    public DataSource getDataSource() {
        return this.getDataSource("rsapool");
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    private String getUsername(ServerAccessInfo accessInfo, String userType) throws Exception {
        String user = accessInfo.getStringValue("com.rsa.db.user");
        if (userType.equals("com.rsa.db.root")) {
            user = accessInfo.getStringValue("com.rsa.db.root");
        } else if (userType.equals("com.rsa.db.dba")) {
            user = accessInfo.getStringValue("com.rsa.db.dba");
        } else if (userType.equals("com.rsa.replication.admin")) {
            user = accessInfo.getStringValue("com.rsa.replication.admin");
        } else if (userType.equals("com.rsa.db.logArchiver")) {
            user = accessInfo.getStringValue("com.rsa.db.logArchiver");
        }
        return user;
    }

    private String getPassword(ServerAccessInfo accessInfo, String userType) throws Exception {
        String password = accessInfo.getStringValue("com.rsa.db.user.password");
        if (userType.equals("com.rsa.db.root")) {
            password = accessInfo.getStringValue("com.rsa.db.root.password");
        } else if (userType.equals("com.rsa.db.dba")) {
            password = accessInfo.getStringValue("com.rsa.db.dba.password");
        } else if (userType.equals("com.rsa.replication.admin")) {
            password = accessInfo.getStringValue("com.rsa.replication.admin.password");
        } else if (userType.equals("com.rsa.db.logArchiver")) {
            password = accessInfo.getStringValue("com.rsa.db.logArchiver.password");
        }
        return password;
    }

    public Object doInTransaction(PrivilegedExceptionAction<Object> action) throws Exception {
        return ConnectionManager4CLIPooled.doInTransaction(this.transactionTemplate, action);
    }

    public static Object doInTransaction(TransactionTemplate template, final PrivilegedExceptionAction<Object> action) throws Exception {
        try {
            return template.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    try {
                        return action.run();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    public void destroy() {
        DataSource ds;
        if (this.singleConnection && (ds = this.getDataSource()) != null) {
            TransactionAwareDataSourceProxy tdsp = (TransactionAwareDataSourceProxy)ds;
            SingleConnectionDataSource sds = (SingleConnectionDataSource)tdsp.getTargetDataSource();
            sds.destroy();
        }
    }

    public boolean isSingleConnection() {
        return this.singleConnection;
    }

    public void setSingleConnection(boolean singleConnection) {
        this.singleConnection = singleConnection;
    }

    public Object getObject() throws Exception {
        return this.getDataSource();
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

