/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.utility;

import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class HTMLReportGenerator {
    public final String NEW_LINE = System.getProperty("line.separator");
    private final String metadata = "<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />";
    private String tabTitle;
    private String HTMLReport;
    public final String titleClass = "reportTitle";
    public final String copyrightId = "copyright";
    public final String centerClass = "center-left";

    public HTMLReportGenerator(String tabTitle) {
        this.tabTitle = StringUtils.isNotEmpty((String)tabTitle) ? tabTitle : "RSA Report";
    }

    protected void saveReport(String reportFilePath) throws IOException {
        Path path = Paths.get(reportFilePath, new String[0]);
        Files.write(path, this.HTMLReport.getBytes(), new OpenOption[0]);
    }

    protected void savePreMigartionCheckReport(String reportPath) throws IOException {
        this.saveReport(reportPath);
    }

    public void generateHTMLReport(String report) {
        StringBuilder renderedHtml = new StringBuilder();
        renderedHtml.append((CharSequence)this.startHTMLHead(this.tabTitle)).append((CharSequence)this.appendStyleTag()).append((CharSequence)this.endHTMLHead(report)).append((CharSequence)this.startHTMLBody()).append(report).append((CharSequence)this.appendCopyright()).append((CharSequence)this.endHTMLBody()).append((CharSequence)this.endHTMLTag());
        this.HTMLReport = renderedHtml.toString();
    }

    public String processHTMLData(String value) {
        if (value != null) {
            return StringEscapeUtils.escapeHtml((String)value);
        }
        return "";
    }

    private StringBuilder startHTMLHead(String title) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append(this.NEW_LINE).append("<head>").append(this.NEW_LINE).append("<title>").append(this.processHTMLData(title)).append("</title>").append(this.NEW_LINE).append("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder appendStyleTag() {
        StringBuilder sb = new StringBuilder();
        sb.append("<style>").append(this.NEW_LINE).append(".reportTitle").append(this.NEW_LINE).append("{").append(this.NEW_LINE).append("text-align: center;").append(this.NEW_LINE).append("}").append(this.NEW_LINE).append(".center-left").append(this.NEW_LINE).append("{").append(this.NEW_LINE).append("margin: auto;").append(this.NEW_LINE).append("width: 80%;").append(this.NEW_LINE).append("padding: 12px;").append(this.NEW_LINE).append("}").append(this.NEW_LINE).append("table").append(this.NEW_LINE).append("{").append(this.NEW_LINE).append("margin-left: auto;").append(this.NEW_LINE).append("margin-right: auto;").append(this.NEW_LINE).append("font-family: Arial, Helvetica, sans-serif;").append(this.NEW_LINE).append("width: 80%;").append(this.NEW_LINE).append("}").append(this.NEW_LINE).append("table td, table th").append(this.NEW_LINE).append("{").append(this.NEW_LINE).append("border: 1px solid #000;").append(this.NEW_LINE).append("padding: 8px;").append(this.NEW_LINE).append("vertical-align: top;").append(this.NEW_LINE).append("}").append(this.NEW_LINE).append("table th").append(this.NEW_LINE).append("{").append(this.NEW_LINE).append("padding-top: 12px;").append(this.NEW_LINE).append("padding-bottom: 12px;").append(this.NEW_LINE).append("text-align: center;").append(this.NEW_LINE).append("}").append(this.NEW_LINE).append("table tr.error {background-color: #f4c1bb;}").append(this.NEW_LINE).append("table tr.warn {background-color: #fafe91;}").append(this.NEW_LINE).append("#copyright").append(this.NEW_LINE).append("{").append(this.NEW_LINE).append("margin-top: 12px;").append(this.NEW_LINE).append("margin-bottom: 12px;").append(this.NEW_LINE).append("text-align: center;").append(this.NEW_LINE).append("font-size: 0.6em;").append(this.NEW_LINE).append("}").append(this.NEW_LINE).append("</style>").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder endHTMLHead(String title) {
        StringBuilder sb = new StringBuilder();
        sb.append("</head>").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder startHTMLBody() {
        StringBuilder sb = new StringBuilder();
        sb.append("<body>").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder appendCopyright() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div id=\"copyright\">").append(this.NEW_LINE).append("<span>").append(this.NEW_LINE).append(AMMigrateRadiusDataCLU.format("report.copyright", new Object[0])).append(this.NEW_LINE).append("<span>").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder endHTMLBody() {
        StringBuilder sb = new StringBuilder();
        sb.append("</body>").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder endHTMLTag() {
        StringBuilder sb = new StringBuilder();
        sb.append("</html>").append(this.NEW_LINE);
        return sb;
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    public void setTabTitle(String tabTitle) {
        this.tabTitle = tabTitle;
    }

    public String getHTMLReport() {
        return this.HTMLReport;
    }

    public void setHTMLReport(String htmlReport) {
        this.HTMLReport = htmlReport;
    }
}

