/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.utility;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class MigrationLoggingHelper {
    private static final String MIGRATION_LOG_FILENAME = "radius-migration.log";
    private static Logger migrationLogger = null;
    private static FileHandler logFileHandler;

    public static Logger getmigrationLogger() {
        if (migrationLogger == null) {
            try {
                migrationLogger = Logger.getLogger(String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + MIGRATION_LOG_FILENAME);
                logFileHandler = new FileHandler(String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + MIGRATION_LOG_FILENAME, true);
                migrationLogger.addHandler(logFileHandler);
                SimpleFormatter formatter = new SimpleFormatter();
                logFileHandler.setFormatter(formatter);
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {}
        }
        return migrationLogger;
    }

    public static void closeLoggingFileHandler() {
        if (logFileHandler != null) {
            logFileHandler.close();
        }
    }

    public static void migrationComponentLogger(Path logFilePath, ArrayList<String> logEntries) {
        for (String entry : logEntries) {
            try {
                Files.write(logFilePath, (String.valueOf(entry) + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (IOException iOException) {}
        }
    }
}

