/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.utility;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import java.io.File;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class MigrationOutputLocationHelper {
    private static final String REPLACE_SPECIAL_CHAR = "[^A-Za-z0-9]+";

    public static String checkCreateMigrationJobDirectory(String outputDir) throws Exception {
        File f;
        String timeStampedMigDir = null;
        String parentHome = null;
        if (outputDir == null && ((outputDir = System.getenv("RSA_IMS_HOME")) == null || outputDir.length() == 0)) {
            outputDir = System.getProperty("java.io.tmpdir");
        }
        if (!(f = new File(outputDir)).exists()) {
            String message = "Unable to create directory " + outputDir + " for radius migration output";
            throw new Exception(message);
        }
        parentHome = String.valueOf(outputDir) + File.separator + "radius-migration".toLowerCase().trim() + File.separator;
        RadiusMigrationUtility.checkCreateDir(parentHome);
        timeStampedMigDir = MigrationOutputLocationHelper.getTimeStampedDirName();
        RadiusMigrationUtility.checkCreateDir(String.valueOf(parentHome) + timeStampedMigDir);
        String sbrMigDir = String.valueOf(parentHome) + timeStampedMigDir + File.separator + "sbr" + File.separator;
        RadiusMigrationUtility.checkCreateDir(sbrMigDir);
        String freeRadiusMigDir = String.valueOf(parentHome) + timeStampedMigDir + File.separator + "freeradius" + File.separator;
        RadiusMigrationUtility.checkCreateDir(freeRadiusMigDir);
        RadiusMigrationUtility.checkCreateDir(String.valueOf(freeRadiusMigDir) + "dictionary" + File.separator);
        RadiusMigrationUtility.checkCreateDir(String.valueOf(sbrMigDir) + "dictionary" + File.separator);
        return String.valueOf(parentHome) + timeStampedMigDir + File.separator;
    }

    private static String getTimeStampedDirName() {
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        return now.toString().replaceAll(REPLACE_SPECIAL_CHAR, "-");
    }
}

