/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.utility;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RadiusMigrationLogParser {
    private static final String LOG_ERROR = "migrationLogError";
    private static final String LOG_WARN = "logWarn";
    private final String logEntryPattern = "([\\w]+\\s[\\w]+[,]\\s[\\d]{4}\\s[\\d:]+\\s[\\w]+)\\s([\\w.]+\\s[\\w]+)\\R([\\w:]+)\\s(.+)";
    private final String WARN = "WARNING:";
    private final String ERROR = "SEVERE:";
    private Set<String> warningLogs = new HashSet<String>();
    private Set<String> errorLogs = new HashSet<String>();

    public void parseLogfile() throws IOException {
        String line2;
        String line1;
        Pattern p = Pattern.compile("([\\w]+\\s[\\w]+[,]\\s[\\d]{4}\\s[\\d:]+\\s[\\w]+)\\s([\\w.]+\\s[\\w]+)\\R([\\w:]+)\\s(.+)");
        File file = new File(this.getMigrationLogFileLocation());
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        while ((line1 = br.readLine()) != null && (line2 = br.readLine()) != null) {
            String parsedLogLine;
            Matcher matcher;
            String logEntry;
            line1 = line1.trim();
            if ((line2 = line2.trim()).endsWith(LOG_WARN) || line2.endsWith(LOG_ERROR)) {
                line1 = line2;
                line2 = br.readLine();
            }
            if (!(logEntry = String.valueOf(line1) + "\n" + line2).contains("WARNING:") && !logEntry.contains("SEVERE:") || !(matcher = p.matcher(logEntry)).matches()) continue;
            if (matcher.group(3).equals("WARNING:")) {
                parsedLogLine = String.valueOf(matcher.group(1)) + " | " + matcher.group(4);
                this.warningLogs.add(parsedLogLine);
                continue;
            }
            if (!matcher.group(3).equals("SEVERE:")) continue;
            parsedLogLine = String.valueOf(matcher.group(1)) + " | " + matcher.group(4);
            this.errorLogs.add(parsedLogLine);
        }
    }

    private String getMigrationLogFileLocation() {
        return String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + "radius-migration.log";
    }

    public Set<String> getWarningLogs() {
        return this.warningLogs;
    }

    public void setWarningLogs(Set<String> warningLogs) {
        this.warningLogs = warningLogs;
    }

    public Set<String> getErrorLogs() {
        return this.errorLogs;
    }

    public void setErrorLogs(Set<String> errorLogs) {
        this.errorLogs = errorLogs;
    }
}

