/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.utility;

import com.rsa.authmgr.admin.migration.utility.HTMLReportGenerator;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationLogParser;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.data.RadiusClientDTO;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationParametersDTO;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationResultsDTO;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusPreMigrationResultsDTO;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.internal.admin.radius.dal.RadiusClientHBM;
import com.rsa.authmgr.internal.radius.jaxb.radiusclient.RadiusClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class RadiusMigrationReportGenerator
extends HTMLReportGenerator {
    private static final String HTML_ANY_CLIENT = "&lt;ANY&gt;";
    private static final String ANY_RADIUS_CLIENT = "<ANY>";
    private String reportTitle = "";
    private String reportDescription = "";
    private List<String[]> preMigrationData;
    private List<String[]> migrationData;
    private String[] warningLogs;
    private String[] failureLogs;
    private final String warnHighlight = "warn";
    private final String errorHighlight = "error";
    private final String errorKey = "error";
    private final String warnKey = "warn";
    private final String failKey = "fail";
    private final String emptyEntry = "";
    private final String migrationResultKey = "migration results";

    public RadiusMigrationReportGenerator() {
        super(null);
    }

    public RadiusMigrationReportGenerator(String reportTitle, String reportDescription) {
        super(reportTitle);
        if (reportTitle != null) {
            this.reportTitle = reportTitle;
        }
        if (reportDescription != null) {
            this.reportDescription = reportDescription;
        }
    }

    public String generateRadiusMigrationReport() throws Exception {
        this.populateTableData();
        StringBuilder migrationReport = new StringBuilder();
        migrationReport.append((CharSequence)this.generateReportTitle(this.reportTitle)).append((CharSequence)this.generateReportDescription(this.reportDescription)).append((CharSequence)this.generateReportTable());
        return migrationReport.toString();
    }

    public void saveReport() throws IOException {
        this.saveReport(AMRadiusMigrationConstants.MIG_REPORT_FILEPATH);
    }

    public void savePreMigationReport(String path) throws IOException {
        this.savePreMigartionCheckReport(String.valueOf(path) + "radius-pre-migration-check-report.html");
    }

    private StringBuilder generateReportTitle(String title) {
        StringBuilder sb = new StringBuilder();
        sb.append("<h3 class=\"reportTitle\">").append(this.processHTMLData(title)).append("_" + this.appendTimeStamp()).append("</h3>").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder generateReportDescription(String desc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<h4 class=\"center-left\">").append(this.processHTMLData(desc)).append("</h4>").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder generateReportTable() {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.beginTable());
        if (this.preMigrationData.size() > 0) {
            sb.append((CharSequence)this.addMergedTableHeader(AMMigrateRadiusDataCLU.format("report.tableHead.premigrate", new Object[0])));
            for (String[] data : this.preMigrationData) {
                if (data[0].toLowerCase().contains("migration results")) {
                    if (data[1].toLowerCase().contains("fail")) {
                        sb.append((CharSequence)this.addTableEntry(data, "error"));
                        continue;
                    }
                    if (data[0].toLowerCase().contains("error") || data[0].toLowerCase().contains("warn")) {
                        sb.append((CharSequence)this.addTableEntry(data, "warn"));
                        continue;
                    }
                    sb.append((CharSequence)this.addTableEntry(data, ""));
                    continue;
                }
                if (data[0].toLowerCase().contains("fail")) {
                    if (StringUtils.isNotEmpty((String)data[1]) && !data[1].equals("0")) {
                        sb.append((CharSequence)this.addTableEntry(data, "error"));
                        continue;
                    }
                    sb.append((CharSequence)this.addTableEntry(data, ""));
                    continue;
                }
                if (data[0].toLowerCase().contains("error") || data[0].toLowerCase().contains("warn")) {
                    if (StringUtils.isNotEmpty((String)data[1]) && !data[1].equals("0")) {
                        sb.append((CharSequence)this.addTableEntry(data, "warn"));
                        continue;
                    }
                    sb.append((CharSequence)this.addTableEntry(data, ""));
                    continue;
                }
                sb.append((CharSequence)this.addTableEntry(data, ""));
            }
        }
        if (this.migrationData.size() > 0) {
            sb.append((CharSequence)this.addMergedTableHeader(AMMigrateRadiusDataCLU.format("report.tableHead.migrate", new Object[0])));
            for (String[] data : this.migrationData) {
                if (data[0].toLowerCase().contains("migration results")) {
                    if (data[1].toLowerCase().contains("fail")) {
                        sb.append((CharSequence)this.addTableEntry(data, "error"));
                        continue;
                    }
                    if (data[0].toLowerCase().contains("error") || data[0].toLowerCase().contains("warn")) {
                        sb.append((CharSequence)this.addTableEntry(data, "warn"));
                        continue;
                    }
                    sb.append((CharSequence)this.addTableEntry(data, ""));
                    continue;
                }
                if (data[0].toLowerCase().contains("fail")) {
                    if (StringUtils.isNotEmpty((String)data[1]) && !data[1].equals("0")) {
                        sb.append((CharSequence)this.addTableEntry(data, "error"));
                        continue;
                    }
                    sb.append((CharSequence)this.addTableEntry(data, ""));
                    continue;
                }
                if (data[0].toLowerCase().contains("error") || data[0].toLowerCase().contains("warn")) {
                    if (StringUtils.isNotEmpty((String)data[1]) && !data[1].equals("0")) {
                        sb.append((CharSequence)this.addTableEntry(data, "warn"));
                        continue;
                    }
                    sb.append((CharSequence)this.addTableEntry(data, ""));
                    continue;
                }
                sb.append((CharSequence)this.addTableEntry(data, ""));
            }
        }
        sb.append((CharSequence)this.addMergedTableHeader(AMMigrateRadiusDataCLU.format("report.tableHead.messages-1", new Object[0])));
        if (StringUtils.isNotEmpty((String)this.failureLogs[1])) {
            sb.append((CharSequence)this.addLogEntry(this.failureLogs, "error"));
        } else {
            sb.append((CharSequence)this.addLogEntry(this.failureLogs, ""));
        }
        if (StringUtils.isNotEmpty((String)this.warningLogs[1])) {
            sb.append((CharSequence)this.addLogEntry(this.warningLogs, "warn"));
        } else {
            sb.append((CharSequence)this.addLogEntry(this.warningLogs, ""));
        }
        sb.append((CharSequence)this.endTable());
        return sb;
    }

    private StringBuilder beginTable() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table>").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder endTable() {
        StringBuilder sb = new StringBuilder();
        sb.append("</table>").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder addMergedTableHeader(String tableHeader) {
        StringBuilder sb = new StringBuilder();
        sb.append("<tr>").append(this.NEW_LINE);
        sb.append("<th colspan=\"2\"><b>").append(this.processHTMLData(tableHeader)).append("</b></th>");
        sb.append("</tr>").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder addTableEntry(String[] entry, String highlight) {
        StringBuilder sb = new StringBuilder();
        if (highlight.equals("error")) {
            sb.append("<tr class=\"error\">").append(this.NEW_LINE);
        } else if (highlight.equals("warn")) {
            sb.append("<tr class=\"warn\">").append(this.NEW_LINE);
        } else {
            sb.append("<tr>").append(this.NEW_LINE);
        }
        String[] stringArray = entry;
        int n = entry.length;
        int n2 = 0;
        while (n2 < n) {
            String cellData = stringArray[n2];
            String[] csv = cellData.split(",");
            sb.append("<td>");
            String[] stringArray2 = csv;
            int n3 = csv.length;
            int n4 = 0;
            while (n4 < n3) {
                String v = stringArray2[n4];
                sb.append(this.processHTMLData(v)).append("</br>");
                ++n4;
            }
            sb.append("</td>").append(this.NEW_LINE);
            ++n2;
        }
        sb.append("</tr>").append(this.NEW_LINE);
        return sb;
    }

    private StringBuilder addLogEntry(String[] entry, String highlight) {
        StringBuilder sb = new StringBuilder();
        if (highlight.equals("error")) {
            sb.append("<tr class=\"error\">").append(this.NEW_LINE);
        } else if (highlight.equals("warn")) {
            sb.append("<tr class=\"warn\">").append(this.NEW_LINE);
        } else {
            sb.append("<tr>").append(this.NEW_LINE);
        }
        String[] stringArray = entry;
        int n = entry.length;
        int n2 = 0;
        while (n2 < n) {
            String cellData = stringArray[n2];
            String[] csv = cellData.split(";");
            sb.append("<td>");
            String[] stringArray2 = csv;
            int n3 = csv.length;
            int n4 = 0;
            while (n4 < n3) {
                String v = stringArray2[n4];
                sb.append(this.processHTMLData(v)).append("</br>");
                ++n4;
            }
            sb.append("</td>").append(this.NEW_LINE);
            ++n2;
        }
        sb.append("</tr>").append(this.NEW_LINE);
        return sb;
    }

    private void populateTableData() throws Exception {
        String[] arr;
        this.preMigrationData = new ArrayList<String[]>();
        this.migrationData = new ArrayList<String[]>();
        this.warningLogs = new String[2];
        this.failureLogs = new String[2];
        AMRadiusPreMigrationResultsDTO premigrateResultDTO = RadiusMigrationUtility.getPremigrateResultDTO();
        AMRadiusMigrationParametersDTO migrateParametersDTO = RadiusMigrationUtility.getMigParamDTO();
        AMRadiusMigrationResultsDTO migrateResultDTO = RadiusMigrationUtility.getMigrateResultDTO();
        RadiusMigrationLogParser logPaser = new RadiusMigrationLogParser();
        logPaser.parseLogfile();
        if (premigrateResultDTO != null) {
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-1", new Object[0]), premigrateResultDTO.getPremigrationStatus().equals((Object)AMRadiusMigrationConstants.Status.SUCCESS) ? AMMigrateRadiusDataCLU.format("report.tableEntry.success", new Object[0]) : (premigrateResultDTO.getPremigrationStatus().equals((Object)AMRadiusMigrationConstants.Status.WARNING) ? AMMigrateRadiusDataCLU.format("report.tableEntry.warn", new Object[0]) : AMMigrateRadiusDataCLU.format("report.tableEntry.fail", new Object[0]))};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-2", new Object[0]), String.valueOf(premigrateResultDTO.getTotalVendorsPresentInSystem())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-3", new Object[0]), String.valueOf(premigrateResultDTO.getTotalNumOfVendorsToBeMigrated())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-4", new Object[0]), String.join((CharSequence)",", premigrateResultDTO.getVendorsToBeMigrated())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-5", new Object[0]), String.valueOf(premigrateResultDTO.getTotalNumOfVendorsMigratedSuccess())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-6", new Object[0]), String.valueOf(premigrateResultDTO.getTotalNumOfVendorsMigratedFailed())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-7", new Object[0]), String.join((CharSequence)",", premigrateResultDTO.getVendorMakeModelNotMigrated())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-8", new Object[0]), String.valueOf(premigrateResultDTO.getTotalDictionaryFilesPresentInSystem())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-9", new Object[0]), String.valueOf(premigrateResultDTO.getTotalNumOfDictionaryFilesToBeMigrated())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-10", new Object[0]), String.join((CharSequence)",", premigrateResultDTO.getDictFilesToBeMigrated())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-11", new Object[0]), String.valueOf(premigrateResultDTO.getTotalNumOfDictionaryMigratedSuccess())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-12", new Object[0]), String.join((CharSequence)",", premigrateResultDTO.getDictFilesMigratedWithErrors())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-13", new Object[0]), String.valueOf(premigrateResultDTO.getTotalNumOfDictionaryMigratedFailed())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-14", new Object[0]), String.join((CharSequence)",", premigrateResultDTO.getDictFilesNotMigrated())};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-15", new Object[0]), String.join((CharSequence)",", premigrateResultDTO.getAttributeValueNameChangedList())};
            this.preMigrationData.add(arr);
        }
        if (migrateParametersDTO != null) {
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-16", new Object[0]), migrateParametersDTO.getOutputMigrationDir()};
            this.preMigrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.premigrate-17", new Object[0]), this.getMigrationLogFileLocation()};
            this.preMigrationData.add(arr);
        }
        if (migrateResultDTO != null) {
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.migrate-1", new Object[0]), migrateResultDTO.getMigrationStatus().equals((Object)AMRadiusMigrationConstants.Status.SUCCESS) ? AMMigrateRadiusDataCLU.format("report.tableEntry.success", new Object[0]) : (migrateResultDTO.getMigrationStatus().equals((Object)AMRadiusMigrationConstants.Status.WARNING) ? AMMigrateRadiusDataCLU.format("report.tableEntry.warn", new Object[0]) : AMMigrateRadiusDataCLU.format("report.tableEntry.fail", new Object[0]))};
            this.migrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.migrate-2", new Object[0]), String.valueOf(migrateResultDTO.getTotalNumberOfClients())};
            this.migrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.migrate-3", new Object[0]), String.valueOf(migrateResultDTO.getTotalNumberOfClientsSuceess())};
            this.migrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.migrate-4", new Object[0]), String.valueOf(migrateResultDTO.getTotalNumberOfClientsFailed())};
            this.migrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.migrate-5", new Object[0]), String.join((CharSequence)",", migrateResultDTO.getClientsFailedToMigrate())};
            this.migrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.migrate-6", new Object[0]), String.valueOf(migrateResultDTO.getTotalNumberOfProfiles())};
            this.migrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.migrate-7", new Object[0]), String.valueOf(migrateResultDTO.getTotalNumberOfProfilesSuccess())};
            this.migrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.migrate-8", new Object[0]), String.valueOf(migrateResultDTO.getTotalNumberOfProfilesFailed())};
            this.migrationData.add(arr);
            arr = new String[]{AMMigrateRadiusDataCLU.format("report.tableEntry.migrate-9", new Object[0]), String.join((CharSequence)",", migrateResultDTO.getProfilesFailedToMigrate())};
            this.migrationData.add(arr);
            ArrayList<String> temp = new ArrayList<String>();
            arr = new String[2];
            arr[0] = AMMigrateRadiusDataCLU.format("report.tableEntry.migrate-10", new Object[0]);
            int serverCertSuccessCounter = 0;
            for (String config : migrateResultDTO.getConfigMigratedSuccessfully()) {
                if (config == null) continue;
                if (config.equalsIgnoreCase("SecurID.ini")) {
                    temp.add(AMMigrateRadiusDataCLU.format("report.tableEntry.radius.configuration-1", new Object[0]));
                    continue;
                }
                if (config.equalsIgnoreCase("radius.p12") || config.equalsIgnoreCase("radius.key") || config.equalsIgnoreCase("radius.crt")) {
                    ++serverCertSuccessCounter;
                    continue;
                }
                temp.add(AMMigrateRadiusDataCLU.format("report.tableEntry.radius.configuration-3", new Object[0]));
            }
            if (serverCertSuccessCounter == 3) {
                temp.add(AMMigrateRadiusDataCLU.format("report.tableEntry.radius.configuration-2", new Object[0]));
            }
            arr[1] = String.join((CharSequence)",", this.removeDuplicates(temp));
            this.migrationData.add(arr);
            temp = new ArrayList();
            arr = new String[2];
            arr[0] = AMMigrateRadiusDataCLU.format("report.tableEntry.migrate-11", new Object[0]);
            for (String config : migrateResultDTO.getConfigMigratedWithErrors()) {
                if (config == null) continue;
                if (config.equalsIgnoreCase("SecurID.ini")) {
                    temp.add(AMMigrateRadiusDataCLU.format("report.tableEntry.radius.configuration-1", new Object[0]));
                    continue;
                }
                if (config.equalsIgnoreCase("radius.p12") || config.equalsIgnoreCase("radius.key") || config.equalsIgnoreCase("radius.crt")) {
                    temp.add(AMMigrateRadiusDataCLU.format("report.tableEntry.radius.configuration-2", new Object[0]));
                    continue;
                }
                temp.add(AMMigrateRadiusDataCLU.format("report.tableEntry.radius.configuration-3", new Object[0]));
            }
            arr[1] = String.join((CharSequence)",", this.removeDuplicates(temp));
            this.migrationData.add(arr);
        }
        this.warningLogs[0] = AMMigrateRadiusDataCLU.format("report.tableEntry.messages-1", new Object[0]);
        this.failureLogs[0] = AMMigrateRadiusDataCLU.format("report.tableEntry.messages-2", new Object[0]);
        this.warningLogs[1] = String.join((CharSequence)";", logPaser.getWarningLogs());
        this.failureLogs[1] = String.join((CharSequence)";", logPaser.getErrorLogs());
    }

    private String appendTimeStamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMddyy_HHmma_z");
        Date today = new Date();
        return dateFormat.format(today);
    }

    private ArrayList<String> removeDuplicates(List<String> listWithDuplicates) {
        return new ArrayList<String>(new HashSet<String>(listWithDuplicates));
    }

    private String getMigrationLogFileLocation() {
        return String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + "radius-migration.log";
    }

    public String getReportTitle() {
        return this.reportTitle;
    }

    public void setReportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
    }

    public String getReportDescription() {
        return this.reportDescription;
    }

    public void setReportDescription(String reportDescription) {
        this.reportDescription = reportDescription;
    }

    public void generateIPConfigReport(Map<String, String> radisuClient, Map<String, String> agentIPNameMap, Map<String, String> alternateRadiusIPMap, Map<String, List<String>> ipTypeResolutionMap) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (!radisuClient.isEmpty()) {
            RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
            RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
            builder.append("</br></br>\n").append("<p style=\"font-weight: bold;\">Radius Client IP Conflict:</p> Below are the list of Radius Client(s) whose IP is conflicting with the Primary IP or Alternate IP of Radius Client(s) or Agent(s)\n").append("</br>\n</br>\n").append("<table id=\"radiusClentTable\" style=\"width:100%;padding-left: 50px; table-layout: fixed;\">\n").append("<tr style=\"background: cyan;\">\n").append("<th style=\"width: 170px;\">Radius-Client-Name</th>\n").append("<th style=\"width: 135px;\">Radius-Client-IP</th>\n").append("<th style=\"width: 180px;\">Conflicted-Agent-Name</th>\n").append("<th style=\"width: 240px;\">Conflicted-Radius-Client-Name</th>\n").append("<th style=\"width: 120px;\">Conflicted-with</th>\n").append("<th style=\"width: 210px;\">Manual-Action-Resolution#</th>\n").append("</tr>\n");
            Set<String> radiusClientIPKey = radisuClient.keySet();
            for (String radiusCientIP : radiusClientIPKey) {
                builder.append("<tr> <td style=\"width: 170px; word-wrap: break-word;\">").append(radisuClient.get(radiusCientIP)).append("</td>\n <td style=\"width: 135px; word-wrap: break-word;\">").append(radiusCientIP).append("</td>\n");
                String agentName = agentIPNameMap.get(radiusCientIP);
                List<String> ipTypeResolutionList = ipTypeResolutionMap.get(radiusCientIP);
                String ipType = ipTypeResolutionList.get(0);
                String resolution = ipTypeResolutionList.get(1);
                if (agentName != null) {
                    builder.append("<td style=\"width: 180px; word-wrap: break-word;\">").append(agentName).append("</td>\n").append("<td style=\"width: 240px;\">-</td>\n").append("<td style=\"width: 120px; word-wrap: break-word;\">").append(ipType).append("</td>\n").append("<td style=\"width: 210px;\">").append(resolution).append("</td>\n");
                } else {
                    builder.append("<td style=\"width: 180px; word-wrap: break-word;\">-</td>\n").append("<td style=\"width: 240px; word-wrap: break-word;\">").append(alternateRadiusIPMap.get(radiusCientIP)).append("</td>\n").append("<td style=\"width: 120px; word-wrap: break-word;\">").append(ipType).append("</td>\n").append("<td style=\"width: 210px; word-wrap: break-word;\">").append(resolution).append("</td>");
                }
                builder.append("</tr>\n");
            }
            builder.append("</table>\n").append("</br></br>\n").append("<font color=\"Green\">Note:</font>").append(" The Alternate IP Address/Primary IP Address of Conflicted-Agent-Name or Conflicted-Radius-Client-Name is matched with ").append("Primary IP Address of Radius Client(s) listed above\n");
        }
        Path path = Paths.get(AMRadiusMigrationConstants.MIG_REPORT_RADIUS_CLIENT_FILEPATH, new String[0]);
        Files.write(path, builder.toString().getBytes(), new OpenOption[0]);
    }

    public void generateInvalidSecretReport(List<RadiusClient> radClientList) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (!radClientList.isEmpty()) {
            builder.append("</br></br>\n").append("<p style=\"font-weight: bold;\">").append("Radius Client With Invalid Shared Secret:</p>").append("  Below are the list of Radius Client(s) with empty shared secret  or special character").append("</br>\n</br>\n").append("<table id=\"radEmptySecret\" style=\"padding-left: 40px;margin-left: inherit;width: 60%;\">\n").append("<tr>\n").append("<th style=\"width: 140px;  background: cyan;\">Radius-Client-Name</th>\n <td style=\"width: 450px;\">");
            int index = 1;
            for (RadiusClient obj : radClientList) {
                if (index > 1) {
                    builder.append(", ");
                }
                builder.append(obj.getId());
                ++index;
            }
            builder.append("</td></tr>\n</table>");
            builder = this.replaceAnyClinet(builder);
        }
        Path path = Paths.get(AMRadiusMigrationConstants.MIG_REPORT_RADIUS_CLIENT_SECRET_FILEPATH, new String[0]);
        Files.write(path, builder.toString().getBytes(), new OpenOption[0]);
    }

    public void generateMissingClientsReport(List<RadiusClientHBM> radClientList) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (!radClientList.isEmpty()) {
            builder.append("</br></br>\n").append("<p style=\"font-weight: bold;\">").append("Radius Client Missing In Radius Server:</p>").append("  Below are the list of Radius Client(s) which are missing in radius server").append("</br>\n</br>\n").append("<table id=\"radMissingClient\" style=\"padding-left: 40px;margin-left: inherit;width: 60%;\">\n").append("<tr>\n").append("<th style=\"width: 140px;  background: cyan;\">Radius-Client-Name</th>\n <td style=\"width: 450px;\">");
            int index = 1;
            for (RadiusClientHBM obj : radClientList) {
                if (index > 1) {
                    builder.append(", ");
                }
                builder.append(obj.getName());
                ++index;
            }
            builder.append("</td></tr>\n</table>");
            builder = this.replaceAnyClinet(builder);
        }
        Path path = Paths.get(AMRadiusMigrationConstants.MIG_REPORT_MISSIG_RADIUS_CLIENT_FILEPATH, new String[0]);
        Files.write(path, builder.toString().getBytes(), new OpenOption[0]);
    }

    public void generateMissingClientsInAMReport(List<RadiusClientDTO> radClientList) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (!radClientList.isEmpty()) {
            builder.append("</br></br>\n").append("<p style=\"font-weight: bold;\">").append("Radius Client Missing In Authentication Manager:</p>").append("  Below are the list of Radius Client(s) which are missing in Authentication Manager").append("</br>\n</br>\n").append("<table id=\"radMissingClientAM\" style=\"padding-left: 40px;margin-left: inherit;width: 60%;\">\n").append("<tr>\n").append("<th style=\"width: 140px;  background: cyan; \">Radius-Client-Name</th>\n <td style=\"width: 450px;\">");
            int index = 1;
            for (RadiusClientDTO obj : radClientList) {
                if (index > 1) {
                    builder.append(", ");
                }
                builder.append(obj.getName());
                ++index;
            }
            builder.append("</td></tr>\n</table>");
            builder = this.replaceAnyClinet(builder);
        }
        Path path = Paths.get(AMRadiusMigrationConstants.MIG_REPORT_MISSIG_RADIUS_CLIENT_AM_FILEPATH, new String[0]);
        Files.write(path, builder.toString().getBytes(), new OpenOption[0]);
    }

    public void mergeAdditionalFailureReport() throws IOException {
        String reportContent = this.getHTMLReport();
        int lastTableIndex = reportContent.lastIndexOf("</table>");
        String splitContent = reportContent.substring(0, lastTableIndex);
        StringBuilder builder = new StringBuilder();
        String radiusIPConflict = this.getGeneratedHTMLreport(AMRadiusMigrationConstants.MIG_REPORT_RADIUS_CLIENT_FILEPATH);
        String radiusSharedSecret = this.getGeneratedHTMLreport(AMRadiusMigrationConstants.MIG_REPORT_RADIUS_CLIENT_SECRET_FILEPATH);
        String missingRadClients = this.getGeneratedHTMLreport(AMRadiusMigrationConstants.MIG_REPORT_MISSIG_RADIUS_CLIENT_FILEPATH);
        String missingRadClientsAM = this.getGeneratedHTMLreport(AMRadiusMigrationConstants.MIG_REPORT_MISSIG_RADIUS_CLIENT_AM_FILEPATH);
        String note = "";
        String warningRow = "<tr class=\"warn\">" + System.getProperty("line.separator") + "<td>WARNINGS</br></td>" + System.getProperty("line.separator");
        if ((missingRadClients.contains("</table>") || missingRadClientsAM.contains("</table>") || radiusSharedSecret.contains("</table>")) && splitContent.contains(warningRow)) {
            int indexOfWarning = splitContent.indexOf(warningRow) + warningRow.length();
            String splitedWaringRow = splitContent.substring(indexOfWarning, splitContent.length());
            String warningContent = splitedWaringRow.substring(0, splitedWaringRow.indexOf("</td>"));
            StringBuilder strBuilder = new StringBuilder();
            if (missingRadClients.contains("</table>")) {
                strBuilder.append("<div style=\"float:left\">").append("Radius Client does not exist in Radius Server </div>").append("<div style=\"float:right\">").append("<u style=\"color: blue;\" onclick=\"document.getElementById('radMissingClient').scrollIntoView();\">").append("click here for more details</u></div>\n<br>");
            }
            if (missingRadClientsAM.contains("</table>")) {
                strBuilder.append("<div style=\"float:left\">").append("Radius Client does not exist in Authentication Manager</div>").append("<div style=\"float:right\">").append("<u style=\"color: blue;\" onclick=\"document.getElementById('radMissingClientAM').scrollIntoView();\">").append("click here for more details</u></div>\n<br>");
            }
            if (radiusSharedSecret.contains("</table>")) {
                strBuilder.append("<div style=\"float:left\">").append("Radius Client With Invalid Shared Secret</div>").append("<div style=\"float:right\">").append("<u style=\"color: blue;\" onclick=\"document.getElementById('radEmptySecret').scrollIntoView();\">").append("click here for more details</u></div>\n<br>");
            }
            splitContent = splitContent.replace(warningContent, String.valueOf(warningContent) + strBuilder.toString());
        }
        if (radiusIPConflict.contains("</table>")) {
            String failuerRow;
            String SuccessMsg = "<tr>\n<td>Pre-Migration Results</br></td>\n<td>Success</br></td>\n</tr>\n";
            String FailedMsg = "<tr class=\"error\">\n<td>Pre-Migration Results</br></td>\n<td>Failed</br></td>\n</tr>";
            if (splitContent.contains(SuccessMsg)) {
                splitContent = splitContent.replace(SuccessMsg, FailedMsg);
            }
            if (splitContent.contains(failuerRow = "<tr>" + System.getProperty("line.separator") + "<td>FAILURES</br></td>" + System.getProperty("line.separator") + "<td></br></td>" + System.getProperty("line.separator") + "</tr>" + System.getProperty("line.separator"))) {
                int index = splitContent.indexOf(failuerRow);
                splitContent = String.valueOf(splitContent.substring(0, index)) + splitContent.substring(index + failuerRow.length(), splitContent.length());
                builder.append(splitContent).append("<tr class=\"error\">\n").append("<td>FAILURES </br></td>\n <td>");
            } else {
                builder.append(splitContent).append("<tr class=\"error\">\n").append("<td>ADDITIONAL FAILURES </br></td>\n <td>");
            }
            if (radiusIPConflict.contains("</table>")) {
                builder.append(" <div style=\"float:left\">").append(" Radius Client IP Conflict </div>").append("  <div style=\"float:right\"> ").append("<u style=\"color: blue;\" onclick=\"document.getElementById('radiusClentTable').scrollIntoView();\">").append("click here for more details</u></div> <br>");
            }
            builder.append("</td>");
            note = "<br> <br> Please follow the resolution steps from the document (rsa_authentication_manager_8.6_RADIUS_premigration_script-2.1.pdf) <br><p style=\"font-weight: bold; color: red;\">\n IMPORTANT - Do not upgrade to Authentication Manager version 8.6 until these reported failures (if any) are resolved.</p>";
        } else {
            builder.append(splitContent);
        }
        builder.append("</tr></table>").append(radiusIPConflict).append(radiusSharedSecret).append(missingRadClients).append(missingRadClientsAM).append(note).append("<br><div id=\"copyright\">\n").append("<span>\n").append("&#169; 1994-2022 RSA Security LLC or its affiliates. All Rights Reserved.\n").append("<span>\n").append("</body>");
        this.setHTMLReport(builder.toString());
        this.savePreMigationReport(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir());
        this.deletExistingReport(AMRadiusMigrationConstants.MIG_REPORT_RADIUS_CLIENT_FILEPATH);
        this.deletExistingReport(AMRadiusMigrationConstants.MIG_REPORT_RADIUS_CLIENT_SECRET_FILEPATH);
        this.deletExistingReport(AMRadiusMigrationConstants.MIG_REPORT_MISSIG_RADIUS_CLIENT_FILEPATH);
        this.deletExistingReport(AMRadiusMigrationConstants.MIG_REPORT_MISSIG_RADIUS_CLIENT_AM_FILEPATH);
        this.deletExistingReport(AMRadiusMigrationConstants.MIG_REPORT_FILEPATH);
    }

    private void deletExistingReport(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    private String getGeneratedHTMLreport(String path) throws IOException {
        BufferedReader reader = null;
        StringBuilder stringBuilder = new StringBuilder();
        File file = new File(path);
        if (file.exists()) {
            reader = new BufferedReader(new FileReader(path));
            String line = null;
            String ls = System.getProperty("line.separator");
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            if (reader != null) {
                reader.close();
            }
        }
        return stringBuilder.toString();
    }

    private StringBuilder replaceAnyClinet(StringBuilder builder) {
        int anyIndex = builder.indexOf(ANY_RADIUS_CLIENT);
        if (anyIndex > -1) {
            builder.replace(anyIndex, anyIndex + ANY_RADIUS_CLIENT.length(), HTML_ANY_CLIENT);
        }
        return builder;
    }
}

