/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.utility;

import com.rsa.authmgr.admin.migration.handler.impl.AMRadiusClientAdministrationImpl;
import com.rsa.authmgr.admin.migration.utility.AMDAOLiteMigrationUtil;
import com.rsa.authmgr.admin.migration.utility.MigrationLoggingHelper;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationParametersDTO;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationResultsDTO;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusPreMigrationResultsDTO;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.internal.admin.radius.RadiusProfileAdministration;
import com.rsa.authmgr.internal.admin.radius.dal.AMRadiusClientAccess;
import com.rsa.authmgr.internal.admin.radius.dal.RadiusServerAccess;
import com.rsa.authmgr.internal.admin.radius.dal.RadiusServerHBM;
import com.rsa.authmgr.internal.admin.radius.impl.RadiusServerAdministrationImpl;
import com.rsa.authmgr.internal.radius.jaxb.checklists.CheckList;
import com.rsa.authmgr.internal.radius.jaxb.profiles.AuthenticationProfiles;
import com.rsa.authmgr.internal.radius.jaxb.radiusclient.RadiusClients;
import com.rsa.authmgr.internal.radius.jaxb.returnlists.ReturnList;
import com.rsa.authmgr.internal.radius.sbr.xui.RSARadiusDataStream;
import com.rsa.authmgr.internal.radius.sbr.xui.XUIAccess;
import com.rsa.authmgr.internal.radius.sbr.xui.impl.XUIConnectionManagerImpl;
import com.rsa.authmgr.internal.radius.util.JAXBUtil;
import com.rsa.authmgr.radius.local.operations.dto.TrustedRootCertDTO;
import com.rsa.authmgr.radius.local.operations.util.RootCertParser;
import com.rsa.command.Command;
import com.rsa.command.CommandException;
import com.rsa.command.exception.DataNotFoundException;
import com.rsa.common.GUID;
import com.rsa.common.InvalidArgumentException;
import com.rsa.common.SystemException;
import com.rsa.common.UnexpectedDataStoreException;
import com.rsa.common.search.Filter;
import com.rsa.ims.admin.SecurityDomain;
import com.rsa.ims.admin.dal.SecurityDomainAccess;
import com.rsa.ims.authn.AuthenticationException;
import com.rsa.ims.cache.IMSCacheAdministration;
import com.rsa.ims.common.IMSGUID;
import com.rsa.ims.components.ComponentUtils;
import com.rsa.ims.configuration.ConfigurationService;
import com.rsa.ims.security.crypto.CryptoException;
import com.rsa.ims.security.keymanager.sys.ServerAccessInfo;
import com.rsa.ims.security.keymanager.sys.ServerAccessInfoWrapper;
import com.rsa.ims.util.packaging.encryption.SecureStreamFactoryHelper;
import com.rsa.security.RSAPrincipal;
import com.rsa.security.SecurityContext;
import com.rsa.tools.common.CLUException;
import com.rsa.tools.common.ConnectionManager4CLI;
import com.rsa.tools.common.IMSCommandProxy;
import com.rsa.tools.common.ReplicationUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.CipherOutputStream;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.util.FileUtils;
import org.xml.sax.InputSource;

public class RadiusMigrationUtility {
    private final Logger migrationLogger = MigrationLoggingHelper.getmigrationLogger();
    private XUIConnectionManagerImpl xuiConnMgr;
    private RadiusProfileAdministration radProfileAdmin;
    private RadiusServerAccess radSrvDAO;
    private AMRadiusClientAccess amRadiuClientAcces;
    private RadiusServerAdministrationImpl radSrvAdmin;
    private AMRadiusClientAdministrationImpl radClientAdmin;
    private ConfigurationService config;
    private SecurityDomainAccess sdDAO;
    private static String IMS_SYSTEM_DOMAIN_GUID = "ims.000000000000000000001000e0011000";
    private static AMRadiusMigrationParametersDTO migParamDTO;
    private static AMRadiusPreMigrationResultsDTO premigrateResultDTO;
    private static AMRadiusMigrationResultsDTO migrateResultDTO;
    private static final String POST_FIX_FILENAME = "-rsa-migrated";
    public static final String RADIUS_CLIENTS_EXPORT_FILE_NAME = "radiusClients.xml";
    public static final String RADIUS_PROFILES_EXPOR_FILE_NAME = "radiusProfiles.xml";
    public static final String RADIUS_CHECK_LIST_EXPOR_FILE_NAME = "radiusCheckList.xml";
    public static final String RADIUS_RETURN_LIST_EXPOR_FILE_NAME = "radiusReturnList.xml";
    public static String IMPORT_RADIUS_CLIENTS;
    public static String IMPORT_RADIUS_PROFILES;
    public static String ENCODE_FORMAT;
    private static final String DOMAIN_OBJECT = "RADIUS profiles";
    public static final String RADIUS_METADATA_PREFIX = "RADIUS_METADATA_";
    public static final String RADIUS_DATA_EXISTS_METADATA = "RADIUS_METADATA_radius.data.exists";
    public static final String RADIUS_SERVER_REALM_METADATA = "RADIUS_METADATA_radius.server.realm.name.";
    private JAXBContext m_jaxbCtxProfiles;
    private JAXBContext m_jaxbContextCheckList;
    private JAXBContext m_jaxbContextReturnList;
    private JAXBContext m_jaxbContext;
    private JAXBContext m_jaxbContextDevice;
    private static String migrationAction;
    private static ServerAccessInfo serverAccess;
    private static final String XUI_GET_RADIUS_SERVER_CERT_URL = "/serverCertificates/serverCertificate%5B@id='server_certificate.pfx'%5D";
    private static String URL_BASE;
    private static String URL_LOOKUP;
    private static String URL_LIST;

    static {
        IMPORT_RADIUS_CLIENTS = "/command/importexport/import_uri=/radiusClients/&import_mode=merge_all";
        IMPORT_RADIUS_PROFILES = "/command/importexport/import_uri=/authenticationProfiles/&import_mode=merge_all";
        ENCODE_FORMAT = "UTF-8";
        migrationAction = null;
        serverAccess = null;
        URL_BASE = "/rootCertificates";
        URL_LOOKUP = String.valueOf(URL_BASE) + "/rootCertificate%5B@id='";
        URL_LIST = String.valueOf(URL_BASE) + "/";
    }

    public RadiusMigrationUtility() {
        this.initializeDAOLite();
        this.initializeXUIConnection();
        this.initilizeJAXB();
    }

    private static String toCanonicalPath(String fileName) throws Exception {
        try {
            File f = new File(fileName);
            return f.getCanonicalPath();
        }
        catch (IOException io) {
            throw new IOException("Unable to get path for file " + fileName + ". IO Exception: " + io.getMessage());
        }
    }

    public static void executeCommand(String userName, String password, Command cmd) throws CLUException {
        System.setProperty("com.rsa.naming.pin.to.local.host", Boolean.TRUE.toString());
        try {
            IMSCommandProxy imsCmdProxy = new IMSCommandProxy();
            RSAPrincipal rsaPrincipal = imsCmdProxy.getPrincipal(userName, password);
            String userGuid = rsaPrincipal.getGuid().getTypedGuid();
            imsCmdProxy.executeCommand(userName, userGuid, cmd);
            imsCmdProxy.logout(userName);
        }
        catch (NamingException e) {
            throw new CLUException("Unable to communicate with server- " + e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new CLUException("Invalid user name or password- " + e.getMessage(), (Throwable)e);
        }
        catch (CommandException e) {
            throw new CLUException("Unable to communicate with server- " + e.getMessage(), (Throwable)e);
        }
    }

    private void initializeDAOLite() {
        AMDAOLiteMigrationUtil.init(RadiusMigrationUtility.getMigrationAction());
        this.radProfileAdmin = (RadiusProfileAdministration)ComponentUtils.getBean((String)"RadiusProfileAdministration");
        this.radSrvDAO = (RadiusServerAccess)ComponentUtils.getBean((String)"RadiusServerAccess");
        this.amRadiuClientAcces = (AMRadiusClientAccess)ComponentUtils.getBean((String)"AMRadiusClientAccess");
        this.sdDAO = (SecurityDomainAccess)ComponentUtils.getBean(SecurityDomainAccess.class);
        this.radSrvAdmin = (RadiusServerAdministrationImpl)ComponentUtils.getBean((String)"RadiusServerAdministration");
        this.config = (ConfigurationService)ComponentUtils.getBean((String)"ReadOnlyConfigurationService");
        this.radClientAdmin = (AMRadiusClientAdministrationImpl)ComponentUtils.getBean((String)"RadiusClientAdministration");
    }

    private void initializeXUIConnection() {
        this.xuiConnMgr = new XUIConnectionManagerImpl();
        this.xuiConnMgr.setServerAccess(this.radSrvDAO);
    }

    private void initilizeJAXB() {
        try {
            this.m_jaxbContextCheckList = JAXBContext.newInstance((String)"com.rsa.authmgr.internal.radius.jaxb.checklists");
            this.m_jaxbContextReturnList = JAXBContext.newInstance((String)"com.rsa.authmgr.internal.radius.jaxb.returnlists");
            this.m_jaxbCtxProfiles = JAXBContext.newInstance((String)"com.rsa.authmgr.internal.radius.jaxb.profiles");
            this.m_jaxbContext = JAXBContext.newInstance((String)"com.rsa.authmgr.internal.radius.jaxb.radiusclient");
            this.m_jaxbContextDevice = JAXBContext.newInstance((String)"com.rsa.authmgr.internal.radius.jaxb.device");
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public Object convertToCheckList(File p_xml, String objectName, JAXBContext jaxbContext) {
        try {
            Unmarshaller um = this.m_jaxbContextCheckList.createUnmarshaller();
            Object objects = um.unmarshal(p_xml);
            return objects;
        }
        catch (JAXBException exp) {
            throw new SystemException("Unable to convert XML ->" + objectName + "POJO ", (Throwable)exp);
        }
    }

    public Object convertToReturnList(File p_xml, String objectName, JAXBContext jaxbContext) {
        try {
            Unmarshaller um = this.m_jaxbContextReturnList.createUnmarshaller();
            Object objects = um.unmarshal(p_xml);
            return objects;
        }
        catch (JAXBException exp) {
            throw new SystemException("Unable to convert XML ->" + objectName + "POJO ", (Throwable)exp);
        }
    }

    public static Object getTrustedMigrationConfigValue(final String configKeyName, final String section) {
        Boolean configValue = false;
        try {
            configValue = (Boolean)SecurityContext.doAsSystem((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConfigurationService config = (ConfigurationService)ComponentUtils.getBean((String)"ReadOnlyConfigurationService");
                    return config.getConfiguration(IMSGUID.DEPLOYMENT_ID.getId(), section).get(configKeyName);
                }
            });
        }
        catch (Exception exception) {}
        if (configValue == null) {
            configValue = false;
        }
        return configValue;
    }

    public static void addMigrationConfigValue() throws Exception {
        RadiusMigrationUtility.addConfigData("auth_manager.radius.migration.clients.pass_on_error", "true");
        RadiusMigrationUtility.addConfigData("auth_manager.radius.migration.premigration.dict.pass_on_error", "true");
        RadiusMigrationUtility.addConfigData("auth_manager.radius.migration.profiles.pass_on_error", "true");
    }

    private static Connection getDBConneciton() throws Exception {
        ServerAccessInfo sai = new ServerAccessInfo();
        ConnectionManager4CLI connManager = new ConnectionManager4CLI(sai);
        DataSource ds = connManager.getDataSource();
        Connection connection = ds.getConnection();
        return connection;
    }

    private static void addConfigData(String name, String value) throws Exception {
        Connection conn = RadiusMigrationUtility.getDBConneciton();
        PreparedStatement queryStmt = conn.prepareStatement("SELECT IMS_CONFIG_METADATA.NAME FROM IMS_CONFIG_METADATA WHERE INSTANCE_ID = ? AND NAME = ?");
        queryStmt.setString(1, IMSGUID.DEPLOYMENT_ID.getId());
        queryStmt.setString(2, name);
        if (!queryStmt.executeQuery().next()) {
            PreparedStatement metaStmt = conn.prepareStatement("INSERT INTO IMS_CONFIG_METADATA(INSTANCE_ID, NAME, DATA_TYPE, SENSITIVE, MULTI_VALUE) VALUES (?,?,?,?,?)");
            metaStmt.setString(1, IMSGUID.DEPLOYMENT_ID.getId());
            metaStmt.setString(2, name);
            metaStmt.setInt(3, 500);
            metaStmt.setBoolean(4, false);
            metaStmt.setBoolean(5, false);
            metaStmt.executeUpdate();
        }
        queryStmt = conn.prepareStatement("SELECT IMS_CONFIG_VALUE.NAME FROM IMS_CONFIG_VALUE  WHERE INSTANCE_ID = ? AND NAME = ?");
        queryStmt.setString(1, IMSGUID.DEPLOYMENT_ID.getId());
        queryStmt.setString(2, name);
        if (!queryStmt.executeQuery().next()) {
            PreparedStatement configStmt = conn.prepareStatement("INSERT INTO IMS_CONFIG_VALUE (ID, INSTANCE_ID, NAME, VALUE)  VALUES (?, ?, ?, ?)");
            configStmt.setString(1, new IMSGUID().getId());
            configStmt.setString(2, IMSGUID.DEPLOYMENT_ID.getId());
            configStmt.setString(3, name);
            configStmt.setString(4, value);
            configStmt.executeUpdate();
        }
        IMSCacheAdministration cacheAdmin = (IMSCacheAdministration)ComponentUtils.getBean((String)"IMSCacheAdministration");
        cacheAdmin.flushCaches(null);
    }

    public static void updateInstanceVersion() throws Exception {
        block15: {
            if (RadiusMigrationUtility.isPrimary()) {
                Statement statement = null;
                ServerAccessInfoWrapper sai = new ServerAccessInfoWrapper();
                String hostName = sai.getStringValue("com.rsa.appserver.hostname");
                String instanceVersion = RadiusMigrationUtility.getInstanceVersion(hostName);
                try {
                    try {
                        statement = RadiusMigrationUtility.getDBConneciton().prepareStatement("UPDATE ims_instance_version set version = ? WHERE instance_id = (Select instance_id from ims_instance_node where host = '" + hostName + "')");
                        statement.setString(1, instanceVersion);
                        statement.executeUpdate();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {
                                statement = null;
                            }
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            statement = null;
                        }
                    }
                    throw throwable;
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        Object var0 = null;
                    }
                }
            }
        }
    }

    private static String getInstanceVersion(String hostName) throws DataNotFoundException {
        PreparedStatement statement = null;
        String instanceVersion = null;
        try {
            try {
                statement = RadiusMigrationUtility.getDBConneciton().prepareStatement("SELECT V.VERSION FROM IMS_INSTANCE_VERSION V, IMS_INSTANCE_NODE N WHERE V.INSTANCE_ID=N.INSTANCE_ID AND LOWER(N.HOST) = LOWER(?)");
                statement.setString(1, hostName);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    instanceVersion = resultSet.getString("version");
                }
            }
            catch (Exception e) {
                throw new DataNotFoundException(e.getMessage(), e.getCause().toString(), new Object[0]);
            }
        }
        catch (Throwable throwable) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    statement = null;
                }
            }
            throw throwable;
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                statement = null;
            }
        }
        return instanceVersion.replace("8.5", "8.6");
    }

    public Collection<SecurityDomain> getTopLevelSecurityDomain() {
        Collection realms = this.sdDAO.searchTopLevelSecurityDomain(Filter.empty());
        return realms;
    }

    public String retrieveSecurityDomainName(GUID securityDomainId) throws UnexpectedDataStoreException, DataNotFoundException, com.rsa.common.DataNotFoundException {
        SecurityDomain securityDomain = this.sdDAO.lookup(securityDomainId);
        return securityDomain.getName();
    }

    public static String replaceSpaceWithHypn(String str) {
        if (str != null && str.trim().length() > 0) {
            str = str.toLowerCase();
            String patternStr = "\\s+";
            String replaceStr = "-";
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(str);
            str = matcher.replaceAll(replaceStr);
            patternStr = "\\s";
            replaceStr = "-";
            pattern = Pattern.compile(patternStr);
            matcher = pattern.matcher(str);
            str = matcher.replaceAll(replaceStr);
        }
        return str;
    }

    public static String getPostFixFileName() {
        return POST_FIX_FILENAME;
    }

    public static String generatingRandomAlphanumericString(int strlength) {
        int leftLimit = 48;
        int rightLimit = 122;
        int targetStringLength = strlength;
        Random random = new Random();
        String generatedString = random.ints(leftLimit, rightLimit + 1).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(targetStringLength).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        return generatedString.toLowerCase();
    }

    public static boolean checkFileExists(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        File f = new File(fileName);
        boolean dataFound = false;
        if (f.exists()) {
            try {
                FileInputStream in = new FileInputStream(f);
                if (in.read() != -1) {
                    dataFound = true;
                }
                in.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        return dataFound;
    }

    public static AMRadiusMigrationResultsDTO getMigrateResultDTO() {
        return migrateResultDTO;
    }

    public static void setMigrateResultDTO(AMRadiusMigrationResultsDTO migrateResultDTO) {
        RadiusMigrationUtility.migrateResultDTO = migrateResultDTO;
    }

    public static void checkCreateDir(String dirName) throws Exception {
        File dir = new File(dirName);
        if (dir.exists()) {
            dir.isDirectory();
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
        RadiusMigrationUtility.changeExistingFilePermissionIfRequired(dir);
    }

    public static void changeExistingFilePermissionIfRequired(File dir) throws Exception {
        try {
            RadiusMigrationUtility.testAndSetFilePermission(dir, "rwxrwx---");
        }
        catch (Exception exception) {
            String cfr_ignored_0 = "Unable to assign executable permissions to directory " + dir.getAbsolutePath() + " for radius migration output";
            throw new Exception("Unable to assign executable permissions to directory " + dir.getAbsolutePath() + " for migration output");
        }
    }

    public static void closeDAOLite() {
        ComponentUtils.close();
    }

    public static String testAndSetFilePermission(File file, String permission) throws IOException {
        if (file == null) {
            throw new IOException("Null file");
        }
        if (permission == null) {
            throw new IOException("Null permission");
        }
        Path path = file.toPath();
        Set<PosixFilePermission> actualPerms = Files.getPosixFilePermissions(path, new LinkOption[0]);
        Set<PosixFilePermission> expectedPerms = PosixFilePermissions.fromString(permission);
        if (actualPerms.size() != expectedPerms.size() || !actualPerms.containsAll(expectedPerms)) {
            Files.setPosixFilePermissions(path, expectedPerms);
        }
        return file.getAbsoluteFile().getCanonicalPath();
    }

    public void exportRadiusServerCertificate() {
        try {
            char[] pwdFromSBRForPfxFile = this.getPfxPasswordFromSBR();
            char[] pwdFromSysFldForP12File = this.getRadiusCertPassword();
            String am85PfxFilePathString = "/opt/rsa/am/radius/ROOT/server_certificate.pfx";
            String radiusStoreType = "PKCS12";
            String am86P12FilePath = String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.FREERADIUS_MIGRATION_DIR + "radius.p12";
            String am86KeyFilePath = String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.FREERADIUS_MIGRATION_DIR + "radius.key";
            String am86CertFilePath = String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.FREERADIUS_MIGRATION_DIR + "radius.crt";
            File f = new File(am85PfxFilePathString);
            KeyStore sourceKeyStore = KeyStore.getInstance(radiusStoreType);
            sourceKeyStore.load(new ByteArrayInputStream(Files.readAllBytes(f.toPath())), pwdFromSBRForPfxFile);
            String alias = sourceKeyStore.aliases().nextElement();
            PrivateKey key = (PrivateKey)sourceKeyStore.getKey(alias, pwdFromSBRForPfxFile);
            Certificate[] certChain = sourceKeyStore.getCertificateChain(alias);
            Certificate headCert = certChain[0];
            KeyStore destinationKeyStore = KeyStore.getInstance(radiusStoreType);
            destinationKeyStore.load(null, pwdFromSysFldForP12File);
            destinationKeyStore.setCertificateEntry(alias, headCert);
            destinationKeyStore.setKeyEntry(alias, key, pwdFromSysFldForP12File, certChain);
            FileOutputStream fileOS = new FileOutputStream(am86P12FilePath);
            destinationKeyStore.store(fileOS, pwdFromSysFldForP12File);
            this.createCertFileUsingOpenSSL(am86CertFilePath, am86P12FilePath);
            this.createKeyFileUsingOpenSSL(am86KeyFilePath, am86P12FilePath);
        }
        catch (Exception e) {
            this.logSevere("Error while exporting the trusted root certificate.", e);
        }
    }

    private char[] getPfxPasswordFromSBR() throws Exception {
        RadiusServerHBM radSrv = this.lookupRadiusSrvByHostName();
        this.logInfo("Fetching the password from the SBR " + radSrv);
        XUIAccess xuiAccess = null;
        xuiAccess = this.xuiConnMgr.getDirectServerAccess(radSrv.getId());
        String xmlString = xuiAccess.read(XUI_GET_RADIUS_SERVER_CERT_URL);
        String password = RadiusMigrationUtility.parseXMLUsingXPATH(xmlString, "/serverCertificate/@encryptedPassword");
        return password.toCharArray();
    }

    private static String parseXMLUsingXPATH(String xmlString, String xpathExpr) {
        if (StringUtils.isBlank((String)xmlString)) {
            throw new IllegalArgumentException("Valid XML string is required");
        }
        if (StringUtils.isBlank((String)xpathExpr)) {
            throw new IllegalArgumentException("Valid XPATH expression needed");
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            return xpath.evaluate(xpathExpr, new InputSource(new StringReader(xmlString)));
        }
        catch (XPathExpressionException xpathExp) {
            throw new SystemException("Unable parse XML -" + xpathExp.getMessage() + "\n XMLString : " + xmlString + "\n XPATHExpr :" + xpathExpr, (Throwable)xpathExp);
        }
    }

    private RadiusServerHBM getPrimaryRadServerGUID() throws Exception {
        Iterator<RadiusServerHBM> iterator;
        List<RadiusServerHBM> radSrvs = this.getAllPrimaryRADIUSSrv();
        if (radSrvs.size() > 1) {
            this.logSevere("Error!!!! Found more than one Radius Server");
        }
        if (radSrvs.size() == 0) {
            this.logSevere("Error!!!! Not able to find any Radius server.");
        }
        if ((iterator = radSrvs.iterator()).hasNext()) {
            RadiusServerHBM radSrv = iterator.next();
            return radSrv;
        }
        return null;
    }

    private RadiusServerHBM lookupRadiusSrvByHostName() throws Exception {
        ServerAccessInfoWrapper sai = new ServerAccessInfoWrapper();
        String hostName = sai.getStringValue("com.rsa.appserver.hostname");
        RadiusServerHBM replicaRadSrvs = this.radSrvDAO.lookupByHostname(hostName);
        if (replicaRadSrvs == null) {
            this.logSevere("Error!!!! Found more than one Radius Server");
        }
        return replicaRadSrvs;
    }

    private void createKeyFileUsingOpenSSL(String keyFilePath, String p12FilePath) throws Exception {
        this.logInfo("creating the key file using openssl command");
        String password = new String(this.getRadiusCertPassword());
        StringBuilder sb = new StringBuilder();
        sb.append("openssl pkcs12 -in " + p12FilePath + " ");
        sb.append("-nocerts -out " + keyFilePath + " ");
        sb.append("-passin pass:" + password + " -passout pass:" + password);
        this.executeExternalProcess(sb.toString());
    }

    private void createCertFileUsingOpenSSL(String certFilePath, String p12FilePath) throws Exception {
        this.logInfo("creating the key file using openssl command");
        String password = new String(this.getRadiusCertPassword());
        StringBuilder sb = new StringBuilder();
        sb.append("openssl pkcs12 -in " + p12FilePath + " ");
        sb.append("-clcerts -nokeys -out " + certFilePath + " ");
        sb.append("-passin pass:" + password + " -passout pass:" + password);
        this.executeExternalProcess(sb.toString());
    }

    private void executeExternalProcess(String command) throws Exception {
        this.logInfo("About to execute command");
        Process proc = Runtime.getRuntime().exec(command);
        boolean procStatus = proc.waitFor(5L, TimeUnit.SECONDS);
        this.logInfo("Completed the command. Return value: " + proc.exitValue() + " " + procStatus);
    }

    private char[] getRadiusCertPassword() throws Exception {
        ServerAccessInfo info = new ServerAccessInfo();
        return info.getCharArray("com.rsa.radius.server.cert.password");
    }

    public void exportRadiusTrustedCertificate() {
        try {
            if (!RadiusMigrationUtility.isPrimaryInstance()) {
                this.logInfo("Not running the export radius trust certificate in replica instance.");
            }
            this.logInfo("Running the export radius trust certificate in primary instance.");
            RadiusServerHBM radSrv = this.lookupRadiusSrvByHostName();
            if (radSrv == null) {
                this.logSevere("Error!!!! Found more than one Radius Server");
            }
            StringBuilder sb = new StringBuilder();
            radSrv = this.lookupRadiusSrvByHostName();
            this.logInfo("Fetching the certificate for the radius server " + radSrv);
            XUIAccess xuiAccess = null;
            xuiAccess = this.xuiConnMgr.getDirectServerAccess(radSrv.getId());
            String xmlList = xuiAccess.read(URL_LIST);
            Collection trustedCertsFromSBR = RootCertParser.parseListXML((String)xmlList);
            for (TrustedRootCertDTO trustedRootCertDTO : trustedCertsFromSBR) {
                this.logInfo("Identified the trusted cert " + trustedRootCertDTO.getId() + " to be migrated.");
                sb.append(trustedRootCertDTO.getId());
                sb.append(System.lineSeparator());
            }
            Path path = Paths.get(String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.SBR_MIG_DIR + "trusted_certs.txt", new String[0]);
            Files.write(path, sb.toString().getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            this.logSevere("Error while exporting the trusted root certificate.", e);
        }
    }

    public Properties exportRADIUSData(byte[] password) throws InvalidArgumentException, DataNotFoundException, UnexpectedDataStoreException, com.rsa.common.DataNotFoundException, CLUException {
        List<RadiusServerHBM> radSrvs = this.getAllPrimaryRADIUSSrv();
        Properties metadata = new Properties();
        int realmNamesCounter = 0;
        for (RadiusServerHBM radSrv : radSrvs) {
            String realmName = this.retrieveSecurityDomainName(radSrv.getSecurityDomainId());
            metadata.put(RADIUS_DATA_EXISTS_METADATA, "true");
            metadata.put(RADIUS_SERVER_REALM_METADATA + ++realmNamesCounter, realmName);
            Path path = Paths.get(String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.SBR_MIG_DIR, new String[0]);
            File realmRadSrvExpLoc = new File(path.toAbsolutePath().toString());
            XUIAccess xuiAccess = null;
            try {
                xuiAccess = this.xuiConnMgr.getDirectServerAccess(radSrv.getId());
            }
            catch (com.rsa.common.DataNotFoundException e) {
                e.printStackTrace();
            }
            RSARadiusDataStream radiusDataStream = null;
            try {
                try {
                    File exportFile = new File(realmRadSrvExpLoc, RADIUS_CLIENTS_EXPORT_FILE_NAME);
                    radiusDataStream = xuiAccess.getDataAsStream("/radiusClients/");
                    this.writeExportData(radiusDataStream.getInputStream(), exportFile, password);
                    radiusDataStream.releaseConnection();
                    exportFile = new File(realmRadSrvExpLoc, RADIUS_PROFILES_EXPOR_FILE_NAME);
                    radiusDataStream = xuiAccess.getDataAsStream("/authenticationProfiles/");
                    this.writeExportData(radiusDataStream.getInputStream(), exportFile, password);
                    exportFile = new File(realmRadSrvExpLoc, RADIUS_CHECK_LIST_EXPOR_FILE_NAME);
                    radiusDataStream = xuiAccess.getDataAsStream("/attributeDictionary/checkList/");
                    this.writeExportData(radiusDataStream.getInputStream(), exportFile, password);
                    exportFile = new File(realmRadSrvExpLoc, RADIUS_RETURN_LIST_EXPOR_FILE_NAME);
                    radiusDataStream = xuiAccess.getDataAsStream("/attributeDictionary/returnList/");
                    this.writeExportData(radiusDataStream.getInputStream(), exportFile, password);
                }
                catch (Exception anyExp) {
                    throw new CLUException("Unable write client_profile data- " + anyExp.getMessage(), (Throwable)anyExp);
                }
            }
            finally {
                if (radiusDataStream != null) {
                    radiusDataStream.releaseConnection();
                    radiusDataStream = null;
                }
            }
        }
        return metadata;
    }

    public List<RadiusServerHBM> getAllPrimaryRADIUSSrv() throws DataNotFoundException {
        Collection primRadSrvs = this.radSrvDAO.getAllPrimaryRadiusServers();
        if (primRadSrvs == null || primRadSrvs.isEmpty()) {
            throw new DataNotFoundException("DAL_OBJECT_NOT_FOUND", "No RADIUS server found", new Object[0]);
        }
        return (List)primRadSrvs;
    }

    private void writeExportData(InputStream inStream, File outFile, byte[] password) throws CLUException {
        if (outFile.exists()) {
            outFile.delete();
        }
        if (password == null) {
            this.writeToFile(outFile, inStream);
        } else {
            this.writeToFile(outFile, inStream, password);
        }
    }

    protected void writeToFile(File fileToWrite, InputStream inStream) throws CLUException {
        FileWriter fw = null;
        BufferedWriter bufWriter = null;
        BufferedReader bufReader = null;
        try {
            try {
                fw = new FileWriter(fileToWrite);
                bufWriter = new BufferedWriter(fw);
                bufReader = new BufferedReader(new InputStreamReader(inStream, ENCODE_FORMAT));
                char[] buffer = new char[4096];
                int len = 0;
                while ((len = bufReader.read(buffer)) != -1) {
                    bufWriter.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                throw new CLUException("Failed to export RADIUS server data :" + e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(bufWriter);
            FileUtils.close((Writer)fw);
            FileUtils.close(bufReader);
            throw throwable;
        }
        FileUtils.close((Writer)bufWriter);
        FileUtils.close((Writer)fw);
        FileUtils.close((Reader)bufReader);
    }

    protected void writeToFile(File fileToWrite, InputStream inStream, byte[] password) throws CLUException {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        CipherOutputStream cos = null;
        BufferedInputStream bis = null;
        try {
            try {
                fos = org.apache.commons.io.FileUtils.openOutputStream((File)fileToWrite);
                bos = new BufferedOutputStream(fos);
                cos = new SecureStreamFactoryHelper().buildOutputStream((OutputStream)bos, password);
                bis = new BufferedInputStream(inStream);
                byte[] buffer = new byte[4096];
                int len = 0;
                while ((len = bis.read(buffer)) != -1) {
                    cos.write(buffer, 0, len);
                }
            }
            catch (InvalidKeyException e) {
                throw new CLUException("Failed to export RADIUS server data :" + e.getMessage(), (Throwable)e);
            }
            catch (CryptoException e) {
                throw new CLUException("Failed to encrypt RADIUS server data :" + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new CLUException("Failed to export RADIUS server data :" + e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(cos);
            FileUtils.close(bos);
            FileUtils.close((OutputStream)fos);
            FileUtils.close(bis);
            throw throwable;
        }
        FileUtils.close((OutputStream)cos);
        FileUtils.close((OutputStream)bos);
        FileUtils.close((OutputStream)fos);
        FileUtils.close((InputStream)bis);
    }

    public static boolean isPrimaryInstance() throws Exception {
        boolean isPrimaryInstance = false;
        try {
            serverAccess = new ServerAccessInfo();
        }
        catch (Exception e) {
            throw new Exception("Unable to retrieve server access information", e);
        }
        if (ReplicationUtil.isPrimary((ServerAccessInfo)serverAccess)) {
            isPrimaryInstance = true;
        }
        return isPrimaryInstance;
    }

    public static boolean isPrimary() throws Exception {
        serverAccess = new ServerAccessInfo();
        return serverAccess.getJNDIProperties().getProperty("com.rsa.installtype").equals("PRIMARY");
    }

    private static boolean isReplica() throws Exception {
        serverAccess = new ServerAccessInfo();
        return serverAccess.getJNDIProperties().getProperty("com.rsa.installtype").equals("REPLICA");
    }

    public AuthenticationProfiles convertRadiusProfileFromXML(String p_xml) {
        return (AuthenticationProfiles)JAXBUtil.convertFromXMLToObject((String)p_xml, (String)DOMAIN_OBJECT, (JAXBContext)this.m_jaxbCtxProfiles);
    }

    public RadiusClients convertFromXML(String p_xml) {
        return (RadiusClients)JAXBUtil.convertFromXMLToObject((String)p_xml, (String)"RADIUS clients", (JAXBContext)this.m_jaxbContext);
    }

    public CheckList convertToCheckList(String p_xml) {
        return (CheckList)JAXBUtil.convertFromXMLToObject((String)p_xml, (String)"CheckLists", (JAXBContext)this.m_jaxbContextCheckList);
    }

    public ReturnList convertToreturnList(String p_xml) {
        return (ReturnList)JAXBUtil.convertFromXMLToObject((String)p_xml, (String)"ReturnLists", (JAXBContext)this.m_jaxbContextReturnList);
    }

    public static Object convertFromXMLToObject(String p_xml, String objectName, JAXBContext jaxbContext) {
        try {
            Unmarshaller um = jaxbContext.createUnmarshaller();
            Object objects = um.unmarshal((Source)new StreamSource(new StringReader(p_xml)));
            return objects;
        }
        catch (JAXBException exp) {
            throw new SystemException("Unable to convert XML ->" + objectName + "POJO ", (Throwable)exp);
        }
    }

    public Object convertXMLToString(File p_xml, String objectName, JAXBContext jaxbContext) {
        try {
            Unmarshaller um = this.m_jaxbContext.createUnmarshaller();
            Object objects = um.unmarshal(p_xml);
            return objects;
        }
        catch (JAXBException exp) {
            throw new SystemException("Unable to convert XML ->" + objectName + "POJO ", (Throwable)exp);
        }
    }

    public static int getLogProgressSize() {
        return 100;
    }

    public Object convertXMLToStringofProfules(File p_xml, String objectName, JAXBContext jaxbContext) {
        try {
            Unmarshaller um = this.m_jaxbCtxProfiles.createUnmarshaller();
            Object objects = um.unmarshal(p_xml);
            return objects;
        }
        catch (JAXBException exp) {
            throw new SystemException("Unable to convert XML ->" + objectName + "POJO ", (Throwable)exp);
        }
    }

    public GUID getTopLevelSD() {
        GUID topLevelSystemDomain = null;
        Collection<SecurityDomain> realms = this.getTopLevelSecurityDomain();
        try {
            if (realms == null || realms.isEmpty()) {
                throw new DataNotFoundException(AMMigrateRadiusDataCLU.format("synchronization-failed", new Object[0]), "Security Domain not found", new Object[0]);
            }
            for (SecurityDomain realm : realms) {
                if (!realm.getName().equals("SystemDomain")) continue;
                topLevelSystemDomain = realm.getKey();
                break;
            }
        }
        catch (Exception exception) {}
        return topLevelSystemDomain;
    }

    public static String getFreeradiusDataType(String sbrDataType) {
        String dataType = AMRadiusMigrationConstants.dataTypeMapping.get(sbrDataType);
        if (dataType != null && !dataType.isEmpty()) {
            return dataType;
        }
        return AMRadiusMigrationConstants.dataTypeMapping.get("default");
    }

    public XUIConnectionManagerImpl getXuiConnMgr() {
        return this.xuiConnMgr;
    }

    public void setXuiConnMgr(XUIConnectionManagerImpl xuiConnMgr) {
        this.xuiConnMgr = xuiConnMgr;
    }

    public static String getMigrationAction() {
        return migrationAction;
    }

    public static void setMigrationAction(String migrationAction) {
        RadiusMigrationUtility.migrationAction = migrationAction;
    }

    public RadiusProfileAdministration getRadProfileAdmin() {
        return this.radProfileAdmin;
    }

    public void setRadProfileAdmin(RadiusProfileAdministration radProfileAdmin) {
        this.radProfileAdmin = radProfileAdmin;
    }

    public AMRadiusClientAccess getAmRadiuClientAcces() {
        return this.amRadiuClientAcces;
    }

    public void setAmRadiuClientAcces(AMRadiusClientAccess amRadiuClientAcces) {
        this.amRadiuClientAcces = amRadiuClientAcces;
    }

    public RadiusServerAdministrationImpl getRadSrvAdmin() {
        return this.radSrvAdmin;
    }

    public void setRadSrvAdmin(RadiusServerAdministrationImpl radSrvAdmin) {
        this.radSrvAdmin = radSrvAdmin;
    }

    public void setRadClientAdmin(AMRadiusClientAdministrationImpl amRadClientAdmin) {
        this.radClientAdmin = amRadClientAdmin;
    }

    public AMRadiusClientAdministrationImpl getRadClientAdmin() {
        return this.radClientAdmin;
    }

    public SecurityDomainAccess getSdDAO() {
        return this.sdDAO;
    }

    public void setSdDAO(SecurityDomainAccess sdDAO) {
        this.sdDAO = sdDAO;
    }

    public static AMRadiusMigrationParametersDTO getMigParamDTO() {
        return migParamDTO;
    }

    public static void setMigParamDTO(AMRadiusMigrationParametersDTO migParamDTO) {
        RadiusMigrationUtility.migParamDTO = migParamDTO;
    }

    public static AMRadiusPreMigrationResultsDTO getPremigrateResultDTO() {
        return premigrateResultDTO;
    }

    public static void setPremigrateResultDTO(AMRadiusPreMigrationResultsDTO premigrateResultDTO) {
        RadiusMigrationUtility.premigrateResultDTO = premigrateResultDTO;
    }

    private void logInfo(String message) {
        this.migrationLogger.log(Level.INFO, message);
    }

    private void logSevere(String msg) {
        this.logSevere(msg, null);
    }

    private void logSevere(String msg, Exception e) {
        this.migrationLogger.log(Level.SEVERE, msg, e);
    }

    public static Connection getDBConnection() throws Exception {
        ServerAccessInfo sai = new ServerAccessInfo();
        ConnectionManager4CLI connManager = new ConnectionManager4CLI(sai);
        DataSource ds = connManager.getDataSource();
        Connection connection = ds.getConnection();
        return connection;
    }

    public static Map<String, String> getOutptMap(String sqlQuery, Connection connection) throws Exception {
        HashMap<String, String> resultData = new HashMap<String, String>();
        try (ResultSet results = null;){
            PreparedStatement stmt = connection.prepareStatement(sqlQuery);
            results = stmt.executeQuery();
            while (results.next()) {
                resultData.put(results.getString(1), results.getString(2));
            }
        }
        return resultData;
    }

    public static Object convertXMLFileToObject(File p_xml, String objectName, JAXBContext m_jaxbContext) {
        try {
            Object objects = null;
            if (p_xml.exists()) {
                Unmarshaller um = m_jaxbContext.createUnmarshaller();
                objects = um.unmarshal(p_xml);
            }
            return objects;
        }
        catch (JAXBException exp) {
            throw new SystemException("Unable to convert XML ->" + objectName + "POJO ", (Throwable)exp);
        }
    }
}

