/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.validator;

import com.rsa.authmgr.admin.migration.utility.MigrationLoggingHelper;
import com.rsa.authmgr.admin.radius.migration.data.DictionaryAttributeDTO;
import com.rsa.authmgr.admin.radius.migration.data.DictionaryAttributeNameValueDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class AMRadiusDictionaryValidator {
    static final String HYPEN = "-";

    public DictionaryAttributeDTO validate(DictionaryAttributeDTO attrDTO, Map<String, List<DictionaryAttributeDTO>> duplicateAttrNameCheckList) {
        if (attrDTO == null) {
            return null;
        }
        if (!this.checkAttributeIDSupportedFormat(attrDTO.getAttrID())) {
            attrDTO.setAttributeIDFormatSupported(false);
        } else {
            attrDTO.setAttributeIDFormatSupported(true);
        }
        this.checkForDuplicateAttrNameWithDifferentID(duplicateAttrNameCheckList, attrDTO);
        return attrDTO;
    }

    public DictionaryAttributeNameValueDTO validate(DictionaryAttributeNameValueDTO attrNameValueDTO, Map<String, List<DictionaryAttributeNameValueDTO>> duplicateAttrNameValueCheckList) {
        if (attrNameValueDTO == null) {
            return null;
        }
        this.checkForDuplicateAttributeValueName(duplicateAttrNameValueCheckList, attrNameValueDTO);
        this.checkForDuplicateAttributeNameValueID(duplicateAttrNameValueCheckList, attrNameValueDTO);
        return attrNameValueDTO;
    }

    private boolean checkAttributeIDSupportedFormat(String attributeID) {
        boolean isAttributeIDSupportedFormat = true;
        if (attributeID != null && attributeID.startsWith("0x") && attributeID.substring(2).length() > 4) {
            isAttributeIDSupportedFormat = false;
        }
        return isAttributeIDSupportedFormat;
    }

    public String replaceUnsupportedCharactersInName(String attrName) {
        return attrName.replaceAll(":", HYPEN);
    }

    private DictionaryAttributeDTO checkForDuplicateAttrNameWithDifferentID(Map<String, List<DictionaryAttributeDTO>> duplicateAttrNameCheckList, DictionaryAttributeDTO attributeDTO) {
        String supportedCharAttrNameChange;
        String orgAttrName = attributeDTO.getAttrName();
        if (!orgAttrName.equalsIgnoreCase(supportedCharAttrNameChange = this.replaceUnsupportedCharactersInName(attributeDTO.getAttrName()))) {
            attributeDTO.setAttrName(supportedCharAttrNameChange);
            this.logWarn("Changed the attribute name, to remove unsupported characters in attribute name: " + orgAttrName + " to attribute name: " + supportedCharAttrNameChange);
        }
        if (duplicateAttrNameCheckList.get(attributeDTO.getAttrName()) != null) {
            this.logInfo("Duplicate attribute name found for attribute name: " + orgAttrName);
            List<DictionaryAttributeDTO> duplicateAttriDTOList = duplicateAttrNameCheckList.get(attributeDTO.getAttrName());
            DictionaryAttributeDTO duplicateAttributeDTO = null;
            if (duplicateAttriDTOList != null && duplicateAttriDTOList.size() > 0) {
                duplicateAttributeDTO = this.checkIfAttributeIDIsSame(duplicateAttriDTOList, attributeDTO.getAttrID());
                if (duplicateAttributeDTO != null) {
                    this.logInfo("Duplicate attribute name has the same identifier, no name change required: " + attributeDTO.getAttrName());
                    attributeDTO.setAttrName(duplicateAttributeDTO.getAttrName());
                } else {
                    int attributeNameCounter = 1;
                    String newAttributeName = String.valueOf(attributeDTO.getAttrName()) + HYPEN + attributeNameCounter;
                    while (duplicateAttrNameCheckList.get(newAttributeName) != null) {
                        duplicateAttriDTOList = duplicateAttrNameCheckList.get(newAttributeName);
                        duplicateAttributeDTO = this.checkIfAttributeIDIsSame(duplicateAttriDTOList, attributeDTO.getAttrID());
                        if (duplicateAttributeDTO != null) break;
                        newAttributeName = String.valueOf(attributeDTO.getAttrName()) + HYPEN + ++attributeNameCounter;
                    }
                    if (duplicateAttributeDTO == null) {
                        attributeDTO.setAttrName(newAttributeName);
                        this.updateDuplicateMap(new ArrayList<DictionaryAttributeDTO>(Arrays.asList(attributeDTO)), duplicateAttrNameCheckList, newAttributeName);
                        duplicateAttriDTOList.add(attributeDTO);
                        this.updateDuplicateMap(duplicateAttriDTOList, duplicateAttrNameCheckList, orgAttrName);
                    } else {
                        attributeDTO.setAttrName(duplicateAttributeDTO.getAttrName());
                    }
                    this.logWarn("Duplicate attribute name value with a different attribute identifier. Updating the attribute original name: " + orgAttrName + " with new attribute name: " + newAttributeName);
                }
            } else {
                ArrayList<DictionaryAttributeDTO> listDto = new ArrayList<DictionaryAttributeDTO>();
                listDto.add(attributeDTO);
                duplicateAttrNameCheckList.put(orgAttrName, listDto);
                this.logInfo("Duplicate attribute name value but no attribute entries present, will update the list with the current attribute dto: " + orgAttrName);
            }
        } else {
            ArrayList<DictionaryAttributeDTO> listDto = new ArrayList<DictionaryAttributeDTO>();
            listDto.add(attributeDTO);
            duplicateAttrNameCheckList.put(orgAttrName, listDto);
        }
        return attributeDTO;
    }

    private DictionaryAttributeNameValueDTO checkForDuplicateAttributeValueName(Map<String, List<DictionaryAttributeNameValueDTO>> duplicateAttrNameValueCheckList, DictionaryAttributeNameValueDTO attribValueNameDTO) {
        String supportedCharAttrValueNameChange;
        String orgAttrValueName = attribValueNameDTO.getAttrValueName();
        if (!orgAttrValueName.equalsIgnoreCase(supportedCharAttrValueNameChange = this.replaceUnsupportedCharactersInName(attribValueNameDTO.getAttrValueName()))) {
            attribValueNameDTO.setAttrValueName(supportedCharAttrValueNameChange);
            this.logWarn("Changed the attribute value name, to remove unsupported characters in attribute value name: " + orgAttrValueName + " to attribute value name: " + supportedCharAttrValueNameChange);
        }
        String mergeAttributeValueName = String.valueOf(attribValueNameDTO.getAttrName()) + HYPEN + attribValueNameDTO.getAttrValueName();
        int attributeCounterValue = 1;
        DictionaryAttributeNameValueDTO duplicateAttributeNameValueDTO = null;
        if (duplicateAttrNameValueCheckList.get(mergeAttributeValueName) != null) {
            this.logInfo("Duplicate attribute value name found for attribute value name: " + attribValueNameDTO.getAttrValueName());
            List<DictionaryAttributeNameValueDTO> duplicateNameValueDTOList = duplicateAttrNameValueCheckList.get(mergeAttributeValueName);
            if (duplicateNameValueDTOList != null && duplicateNameValueDTOList.size() > 0) {
                duplicateAttributeNameValueDTO = this.checkIfAttributeValueNameIDIsSame(duplicateNameValueDTOList, attribValueNameDTO.getAttrValueID());
                if (duplicateAttributeNameValueDTO != null) {
                    this.logInfo("Duplicate attribute name value has the same ID, no name change required: " + duplicateAttributeNameValueDTO.getAttrName());
                    attribValueNameDTO.setAttrValueName(duplicateAttributeNameValueDTO.getAttrValueName());
                } else {
                    String newAttributeValueName = String.valueOf(attribValueNameDTO.getAttrValueName()) + HYPEN + attributeCounterValue;
                    String newMergeAttributeValueName = String.valueOf(attribValueNameDTO.getAttrName()) + HYPEN + newAttributeValueName;
                    while (duplicateAttrNameValueCheckList.get(newMergeAttributeValueName) != null) {
                        duplicateNameValueDTOList = duplicateAttrNameValueCheckList.get(newMergeAttributeValueName);
                        duplicateAttributeNameValueDTO = this.checkIfAttributeValueNameIDIsSame(duplicateNameValueDTOList, attribValueNameDTO.getAttrValueID());
                        if (duplicateAttributeNameValueDTO != null) {
                            this.logWarn("Duplicate attribute name value with a different identifier using an already generated name suffix as it exists: " + newAttributeValueName);
                            break;
                        }
                        newAttributeValueName = String.valueOf(attribValueNameDTO.getAttrValueName()) + HYPEN + ++attributeCounterValue;
                        newMergeAttributeValueName = String.valueOf(attribValueNameDTO.getAttrName()) + HYPEN + newAttributeValueName;
                    }
                    if (duplicateAttributeNameValueDTO == null) {
                        duplicateNameValueDTOList.add(duplicateAttributeNameValueDTO);
                        this.updateDuplicateAttribNameValueMap(duplicateNameValueDTOList, duplicateAttrNameValueCheckList, orgAttrValueName);
                    }
                    if (duplicateAttributeNameValueDTO == null) {
                        attribValueNameDTO.setAttrValueName(newAttributeValueName);
                        this.updateDuplicateAttribNameValueMap(new ArrayList<DictionaryAttributeNameValueDTO>(Arrays.asList(attribValueNameDTO)), duplicateAttrNameValueCheckList, newAttributeValueName);
                        duplicateNameValueDTOList.add(attribValueNameDTO);
                        this.updateDuplicateAttribNameValueMap(duplicateNameValueDTOList, duplicateAttrNameValueCheckList, orgAttrValueName);
                    } else {
                        attribValueNameDTO.setAttrValueName(duplicateAttributeNameValueDTO.getAttrValueName());
                    }
                    this.logWarn("Duplicate attribute name value with a different attribute identifier. Updating the attribute original name: " + orgAttrValueName + " with new attribute name: " + newAttributeValueName);
                }
            } else {
                ArrayList<DictionaryAttributeNameValueDTO> listDto = new ArrayList<DictionaryAttributeNameValueDTO>();
                listDto.add(attribValueNameDTO);
                duplicateAttrNameValueCheckList.put(orgAttrValueName, listDto);
                this.logInfo("Duplicate attribute name value but no attribute entries present, will update the list with the current attribute dto: " + orgAttrValueName);
            }
        } else {
            ArrayList<DictionaryAttributeNameValueDTO> dto = new ArrayList<DictionaryAttributeNameValueDTO>();
            dto.add(attribValueNameDTO);
            duplicateAttrNameValueCheckList.put(mergeAttributeValueName, dto);
        }
        return attribValueNameDTO;
    }

    private DictionaryAttributeNameValueDTO checkForDuplicateAttributeNameValueID(Map<String, List<DictionaryAttributeNameValueDTO>> duplicateAttrNameValueCheckList, DictionaryAttributeNameValueDTO attribValueNameDTO) {
        int attributeCounterValue = 1;
        String key = String.valueOf(attribValueNameDTO.getVendorID()) + "," + attribValueNameDTO.getAttrID() + "," + attribValueNameDTO.getAttrValueName();
        String newValueName = null;
        List<DictionaryAttributeNameValueDTO> dupAttributeNameValueDTO = null;
        if (duplicateAttrNameValueCheckList.get(key) != null) {
            dupAttributeNameValueDTO = duplicateAttrNameValueCheckList.get(key);
            if (!attribValueNameDTO.getAttrValueID().equalsIgnoreCase(dupAttributeNameValueDTO.get(0).getAttrValueID())) {
                this.logWarn("Duplicate Value Name with different identifier found. The name will be appended with integer: " + key);
                newValueName = String.valueOf(attribValueNameDTO.getAttrValueName()) + HYPEN + attributeCounterValue;
                key = String.valueOf(attribValueNameDTO.getVendorID()) + "," + attribValueNameDTO.getAttrID() + "," + newValueName;
                while (duplicateAttrNameValueCheckList.get(key) != null) {
                    newValueName = String.valueOf(attribValueNameDTO.getAttrValueName()) + HYPEN + ++attributeCounterValue;
                    key = String.valueOf(attribValueNameDTO.getVendorID()) + "," + attribValueNameDTO.getAttrID() + "," + newValueName;
                }
                this.logWarn("Updated name of the identifier: " + key);
                attribValueNameDTO.setAttrValueName(newValueName);
                duplicateAttrNameValueCheckList.put(key, new ArrayList<DictionaryAttributeNameValueDTO>(Arrays.asList(attribValueNameDTO)));
            }
        } else {
            duplicateAttrNameValueCheckList.put(key, new ArrayList<DictionaryAttributeNameValueDTO>(Arrays.asList(attribValueNameDTO)));
        }
        return attribValueNameDTO;
    }

    private void updateDuplicateAttribNameValueMap(List<DictionaryAttributeNameValueDTO> duplicateAttribNameValueDTOList, Map<String, List<DictionaryAttributeNameValueDTO>> duplicateAttrNameValueCheckList, String attributeNameValue) {
        duplicateAttrNameValueCheckList.put(attributeNameValue, duplicateAttribNameValueDTOList);
    }

    private void updateDuplicateMap(List<DictionaryAttributeDTO> duplicateAttriDTOList, Map<String, List<DictionaryAttributeDTO>> duplicateAttrNameCheckList, String attributeName) {
        duplicateAttrNameCheckList.put(attributeName, duplicateAttriDTOList);
    }

    private DictionaryAttributeDTO checkIfAttributeIDIsSame(List<DictionaryAttributeDTO> duplicateAttriDTOList, String attributeID) {
        if (duplicateAttriDTOList != null && duplicateAttriDTOList.size() > 0) {
            for (DictionaryAttributeDTO attribDTO : duplicateAttriDTOList) {
                if (!attributeID.equalsIgnoreCase(attribDTO.getAttrID())) continue;
                System.out.println("Equals listttttttttttttt to be returned " + attribDTO.getAttrName());
                return attribDTO;
            }
        }
        return null;
    }

    private DictionaryAttributeNameValueDTO checkIfAttributeValueNameIDIsSame(List<DictionaryAttributeNameValueDTO> duplicateAttribNameValueDTOList, String attributeID) {
        if (duplicateAttribNameValueDTOList != null && duplicateAttribNameValueDTOList.size() > 0) {
            for (DictionaryAttributeNameValueDTO attribDTO : duplicateAttribNameValueDTOList) {
                if (!attributeID.equalsIgnoreCase(attribDTO.getAttrID())) continue;
                return attribDTO;
            }
        }
        return null;
    }

    private void logInfo(String msg) {
        MigrationLoggingHelper.getmigrationLogger().log(Level.INFO, msg);
    }

    private void logWarn(String msg) {
        MigrationLoggingHelper.getmigrationLogger().log(Level.WARNING, msg);
    }

    private void logError(String msg, Throwable thrown) {
        MigrationLoggingHelper.getmigrationLogger().log(Level.SEVERE, msg, thrown);
    }
}

