/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.migration.validator;

import com.googlecode.ipv6.IPv6Network;
import com.rsa.authmgr.admin.radius.data.DeviceModelDTO;
import com.rsa.authmgr.admin.radius.data.RadiusClientDTO;
import com.rsa.authmgr.admin.radius.data.RadiusRealmSettingsDTO;
import com.rsa.authmgr.admin.radius.data.RegisterRadiusServerDTO;
import com.rsa.authmgr.internal.admin.hostmgt.dal.Host;
import com.rsa.authmgr.internal.admin.hostmgt.impl.HostValidator;
import com.rsa.authmgr.internal.admin.radius.RadiusClientAdministration;
import com.rsa.authmgr.internal.admin.radius.dal.RadiusServerHBM;
import com.rsa.authmgr.internal.common.util.DateFormatterHelper;
import com.rsa.authmgr.internal.common.util.IPV4AddressValidator;
import com.rsa.authmgr.internal.common.util.IPV6AddressValidator;
import com.rsa.authmgr.internal.radius.jaxb.radiusclient.RadiusClient;
import com.rsa.authmgr.internal.radius.util.SecurityDomainUtil;
import com.rsa.common.DataNotFoundException;
import com.rsa.common.GUID;
import com.rsa.common.InvalidArgumentException;
import com.rsa.ims.components.ComponentUtils;
import com.rsa.ims.logging.Level;
import com.rsa.ims.logging.trace.TraceLog;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.GenericValidator;

public final class RadiusValidators {
    private static final int HEXADECIMAL_RADIX = 16;
    private static final int UNSIGNED_1_BYTE_MAX = 255;
    private static final int UNSIGNED_2_BYTE_MAX = 65535;
    private static final long UNSIGNED_4_BYTE_MAX = 0xFFFFFFFFL;
    private static final long SIGNED_4_BYTE_MIN = Integer.MIN_VALUE;
    private static final long SIGNED_4_BYTE_MAX = Integer.MAX_VALUE;
    private static final BigInteger UNSIGNED_8_BYTE_MAX = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger UNSIGNED_8_BYTE_MIN = BigInteger.ZERO;
    public static final int RADIUS_ATTRIBUTE_LENGTH_MAX = 253;
    public static final long RADIUS_INTEGER_ATTR_MAX = 0xFFFFFFFFL;
    public static final long RADIUS_SIGNED_INTEGER_ATTR_MAX = Integer.MAX_VALUE;
    public static final BigInteger RADIUS_INT64_ATTR_MAX = UNSIGNED_8_BYTE_MAX;
    public static final BigInteger RADIUS_INT64_ATTR_MIN = UNSIGNED_8_BYTE_MIN;
    public static final int RADIUS_INT1_TYPE_ATTR_MAX = 255;
    public static final int RADIUS_INT2_TYPE_ATTR_MAX = 65535;
    public static final long RADIUS_INT4_TYPE_ATTR_MAX = 0xFFFFFFFFL;
    public static final long RADIUS_HEXADECIMAL_TYPE_ATTR_MAX = 0xFFFFFFFFL;
    public static final int RADIUS_HEX1_TYPE_ATTR_MAX = 255;
    public static final int RADIUS_HEX2_TYPE_ATTR_MAX = 65535;
    public static final long RADIUS_HEX4_TYPE_ATTR_MAX = 0xFFFFFFFFL;
    public static final long RADIUS_SIGNED_INT_TYPE_ATTR_MIN = Integer.MIN_VALUE;
    private static final String DATE_FORMAT_YYYYMMDDHHMMSS = "uuuu/MM/dd HH:mm:ss";
    private static TraceLog trace = TraceLog.getTraceLogger(RadiusValidators.class);

    private RadiusValidators() {
    }

    public static boolean validateRadiusClientDTO(RadiusClientDTO p_client, Actions p_opts) throws InvalidArgumentException {
        if (p_client == null) {
            throw new InvalidArgumentException(" Radius client cannot be null", "RADIUS_DTO_NULL");
        }
        if (p_client.getSecurityDomain() == null) {
            throw new InvalidArgumentException("Invalid RadiusClientDTO -  security domain is null", "SECURITY_DOMAIN_NULL");
        }
        SecurityDomainUtil.validateSecurityDomain((String)p_client.getSecurityDomain());
        if (StringUtils.isBlank((String)p_client.getName())) {
            throw new InvalidArgumentException("Invalid RadiusClientDTO - client name cannot be empty", "RADIUS_CLIENT_DTO_INVALID", new Object[]{p_client.getName()});
        }
        if (!GenericValidator.matchRegexp((String)p_client.getName(), (String)"(?U)^[\\w\\-\\_\\.\\x3E\\x3C\\s]+$")) {
            throw new InvalidArgumentException("Invalid RadiusClientDTO - Radius client Name contains invalid characters", "RADIUS_CLIENT_NAME_INVALID");
        }
        if (p_client.getName().contains("<") || p_client.getName().contains(">")) {
            if (!p_client.getName().equals("<ANY>")) {
                throw new InvalidArgumentException("Invalid RadiusClientDTO - Radius client Name contains invalid characters", "RADIUS_CLIENT_NAME_INVALID");
            }
        } else if (p_client.getName().length() > 50) {
            throw new InvalidArgumentException("Invalid RadiusClientDTO - client name cannot be greater than 50 characters", "RADIUS_CLIENT_NAME_EXCEEDS_MAXIMUM_LENGTH");
        }
        switch (p_opts) {
            case CREATE: {
                if (p_client.getId() == null) break;
                throw new InvalidArgumentException("Invalid RadiusClientDTO - valid guid cannot be set forcreate", "RADIUS_CLIENT_DTO_INVALID", new Object[]{p_client.getId()});
            }
            case UPDATE: {
                if (p_client.getId() != null) break;
                throw new InvalidArgumentException("Invalid RadiusClientDTO - valid guid should set for update ", "RADIUS_CLIENT_DTO_INVALID", new Object[]{p_client.getId()});
            }
        }
        if (p_client.isAcctSecretSet()) {
            RadiusValidators.validateSecrets(new String[]{p_client.getAcctSharedSecret()});
        }
        if (p_client.isClearAcctSecret()) {
            p_client.setAcctSharedSecret("");
        }
        if (p_client.isSharedSecretSet()) {
            RadiusValidators.validateSecrets(new String[]{p_client.getSharedSecret()});
        }
        if (p_client.getName().equals("<ANY>")) {
            String errorMessageIPv4 = "Expecting an empty IPv4 address for this <ANY> client";
            RadiusValidators.validateEmptyIPAddress(p_client.getIpaddress(), errorMessageIPv4);
            String errorMessageIPv6 = "Expecting an empty IPv6 address for this <ANY> client";
            RadiusValidators.validateEmptyIPAddress(p_client.getIpV6address(), errorMessageIPv6);
        } else {
            String ipaddressType = p_client.getIpaddressType();
            if (StringUtils.isBlank((String)ipaddressType)) {
                ipaddressType = "0";
            }
            if (ipaddressType.equals("0")) {
                RadiusValidators.validateIpV4AddressString(p_client.getIpaddress());
                String errorMessage = "Expecting an empty IPv6 address for this client";
                RadiusValidators.validateEmptyIPAddress(p_client.getIpV6address(), errorMessage);
            } else if (ipaddressType.equals("1")) {
                RadiusValidators.validateIpV6AddressString(p_client.getIpV6address());
                RadiusValidators.validateIpV4GeneratedAddressString(p_client.getIpaddress());
            } else if (ipaddressType.equals("2")) {
                RadiusValidators.validateIpV4AddressString(p_client.getIpaddress());
                RadiusValidators.validateIpV6AddressString(p_client.getIpV6address());
            } else {
                throw new InvalidArgumentException("Expecting valid IP Address Type for this client", "IP_ADDRESS_TYPE_VALID");
            }
        }
        RadiusValidators.validateIntParams(new int[]{p_client.getKeepAlive()});
        p_client.setName(p_client.getName().toUpperCase());
        return true;
    }

    public static boolean validateEmptyIPAddress(String ipAddress, String errorMessage) throws InvalidArgumentException {
        if (!StringUtils.isBlank((String)ipAddress)) {
            throw new InvalidArgumentException(errorMessage, "EMPTY_IP_ADDRESS_REQUIRED");
        }
        return true;
    }

    public static boolean validateEmptyIPAddress(String ipAddress) {
        return StringUtils.isBlank((String)ipAddress);
    }

    public static boolean validateGUIDs(String[] p_guids) throws InvalidArgumentException {
        if (p_guids == null) {
            throw new InvalidArgumentException("Null GUIDs", "RADIUS_INVALID_GUIDS");
        }
        String[] stringArray = p_guids;
        int n = p_guids.length;
        int n2 = 0;
        while (n2 < n) {
            String guid = stringArray[n2];
            if (guid == null) {
                throw new InvalidArgumentException("Null GUID", "RADIUS_INVALID_GUIDS");
            }
            try {
                GUID.parse2((String)guid);
            }
            catch (GUID.UnknownGUIDTypeException unknownGUIDTypeException) {
                throw new InvalidArgumentException("Invalid GUID", "RADIUS_INVALID_GUIDS", new Object[]{guid});
            }
            ++n2;
        }
        return true;
    }

    public static boolean validateDeviceModel(RadiusClientDTO p_client) throws InvalidArgumentException {
        boolean found = false;
        if (p_client == null) {
            throw new InvalidArgumentException("Invalid RadiusClientDTO", "RADIUS_DTO_NULL");
        }
        if (StringUtils.isEmpty((String)p_client.getModel())) {
            throw new InvalidArgumentException("Invalid RadiusClientDTO - model name cannot be empty", "RADIUS_CLIENT_DTO_INVALID");
        }
        RadiusClientAdministration admin = (RadiusClientAdministration)ComponentUtils.getBean((String)"RadiusClientAdministration");
        List dtos = null;
        try {
            dtos = admin.getAllDeviceModels(GUID.parse2((String)p_client.getSecurityDomain()));
        }
        catch (GUID.UnknownGUIDTypeException e) {
            throw new InvalidArgumentException("Invalid Security Domain GUID", "RADIUS_INVALID_GUIDS", (Object)e);
        }
        if (dtos != null && !dtos.isEmpty()) {
            for (DeviceModelDTO dto : dtos) {
                if (dto == null || !dto.getId().equals(p_client.getModel())) continue;
                found = true;
                break;
            }
        } else {
            found = true;
        }
        if (!found) {
            throw new InvalidArgumentException("Invalid RadiusClientDTO - unknown device model", "INVALID_DEVICE_MODEL", new Object[]{p_client.getModel()});
        }
        return found;
    }

    public static boolean validateSecrets(String[] p_secrets) {
        boolean status = true;
        if (p_secrets != null && p_secrets.length > 0) {
            String[] stringArray = p_secrets;
            int n = p_secrets.length;
            int n2 = 0;
            while (n2 < n) {
                String secret = stringArray[n2];
                if (StringUtils.isBlank((String)secret)) {
                    status = false;
                }
                ++n2;
            }
        }
        return status;
    }

    public static boolean validateIntParams(int[] p_params) throws InvalidArgumentException {
        boolean status = false;
        if (p_params != null && p_params.length > 0) {
            int[] nArray = p_params;
            int n = p_params.length;
            int n2 = 0;
            while (n2 < n) {
                int param = nArray[n2];
                if (param < 0 || param > Integer.MAX_VALUE) {
                    throw new InvalidArgumentException("Invalid Integer params", "INVALID_INTEGER", new Object[]{param});
                }
                ++n2;
            }
            status = true;
        }
        return status;
    }

    public static boolean isValidOrderValue(BigInteger order) throws InvalidArgumentException {
        if (order == null) {
            throw new InvalidArgumentException("Invalid Order value :" + order, "INVALID_ORDER_VALUE");
        }
        if (order.intValue() <= 0) {
            throw new InvalidArgumentException("Invalid Order value :" + order, "INVALID_ORDER_VALUE");
        }
        return true;
    }

    public static boolean validateIpV4AddressString(String p_ipStr) {
        return IPV4AddressValidator.isValidIpV4((String)p_ipStr);
    }

    public static boolean validateIpV6AddressString(String p_ipV6Str) {
        return IPV6AddressValidator.isValidIpV6((String)p_ipV6Str);
    }

    public static boolean validateIpV4GeneratedAddressString(String p_ipV4Str) {
        if (!p_ipV4Str.startsWith("255.")) {
            return false;
        }
        return RadiusValidators.validateIpV4AddressString(p_ipV4Str);
    }

    public static boolean validateIpV4AddressAttr(String attrName, String attrValue) throws InvalidArgumentException {
        if (!IPV4AddressValidator.isValidIpV4((String)attrValue)) {
            throw new InvalidArgumentException("Invalid ipV4 address attribute", "INVALID_IP_V4_ADDRESS_ATTR", new Object[]{attrName, attrValue});
        }
        return true;
    }

    public static boolean validateIPv4Prefix4AddressAttr(String attrName, String attrValue) throws InvalidArgumentException {
        if (!IPV4AddressValidator.isValidIPv4Prefix((String)attrValue)) {
            throw new InvalidArgumentException("Invalid IPv4Prefix address attribute", "INVALID_IP_V4_PREFIX_ATTR", new Object[]{attrName, attrValue});
        }
        return true;
    }

    public static boolean validateIpV6AddressAttr(String attrName, String attrValue) throws InvalidArgumentException {
        if (StringUtils.isBlank((String)attrValue)) {
            throw new InvalidArgumentException("Invalid ipV6 address attribute", "INVALID_IP_V6_ADDRESS_ATTR", new Object[]{attrName, attrValue});
        }
        try {
            Inet6Address.getByName(attrValue);
        }
        catch (UnknownHostException unknownHostException) {
            throw new InvalidArgumentException("Invalid ipV6 address attribute", "INVALID_IP_V6_ADDRESS_ATTR", new Object[]{attrName, attrValue});
        }
        return true;
    }

    public static boolean validateIPv6PrefixAddressAttr(String attrName, String attrValue) throws InvalidArgumentException {
        if (StringUtils.isBlank((String)attrValue)) {
            throw new InvalidArgumentException("Invalid IPv6Prefix attribute", "INVALID_IP_V6_PREFIX_ATTR", new Object[]{attrName, attrValue});
        }
        try {
            IPv6Network.fromString((String)attrValue);
        }
        catch (Exception exception) {
            throw new InvalidArgumentException("Invalid IPv6Prefix attribute", "INVALID_IP_V6_PREFIX_ATTR", new Object[]{attrName, attrValue});
        }
        return true;
    }

    public static boolean validateIfidAttr(String attrName, String attrValue) throws InvalidArgumentException {
        String regex = "^([0-9A-Fa-f]{4}:){3}([0-9A-Fa-f]{4})";
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(attrValue);
        if (StringUtils.isBlank((String)attrValue) || !match.matches()) {
            throw new InvalidArgumentException("Invalid IFID attribute", "INVALID_IFID_ATTR", new Object[]{attrName, attrValue});
        }
        return true;
    }

    public static boolean validateComboIpAttr(String attrName, String attrValue) throws InvalidArgumentException {
        if (StringUtils.isBlank((String)attrValue)) {
            throw new InvalidArgumentException("Invalid Combo IP attribute", "INVALID_COMBO_IP_ATTR", new Object[]{attrName, attrValue});
        }
        try {
            InetAddress address = InetAddress.getByName(attrValue);
            if (IPV4AddressValidator.isValidIpV4((String)attrValue) || address instanceof Inet6Address) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new InvalidArgumentException("Invalid combo-ip address attribute", "INVALID_COMBO_IP_ATTR", new Object[]{attrName, attrValue});
        }
        return true;
    }

    public static boolean validateEtherAttr(String attrName, String attrValue) throws InvalidArgumentException {
        String regex = "^([0-9A-Fa-f]{2}:){5}([0-9A-Fa-f]{2})";
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(attrValue);
        if (StringUtils.isBlank((String)attrValue) || !match.matches()) {
            throw new InvalidArgumentException("Invalid ether attribute", "INVALID_ETHER_ATTR", new Object[]{attrName, attrValue});
        }
        return true;
    }

    public static boolean validateGUIDObjects(String[] p_guids) throws InvalidArgumentException {
        if (p_guids == null) {
            throw new InvalidArgumentException("Invalid GUIDs", "RADIUS_INVALID_GUIDS");
        }
        String[] stringArray = p_guids;
        int n = p_guids.length;
        int n2 = 0;
        while (n2 < n) {
            String guid = stringArray[n2];
            try {
                GUID.parse2((String)guid);
            }
            catch (GUID.UnknownGUIDTypeException unknownGUIDTypeException) {
                throw new InvalidArgumentException("Invalid GUID", "RADIUS_INVALID_GUIDS", new Object[]{guid});
            }
            ++n2;
        }
        return true;
    }

    public static boolean validateGUIDObjects(GUID[] p_guids) throws InvalidArgumentException {
        if (p_guids == null) {
            throw new InvalidArgumentException("Invalid GUIDs", "RADIUS_INVALID_GUIDS");
        }
        GUID[] gUIDArray = p_guids;
        int n = p_guids.length;
        int n2 = 0;
        while (n2 < n) {
            GUID guid = gUIDArray[n2];
            if (guid == null || guid != null && guid.getId() == null) {
                throw new InvalidArgumentException("Invalid GUID", "RADIUS_INVALID_GUIDS", new Object[]{guid});
            }
            ++n2;
        }
        return true;
    }

    public static boolean validateRadiusPolicyDTO(RadiusRealmSettingsDTO p_dto, Actions p_opts) throws InvalidArgumentException {
        if (p_dto == null) {
            throw new InvalidArgumentException("RadiusPolicyDTO cannot be null", "RADIUS_DTO_NULL", null);
        }
        if (p_dto.getSdGuid() == null) {
            throw new InvalidArgumentException("SecurityDomain cannot be null", "SECURITY_DOMAIN_NULL", null);
        }
        SecurityDomainUtil.validateSecurityDomain((GUID)p_dto.getSdGuid());
        if (StringUtils.isBlank((String)p_dto.getName())) {
            throw new InvalidArgumentException("Invalid RadiusPolicyDTO - RadiusPolicy name cannot be empty", "RADIUS_POLICY_DTO_INVALID", new Object[]{p_dto.getName()});
        }
        String defaultProfile = p_dto.getDefaultProfile();
        if (StringUtils.isBlank((String)defaultProfile)) {
            throw new InvalidArgumentException("Invalid RadiusPolicyDTO -  valid RadiusProfile Name should be given", "RADIUS_POLICY_DTO_INVALID", new Object[]{defaultProfile});
        }
        return true;
    }

    public static boolean isHex(String attrName, String hexValueInString, long maxValue) throws InvalidArgumentException {
        try {
            long tmp = Long.parseLong(hexValueInString, 16);
            return RadiusValidators.checkValidRange(attrName, hexValueInString, tmp, maxValue);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidArgumentException("Invalid Hexadecimal value :" + hexValueInString, "INVALID_HEX_VALUE", new Object[]{attrName, hexValueInString});
        }
    }

    public static boolean isNumeric(String attrName, String valueToValidate, long maxValue) throws InvalidArgumentException {
        try {
            long tmp = Long.parseLong(valueToValidate);
            return RadiusValidators.checkValidRange(attrName, valueToValidate, tmp, maxValue);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidArgumentException("Not a number: " + valueToValidate, "INVALID_INTEGER_ATTR", new Object[]{attrName, valueToValidate});
        }
    }

    private static boolean checkValidRange(String attrName, String attrValueInString, long value, long maxValue) throws InvalidArgumentException {
        if (value < 0L || value > maxValue) {
            throw new InvalidArgumentException("Invalid length ", "INVALID_INTEGER_OR_HEX_ATTR_LENGTH", new Object[]{attrName, attrValueInString, maxValue});
        }
        return true;
    }

    public static boolean isInteger64(String attrName, BigInteger valueToValidate, BigInteger maxValue, BigInteger minValue) throws InvalidArgumentException {
        block3: {
            try {
                if (maxValue.compareTo(valueToValidate) < 0 || minValue.compareTo(valueToValidate) > 0) break block3;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidArgumentException("Not a number: " + valueToValidate, "INVALID_INTEGER_ATTR", new Object[]{attrName, valueToValidate});
            }
        }
        throw new InvalidArgumentException("Invalid length ", "INVALID_INTEGER_OR_HEX_ATTR_LENGTH", new Object[]{attrName, valueToValidate, maxValue});
    }

    public static boolean isSignedInteger(String attrName, String valueToValidate, long minValue, long maxValue) throws InvalidArgumentException {
        try {
            long tmp = Long.parseLong(valueToValidate);
            return RadiusValidators.checkSignedValidRange(attrName, valueToValidate, tmp, minValue, maxValue);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidArgumentException("Not a number: " + valueToValidate, "INVALID_SIGNED_INTEGER_ATTR", new Object[]{attrName, valueToValidate});
        }
    }

    private static boolean checkSignedValidRange(String attrName, String attrValueInString, long value, long minValue, long maxValue) throws InvalidArgumentException {
        if (value < minValue || value > maxValue) {
            throw new InvalidArgumentException("Invalid length ", "INVALID_INTEGER_OR_HEX_ATTR_LENGTH", new Object[]{attrName, attrValueInString, minValue, maxValue});
        }
        return true;
    }

    public static boolean isValidStringAttr(String attrName, String attrValue) throws InvalidArgumentException {
        if (StringUtils.isBlank((String)attrValue)) {
            throw new InvalidArgumentException("Invalid String attr value", "INVALID_STRING_ATTR", new Object[]{attrName, attrValue});
        }
        if (attrValue.length() > 253) {
            throw new InvalidArgumentException("Invalid String attr length", "INVALID_STRING_ATTR_LENGTH", new Object[]{attrName, attrValue, 253});
        }
        return true;
    }

    public static boolean isValidAttrValue(String attrName, String attrValue, String errorMsg) throws InvalidArgumentException {
        if (StringUtils.isBlank((String)attrValue)) {
            throw new InvalidArgumentException("Invalid String attr value", "INVALID_STRING_ATTR", new Object[]{attrName, attrValue});
        }
        if (attrValue.length() > 253) {
            throw new InvalidArgumentException("Invalid attr value", errorMsg, new Object[]{attrName, attrValue});
        }
        return true;
    }

    public static boolean isValidDateAttr(String attrName, String attrValue) throws InvalidArgumentException {
        if (StringUtils.isBlank((String)attrValue)) {
            throw new InvalidArgumentException("Invalid date attr value", "INVALID_DATE_ATTR", new Object[]{attrName, attrValue});
        }
        String dateModifiedValue = DateFormatterHelper.getDateinPrefferedFormat((String)attrValue);
        if (StringUtils.isBlank((String)dateModifiedValue)) {
            throw new InvalidArgumentException("Invalid date attr value", "INVALID_DATE_ATTR", new Object[]{attrName, attrValue});
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATE_FORMAT_YYYYMMDDHHMMSS).withResolverStyle(ResolverStyle.STRICT);
        try {
            ZonedDateTime.parse(dateModifiedValue, dateTimeFormatter.withZone(ZoneId.systemDefault()));
        }
        catch (DateTimeParseException e) {
            trace.log(Level.ERROR, (Object)"The Date attribute Value thrown exception::", (Throwable)e);
            throw new InvalidArgumentException("Invalid date attr value", "INVALID_DATE_ATTR", new Object[]{attrName, attrValue});
        }
        return true;
    }

    public static void validateAddRadiusServer(RadiusServerHBM server) throws InvalidArgumentException, DataNotFoundException {
        RadiusValidators.validateRadiusServer(server);
        if (server.getId() != null) {
            throw new InvalidArgumentException("Can't Specify GUID for new Server (AutoGenerated)", "RADIUS_SERVER_NO_GUID_ON_ADD");
        }
    }

    public static void validateUpdateRadiusServer(RadiusServerHBM oldServer, RadiusServerHBM newServer) throws InvalidArgumentException {
        if (!oldServer.getSecurityDomainId().equals((Object)newServer.getSecurityDomainId())) {
            trace.log(Level.ERROR, (Object)("validateUpdate() SDs don't match: new=" + oldServer.getSecurityDomainId() + " old=" + newServer.getSecurityDomainId()));
            throw new InvalidArgumentException("Cannot change Security Domain", "RADIUS_SERVER_NO_MOVE_SECDOMAIN");
        }
        if (!oldServer.getHost().getId().equals((Object)newServer.getHost().getId())) {
            trace.log(Level.ERROR, (Object)("validateUpdate() Host IDs don't match: new=" + oldServer.getHost().getId() + " old=" + newServer.getHost().getId()));
            throw new InvalidArgumentException("Cannot change Host link", "RADIUS_SERVER_NO_MOVE_HOST");
        }
    }

    public static void validateRadiusServer(RadiusServerHBM server) throws InvalidArgumentException, DataNotFoundException {
        if (server == null) {
            throw new InvalidArgumentException("Server must be specified", "RADIUS_SERVER_NO_SERVER");
        }
        RadiusValidators.validateHost(server.getHost());
        SecurityDomainUtil.validateSecurityDomainWithDNFE((GUID)server.getSecurityDomainId());
    }

    public static void validateHost(Host host) throws InvalidArgumentException {
        if (host == null) {
            throw new InvalidArgumentException("Host must be specified", "RADIUS_SERVER_HOST_NEEDED");
        }
        if (host.getName() == null || host.getName().length() < 1 || host.getName().length() > 256) {
            throw new InvalidArgumentException("Server Hostname invalid", "RADIUS_SERVER_INVALID_HOSTNAME");
        }
        String ip = host.getPrimaryIpAddress();
        if (ip == null || ip.equals("")) {
            throw new InvalidArgumentException("Server IP be specified", "RADIUS_SERVER_INVALID_IP");
        }
        HostValidator.validateHostAddressFormat((String)ip);
    }

    public static boolean validateRegisterRadiusServerDTO(RegisterRadiusServerDTO dto) throws InvalidArgumentException {
        if (dto != null) {
            if (StringUtils.isBlank((String)dto.getRadiusServerHostname()) || StringUtils.isBlank((String)dto.getRadiusServerIpAddress()) || StringUtils.isBlank((String)dto.getRadiusServerAdminUserName()) || StringUtils.isBlank((String)dto.getRadiusServerAdminPassword()) || StringUtils.isBlank((String)dto.getSecurityDomainGuid())) {
                throw new InvalidArgumentException("Invalid DTO", "INVALID_REGISTER_RADIUS_SERVER_DTO");
            }
        } else {
            throw new InvalidArgumentException("Invalid DTO", "INVALID_REGISTER_RADIUS_SERVER_DTO");
        }
        return true;
    }

    public static boolean isValidClientName(String clientName) {
        boolean flag = true;
        if (StringUtils.isBlank((String)clientName)) {
            flag = false;
        } else if (!GenericValidator.matchRegexp((String)clientName, (String)"(?U)^[\\w\\-\\_\\.\\x3E\\x3C\\s]+$")) {
            flag = false;
        } else if (clientName.contains("<") || clientName.contains(">")) {
            if (!clientName.equals("<ANY>")) {
                flag = false;
            }
        } else if (clientName.length() > 50) {
            flag = false;
        }
        return flag;
    }

    public static boolean isValidIpAddress(RadiusClientDTO p_client) {
        boolean flag = true;
        if (!p_client.getName().equals("<ANY>")) {
            String ipaddressType = p_client.getIpaddressType();
            if (StringUtils.isBlank((String)ipaddressType)) {
                ipaddressType = "0";
            }
            if (ipaddressType.equals("0")) {
                flag = RadiusValidators.validateIpV4AddressString(p_client.getIpaddress());
                if (flag) {
                    flag = RadiusValidators.validateEmptyIPAddress(p_client.getIpV6address());
                }
            } else if (ipaddressType.equals("1")) {
                flag = RadiusValidators.validateIpV6AddressString(p_client.getIpV6address());
                if (flag) {
                    flag = RadiusValidators.validateIpV4GeneratedAddressString(p_client.getIpaddress());
                }
            } else if (ipaddressType.equals("2")) {
                flag = RadiusValidators.validateIpV4AddressString(p_client.getIpaddress());
                if (flag) {
                    flag = RadiusValidators.validateIpV6AddressString(p_client.getIpV6address());
                }
            } else {
                flag = false;
            }
        }
        return flag;
    }

    public static boolean isSpecialCharacter(Set<Character> uniqueSpecialCharaters, RadiusClient radClientObj) {
        String sharedSecret;
        boolean isSpecialCharaterPresent = false;
        if (uniqueSpecialCharaters != null && (sharedSecret = radClientObj.getEncryptedAuthenticationSharedSecret()) != null) {
            for (Character character : uniqueSpecialCharaters) {
                if (!sharedSecret.contains(character.toString())) continue;
                isSpecialCharaterPresent = true;
                break;
            }
        }
        return isSpecialCharaterPresent;
    }

    public static enum Actions {
        CREATE,
        DELETE,
        UPDATE,
        LIST;

    }
}

