/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools;

import com.rsa.authmgr.admin.tools.Version;
import com.rsa.authmgr.admin.tools.arguments.CommandLineArguments;
import com.rsa.authmgr.admin.tools.arguments.MigrateArguments;
import com.rsa.authmgr.admin.tools.arguments.PreMigrateArguments;
import com.rsa.common.Global;
import com.rsa.ims.components.spring.SimpleApplicationLoader;
import com.rsa.ims.components.spring.SpringComponentManagerImpl;
import com.rsa.ims.logging.Level;
import com.rsa.ims.logging.trace.TraceLog;
import com.rsa.tools.common.CLUException;
import com.rsa.tools.common.action.Action;
import com.rsa.tools.common.action.Arguments;
import com.rsa.tools.common.action.CLUExitCodes;
import com.rsa.tools.common.action.exception.ExitException;
import com.rsa.tools.common.action.exception.MissingArgumentException;
import jargs.gnu.CmdLineParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.OrderComparator;

public class AMMigrateRadiusDataCLU {
    private static String outputDirLocation = null;
    private static final String BUNDLE_NAME = "resources.AMMigrateRadiusDataCLU";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("resources.AMMigrateRadiusDataCLU");
    public static final TraceLog TRACE_LOG = TraceLog.getTraceLogger(AMMigrateRadiusDataCLU.class);
    private static boolean debug;
    private static boolean silent;
    private static boolean interactive;
    private ValidAction action;
    private Arguments arguments;

    public void execute() throws Exception {
        if (this.action == null) {
            throw new MissingArgumentException(AMMigrateRadiusDataCLU.format("no-action", new Object[0]));
        }
        SimpleApplicationLoader loader = new SimpleApplicationLoader();
        loader.setPaths(new String[]{"applicationContext-" + this.action.name() + ".xml"});
        SpringComponentManagerImpl componentManager = new SpringComponentManagerImpl();
        componentManager.setBeanFactory(loader.useBeanFactory(null));
        componentManager.setRegister(true);
        componentManager.initialize();
        try {
            Map beans = componentManager.getBeanFactory().getBeansOfType(Action.class, false, false);
            ArrayList actions = new ArrayList();
            actions.addAll(beans.values());
            Collections.sort(actions, new OrderComparator());
            AMMigrateRadiusDataCLU.printMsg("execute-msg", this.action.name());
            for (Action act : actions) {
                act.setArguments(this.arguments);
                act.execute();
            }
            AMMigrateRadiusDataCLU.printMsg("success-msg", this.action.name());
        }
        finally {
            componentManager.close();
        }
    }

    public void setAction(ValidAction validAction) throws MissingArgumentException {
        if (validAction == null) {
            throw new MissingArgumentException(AMMigrateRadiusDataCLU.format("no-action", new Object[0]));
        }
        this.action = validAction;
    }

    public static boolean isSet(CmdLineParser parser, CmdLineParser.Option opt) {
        Boolean isSet = (Boolean)parser.getOptionValue(opt, (Object)Boolean.FALSE);
        return isSet;
    }

    public static void printWarn(String key, Object ... args) {
        String msg = AMMigrateRadiusDataCLU.format(key, args);
        if (!silent) {
            System.err.println(msg);
        }
        AMMigrateRadiusDataCLU.actionLog(Level.WARN, msg);
    }

    public static void printActionUsage(ValidAction action, CLUExitCodes exitCode) {
        System.err.format(AMMigrateRadiusDataCLU.getString("Usage-" + action.name()), new Object[0]);
        throw new ExitException(exitCode);
    }

    public static boolean isVerbose() {
        return TRACE_LOG.isEnabled(Level.VERBOSE);
    }

    public static void actionLog(Level level, String msg) {
        AMMigrateRadiusDataCLU.actionLog(level, msg, null);
    }

    public static String version() {
        return AMMigrateRadiusDataCLU.format("version", Version.VERSION, "");
    }

    public static String format(String key, Object ... args) {
        return String.format(AMMigrateRadiusDataCLU.getString(key), args);
    }

    public static void setSilent(boolean silent) {
        AMMigrateRadiusDataCLU.silent = silent;
    }

    public static void setDebug(boolean debug, Level level) {
        AMMigrateRadiusDataCLU.debug = debug;
        TRACE_LOG.setLevel(level);
    }

    public static void setInteractive(boolean interactive) {
        AMMigrateRadiusDataCLU.interactive = interactive;
    }

    public void setArguments(CommandLineArguments arguments) {
        this.arguments = arguments;
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString("AMMigrateRadiusDataCLU." + key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!AMMigrateRadiusDataCLU." + key + '!';
        }
    }

    public static void actionLog(Level level, String msg, Throwable error) {
        TRACE_LOG.log(level, (Object)msg.trim(), error);
    }

    public static boolean isSilent() {
        return silent;
    }

    public static void printMsg(String key, Object ... args) {
        String msg = AMMigrateRadiusDataCLU.format(key, args);
        if (!silent) {
            System.out.println(msg);
        }
        AMMigrateRadiusDataCLU.actionLog(Level.INFO, msg);
    }

    public static void printUsage(String msg, CLUExitCodes exitCode) {
        System.err.format(AMMigrateRadiusDataCLU.getString("Usage"), new Object[0]);
        throw new ExitException(msg, null, exitCode);
    }

    public static final AMMigrateRadiusDataCLU setupArgs(String[] args) throws IllegalArgumentException {
        CmdLineParser parser = new CmdLineParser();
        String actionStr = AMMigrateRadiusDataCLU.getAction(args);
        CommandLineArguments arguments = null;
        ValidAction validAction = null;
        if (!StringUtils.isEmpty((String)actionStr)) {
            try {
                validAction = ValidAction.valueOf(actionStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AMMigrateRadiusDataCLU.printUsage(AMMigrateRadiusDataCLU.format("invalid-action", actionStr), CLUExitCodes.INVALID_ARGUMENT_ERROR);
            }
            switch (validAction) {
                case migrate: {
                    arguments = new MigrateArguments(parser);
                    break;
                }
                case premigrate: {
                    arguments = new PreMigrateArguments(parser);
                    break;
                }
                case migratedictionary: {
                    arguments = new MigrateArguments(parser);
                    break;
                }
                default: {
                    AMMigrateRadiusDataCLU.printUsage(AMMigrateRadiusDataCLU.format("invalid-action", actionStr), CLUExitCodes.INVALID_ARGUMENT_ERROR);
                }
            }
        }
        if (arguments != null) {
            arguments.addOptions();
        }
        AMMigrateRadiusDataCLU.processDefaultArguments(validAction, parser, args);
        if (arguments == null) {
            AMMigrateRadiusDataCLU.printUsage(AMMigrateRadiusDataCLU.getString("no-action"), CLUExitCodes.REQUIRED_ARGUMENT_MISSING_ERROR);
        } else {
            arguments.parse();
        }
        String ocAdmin = arguments.getOCAdmin();
        StringUtils.isEmpty((String)ocAdmin);
        AMMigrateRadiusDataCLU migrateSBRRadiusData = new AMMigrateRadiusDataCLU();
        migrateSBRRadiusData.setAction(validAction);
        migrateSBRRadiusData.setArguments(arguments);
        return migrateSBRRadiusData;
    }

    private static String getAction(String[] args) {
        if (args == null) {
            return null;
        }
        int i = 0;
        while (i < args.length) {
            if ("-a".equals(args[i]) || "--action".equals(args[i])) {
                if (i >= args.length - 1) break;
                String action = args[i + 1];
                return action.startsWith("-") ? null : action.trim();
            }
            ++i;
        }
        return null;
    }

    private static final void processDefaultArguments(ValidAction action, CmdLineParser parser, String[] args) {
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option versionOpt = parser.addBooleanOption('v', "version");
        CmdLineParser.Option debugOpt = parser.addBooleanOption('X', "debug");
        CmdLineParser.Option scriptOpt = parser.addBooleanOption('S', "script-mode");
        CmdLineParser.Option silentOpt = parser.addBooleanOption('s', "silent");
        parser.addStringOption('a', "action");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.IllegalOptionValueException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        catch (CmdLineParser.UnknownOptionException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        String[] remainingArgs = parser.getRemainingArgs();
        if (remainingArgs != null && remainingArgs.length > 0) {
            throw new IllegalArgumentException(AMMigrateRadiusDataCLU.format("extraneous-arguments", Arrays.asList(remainingArgs)));
        }
        if (AMMigrateRadiusDataCLU.isSet(parser, helpOpt)) {
            if (action == null) {
                AMMigrateRadiusDataCLU.printUsage("", CLUExitCodes.SUCCESSFUL_OPERATION);
            } else {
                AMMigrateRadiusDataCLU.printActionUsage(action, CLUExitCodes.SUCCESSFUL_OPERATION);
            }
        }
        if (AMMigrateRadiusDataCLU.isSet(parser, versionOpt)) {
            System.out.format(AMMigrateRadiusDataCLU.getString("version"), Version.VERSION, Global.getCopyright());
            throw new ExitException(CLUExitCodes.SUCCESSFUL_OPERATION);
        }
        if (AMMigrateRadiusDataCLU.isSet(parser, silentOpt)) {
            AMMigrateRadiusDataCLU.setSilent(true);
        }
        if (AMMigrateRadiusDataCLU.isSet(parser, debugOpt)) {
            AMMigrateRadiusDataCLU.setDebug(true, Level.INFO);
        }
        AMMigrateRadiusDataCLU.setInteractive(!AMMigrateRadiusDataCLU.isSet(parser, scriptOpt));
    }

    public static void main(String[] args) {
        AMMigrateRadiusDataCLU migrateSBRRadiusData = null;
        try {
            migrateSBRRadiusData = AMMigrateRadiusDataCLU.setupArgs(args);
            migrateSBRRadiusData.arguments.validate();
            migrateSBRRadiusData.execute();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            AMMigrateRadiusDataCLU.terminalExceptionHandler(e, CLUExitCodes.INVALID_ARGUMENT_ERROR.ordinal());
        }
        catch (CLUException e) {
            AMMigrateRadiusDataCLU.terminalExceptionHandler((Exception)((Object)e), e.getReturnCode());
        }
        catch (ExitException e) {
            if (e.getExitCode() != CLUExitCodes.SUCCESSFUL_OPERATION.ordinal()) {
                AMMigrateRadiusDataCLU.terminalExceptionHandler((Exception)((Object)e), e.getExitCode());
            }
        }
        catch (Exception e) {
            AMMigrateRadiusDataCLU.terminalExceptionHandler(e, CLUExitCodes.UNSPECIFIED_ERROR.ordinal());
        }
    }

    private static void terminalExceptionHandler(Exception ex, int exitCode) {
        String err = ex.getLocalizedMessage();
        if (StringUtils.isEmpty((String)err)) {
            err = ex.getClass().getName();
        }
        err = AMMigrateRadiusDataCLU.format("error-msg", err);
        System.err.println(err);
        AMMigrateRadiusDataCLU.actionLog(Level.FATAL, err, ex);
        System.exit(0);
        if (debug) {
            CLUException.showCauses((Throwable)ex.getCause());
        }
    }

    public static boolean isInteractive() {
        return interactive;
    }

    public static enum ValidAction {
        migrate,
        premigrate,
        migratedictionary,
        migratelogs,
        migrateconfig,
        migratecertificate;

    }
}

