/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.migrate;

import com.rsa.authmgr.admin.migration.handler.AMRadiusClientMigration;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.admin.tools.arguments.MigrateArguments;
import com.rsa.tools.common.CLUException;
import com.rsa.tools.common.action.Arguments;

public class AMMigrateClientAction
extends OrderedRadiusMigrationAction {
    protected MigrateArguments arguments;
    protected AMRadiusClientMigration amRadiusClientMigration;

    public void execute() throws CLUException {
        this.migrationLogInfo("======Start: Migration of clients to FreeRadius=========");
        try {
            if (!RadiusMigrationUtility.isPrimary()) {
                this.migrationLogInfo(AMMigrateRadiusDataCLU.format("retrieve-instance-type", ": Not Primary Instance"));
                this.setMigrationSuccessResults();
                this.passOnFailure();
                return;
            }
        }
        catch (Exception e1) {
            this.setMigrationUnSuccessResults();
            this.passOnFailure();
            this.migrationLogError(AMMigrateRadiusDataCLU.format("retrieve-instance-type-failed", new Object[0]), e1);
            this.migrationLogInfo("======Failed: Export of Clients and Profiles============" + e1.getLocalizedMessage());
        }
        if (RadiusMigrationUtility.getPremigrateResultDTO().getTotalNumOfVendorsToBeMigrated() == 0) {
            this.migrationLogInfo("======Skip: No clients available for migration=========");
            this.setMigrationSuccessResults();
            this.passOnFailure();
            return;
        }
        if (!RadiusMigrationUtility.getPremigrateResultDTO().isClientsExported()) {
            this.migrationLogInfo("======Warning: No clients available for migration as clients exported is false=========");
            RadiusMigrationUtility.getMigParamDTO().setMigrateRADIUSClients(false);
            this.setMigrationSuccessResults();
            this.passOnFailure();
            return;
        }
        if (!RadiusMigrationUtility.getMigrateResultDTO().isDictionaryFilesMigrated()) {
            this.migrationLogInfo("======Continue: Migration of clients though, migration of dictionary failed=========");
        }
        try {
            this.amRadiusClientMigration.importRadiusClientData();
            this.setMigrationSuccessResults();
            this.migrationLogInfo("Successfully migrated Radius Clients to FreeRadius");
        }
        catch (Exception e) {
            this.setMigrationUnSuccessResults();
            this.passOnFailure();
            this.migrationLogInfo("======Failure: Migration of clients failed=========" + e.getLocalizedMessage());
        }
        if (RadiusMigrationUtility.getMigrateResultDTO().getClientsFailedToMigrate() != null && RadiusMigrationUtility.getMigrateResultDTO().getClientsFailedToMigrate().size() > 0) {
            this.setMigrationUnSuccessResults();
            this.migrationLogInfo("======Failure: Migration of clients failed=========");
        }
        this.passOnFailure();
        this.migrationLogInfo("======Completed: Migration of clients to FreeRadius=========");
    }

    public void passOnFailure() {
        boolean migConfigValue = (Boolean)RadiusMigrationUtility.getTrustedMigrationConfigValue("auth_manager.radius.migration.clients.pass_on_error", "auth_manager.radius.migration");
        if (migConfigValue) {
            RadiusMigrationUtility.getMigrateResultDTO().setMigrationSuccess(true);
            RadiusMigrationUtility.getMigrateResultDTO().setMigrationStatus(AMRadiusMigrationConstants.Status.WARNING);
            this.migrationLogInfo("Pass on failure for clients config value has been set to true");
        }
    }

    public void setArguments(Arguments arguments) {
        this.arguments = (MigrateArguments)arguments;
    }

    public void setAmRadiusClientMigration(AMRadiusClientMigration amRadiusClientMigration) {
        this.amRadiusClientMigration = amRadiusClientMigration;
    }

    private void setMigrationSuccessResults() {
        RadiusMigrationUtility.getMigrateResultDTO().setClientsMigrated(true);
    }

    private void setMigrationUnSuccessResults() {
        RadiusMigrationUtility.getMigParamDTO().setMigrateRADIUSClients(false);
        RadiusMigrationUtility.getMigrateResultDTO().setMigrationSuccess(false);
        RadiusMigrationUtility.getMigrateResultDTO().setClientsMigrated(false);
        RadiusMigrationUtility.getMigrateResultDTO().setMigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
    }
}

