/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.migrate;

import com.rsa.authmgr.admin.migration.handler.AMRadiusMigrateDictionary;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.admin.tools.arguments.MigrateArguments;
import com.rsa.tools.common.action.Arguments;
import com.rsa.tools.common.action.exception.CLUExitException;

public class AMMigrateDictionaryAction
extends OrderedRadiusMigrationAction {
    protected MigrateArguments arguments;
    private AMRadiusMigrateDictionary radiusMigrateDictionary;

    public void execute() throws CLUExitException {
        this.migrationLogInfo("======Start: Migration of dictionary files to FreeRadius=========");
        if (RadiusMigrationUtility.getPremigrateResultDTO().getTotalNumOfVendorsToBeMigrated() == 0) {
            this.migrationLogInfo(AMMigrateRadiusDataCLU.format("no-vendors-present", new Object[0]));
            this.setMigrationSuccessResults();
            return;
        }
        if (!RadiusMigrationUtility.getPremigrateResultDTO().isDictionaryConv() && RadiusMigrationUtility.getPremigrateResultDTO().getTotalNumOfDictionaryFilesToBeMigrated() == 0) {
            this.migrationLogInfo(AMMigrateRadiusDataCLU.format("dictionary_not_migrated", new Object[0]));
            this.setMigrationSuccessResults();
            return;
        }
        try {
            this.radiusMigrateDictionary.createFreeRadiusMergedConfigution();
            this.migrationLogInfo(AMMigrateRadiusDataCLU.format("migration-dictionary-merge-success", new Object[0]));
            this.setMigrationParameter();
            this.setMigrationSuccessResults();
        }
        catch (Exception e1) {
            this.migrationLogError(AMMigrateRadiusDataCLU.format("migration-dictionary-merge-failure", new Object[0]), e1);
            this.setMigrationFailureResults();
            this.setMigrationParameter();
            this.migrationLogInfo("======Failed: Migration of dictionary files to FreeRadius=========" + e1.getLocalizedMessage());
        }
        this.migrationLogInfo("======Completed: Migration of dictionary files to FreeRadius=========");
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setArguments(Arguments arguments) {
        this.arguments = (MigrateArguments)arguments;
    }

    private void setMigrationParameter() {
        this.migrationLogInfo(AMMigrateRadiusDataCLU.format("no-dictionary-config-present", new Object[0]));
        RadiusMigrationUtility.getMigParamDTO().setMigrateRADIUSDictionary(true);
    }

    private void setMigrationSuccessResults() {
        RadiusMigrationUtility.getMigrateResultDTO().setDictionaryFilesMigrated(true);
    }

    private void setMigrationFailureResults() {
        RadiusMigrationUtility.getMigrateResultDTO().setDictionaryFilesMigrated(false);
        RadiusMigrationUtility.getMigrateResultDTO().setMigrationSuccess(false);
        RadiusMigrationUtility.getMigrateResultDTO().setMigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
    }

    public void setRadiusMigrateDictionary(AMRadiusMigrateDictionary radiusMigrateDictionary) {
        this.radiusMigrateDictionary = radiusMigrateDictionary;
    }
}

