/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.migrate;

import com.rsa.authmgr.admin.migration.handler.AMRadiusProfileMigration;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.admin.tools.arguments.MigrateArguments;
import com.rsa.tools.common.CLUException;
import com.rsa.tools.common.action.Arguments;

public class AMMigrateProfileAction
extends OrderedRadiusMigrationAction {
    protected MigrateArguments arguments;
    protected AMRadiusProfileMigration amRadiusProfileMigration;

    public void execute() throws CLUException {
        try {
            if (!RadiusMigrationUtility.isPrimary()) {
                this.migrationLogInfo(AMMigrateRadiusDataCLU.format("retrieve-instance-type", ": Not Primary Instance"));
                this.setMigrationSuccessResults();
                this.passOnFailure();
                return;
            }
        }
        catch (Exception e1) {
            this.setMigrationUnSuccessResults();
            this.passOnFailure();
            this.migrationLogError(AMMigrateRadiusDataCLU.format("retrieve-instance-type-failed", new Object[0]), e1);
            this.migrationLogInfo("======Failed:Unable to retrive the type of instance ============" + e1.getLocalizedMessage());
        }
        if (RadiusMigrationUtility.getPremigrateResultDTO().getTotalNumOfVendorsToBeMigrated() == 0) {
            this.migrationLogInfo("======Skip: No profiles available for migration=========");
            this.setMigrationSuccessResults();
            this.passOnFailure();
            return;
        }
        if (!RadiusMigrationUtility.getPremigrateResultDTO().isProfilesExported()) {
            this.migrationLogInfo("======Warning: No profiles available for migration as profiles exported is false=========");
            RadiusMigrationUtility.getMigParamDTO().setMigrateRADIUSProfilesAndAttr(false);
            this.setMigrationSuccessResults();
            this.passOnFailure();
            return;
        }
        try {
            this.migrationLogInfo("======Start: Migration of profile to FreeRadius=========");
            this.amRadiusProfileMigration.importRadiusProfileData();
            this.migrationLogInfo("======Completed: Migration of profile to FreeRadius=========");
            this.setMigrationSuccessResults();
        }
        catch (Exception exception) {
            this.setMigrationUnSuccessResults();
            this.passOnFailure();
            this.migrationLogInfo("======Failed: Migration of profile to FreeRadius=========");
        }
        if (RadiusMigrationUtility.getMigrateResultDTO().getProfilesFailedToMigrate() != null && RadiusMigrationUtility.getMigrateResultDTO().getProfilesFailedToMigrate().size() > 0) {
            this.setMigrationUnSuccessResults();
            this.migrationLogInfo("======Failed: Migration of profile to FreeRadius=========");
        }
        this.passOnFailure();
    }

    public void setArguments(Arguments arguments) {
        this.arguments = (MigrateArguments)arguments;
    }

    public void passOnFailure() {
        boolean migConfigValue = (Boolean)RadiusMigrationUtility.getTrustedMigrationConfigValue("auth_manager.radius.migration.profiles.pass_on_error", "auth_manager.radius.migration");
        if (migConfigValue) {
            RadiusMigrationUtility.getMigrateResultDTO().setMigrationSuccess(true);
            RadiusMigrationUtility.getMigrateResultDTO().setMigrationStatus(AMRadiusMigrationConstants.Status.WARNING);
            this.migrationLogInfo("Pass on failure for profiles config value has been set to true");
        }
    }

    public void setAmRadiusProfileMigration(AMRadiusProfileMigration amRadiusProfileMigration) {
        this.amRadiusProfileMigration = amRadiusProfileMigration;
    }

    private void setMigrationSuccessResults() {
        RadiusMigrationUtility.getMigrateResultDTO().setProfilesMigrated(true);
    }

    private void setMigrationUnSuccessResults() {
        RadiusMigrationUtility.getMigParamDTO().setMigrateRADIUSProfilesAndAttr(false);
        RadiusMigrationUtility.getMigrateResultDTO().setMigrationSuccess(false);
        RadiusMigrationUtility.getMigrateResultDTO().setProfilesMigrated(false);
        RadiusMigrationUtility.getMigrateResultDTO().setMigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
    }
}

