/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.migrate;

import com.rsa.authmgr.admin.migration.utility.MigrationLoggingHelper;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.admin.tools.arguments.MigrateArguments;
import com.rsa.common.InvalidArgumentException;
import com.rsa.common.SystemException;
import com.rsa.common.search.Filter;
import com.rsa.ims.components.ComponentUtils;
import com.rsa.ims.security.certmanager.CertificateManager;
import com.rsa.ims.security.certmanager.StoredCertificate;
import com.rsa.security.certmanager.CertificatePurpose;
import com.rsa.tools.common.CLUException;
import com.rsa.tools.common.action.Arguments;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AMMigrateRadiusConfigurationFileAction
extends OrderedRadiusMigrationAction {
    public static final Logger migrationLogger = MigrationLoggingHelper.getmigrationLogger();
    protected MigrateArguments arguments;
    private List<String> configMigratedSuccessfully = new ArrayList<String>();
    private List<String> configMigratedWithErrors = new ArrayList<String>();
    private static final String SECURID_CONFIG_FILE = "SecurID.ini";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----\n";
    private static final String END_CERT = "-----END CERTIFICATE-----\n";

    public void execute() throws CLUException {
        try {
            this.logInfo("Started the Configuration file migrations.");
            this.migrateSecurIDIniFileContents();
            this.migrateEAPCertificates();
            this.logInfo("Completed the Configuration file migrations.");
            this.updateMigrationResults();
        }
        catch (Exception e) {
            this.updateMigrationResults();
            this.logSevere("Error while migrating the configuration files." + e.getMessage(), e);
        }
    }

    private void migrateEAPCertificates() throws Exception {
        try {
            this.logInfo("Migrating EAP Certificate contents.");
            this.logInfo("Running the RADIUS server certificate migration.This should run for all the instances.");
            this.copyEAPCertsFromMigration();
            if (RadiusMigrationUtility.isPrimaryInstance()) {
                this.logInfo("Running the RADIUS trust certificate migration.This should run only for primary instances.");
                this.readTrustedCertFromMigrationBackup();
            } else {
                this.logInfo("Skipping the Migration of Radius Trust certificate since we are running in replica instance.");
            }
            this.logInfo("Completed the EAP Certificate contents.");
        }
        catch (Exception e) {
            this.logSevere("Error while migrating the configuration files." + e.getMessage(), e);
        }
    }

    private void copyEAPCertsFromMigration() throws IOException {
        try {
            String am86P12FilePath = String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.FREERADIUS_MIGRATION_DIR + "radius.p12";
            String am86KeyFilePath = String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.FREERADIUS_MIGRATION_DIR + "radius.key";
            String am86CertFilePath = String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.FREERADIUS_MIGRATION_DIR + "radius.crt";
            String copyToLocation = String.valueOf(AMRadiusMigrationConstants.RADIUS_HOME_DIR) + "raddb" + File.separator + "certs" + File.separator;
            this.copyFiles(am86P12FilePath, String.valueOf(copyToLocation) + "radius.p12");
            this.configMigratedSuccessfully.add("radius.p12");
            this.copyFiles(am86KeyFilePath, String.valueOf(copyToLocation) + "radius.key");
            this.configMigratedSuccessfully.add("radius.key");
            this.copyFiles(am86CertFilePath, String.valueOf(copyToLocation) + "radius.crt");
            this.configMigratedSuccessfully.add("radius.crt");
        }
        catch (Exception e) {
            this.configMigratedWithErrors.add("radius.p12");
            this.configMigratedWithErrors.add("radius.key");
            this.configMigratedWithErrors.add("radius.crt");
            this.logSevere("Error while migrating the Radius server certificate." + e.getMessage(), e);
        }
    }

    public void copyFiles(String srcFilePath, String destFilePath) throws IOException {
        try {
            if (!RadiusMigrationUtility.checkFileExists(srcFilePath)) {
                throw new FileNotFoundException("Unable to find the source file to copy " + srcFilePath);
            }
            Files.copy(Paths.get(srcFilePath, new String[0]), Paths.get(destFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void readTrustedCertFromMigrationBackup() throws Exception {
        Path path = Paths.get(String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.SBR_MIG_DIR + "trusted_certs.txt", new String[0]);
        String trustedCertFileName2 = null;
        try {
            List<String> fileNames = Files.readAllLines(path);
            for (String trustedCertFileName2 : fileNames) {
                StoredCertificate[] existingTrustCerts;
                String am85EAPTrustedCert = "/opt/rsa/am/radius_sbr_backup/ROOT/" + trustedCertFileName2;
                this.logInfo("Reading the file " + am85EAPTrustedCert + " from the local file system.");
                byte[] rawFileContent = Files.readAllBytes(new File(am85EAPTrustedCert).toPath());
                byte[] fileContentInPemFormat = AMMigrateRadiusConfigurationFileAction.getBytesInPEMFormat(rawFileContent);
                this.logInfo("Converting the file to StoreCertificate DTO ");
                StoredCertificate storedCert = new StoredCertificate();
                storedCert.setPurpose(CertificatePurpose.RADIUS_TRUST_CERT);
                storedCert.setName(trustedCertFileName2);
                storedCert.setCertificateBytes(fileContentInPemFormat);
                this.logInfo("Storing the Certificate into database.");
                CertificateManager certManager = (CertificateManager)ComponentUtils.getBean(CertificateManager.class);
                Filter filter = Filter.equal((String)"PURPOSE", (String)"RADIUS_TRUST_CERT");
                StoredCertificate[] storedCertificateArray = existingTrustCerts = certManager.trustedSearch(filter);
                int n = existingTrustCerts.length;
                int n2 = 0;
                while (n2 < n) {
                    StoredCertificate cert = storedCertificateArray[n2];
                    if (cert.getName().equalsIgnoreCase(trustedCertFileName2)) {
                        storedCert.setGuid(cert.getGuid());
                        certManager.delete(cert.getGuid());
                    }
                    ++n2;
                }
                certManager.add(storedCert);
                this.configMigratedSuccessfully.add(trustedCertFileName2);
            }
        }
        catch (Exception e) {
            this.configMigratedWithErrors.add(trustedCertFileName2);
            throw e;
        }
    }

    private static byte[] getBytesInPEMFormat(byte[] fileData) throws InvalidArgumentException {
        try {
            X509Certificate certificate = AMMigrateRadiusConfigurationFileAction.bytesToCertificate(fileData);
            return AMMigrateRadiusConfigurationFileAction.convertCertToPem(certificate).getBytes();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new InvalidArgumentException("Exception while encoding certificate.", "CERT_ENCODING_FAILURE");
        }
    }

    public static X509Certificate bytesToCertificate(byte[] asBytes) throws InvalidArgumentException {
        CertificateFactory factory;
        try {
            factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new SystemException("X.509 certificate factory not found.");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(asBytes);
        try {
            return (X509Certificate)factory.generateCertificate(is);
        }
        catch (CertificateException certificateException) {
            throw new InvalidArgumentException("Exception while decoding certificate.", "CERT_ENCODING_FAILURE");
        }
    }

    private static String convertCertToPem(Certificate cert) throws CertificateEncodingException {
        return AMMigrateRadiusConfigurationFileAction.convertToPem(BEGIN_CERT, cert.getEncoded(), END_CERT);
    }

    private static String convertToPem(String beingFormat, byte[] rawData, String endFormat) throws CertificateEncodingException {
        Base64.Encoder encoder = Base64.getMimeEncoder(64, LINE_SEPARATOR.getBytes());
        String encodedCertText = new String(encoder.encode(rawData));
        String prettified_cert = String.valueOf(beingFormat) + LINE_SEPARATOR + encodedCertText + LINE_SEPARATOR + endFormat;
        return prettified_cert;
    }

    private void migrateSecurIDIniFileContents() throws Exception {
        String am85SecurIDIniFile = "/opt/rsa/am/radius_sbr_backup/securid.ini";
        String am86SecurIDIniFile = "/opt/rsa/am/radius/securid.ini";
        this.migrateSecurIDIniFileContents(am85SecurIDIniFile, am86SecurIDIniFile);
    }

    Map<String, String> migrateSecurIDIniFileContents(String am85SecurIDIniFile, String am86SecurIDIniFile) throws Exception {
        try {
            this.logInfo("Migrating SecurID InI file contents." + am85SecurIDIniFile + " To " + am86SecurIDIniFile);
            List<String> oldFileEntries = this.readFileContent(am85SecurIDIniFile);
            List<String> am86FileContents = this.readFileContent(am86SecurIDIniFile);
            Map<String, String> keyValuePairFromAM85 = this.readKeyValuePairFromINIFileContent(oldFileEntries);
            keyValuePairFromAM85 = this.specialTranslation(keyValuePairFromAM85);
            this.migrate85KeyValueTo86FileConent(am86FileContents, keyValuePairFromAM85);
            this.overWriteSecurIdFileEntries(am86SecurIDIniFile, am86FileContents);
            this.logInfo("Successfully completed the SecurID INI file contents migration.");
            this.configMigratedSuccessfully.add(SECURID_CONFIG_FILE);
            return this.readKeyValuePairFromINIFile(am86SecurIDIniFile);
        }
        catch (Exception e) {
            this.configMigratedWithErrors.add(SECURID_CONFIG_FILE);
            this.logSevere("Error while migrating the SecurID INI files." + e.getMessage(), e);
            return null;
        }
    }

    private Map<String, String> specialTranslation(Map<String, String> dataFrmAM85) {
        String valueOfInputMustChoose_S_S = dataFrmAM85.get("InputMustChoose_S_S");
        if (valueOfInputMustChoose_S_S == null || valueOfInputMustChoose_S_S.trim().length() == 0) {
            return dataFrmAM85;
        }
        String mod_S = "%s";
        String mod_D = "%d";
        String range_Mod_D_D = "%d to %d";
        String digitsPrefixAM86 = dataFrmAM85.get("Digits") == null ? "digits" : dataFrmAM85.get("Digits");
        String charsSuffixAM86 = dataFrmAM85.get("Characters") == null ? "alphanumeric characters" : dataFrmAM85.get("Characters");
        String value_D = valueOfInputMustChoose_S_S.replaceFirst(mod_S, mod_D).replaceFirst(mod_S, digitsPrefixAM86);
        String value_C = valueOfInputMustChoose_S_S.replaceFirst(mod_S, mod_D).replaceFirst(mod_S, charsSuffixAM86);
        String value_D_D = valueOfInputMustChoose_S_S.replaceFirst(mod_S, range_Mod_D_D).replaceFirst(mod_S, digitsPrefixAM86);
        String value_C_C = valueOfInputMustChoose_S_S.replaceFirst(mod_S, range_Mod_D_D).replaceFirst(mod_S, charsSuffixAM86);
        dataFrmAM85.put("ExtInputMustChoose_D", value_D);
        dataFrmAM85.put("ExtInputMustChoose_C", value_C);
        dataFrmAM85.put("ExtInputMustChoose_D_D", value_D_D);
        dataFrmAM85.put("ExtInputMustChoose_C_C", value_C_C);
        return dataFrmAM85;
    }

    private void overWriteSecurIdFileEntries(String filePath, List<String> newFileEntries) throws Exception {
        Path filePathObj = Paths.get(filePath, new String[0]);
        Files.write(filePathObj, newFileEntries, new OpenOption[0]);
    }

    private void migrate85KeyValueTo86FileConent(List<String> am86FileEntries, Map<String, String> am85KeyValuePair) {
        int i = 0;
        for (String fileLineEntry : am86FileEntries) {
            if (fileLineEntry.contains("=")) {
                String[] currentLineFromAM86WithKeyValuePair = fileLineEntry.split("=");
                String am86KeyFromCurrentLine = currentLineFromAM86WithKeyValuePair[0].trim();
                String am86ValueFromCurrentLine = currentLineFromAM86WithKeyValuePair[1].trim();
                if (am86KeyFromCurrentLine.startsWith(";")) {
                    am86KeyFromCurrentLine = am86KeyFromCurrentLine.substring(1, am86KeyFromCurrentLine.length());
                }
                String valueFromAM85 = null;
                if (am85KeyValuePair.containsKey(am86KeyFromCurrentLine)) {
                    valueFromAM85 = am85KeyValuePair.get(am86KeyFromCurrentLine);
                } else {
                    String keyWithouExtPart = this.getKeyExcludingExtPart(am86KeyFromCurrentLine);
                    this.logInfo("Keywithout ext part " + keyWithouExtPart);
                    if (am85KeyValuePair.containsKey(keyWithouExtPart)) {
                        valueFromAM85 = am85KeyValuePair.get(keyWithouExtPart);
                    }
                }
                if (valueFromAM85 != null) {
                    this.logInfo("Replacing " + am86ValueFromCurrentLine + " with " + valueFromAM85 + " for the key" + am86KeyFromCurrentLine);
                    fileLineEntry = fileLineEntry.replace(am86ValueFromCurrentLine, valueFromAM85);
                    fileLineEntry = fileLineEntry.replace(";" + am86KeyFromCurrentLine, am86KeyFromCurrentLine);
                    am86FileEntries.set(i, fileLineEntry);
                }
            }
            ++i;
        }
    }

    private String getKeyExcludingExtPart(String keyForCurrentLine) {
        return keyForCurrentLine.substring(3, keyForCurrentLine.length());
    }

    private Map<String, String> readKeyValuePairFromINIFile(String fileName) throws Exception {
        List<String> fileEntries = this.readFileContent(fileName);
        return this.readKeyValuePairFromINIFileContent(fileEntries);
    }

    private Map<String, String> readKeyValuePairFromINIFileContent(List<String> fileEntries) {
        HashMap<String, String> keyValuePair = new HashMap<String, String>();
        int promptCount = 0;
        for (String fileEntry : fileEntries) {
            String[] keyValuePairStr;
            if (fileEntry.startsWith(";")) continue;
            if (fileEntry.startsWith("[Prompts]")) {
                ++promptCount;
            }
            if (promptCount > 1 || (keyValuePairStr = fileEntry.split("=")).length != 2) continue;
            String key = keyValuePairStr[0].trim();
            String value = keyValuePairStr[1].trim();
            keyValuePair.putIfAbsent(key, value);
        }
        return keyValuePair;
    }

    private List<String> readFileContent(String filePath) throws Exception {
        return Files.readAllLines(new File(filePath).toPath());
    }

    private void updateMigrationResults() {
        RadiusMigrationUtility.getMigrateResultDTO().setConfigMigratedSuccessfully(this.configMigratedSuccessfully);
        RadiusMigrationUtility.getMigrateResultDTO().setConfigMigratedWithErrors(this.configMigratedWithErrors);
    }

    public void setArguments(Arguments arg) {
        this.arguments = (MigrateArguments)arg;
    }

    private void logInfo(String message) {
        migrationLogger.log(Level.INFO, message);
    }

    private void logSevere(String msg, Exception e) {
        migrationLogger.log(Level.SEVERE, msg, e);
    }
}

