/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.migrate;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationReportGenerator;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.admin.tools.arguments.MigrateArguments;
import com.rsa.tools.common.CLUException;
import com.rsa.tools.common.action.Arguments;
import com.rsa.tools.common.action.CLUExitCodes;
import com.rsa.tools.common.action.exception.CLUExitException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Properties;

public class AMMigrateResultsAction
extends OrderedRadiusMigrationAction {
    protected MigrateArguments arguments;

    public void execute() throws CLUException {
        try {
            this.writeMigrationResults();
            this.readAndUpdateMigrationLogsWithResults();
            this.generateReport();
        }
        catch (IOException e) {
            throw new CLUExitException(AMMigrateRadiusDataCLU.format("migration-results-failed", this.getPreMigrationPropertiesFileLocation()), (Throwable)e, CLUExitCodes.UNSPECIFIED_ERROR);
        }
        catch (Exception e) {
            throw new CLUExitException(AMMigrateRadiusDataCLU.format("migration-results-failed", this.getPreMigrationPropertiesFileLocation()), (Throwable)e, CLUExitCodes.UNSPECIFIED_ERROR);
        }
        if (!RadiusMigrationUtility.getMigrateResultDTO().isMigrationSuccess()) {
            throw new CLUExitException(AMMigrateRadiusDataCLU.format("migration-results-failed", this.getPreMigrationPropertiesFileLocation()), null, CLUExitCodes.UNSPECIFIED_ERROR);
        }
        this.migrationLogInfo(AMMigrateRadiusDataCLU.format("migration-results-success", new Object[0]));
        try {
            this.closeDAOLite();
        }
        catch (Exception exception) {}
    }

    public void setArguments(Arguments arg0) {
        this.arguments = (MigrateArguments)arg0;
    }

    private void closeDAOLite() {
        RadiusMigrationUtility.closeDAOLite();
    }

    private void writeMigrationResults() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileOutputStream output = new FileOutputStream(this.getPreMigrationPropertiesFileLocation(), true);){
                Properties prop = new Properties();
                prop.setProperty("migration.results", String.valueOf(RadiusMigrationUtility.getMigrateResultDTO().isMigrationSuccess()));
                prop.setProperty("migration.dictionary.migrated.success", String.valueOf(RadiusMigrationUtility.getMigrateResultDTO().isDictionaryFilesMigrated()));
                prop.setProperty("migration.clients.migrated.success", String.valueOf(RadiusMigrationUtility.getMigrateResultDTO().isClientsMigrated()));
                prop.setProperty("migration.profiles.migrated.success", String.valueOf(RadiusMigrationUtility.getMigrateResultDTO().isProfilesMigrated()));
                prop.setProperty("migration.client.total.success", String.valueOf(RadiusMigrationUtility.getMigrateResultDTO().getTotalNumberOfClientsSuceess()));
                prop.setProperty("migration.client.total.failed", String.valueOf(RadiusMigrationUtility.getMigrateResultDTO().getTotalNumberOfClientsFailed()));
                prop.setProperty("migration.client.failed", String.join((CharSequence)",", RadiusMigrationUtility.getMigrateResultDTO().getClientsFailedToMigrate()));
                prop.setProperty("migration.profiles.total.success", String.valueOf(RadiusMigrationUtility.getMigrateResultDTO().getTotalNumberOfProfilesSuccess()));
                prop.setProperty("migration.profiles.total.failed", String.valueOf(RadiusMigrationUtility.getMigrateResultDTO().getTotalNumberOfProfilesFailed()));
                prop.setProperty("migration.profiles.failed", String.join((CharSequence)",", RadiusMigrationUtility.getMigrateResultDTO().getProfilesFailedToMigrate()));
                prop.setProperty("migration.configuration.success", String.join((CharSequence)",", RadiusMigrationUtility.getMigrateResultDTO().getConfigMigratedSuccessfully()));
                prop.setProperty("migration.configuration.errors", String.join((CharSequence)",", RadiusMigrationUtility.getMigrateResultDTO().getConfigMigratedWithErrors()));
                prop.setProperty("migration.status", String.valueOf((Object)RadiusMigrationUtility.getMigrateResultDTO().getMigrationStatus()));
                prop.setProperty("migration.conflict.attributename.change", String.valueOf(RadiusMigrationUtility.getMigrateResultDTO().getUsedAttributeNameChanged()));
                prop.store(output, "Migration Result");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            this.migrationLogError(AMMigrateRadiusDataCLU.format("migration-results-failed", this.getPreMigrationPropertiesFileLocation()), ioe);
            throw ioe;
        }
    }

    private void readAndUpdateMigrationLogsWithResults() throws IOException {
        List<String> migrationProperties = Files.readAllLines(Paths.get(this.getPreMigrationPropertiesFileLocation(), new String[0]), StandardCharsets.ISO_8859_1);
        this.migrationLogInfo("****Migration properties results*****");
        for (String line : migrationProperties) {
            this.writeToFile(line);
        }
        this.migrationLogInfo("****The Radius migration result summary can be view in the: " + this.getPreMigrationPropertiesFileLocation() + "*****");
        this.migrationLogInfo("****The Radius migration log location: " + this.getMigrationLogFileLocation() + "*****");
    }

    private void writeToFile(String line) {
        try {
            Files.write(Paths.get(String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + "radius-migration.log", new String[0]), (String.valueOf(line) + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateReport() throws Exception {
        this.migrationLogInfo("=========Start: Report Generation============");
        RadiusMigrationReportGenerator rmrg = new RadiusMigrationReportGenerator();
        rmrg.setTabTitle(AMMigrateRadiusDataCLU.format("report.title", new Object[0]));
        rmrg.setReportTitle(AMMigrateRadiusDataCLU.format("report.title", new Object[0]));
        rmrg.setReportDescription(AMMigrateRadiusDataCLU.format("report.description", new Object[0]));
        try {
            rmrg.generateHTMLReport(rmrg.generateRadiusMigrationReport());
            rmrg.saveReport();
            this.migrationLogInfo("**************************************************************************************************************");
            this.migrationLogInfo(AMMigrateRadiusDataCLU.format("report.location", AMRadiusMigrationConstants.MIG_REPORT_DIRECTORY));
            this.migrationLogInfo("**************************************************************************************************************");
        }
        catch (Exception e) {
            this.migrationLogError(AMMigrateRadiusDataCLU.format("premigration-results-failed", this.getPreMigrationPropertiesFileLocation()), e);
            throw e;
        }
        this.migrationLogInfo("=========End: Report Generation============");
    }

    private String getPreMigrationPropertiesFileLocation() {
        return String.valueOf(AMRadiusMigrationConstants.PREMIG_RESULT_PROPERTIES_FILE_PATH) + "radius_migration.properties";
    }

    private String getMigrationLogFileLocation() {
        return String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + "radius-migration.log";
    }
}

