/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.premigrate;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationReportGenerator;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.data.RadiusClientDTO;
import com.rsa.authmgr.admin.radius.data.converter.RadiusConverters;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.admin.tools.arguments.PreMigrateArguments;
import com.rsa.authmgr.internal.admin.radius.dal.RadiusClientHBM;
import com.rsa.authmgr.internal.admin.radius.dal.RadiusServerHBM;
import com.rsa.authmgr.internal.radius.jaxb.radiusclient.RadiusClients;
import com.rsa.authmgr.internal.radius.sbr.xui.impl.XUIConnectionManagerImpl;
import com.rsa.common.DataNotFoundException;
import com.rsa.common.GUID;
import com.rsa.common.SystemException;
import com.rsa.ims.admin.SecurityDomain;
import com.rsa.tools.common.CLUException;
import com.rsa.tools.common.action.Arguments;
import com.rsa.tools.common.action.CLUExitCodes;
import com.rsa.tools.common.action.exception.CLUExitException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AMMigrateSyncRadiusDataAction
extends OrderedRadiusMigrationAction {
    protected PreMigrateArguments arguments;
    GUID topLevelSystemDomain = null;

    public void execute() throws CLUException {
        this.migrationLogInfo("======Start: Synchronization of clients and profiles=========");
        RadiusMigrationUtility migUtility = new RadiusMigrationUtility();
        try {
            if (!RadiusMigrationUtility.isPrimary()) {
                this.migrationLogInfo(AMMigrateRadiusDataCLU.format("retrieve-instance-type", ": Not Primary Instance for synchronization of clients and profiles"));
                return;
            }
        }
        catch (Exception e1) {
            this.installInfo(AMMigrateRadiusDataCLU.format("retrieve-instance-type-failed", new Object[0]), e1);
            this.setPremigrationFailureResult();
            this.migrationLogInfo("======Failure: Synchronization of clients and profiles=========" + e1.getLocalizedMessage());
        }
        Collection<SecurityDomain> realms = migUtility.getTopLevelSecurityDomain();
        try {
            if (realms == null || realms.isEmpty()) {
                this.migrationLogInfo("======Failure: Synchronization of clients and profiles=========Security Domain not found");
                this.setPremigrationFailureResult();
                throw new DataNotFoundException(AMMigrateRadiusDataCLU.format("synchronization-failed", new Object[0]), "Security Domain not found");
            }
            for (SecurityDomain realm : realms) {
                if (!realm.getName().equals("SystemDomain")) continue;
                this.topLevelSystemDomain = realm.getKey();
                break;
            }
            List<RadiusServerHBM> radSrvs = null;
            try {
                radSrvs = migUtility.getAllPrimaryRADIUSSrv();
            }
            catch (Exception anyExp) {
                this.migrationLogError(AMMigrateRadiusDataCLU.format("synchronization-failed", new Object[0]), anyExp);
                this.setPremigrationFailureResult();
                this.migrationLogInfo("=========Failure: Synchronization of clients and profiles: retrieve server============" + anyExp.getMessage());
                throw new CLUExitException(AMMigrateRadiusDataCLU.format("synchronization-failed", new Object[0]), (Throwable)anyExp, CLUExitCodes.DATA_NOT_FOUND);
            }
            int iNeedSynchCount = 0;
            for (RadiusServerHBM radSrv : radSrvs) {
                XUIConnectionManagerImpl xuiConnMgr = migUtility.getXuiConnMgr();
                String l_respXML = null;
                try {
                    l_respXML = xuiConnMgr.getDirectServerAccess(radSrv.getId()).read("/radiusClients/");
                }
                catch (Exception anyExp) {
                    this.migrationLogError(AMMigrateRadiusDataCLU.format("synchronization-failed", new Object[0]), anyExp);
                    this.setPremigrationFailureResult();
                    this.migrationLogInfo("=========Failure: Synchronization of clients and profile: retrieve client from SBR============" + anyExp.getMessage());
                    throw new CLUExitException(AMMigrateRadiusDataCLU.format("synchronization-failed", new Object[0]), (Throwable)anyExp, CLUExitCodes.DATA_NOT_FOUND);
                }
                if (StringUtils.isBlank((String)l_respXML)) continue;
                int xuiRadiusClientList = RadiusConverters.getRadiusClients((RadiusClients)migUtility.convertFromXML(l_respXML)).size();
                int amRadiusClientList = migUtility.getRadClientAdmin().getRadiusClients(this.topLevelSystemDomain).size();
                iNeedSynchCount = xuiRadiusClientList - amRadiusClientList;
                migUtility.getRadClientAdmin().synchronizeRadiusClients(this.topLevelSystemDomain, false);
            }
            migUtility.getRadProfileAdmin().synchronizeRadiusProfiles(this.topLevelSystemDomain, false);
            RadiusMigrationUtility.getPremigrateResultDTO().setSBRSynchronised(true);
            List<RadiusClientHBM> missingClientsInSBR = migUtility.getRadClientAdmin().getMissingClientsinSBR();
            List<RadiusClientDTO> missingClientsInAM = migUtility.getRadClientAdmin().getMissingClientsinAM();
            RadiusMigrationReportGenerator reportGenerator = new RadiusMigrationReportGenerator();
            if (missingClientsInSBR != null && !missingClientsInSBR.isEmpty()) {
                RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.WARNING);
                reportGenerator.generateMissingClientsReport(missingClientsInSBR);
                iNeedSynchCount += missingClientsInSBR.size();
            }
            if (iNeedSynchCount > 0) {
                this.setPremigrationFailureResult();
                this.migrationLogError("The number of RADIUS clients that need to be synched from SBR to AM database is:  " + iNeedSynchCount, (Throwable)new SystemException("Failed to synch RADIUS client from SBR to AM database "));
            }
            if (missingClientsInAM != null && !missingClientsInAM.isEmpty()) {
                this.setPremigrationFailureResult();
                reportGenerator.generateMissingClientsInAMReport(missingClientsInAM);
            }
            this.migrationLogInfo("======Completed: Synchronization of clients and profiles=========");
            this.installInfo(AMMigrateRadiusDataCLU.format("synchronization-success", new Object[0]));
        }
        catch (Exception e) {
            this.setPremigrationFailureResult();
            this.installInfo(AMMigrateRadiusDataCLU.format("synchronization-failed", new Object[0]), e);
            this.migrationLogInfo("======Failure: Synchronization of clients and profiles=========" + e.getLocalizedMessage());
        }
    }

    public void setArguments(Arguments arg0) {
        this.arguments = (PreMigrateArguments)arg0;
    }

    private void setPremigrationFailureResult() {
        RadiusMigrationUtility.getPremigrateResultDTO().setSBRSynchronised(false);
        RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
        RadiusMigrationUtility.getPremigrateResultDTO().setDictionaryConv(false);
        RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
    }
}

