/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.premigrate;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.data.RadiusAttributeDTO;
import com.rsa.authmgr.admin.radius.data.RadiusProfileAttrDTO;
import com.rsa.authmgr.admin.radius.data.RadiusProfileDTO;
import com.rsa.authmgr.admin.radius.data.converter.RadiusProfileConverter;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.admin.tools.arguments.PreMigrateArguments;
import com.rsa.authmgr.internal.admin.radius.RadiusProfileAdministration;
import com.rsa.authmgr.internal.admin.radius.dal.RadiusServerHBM;
import com.rsa.authmgr.internal.radius.jaxb.profiles.Attribute;
import com.rsa.authmgr.internal.radius.jaxb.profiles.AuthenticationProfile;
import com.rsa.authmgr.internal.radius.jaxb.profiles.AuthenticationProfiles;
import com.rsa.authmgr.internal.radius.sbr.xui.impl.XUIConnectionManagerImpl;
import com.rsa.common.InvalidArgumentException;
import com.rsa.tools.common.action.Arguments;
import com.rsa.tools.common.action.CLUExitCodes;
import com.rsa.tools.common.action.exception.CLUExitException;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;

public class AMPreMigrateAttributeAction
extends OrderedRadiusMigrationAction {
    protected PreMigrateArguments arguments;
    private static final String USER_NAME_CHECK_LIST_ATTRIBUTE = "User-Name";
    RadiusMigrationUtility migUtility = new RadiusMigrationUtility();

    public void execute() throws CLUExitException {
        this.migrationLogInfo("=========Start: Check profile attributes============");
        List<RadiusServerHBM> radSrvs = null;
        try {
            radSrvs = this.migUtility.getAllPrimaryRADIUSSrv();
        }
        catch (Exception anyExp) {
            this.migrationLogError(AMMigrateRadiusDataCLU.format("profile-attributes-migration-error", new Object[0]), anyExp);
            this.setPremigrationFailureResult();
            this.migrationLogInfo("=========Failure: Compare profile attribute: retrieve server============" + anyExp.getMessage());
            throw new CLUExitException(AMMigrateRadiusDataCLU.format("profile-attributes-migration-error", new Object[0]), (Throwable)anyExp, CLUExitCodes.DATA_NOT_FOUND);
        }
        for (RadiusServerHBM radSrv : radSrvs) {
            XUIConnectionManagerImpl xuiConnMgr = this.migUtility.getXuiConnMgr();
            String l_respXML = null;
            try {
                l_respXML = xuiConnMgr.getDirectServerAccess(radSrv.getId()).read("/authenticationProfiles/");
            }
            catch (Exception anyExp) {
                this.migrationLogError(AMMigrateRadiusDataCLU.format("profile-attributes-migration-error", new Object[0]), anyExp);
                this.setPremigrationFailureResult();
                this.migrationLogInfo("=========Failure: Compare profile attribute: retrieve profile from SBR============" + anyExp.getMessage());
                throw new CLUExitException(AMMigrateRadiusDataCLU.format("profile-attributes-migration-error", new Object[0]), (Throwable)anyExp, CLUExitCodes.DATA_NOT_FOUND);
            }
            if (StringUtils.isBlank((String)l_respXML)) continue;
            List radiusProfileList = RadiusProfileConverter.getRadiusProfilesDTO((AuthenticationProfiles)this.migUtility.convertRadiusProfileFromXML(l_respXML));
            Map<Object, Object> radReturnListAttrMap = null;
            Map<Object, Object> radCheckListAttrMap = null;
            try {
                List<RadiusAttributeDTO> checkAttrList = new ArrayList();
                checkAttrList = this.getRadiusProfile().getCheckListAttributes(this.migUtility.getTopLevelSD());
                if (checkAttrList != null) {
                    radCheckListAttrMap = new HashMap(checkAttrList.size());
                    radCheckListAttrMap = this.convertToHashMap(checkAttrList);
                }
                List<RadiusAttributeDTO> returnAttrList = new ArrayList();
                returnAttrList = this.getRadiusProfile().getReturnListAttributes(this.migUtility.getTopLevelSD());
                if (returnAttrList != null) {
                    radReturnListAttrMap = new HashMap(returnAttrList.size());
                    radReturnListAttrMap = this.convertToHashMap(returnAttrList);
                }
            }
            catch (Exception e1) {
                this.migrationLogError(AMMigrateRadiusDataCLU.format("profile-attributes-migration-error", new Object[0]), e1);
                this.setPremigrationFailureResult();
                this.migrationLogInfo("=========Failure: compare profile attribute============" + e1.getMessage());
                throw new CLUExitException(AMMigrateRadiusDataCLU.format("profile-attributes-migration-error", new Object[0]), (Throwable)e1, CLUExitCodes.REQUIRED_ARGUMENT_MISSING_ERROR);
            }
            for (RadiusProfileDTO full_dto : radiusProfileList) {
                List returnList = full_dto.getReturnLists();
                if (radReturnListAttrMap != null && returnList != null) {
                    for (RadiusProfileAttrDTO attrUnderValidation : returnList) {
                        RadiusAttributeDTO attrDef = (RadiusAttributeDTO)radReturnListAttrMap.get(attrUnderValidation.getName());
                        if (attrDef != null) continue;
                        this.migrationLogError(String.valueOf(AMMigrateRadiusDataCLU.format("profile-attributes-migration-failed", new Object[0])) + attrUnderValidation.getName() + " for profile: " + full_dto.getName(), new InvalidArgumentException("Unknown RADIUS profile attribute: " + attrUnderValidation.getName(), "UNKNOWN_RADIUS_PROFILE_ATTR", new Object[]{attrUnderValidation.getName()}));
                        RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
                        RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
                        this.setPremigrationFailureResult();
                        this.migrationLogInfo("=========Failure: compare profile return attribute============");
                    }
                }
                List checkList = full_dto.getCheckLists();
                if (radCheckListAttrMap == null || checkList == null) continue;
                for (RadiusProfileAttrDTO attrUnderValidation : checkList) {
                    RadiusAttributeDTO attrDef = (RadiusAttributeDTO)radCheckListAttrMap.get(attrUnderValidation.getName());
                    if (attrDef != null) continue;
                    this.migrationLogError(String.valueOf(AMMigrateRadiusDataCLU.format("profile-attributes-migration-failed", new Object[0])) + attrUnderValidation.getName() + " for profile: " + full_dto.getName(), new InvalidArgumentException("Unknown RADIUS profile attribute: " + attrUnderValidation.getName(), "UNKNOWN_RADIUS_PROFILE_ATTR", new Object[]{attrUnderValidation.getName()}));
                    RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
                    RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
                    this.setPremigrationFailureResult();
                    this.migrationLogInfo("=========Failure: compare profile check attribute list============");
                }
            }
        }
        try {
            this.validateRadiusProfileAttributes();
        }
        catch (JAXBException e) {
            RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
            RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
            this.migrationLogError("=========Failure: Exception Occured while validating the ProfileAttributes ============", e);
        }
        this.migrationLogInfo("======Completed: Check profile attributes=========");
    }

    public void setArguments(Arguments arguments) {
        this.arguments = (PreMigrateArguments)arguments;
    }

    private Map<String, RadiusAttributeDTO> convertToHashMap(List<RadiusAttributeDTO> p_dtos) {
        HashMap<String, RadiusAttributeDTO> map = null;
        if (p_dtos != null && !p_dtos.isEmpty()) {
            map = new HashMap<String, RadiusAttributeDTO>(p_dtos.size());
            for (RadiusAttributeDTO dto : p_dtos) {
                map.put(dto.getId(), dto);
            }
        }
        return map;
    }

    private void setPremigrationFailureResult() {
        RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
        RadiusMigrationUtility.getPremigrateResultDTO().setDictionaryConv(false);
        RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
    }

    private RadiusProfileAdministration getRadiusProfile() {
        return this.migUtility.getRadProfileAdmin();
    }

    private void validateRadiusProfileAttributes() throws JAXBException {
        AuthenticationProfiles profiles = this.getRadiusProfiles();
        if (profiles != null) {
            List list = profiles.getAuthenticationProfile();
            for (AuthenticationProfile profile : list) {
                List listAtr = profile.getCheckListAttributes().getAttribute();
                if (listAtr == null) continue;
                boolean islogMsgFal = true;
                for (Attribute atrObj : listAtr) {
                    if (!atrObj.getName().equals(USER_NAME_CHECK_LIST_ATTRIBUTE)) continue;
                    if (islogMsgFal) {
                        this.migrationLogInfo("Apply 8.6Patch4 to fix the blow Radius profile with User-Name attributes in the checklist.");
                    }
                    this.migrationLogWarn("Radius Profile " + profile.getId() + " has User-Name as a checklist attribute.");
                }
            }
        }
    }

    private AuthenticationProfiles getRadiusProfiles() throws JAXBException {
        Path path = Paths.get(String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.SBR_MIG_DIR, new String[0]);
        File realmRadSrvExpLoc = new File(path.toAbsolutePath().toString());
        JAXBContext m_jaxbContext = JAXBContext.newInstance((String)"com.rsa.authmgr.internal.radius.jaxb.profiles");
        AuthenticationProfiles profiles = (AuthenticationProfiles)RadiusMigrationUtility.convertXMLFileToObject(new File(realmRadSrvExpLoc, "radiusProfiles.xml"), "RADIUS clients", m_jaxbContext);
        return profiles;
    }
}

