/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.premigrate;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.admin.tools.arguments.PreMigrateArguments;
import com.rsa.tools.common.CLUException;
import com.rsa.tools.common.action.Arguments;
import com.rsa.tools.common.action.CLUExitCodes;
import com.rsa.tools.common.action.exception.CLUExitException;

public class AMPreMigrateClientAction
extends OrderedRadiusMigrationAction {
    protected PreMigrateArguments arguments;

    public void execute() throws CLUException {
        this.migrationLogInfo("=========Start: Export of Clients and Profiles============");
        try {
            if (!RadiusMigrationUtility.isPrimary()) {
                this.migrationLogInfo(AMMigrateRadiusDataCLU.format("retrieve-instance-type", ": Not Primary Instance"));
                this.setPremigrationSuccessResult();
                return;
            }
        }
        catch (Exception e1) {
            this.setPremigrationFailureResult();
            this.migrationLogError(AMMigrateRadiusDataCLU.format("retrieve-instance-type-failed", new Object[0]), e1);
            this.migrationLogInfo("======Failed: Export of Clients and Profiles============" + e1.getLocalizedMessage());
            throw new CLUExitException(AMMigrateRadiusDataCLU.format("retrieve-instance-type-failed", e1.getMessage()), (Throwable)e1, CLUExitCodes.UNSPECIFIED_ERROR);
        }
        try {
            if (!RadiusMigrationUtility.getPremigrateResultDTO().isDictionaryConv() && RadiusMigrationUtility.getPremigrateResultDTO().getTotalNumOfVendorsToBeMigrated() == 0) {
                this.skipResult();
                this.migrationLogInfo("=========Skip: No vendors present to be migrated============");
                return;
            }
            RadiusMigrationUtility migUtility = new RadiusMigrationUtility();
            migUtility.exportRADIUSData(null);
            this.setPremigrationSuccessResult();
            this.migrationLogInfo("Successfully exported the clients and profile data");
        }
        catch (Exception e) {
            this.setPremigrationFailureResult();
            this.migrationLogInfo("=========Failed: Export of Clients and Profiles============" + e.getMessage());
        }
        this.migrationLogInfo("=========Completed: Exported Clients and Profiles============");
    }

    public void setArguments(Arguments arg0) {
        this.arguments = (PreMigrateArguments)arg0;
    }

    private void setPremigrationSuccessResult() {
        RadiusMigrationUtility.getPremigrateResultDTO().setClientsExported(true);
        RadiusMigrationUtility.getPremigrateResultDTO().setClientsFound(true);
        RadiusMigrationUtility.getPremigrateResultDTO().setProfilesExported(true);
    }

    private void setPremigrationFailureResult() {
        RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
        RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
        this.skipResult();
    }

    private void skipResult() {
        RadiusMigrationUtility.getPremigrateResultDTO().setClientsExported(false);
        RadiusMigrationUtility.getPremigrateResultDTO().setClientsFound(false);
        RadiusMigrationUtility.getPremigrateResultDTO().setProfilesExported(false);
    }
}

