/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.premigrate;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationReportGenerator;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.migration.validator.RadiusValidators;
import com.rsa.authmgr.admin.radius.data.RadiusClientDTO;
import com.rsa.authmgr.admin.radius.data.converter.RadiusConverters;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.internal.radius.jaxb.radiusclient.RadiusClient;
import com.rsa.authmgr.internal.radius.jaxb.radiusclient.RadiusClients;
import com.rsa.common.InvalidArgumentException;
import com.rsa.tools.common.CLUException;
import com.rsa.tools.common.action.Arguments;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class AMPreMigrateClientValidationAction
extends OrderedRadiusMigrationAction {
    private static final Character WHITE_SPACE = Character.valueOf(' ');
    private static final String SHARED_SECRET_SPECIAL_CHARACTER_VALIDATION = "Shared.Secret.Specialcharacter.Validation";
    private static final String PREMIGRATION_PROPERTIES = "premigration.properties";
    private static final String USER_DIR = "user.dir";
    private static final String RESOLUTION_NO_1 = "Resolution No 1";
    private static final String RESOLUTION_NO_2 = "Resolution No 2";
    private static final String RESOLUTION_NO_3 = "Resolution No 3";
    private static final String ALTERNATE_IP = "Alternate IP";
    private static final String PRIMARY_IP = "Primary IP";
    private static final String COMMA_SEPERATOR = ",";
    private static final String SINGLE_CODE = "'";
    private static final String INVALID_SHARED_SECRET = "invalidSharedSecret";
    private static final String INVALID_IP_ADDRESS = "invalidIPAddress";
    private static final String INVALID_CLIENT_NAME = "invalidClientName";
    private static final String SAME_HOST_CLIENT_IP = "sameIPasRadiusClientAndHost";

    public void execute() throws CLUException {
        block30: {
            this.migrationLogInfo("****Start Validating Radius Client*****");
            Connection dbConnection = null;
            try {
                try {
                    String radiusSubDomainAgentsSQL;
                    Map<String, String> subdominAgentMap;
                    dbConnection = RadiusMigrationUtility.getDBConnection();
                    String radiusClientSql = "select radclient.ip_address, name  from rsa_rep.am_host hosttab, rsa_rep.am_radius_clients radclient where lower(hosttab.name) in ( select lower(client_name) from rsa_rep.am_radius_clients where ip_address in ( select amhost.primary_ip from rsa_rep.am_agent agent, rsa_rep.am_host amhost\twhere amhost.id=agent.host_id and agent.client_type!=4 union all select alt.ip_addr from rsa_rep.am_agent_alternate alt)) and\tlower(radclient.client_name)= lower(hosttab.name)";
                    Map<String, String> duplicateRadiusClientIP = RadiusMigrationUtility.getOutptMap(radiusClientSql, dbConnection);
                    String radiusClientAlternateIPSQL = "SELECT rc.ip_address,rc.client_name FROM rsa_rep.am_radius_clients rc,  rsa_rep.am_agent_alternate agentAltr where rc.ip_address = agentAltr.ip_addr";
                    Map<String, String> duplicateAlterRadiusClientIP = RadiusMigrationUtility.getOutptMap(radiusClientAlternateIPSQL, dbConnection);
                    Map<String, List<RadiusClient>> radiusClientValidationMap = null;
                    if (!duplicateAlterRadiusClientIP.isEmpty()) {
                        Set<String> keySet = duplicateAlterRadiusClientIP.keySet();
                        for (String ipAddress : keySet) {
                            if (duplicateRadiusClientIP.containsKey(ipAddress)) continue;
                            duplicateRadiusClientIP.put(ipAddress, duplicateAlterRadiusClientIP.get(ipAddress));
                        }
                    }
                    this.migrationLogInfo("========= No# of Radius Client IP With Incorrect IP===========" + duplicateRadiusClientIP.size());
                    RadiusMigrationReportGenerator report = new RadiusMigrationReportGenerator();
                    if (!duplicateRadiusClientIP.isEmpty()) {
                        HashMap<String, List<String>> ipTypeResolutionMap = new HashMap<String, List<String>>();
                        String ipAddresses = this.getQueryInput(duplicateRadiusClientIP.keySet());
                        String agentPrimaryIPsql = "select host.primary_ip ,host.name as agent_name from rsa_rep.am_host host,rsa_rep.am_agent agent where agent.host_id=host.id and agent.client_type!=4 and host.primary_ip in (" + ipAddresses + ")";
                        String altenateAgentIPsql = "select alt.ip_addr, host.name as agent_name  from rsa_rep.am_host host,rsa_rep.am_agent agent,rsa_rep.am_agent_alternate alt where agent.host_id=host.id and  agent.client_type!=4 and alt.agent_id=agent.id and alt.ip_addr in(" + ipAddresses + ")";
                        String altenateRadiusIPsql = "select alt.ip_addr, host.name as agent_name  from rsa_rep.am_host host,rsa_rep.am_agent agent,rsa_rep.am_agent_alternate alt where agent.host_id=host.id and  agent.client_type=4 and alt.agent_id=agent.id and alt.ip_addr in(" + ipAddresses + ")";
                        Map<String, String> agentIPNameMap = RadiusMigrationUtility.getOutptMap(agentPrimaryIPsql, dbConnection);
                        this.setIPTypeMap(agentIPNameMap.keySet(), ipTypeResolutionMap, PRIMARY_IP, RESOLUTION_NO_1);
                        Map<String, String> alternateAgentIPMap = RadiusMigrationUtility.getOutptMap(altenateAgentIPsql, dbConnection);
                        this.setIPTypeMap(alternateAgentIPMap.keySet(), ipTypeResolutionMap, ALTERNATE_IP, RESOLUTION_NO_2);
                        agentIPNameMap.putAll(alternateAgentIPMap);
                        Map<String, String> alternateRadiusIPMap = RadiusMigrationUtility.getOutptMap(altenateRadiusIPsql, dbConnection);
                        this.setIPTypeMap(alternateRadiusIPMap.keySet(), ipTypeResolutionMap, ALTERNATE_IP, RESOLUTION_NO_3);
                        report.generateIPConfigReport(duplicateRadiusClientIP, agentIPNameMap, alternateRadiusIPMap, ipTypeResolutionMap);
                    } else {
                        report.generateIPConfigReport(duplicateRadiusClientIP, null, null, null);
                    }
                    RadiusClients radiusClients = this.getRadiusClients();
                    if (radiusClients != null) {
                        List<RadiusClient> clientWithHostIP;
                        List<RadiusClient> clientsWithInvalidIP;
                        List<RadiusClient> radClientNameList;
                        String hostIPSQL = "SELECT primary_ip,name FROM rsa_rep.am_host where is_server=true";
                        Map<String, String> hostIPMap = RadiusMigrationUtility.getOutptMap(hostIPSQL, dbConnection);
                        radiusClientValidationMap = this.getValidatedRadiusClients(radiusClients.getRadiusClient(), hostIPMap);
                        List<RadiusClient> radClientInvalidSecret = radiusClientValidationMap.get(INVALID_SHARED_SECRET);
                        if (!radClientInvalidSecret.isEmpty()) {
                            if (!RadiusMigrationUtility.getPremigrateResultDTO().getPremigrationStatus().equals((Object)AMRadiusMigrationConstants.Status.FAILED)) {
                                RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.WARNING);
                            }
                            report.generateInvalidSecretReport(radClientInvalidSecret);
                        }
                        if (!(radClientNameList = radiusClientValidationMap.get(INVALID_CLIENT_NAME)).isEmpty()) {
                            RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
                            RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
                            this.migrationLogError("Radius Client With Invalid Name", new InvalidArgumentException("Invalid Radius Client Name", "Invalid Name"));
                            this.migrationLogInfo("Number of invalid Radius Client Names : " + radClientNameList.size());
                            for (RadiusClient obj : radClientNameList) {
                                this.migrationLogInfo("Invalid Radius Client Name : " + obj.getId());
                            }
                        }
                        if (!(clientsWithInvalidIP = radiusClientValidationMap.get(INVALID_IP_ADDRESS)).isEmpty()) {
                            RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
                            RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
                            this.migrationLogError("Radius client with Invalid IP Address", new InvalidArgumentException("Invalid Radius Client IP Address", "Invalid IP Address"));
                            this.migrationLogInfo("Number of Radius Client with Invalid IP Address : " + clientsWithInvalidIP.size());
                            for (RadiusClient obj : clientsWithInvalidIP) {
                                this.migrationLogInfo("Invalid Radius Client IP in Radius Client Name : " + obj.getId());
                            }
                        }
                        if (!(clientWithHostIP = radiusClientValidationMap.get(SAME_HOST_CLIENT_IP)).isEmpty()) {
                            RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
                            RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
                            this.migrationLogError("Radius client IP Address same as Host IP Address", new InvalidArgumentException("Invalid Radius Client IP Address same as Host IP Address", "Invalid IP Address"));
                            this.migrationLogInfo("Number of Radius Clients with the Same Host IP Address: " + clientWithHostIP.size());
                            for (RadiusClient obj : clientWithHostIP) {
                                this.migrationLogInfo("Radius Client IP is same as the Host IP in Radius Client Name: " + obj.getId());
                            }
                        }
                    }
                    if (!(subdominAgentMap = RadiusMigrationUtility.getOutptMap(radiusSubDomainAgentsSQL = "SELECT h.name, h.primary_ip FROM rsa_rep.am_agent a, am_host h where h.id = a.host_id AND h.primary_ip in(SELECT ip_address FROM rsa_rep.am_radius_clients)and a.owner_id NOT IN (SELECT d.id FROM rsa_rep.ims_security_domain d where name='SystemDomain')", dbConnection)).isEmpty()) {
                        Set<String> agentKey = subdominAgentMap.keySet();
                        this.migrationLogWarn("Radius Client Associated Agent with Sub Domain.");
                        this.migrationLogInfo("To fix the below subdomain issue, apply 8.6Patch4");
                        for (String agentName : agentKey) {
                            this.migrationLogInfo("Radius Client Associated Agent with Sub Domain: " + agentName);
                        }
                        if (!RadiusMigrationUtility.getPremigrateResultDTO().getPremigrationStatus().equals((Object)AMRadiusMigrationConstants.Status.FAILED)) {
                            RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.WARNING);
                        }
                    }
                }
                catch (Exception e) {
                    RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
                    RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
                    this.migrationLogError("=========Failure: Premigration Radius Client Validation============", e);
                    if (dbConnection != null) {
                        try {
                            dbConnection.close();
                        }
                        catch (SQLException e2) {
                            this.migrationLogInfo("=========Failed to Close DB Connection: Premigration Radius Client IP Validation============" + e2.getLocalizedMessage());
                        }
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (dbConnection != null) {
                    try {
                        dbConnection.close();
                    }
                    catch (SQLException e) {
                        this.migrationLogInfo("=========Failed to Close DB Connection: Premigration Radius Client IP Validation============" + e.getLocalizedMessage());
                    }
                }
                throw throwable;
            }
            if (dbConnection != null) {
                try {
                    dbConnection.close();
                }
                catch (SQLException e) {
                    this.migrationLogInfo("=========Failed to Close DB Connection: Premigration Radius Client IP Validation============" + e.getLocalizedMessage());
                }
            }
        }
        this.migrationLogInfo("****Radius Client Validation Done*****");
    }

    private void setIPTypeMap(Set<String> keySet, Map<String, List<String>> ipTypeResolutionMap, String pimaryIpType, String resolutionValue) {
        for (String value : keySet) {
            ArrayList<String> obj = new ArrayList<String>();
            obj.add(pimaryIpType);
            obj.add(resolutionValue);
            ipTypeResolutionMap.put(value, obj);
        }
    }

    public void setArguments(Arguments arg0) {
    }

    private String getQueryInput(Set<String> set) {
        StringBuilder bulder = new StringBuilder();
        for (String value : set) {
            if (bulder.length() == 0) {
                bulder.append(SINGLE_CODE + value + SINGLE_CODE);
                continue;
            }
            bulder.append(COMMA_SEPERATOR).append(SINGLE_CODE + value + SINGLE_CODE);
        }
        return bulder.toString();
    }

    private String getPreMigrationPropertiesFileLocation() {
        return String.valueOf(AMRadiusMigrationConstants.PREMIG_RESULT_PROPERTIES_FILE_PATH) + "radius_migration.properties";
    }

    private RadiusClients getRadiusClients() throws JAXBException {
        Path path = Paths.get(String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + AMRadiusMigrationConstants.SBR_MIG_DIR, new String[0]);
        File realmRadSrvExpLoc = new File(path.toAbsolutePath().toString());
        JAXBContext m_jaxbContext = JAXBContext.newInstance((String)"com.rsa.authmgr.internal.radius.jaxb.radiusclient");
        RadiusClients clientData = (RadiusClients)RadiusMigrationUtility.convertXMLFileToObject(new File(realmRadSrvExpLoc, "radiusClients.xml"), "RADIUS clients", m_jaxbContext);
        return clientData;
    }

    private Properties loadPreMigrationProperties() throws IOException {
        String currentDirctory = System.getProperty(USER_DIR);
        FileInputStream iStream = new FileInputStream(String.valueOf(currentDirctory) + File.separator + PREMIGRATION_PROPERTIES);
        Properties properties = new Properties();
        properties.load(new InputStreamReader((InputStream)iStream, StandardCharsets.UTF_8));
        return properties;
    }

    private Map<String, List<RadiusClient>> getValidatedRadiusClients(List<RadiusClient> radiusClients, Map<String, String> hostIPMap) throws IOException {
        HashMap<String, List<RadiusClient>> map = new HashMap<String, List<RadiusClient>>();
        ArrayList invalidSharedSecret = new ArrayList();
        ArrayList invalidClientName = new ArrayList();
        ArrayList invalidIPAddress = new ArrayList();
        ArrayList sameHostIPClient = new ArrayList();
        Properties properties = this.loadPreMigrationProperties();
        HashSet<Character> uniqueSpecialCharaters = new HashSet<Character>();
        char[] charArray = properties.getProperty(SHARED_SECRET_SPECIAL_CHARACTER_VALIDATION).toCharArray();
        int i = 0;
        while (i < charArray.length) {
            uniqueSpecialCharaters.add(new Character(charArray[i]));
            ++i;
        }
        if (uniqueSpecialCharaters.contains(WHITE_SPACE)) {
            uniqueSpecialCharaters.remove(WHITE_SPACE);
        }
        radiusClients.stream().forEach(radClientObj -> {
            RadiusClientDTO radiusClientDTO;
            boolean isInvalidIPAddress;
            boolean isInvalidClientName;
            if (!RadiusValidators.validateSecrets(new String[]{radClientObj.getEncryptedAuthenticationSharedSecret()})) {
                invalidSharedSecret.add(radClientObj);
                this.migrationLogInfo("Radius Client with empty shared secret : " + radClientObj.getId());
            } else if (RadiusValidators.isSpecialCharacter(uniqueSpecialCharaters, radClientObj)) {
                invalidSharedSecret.add(radClientObj);
                this.migrationLogInfo("Radius Client with invalid special character in shared secret : " + radClientObj.getId());
            }
            boolean bl = isInvalidClientName = !RadiusValidators.isValidClientName(radClientObj.getId());
            if (isInvalidClientName) {
                invalidClientName.add(radClientObj);
            }
            boolean bl2 = isInvalidIPAddress = !RadiusValidators.isValidIpAddress(radiusClientDTO = RadiusConverters.converRadiusClientDTO((RadiusClient)radClientObj));
            if (isInvalidIPAddress) {
                invalidIPAddress.add(radClientObj);
            }
            if (hostIPMap.containsKey(radiusClientDTO.getIpaddress())) {
                sameHostIPClient.add(radClientObj);
            }
        });
        map.put(INVALID_SHARED_SECRET, invalidSharedSecret);
        map.put(INVALID_CLIENT_NAME, invalidClientName);
        map.put(INVALID_IP_ADDRESS, invalidIPAddress);
        map.put(SAME_HOST_CLIENT_IP, sameHostIPClient);
        return map;
    }
}

