/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.premigrate;

import com.rsa.authmgr.admin.migration.handler.AMRadiusPreMigrateDictionary;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.admin.tools.arguments.PreMigrateArguments;
import com.rsa.common.DataNotFoundException;
import com.rsa.tools.common.action.Arguments;
import com.rsa.tools.common.action.CLUExitCodes;
import com.rsa.tools.common.action.exception.CLUExitException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AMPreMigrateDictionaryAction
extends OrderedRadiusMigrationAction {
    protected PreMigrateArguments arguments;
    private AMRadiusPreMigrateDictionary radiusPreMigrateDictionary;

    public void execute() throws CLUExitException {
        block11: {
            Map<String, String> radiusClientMakeModel;
            this.migrationLogInfo("=========Start: Conversion of SBR Dictionary files============");
            try {
                radiusClientMakeModel = this.radiusPreMigrateDictionary.getAllVendorsForMigration();
            }
            catch (DataNotFoundException e1) {
                this.migrationLogError(AMMigrateRadiusDataCLU.format("unexpected-data-store-error ", new Object[0]), e1);
                this.setPremigrationFailureResult();
                this.migrationLogInfo("=========Failure: Conversion of SBR Dictionary files============" + e1.getMessage());
                throw new CLUExitException(AMMigrateRadiusDataCLU.format("unexpected-data-store-error ", new Object[0]), (Throwable)e1, CLUExitCodes.REQUIRED_ARGUMENT_MISSING_ERROR);
            }
            if (radiusClientMakeModel != null && radiusClientMakeModel.size() > 0) {
                this.migrationLogInfo(AMMigrateRadiusDataCLU.format("vendors-retrieved-successful ", radiusClientMakeModel.size()));
                this.migrationLogInfo(AMMigrateRadiusDataCLU.format("dictionary-file-conversion", new Object[0]));
                HashMap<String, List<String>> vendorIniMap = new HashMap();
                Boolean migConfigValue = false;
                try {
                    vendorIniMap = this.radiusPreMigrateDictionary.createVendorIniMap();
                }
                catch (Exception e) {
                    this.setPremigrationFailureResult();
                    RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfVendorsToBeMigrated(0);
                    RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfDictionaryFilesToBeMigrated(0);
                    this.migrationLogInfo("=========Failure: Conversion of SBR Dictionary files============" + e.getMessage());
                    throw new CLUExitException("Failed to revtrieve information from vendor.ini file", (Throwable)e, CLUExitCodes.REQUIRED_ARGUMENT_MISSING_ERROR);
                }
                try {
                    this.radiusPreMigrateDictionary.convertSbrRadiusDictionaryToFreeRadiusFormat(radiusClientMakeModel, vendorIniMap);
                    this.migrationLogInfo(AMMigrateRadiusDataCLU.format("dictionary-file-conversion", new Object[0]));
                    migConfigValue = (Boolean)RadiusMigrationUtility.getTrustedMigrationConfigValue("auth_manager.radius.migration.premigration.dict.pass_on_error", "auth_manager.radius.migration");
                    if (RadiusMigrationUtility.getPremigrateResultDTO().getDictFilesNotMigrated().size() <= 0 && RadiusMigrationUtility.getPremigrateResultDTO().getVendorMakeModelNotMigrated().size() <= 0) break block11;
                    if (migConfigValue.booleanValue()) {
                        RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(true);
                        RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.WARNING);
                        break block11;
                    }
                    RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
                    RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
                    this.setPremigrationFailureResult();
                    this.migrationLogInfo("=========Failure: Failed to convert some of the vendor dictionary files============");
                }
                catch (Exception e) {
                    this.migrationLogError(AMMigrateRadiusDataCLU.format("dictionary-migration-failed", new Object[0]), e);
                    this.setPremigrationFailureResult();
                    this.migrationLogInfo("=========Failure: Conversion of SBR Dictionary files============" + e.getMessage());
                }
            } else {
                this.migrationLogInfo(AMMigrateRadiusDataCLU.format("no-vendors-present", new Object[0]));
                RadiusMigrationUtility.getPremigrateResultDTO().setClientsFound(false);
                RadiusMigrationUtility.getPremigrateResultDTO().setClientsExported(false);
                RadiusMigrationUtility.getPremigrateResultDTO().setProfilesExported(false);
                RadiusMigrationUtility.getPremigrateResultDTO().setProfilesExported(false);
                RadiusMigrationUtility.getPremigrateResultDTO().setDictionaryConv(false);
            }
        }
        try {
            this.radiusPreMigrateDictionary.copySBRDictFilesToMigrationDir();
            this.migrationLogInfo(AMMigrateRadiusDataCLU.format("dict-filecopy-success", new Object[0]));
        }
        catch (Exception exception) {
            this.migrationLogWarn(AMMigrateRadiusDataCLU.format("dict-filecopy-failed", new Object[0]));
        }
        this.migrationLogInfo("======Completed: Convertion of dictionary files completed=========");
    }

    public void setArguments(Arguments arguments) {
        this.arguments = (PreMigrateArguments)arguments;
    }

    public void setRadiusPreMigrateDictionary(AMRadiusPreMigrateDictionary radiusPreMigrateDictionary) {
        this.radiusPreMigrateDictionary = radiusPreMigrateDictionary;
    }

    private void setPremigrationFailureResult() {
        RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(false);
        RadiusMigrationUtility.getPremigrateResultDTO().setDictionaryConv(false);
        RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.FAILED);
    }
}

