/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.premigrate;

import com.rsa.authmgr.admin.migration.utility.MigrationLoggingHelper;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.admin.tools.arguments.PreMigrateArguments;
import com.rsa.tools.common.CLUException;
import com.rsa.tools.common.action.Arguments;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AMPreMigrateRadiusConfigurationFileAction
extends OrderedRadiusMigrationAction {
    private static final Logger migrationLogger = MigrationLoggingHelper.getmigrationLogger();
    protected PreMigrateArguments arguments;

    public void execute() throws CLUException {
        try {
            this.logInfo("Started the pre-migration of radius configuration files.");
            this.premigrateRadiusServerCertificate();
            this.premigrateRadiusTrustCertificate();
            this.logInfo("Completed the pre-migration of radius configuration files.");
        }
        catch (Exception e) {
            this.logSevere("Error while migrating the configuration files. Don't fail the upgrade process. " + e.getMessage(), e);
        }
    }

    private void premigrateRadiusServerCertificate() {
        this.logInfo("Start: Pre-Migrate the Radius Server Certificate.");
        RadiusMigrationUtility ut = new RadiusMigrationUtility();
        ut.exportRadiusServerCertificate();
        this.logInfo("End: Pre-Migrate the Radius Server Certificate.");
    }

    private void premigrateRadiusTrustCertificate() {
        this.logInfo("Start: Pre-Migrate the Radius Trust Certificate.");
        RadiusMigrationUtility ut = new RadiusMigrationUtility();
        ut.exportRadiusTrustedCertificate();
        this.logInfo("End: Pre-Migrate the Radius Trust Certificate.");
    }

    public void setArguments(Arguments arg) {
        this.arguments = (PreMigrateArguments)arg;
    }

    private void logInfo(String message) {
        migrationLogger.log(Level.INFO, message);
    }

    private void logSevere(String msg, Exception e) {
        migrationLogger.log(Level.SEVERE, msg, e);
    }
}

