/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.action.premigrate;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationReportGenerator;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.admin.tools.action.OrderedRadiusMigrationAction;
import com.rsa.authmgr.admin.tools.arguments.PreMigrateArguments;
import com.rsa.tools.common.action.Arguments;
import com.rsa.tools.common.action.CLUExitCodes;
import com.rsa.tools.common.action.exception.CLUExitException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Properties;

public class AMPreMigrateResultsAction
extends OrderedRadiusMigrationAction {
    protected PreMigrateArguments arguments;

    public void execute() throws CLUExitException {
        this.migrationLogInfo("=========Start: Premigration Results============");
        try {
            this.writePreMigrationResults();
            this.readAndUpdateMigrationLogsWithResults();
        }
        catch (IOException e) {
            this.migrationLogInfo("Logs present in the migration directory" + RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir());
            this.migrationLogInfo("=========Failure: Premigration Results============" + e.getLocalizedMessage());
            throw new CLUExitException(AMMigrateRadiusDataCLU.format("premigration-results-failed", this.getPreMigrationPropertiesFileLocation()), (Throwable)e, CLUExitCodes.UNSPECIFIED_ERROR);
        }
        this.migrationLogInfo(AMMigrateRadiusDataCLU.format("premigration-results-success", this.getPreMigrationPropertiesFileLocation()));
        try {
            this.closeDAOLite();
        }
        catch (Exception exception) {}
        try {
            this.generateReport();
            if (!RadiusMigrationUtility.getPremigrateResultDTO().isPreMigrateSuccess()) {
                this.migrationLogError(AMMigrateRadiusDataCLU.format("premigration-results-failed", this.getPreMigrationPropertiesFileLocation()), null);
                this.migrationLogInfo("****The RADIUS migration log location: " + this.getMigrationLogFileLocation() + "*****");
                this.migrationLogInfo("=========Failure: Premigration failed, upgrade will stop, fix the issue to continue upgrade============");
                throw new Exception("Premigration of RADIUS data failed, refer the logs for more details");
            }
        }
        catch (Exception e) {
            this.migrationLogInfo("=========Failure: Premigration Results============" + e.getLocalizedMessage());
            throw new CLUExitException(AMMigrateRadiusDataCLU.format("premigration-results-failed", this.getPreMigrationPropertiesFileLocation()), (Throwable)e, CLUExitCodes.UNSPECIFIED_ERROR);
        }
        this.migrationLogInfo("=========Completed: Premigration Results============");
    }

    private void closeDAOLite() {
        RadiusMigrationUtility.closeDAOLite();
    }

    public void setArguments(Arguments arg0) {
        this.arguments = (PreMigrateArguments)arg0;
    }

    private void writePreMigrationResults() throws IOException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileOutputStream output = new FileOutputStream(this.getPreMigrationPropertiesFileLocation());){
                Properties prop = new Properties();
                prop.setProperty("migration.directory", RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir());
                prop.setProperty("premigration.results", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().isPreMigrateSuccess()));
                prop.setProperty("premigration.client.found", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().isClientsFound()));
                prop.setProperty("premigration.client.exported", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().isClientsExported()));
                prop.setProperty("premigration.profile.exported", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().isProfilesExported()));
                prop.setProperty("premigration.dictionary.converted", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().isDictionaryConv()));
                prop.setProperty("premigration.dictionary.number.converted", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().getTotalNumOfDictionaryFilesToBeMigrated()));
                prop.setProperty("premigration.dictionary.for.migration", String.join((CharSequence)",", RadiusMigrationUtility.getPremigrateResultDTO().getDictFilesToBeMigrated()));
                prop.setProperty("premigration.dictionary.migration.success", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().getTotalNumOfDictionaryMigratedSuccess()));
                prop.setProperty("premigration.dictionary.migration.errors", String.join((CharSequence)",", RadiusMigrationUtility.getPremigrateResultDTO().getDictFilesMigratedWithErrors()));
                prop.setProperty("premigration.dictionary.total.migration.failure", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().getTotalNumOfDictionaryMigratedFailed()));
                prop.setProperty("premigration.dictionary.migration.failure", String.join((CharSequence)",", RadiusMigrationUtility.getPremigrateResultDTO().getDictFilesNotMigrated()));
                prop.setProperty("premigration.dictionary.total.migration.vendor.failure", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().getTotalNumOfVendorsMigratedFailed()));
                prop.setProperty("premigration.dictionary.migration.vendor.failure", String.join((CharSequence)",", RadiusMigrationUtility.getPremigrateResultDTO().getVendorMakeModelNotMigrated()));
                prop.setProperty("premigration.dictionary.vendors.for.migration", String.join((CharSequence)",", RadiusMigrationUtility.getPremigrateResultDTO().getVendorsToBeMigrated()));
                prop.setProperty("premigration.dictionary.vendors.present", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().getTotalNumOfVendorsToBeMigrated()));
                prop.setProperty("premigration.dictionary.vendors.success", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().getTotalNumOfVendorsMigratedSuccess()));
                prop.setProperty("premigration.dictionary.attribute.valuename.changed", String.join((CharSequence)",", RadiusMigrationUtility.getPremigrateResultDTO().getAttributeValueNameChangedList()));
                prop.setProperty("premigration.dictionary.attribute.name.changed", String.join((CharSequence)",", RadiusMigrationUtility.getPremigrateResultDTO().getAttributeNameChangedList()));
                prop.setProperty("premigration.total.dictionary.insystem", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().getTotalDictionaryFilesPresentInSystem()));
                prop.setProperty("premigration.total.vendors.insystem", String.valueOf(RadiusMigrationUtility.getPremigrateResultDTO().getTotalVendorsPresentInSystem()));
                prop.setProperty("premigration.status", String.valueOf((Object)RadiusMigrationUtility.getPremigrateResultDTO().getPremigrationStatus()));
                prop.store(output, "Premigration Result");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            this.migrationLogError(AMMigrateRadiusDataCLU.format("premigration-results-failed", this.getPreMigrationPropertiesFileLocation()), ioe);
            throw ioe;
        }
    }

    private void readAndUpdateMigrationLogsWithResults() throws IOException {
        List<String> migrationProperties = Files.readAllLines(Paths.get(this.getPreMigrationPropertiesFileLocation(), new String[0]), StandardCharsets.ISO_8859_1);
        for (String line : migrationProperties) {
            this.writeToFile(line);
        }
    }

    private void writeToFile(String line) {
        try {
            Files.write(Paths.get(String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + "radius-migration.log", new String[0]), (String.valueOf(line) + "\n").getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateReport() throws Exception {
        this.migrationLogInfo("=========Start: Report Generation============");
        RadiusMigrationReportGenerator rmrg = new RadiusMigrationReportGenerator();
        rmrg.setTabTitle(AMMigrateRadiusDataCLU.format("report.title", new Object[0]));
        rmrg.setReportTitle(AMMigrateRadiusDataCLU.format("report.title", new Object[0]));
        rmrg.setReportDescription(AMMigrateRadiusDataCLU.format("report.description", new Object[0]));
        try {
            rmrg.generateHTMLReport(rmrg.generateRadiusMigrationReport());
            rmrg.saveReport();
            this.migrationLogInfo("**************************************************************************************************************");
            this.migrationLogInfo(AMMigrateRadiusDataCLU.format("report.location", AMRadiusMigrationConstants.MIG_REPORT_DIRECTORY));
            this.migrationLogInfo("**************************************************************************************************************");
            rmrg.mergeAdditionalFailureReport();
            this.migrationLogInfo("The RSA RADIUS Migration Report is available in " + AMRadiusMigrationConstants.MIG_REPORT_RADIUS_CLIENT_FILEPATH);
        }
        catch (Exception e) {
            this.migrationLogError(AMMigrateRadiusDataCLU.format("premigration-results-failed", this.getPreMigrationPropertiesFileLocation()), e);
            throw e;
        }
        this.migrationLogInfo("=========End: Report Generation============");
    }

    private String getPreMigrationPropertiesFileLocation() {
        return String.valueOf(AMRadiusMigrationConstants.PREMIG_RESULT_PROPERTIES_FILE_PATH) + "radius_migration.properties";
    }

    private String getMigrationLogFileLocation() {
        return String.valueOf(RadiusMigrationUtility.getMigParamDTO().getOutputMigrationDir()) + "radius-migration.log";
    }
}

