/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.arguments;

import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.ims.logging.Level;
import com.rsa.ims.ocadmin.management.clu.CluOcAdminLogonHelper;
import com.rsa.tools.common.CLUPrompts;
import com.rsa.tools.common.action.Arguments;
import com.rsa.tools.common.action.CLUExitCodes;
import com.rsa.tools.common.action.exception.ExitException;
import com.rsa.tools.common.action.exception.MissingArgumentException;
import jargs.gnu.CmdLineParser;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class CommandLineArguments
implements Arguments {
    private CmdLineParser.Option ocAdminOpt;
    private CmdLineParser.Option ocPasswordOpt;
    protected CmdLineParser parser;
    protected String ocAdmin;
    protected char[] ocPassword;

    public CommandLineArguments(CmdLineParser parser) {
        this.parser = parser;
    }

    public CommandLineArguments() {
    }

    private void validateOCCredentials() throws ExitException {
        try {
            CluOcAdminLogonHelper.getServerAccessInfo((char[])this.ocAdmin.toCharArray(), (char[])this.ocPassword);
        }
        catch (Exception e) {
            throw new ExitException(AMMigrateRadiusDataCLU.format("invalid-ocadmin-credentials", new Object[0]), (Throwable)e, CLUExitCodes.INVALID_OC_CREDENTIALS_ERROR);
        }
    }

    protected char[] getPassword(char[] pwd, String key, boolean confirm) throws IllegalArgumentException {
        if (AMMigrateRadiusDataCLU.isInteractive() && (pwd == null || pwd.length < 1)) {
            try {
                String prompt = CLUPrompts.getPassword((String)AMMigrateRadiusDataCLU.getString("prompt-" + key));
                if (confirm) {
                    String repeat = CLUPrompts.getPassword((String)AMMigrateRadiusDataCLU.getString("confirm-" + key));
                    while (!prompt.equals(repeat)) {
                        System.err.println(AMMigrateRadiusDataCLU.getString("password-mismatch"));
                        prompt = CLUPrompts.getPassword((String)AMMigrateRadiusDataCLU.getString("prompt-" + key));
                        repeat = CLUPrompts.getPassword((String)AMMigrateRadiusDataCLU.getString("confirm-" + key));
                    }
                }
                return prompt.toCharArray();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return pwd;
    }

    protected void verbose(String msg) {
        AMMigrateRadiusDataCLU.TRACE_LOG.log(Level.INFO, (Object)msg);
    }

    protected void warn(String msg, Throwable throwable) {
        AMMigrateRadiusDataCLU.TRACE_LOG.log(Level.WARN, (Object)msg, throwable);
        AMMigrateRadiusDataCLU.actionLog(Level.WARN, msg, throwable);
    }

    protected void error(String msg, Throwable throwable) {
        AMMigrateRadiusDataCLU.TRACE_LOG.log(Level.ERROR, (Object)msg, throwable);
        AMMigrateRadiusDataCLU.actionLog(Level.ERROR, msg, throwable);
    }

    protected boolean isVerbose() {
        return AMMigrateRadiusDataCLU.TRACE_LOG.isEnabled(Level.INFO);
    }

    public void parse() throws IllegalArgumentException {
        if (this.parser == null) {
            throw new IllegalStateException("Command line parser is not initialized.");
        }
        this.ocAdmin = (String)this.parser.getOptionValue(this.ocAdminOpt);
        String temp = (String)this.parser.getOptionValue(this.ocPasswordOpt);
        if (!StringUtils.isEmpty((String)temp)) {
            this.ocPassword = temp.toCharArray();
        }
    }

    public void validate() throws MissingArgumentException, ExitException {
        if (StringUtils.isEmpty((String)this.ocAdmin)) {
            throw new MissingArgumentException(AMMigrateRadiusDataCLU.format("missing-ocadmin", new Object[0]));
        }
        this.ocPassword = this.getPassword(this.ocPassword, "ocadmin-password", false);
        if (this.ocPassword == null || this.ocPassword.length < 1) {
            throw new MissingArgumentException(AMMigrateRadiusDataCLU.format("missing-ocadmin-password", new Object[0]));
        }
        this.validateOCCredentials();
    }

    public void addOptions() {
        this.ocAdminOpt = this.parser.addStringOption('o', "oc-user");
        this.ocPasswordOpt = this.parser.addStringOption('b', "oc-user-pwd");
    }

    public String getOCAdmin() {
        return this.ocAdmin;
    }

    public void setOCAdmin(String ocAdmin) {
        this.ocAdmin = ocAdmin;
    }

    public char[] getOCAdminPassword() {
        return this.copy(this.ocPassword);
    }

    public void setOCPassword(char[] ocPassword) {
        this.ocPassword = this.copy(ocPassword);
    }

    protected char[] copy(char[] input) {
        if (input == null) {
            return null;
        }
        return Arrays.copyOf(input, input.length);
    }
}

