/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.arguments;

import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationConstants;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationParametersDTO;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationResultsDTO;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusPreMigrationResultsDTO;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.admin.tools.arguments.CommandLineArguments;
import jargs.gnu.CmdLineParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;

public class MigrateArguments
extends CommandLineArguments {
    private CmdLineParser.Option dirLocationOpt;
    private String directoryLocation;
    private AMRadiusMigrationParametersDTO migParamDTO = new AMRadiusMigrationParametersDTO();
    private AMRadiusPreMigrationResultsDTO preMigResultDTO = new AMRadiusPreMigrationResultsDTO();
    private AMRadiusMigrationResultsDTO migResultDTO = new AMRadiusMigrationResultsDTO();

    public MigrateArguments(CmdLineParser parser) {
        super(parser);
    }

    public MigrateArguments() {
    }

    @Override
    public void parse() throws IllegalArgumentException {
        super.parse();
        this.directoryLocation = (String)this.parser.getOptionValue(this.dirLocationOpt);
        RadiusMigrationUtility.setMigrationAction("migrate");
        RadiusMigrationUtility.setMigParamDTO(this.migParamDTO);
        RadiusMigrationUtility.setPremigrateResultDTO(this.preMigResultDTO);
        RadiusMigrationUtility.setMigrateResultDTO(this.migResultDTO);
        try {
            this.readPreMigrationResults();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(AMMigrateRadiusDataCLU.format("migration-initization-failed", this.getPreMigrationPropertiesFileLocation()), e);
        }
        try {
            RadiusMigrationUtility.updateInstanceVersion();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void validate() throws IllegalArgumentException {
    }

    @Override
    public void addOptions() {
        super.addOptions();
        this.dirLocationOpt = this.parser.addStringOption('l', "directory-location");
    }

    public String getDirectoryLocation() {
        return this.directoryLocation;
    }

    public void setDirectoryLocation(String directoryLocation) {
        this.directoryLocation = directoryLocation;
    }

    private void readPreMigrationResults() throws IOException {
        Properties prop = new Properties();
        Throwable throwable = null;
        Object var3_5 = null;
        try (FileInputStream inputStream = new FileInputStream(this.getPreMigrationPropertiesFileLocation());){
            prop.load(inputStream);
            RadiusMigrationUtility.getMigParamDTO().setOutputMigrationDir(prop.getProperty("migration.directory"));
            RadiusMigrationUtility.getPremigrateResultDTO().setPreMigrateSuccess(Boolean.valueOf(prop.getProperty("premigration.results")));
            RadiusMigrationUtility.getPremigrateResultDTO().setClientsFound(Boolean.valueOf(prop.getProperty("premigration.client.found")));
            RadiusMigrationUtility.getPremigrateResultDTO().setClientsExported(Boolean.valueOf(prop.getProperty("premigration.client.exported")));
            RadiusMigrationUtility.getPremigrateResultDTO().setProfilesExported(Boolean.valueOf(prop.getProperty("premigration.profile.exported")));
            RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfDictionaryFilesToBeMigrated(Integer.valueOf(prop.getProperty("premigration.dictionary.number.converted")));
            RadiusMigrationUtility.getPremigrateResultDTO().setDictionaryConv(Boolean.valueOf(prop.getProperty("premigration.dictionary.converted")));
            RadiusMigrationUtility.getPremigrateResultDTO().setDictFilesToBeMigrated(Arrays.asList(prop.getProperty("premigration.dictionary.for.migration").split(",")));
            RadiusMigrationUtility.getPremigrateResultDTO().setDictFilesMigratedWithErrors(Arrays.asList(prop.getProperty("premigration.dictionary.migration.errors").split(",")));
            RadiusMigrationUtility.getPremigrateResultDTO().setDictFilesNotMigrated(Arrays.asList(prop.getProperty("premigration.dictionary.migration.failure").split(",")));
            RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfVendorsToBeMigrated(Integer.valueOf(prop.getProperty("premigration.dictionary.vendors.present")));
            RadiusMigrationUtility.getPremigrateResultDTO().setAttributeValueNameChangedList(Arrays.asList(prop.getProperty("premigration.dictionary.attribute.valuename.changed").split(",")));
            RadiusMigrationUtility.getPremigrateResultDTO().setAttributeNameChangedList(Arrays.asList(prop.getProperty("premigration.dictionary.attribute.name.changed").split(",")));
            RadiusMigrationUtility.getPremigrateResultDTO().setTotalDictionaryFilesPresentInSystem(Integer.valueOf(prop.getProperty("premigration.total.dictionary.insystem")));
            RadiusMigrationUtility.getPremigrateResultDTO().setTotalVendorsPresentInSystem(Integer.valueOf(prop.getProperty("premigration.total.vendors.insystem")));
            RadiusMigrationUtility.getPremigrateResultDTO().setPremigrationStatus(AMRadiusMigrationConstants.Status.valueOf(prop.getProperty("premigration.status")));
            RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfDictionaryMigratedSuccess(Integer.valueOf(prop.getProperty("premigration.dictionary.migration.success")));
            RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfVendorsMigratedSuccess(Integer.valueOf(prop.getProperty("premigration.dictionary.vendors.success")));
            RadiusMigrationUtility.getPremigrateResultDTO().setVendorsToBeMigrated(Arrays.asList(prop.getProperty("premigration.dictionary.vendors.for.migration").split(",")));
            RadiusMigrationUtility.getPremigrateResultDTO().setVendorMakeModelNotMigrated(Arrays.asList(prop.getProperty("premigration.dictionary.migration.vendor.failure").split(",")));
            RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfDictionaryMigratedFailed(Integer.valueOf(prop.getProperty("premigration.dictionary.total.migration.failure")));
            RadiusMigrationUtility.getPremigrateResultDTO().setTotalNumOfVendorsMigratedFailed(Integer.valueOf(prop.getProperty("premigration.dictionary.total.migration.vendor.failure")));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getPreMigrationPropertiesFileLocation() {
        return String.valueOf(AMRadiusMigrationConstants.PREMIG_RESULT_PROPERTIES_FILE_PATH) + "radius_migration.properties";
    }
}

