/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.authmgr.admin.tools.arguments;

import com.rsa.authmgr.admin.migration.utility.MigrationOutputLocationHelper;
import com.rsa.authmgr.admin.migration.utility.RadiusMigrationUtility;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusMigrationParametersDTO;
import com.rsa.authmgr.admin.radius.migration.data.AMRadiusPreMigrationResultsDTO;
import com.rsa.authmgr.admin.tools.AMMigrateRadiusDataCLU;
import com.rsa.authmgr.admin.tools.arguments.CommandLineArguments;
import com.rsa.tools.common.action.CLUExitCodes;
import jargs.gnu.CmdLineParser;

public class PreMigrateArguments
extends CommandLineArguments {
    private CmdLineParser.Option outputDirectoryLocationOpt;
    private String outputDirectoryLocation;
    private AMRadiusMigrationParametersDTO migParamDTO = new AMRadiusMigrationParametersDTO();
    private AMRadiusPreMigrationResultsDTO preMigResultDTO = new AMRadiusPreMigrationResultsDTO();

    public PreMigrateArguments(CmdLineParser parser) {
        super(parser);
    }

    public PreMigrateArguments() {
    }

    @Override
    public void parse() throws IllegalArgumentException {
        super.parse();
        RadiusMigrationUtility.setMigrationAction("premigrate");
        this.outputDirectoryLocation = (String)this.parser.getOptionValue(this.outputDirectoryLocationOpt);
        try {
            this.migParamDTO.setOutputMigrationDir(MigrationOutputLocationHelper.checkCreateMigrationJobDirectory(this.outputDirectoryLocation));
            RadiusMigrationUtility.setMigParamDTO(this.migParamDTO);
            RadiusMigrationUtility.setPremigrateResultDTO(this.preMigResultDTO);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(AMMigrateRadiusDataCLU.format("create-output-directory-failed", e.getLocalizedMessage(), e, CLUExitCodes.UNSPECIFIED_ERROR));
        }
    }

    @Override
    public void validate() throws IllegalArgumentException {
    }

    @Override
    public void addOptions() {
        super.addOptions();
        this.outputDirectoryLocationOpt = this.parser.addStringOption('l', "output-directory");
    }

    public String getOutputDirectoryLocation() {
        return this.outputDirectoryLocation;
    }

    public void setOutputDirectoryLocation(String outputDirectoryLocation) {
        this.outputDirectoryLocation = outputDirectoryLocation;
    }

    public AMRadiusMigrationParametersDTO getMigrateDTO() {
        return this.migParamDTO;
    }
}

